package com.ejianc.foundation.supplier.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.vo.SupLeaderSupplierVO;
import com.ejianc.foundation.supplier.vo.SuplSupplierVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface ISuplSupplierService extends IBaseService<SupplierEntity> {
    List<SupplierVO> queryListByCategoryId(Long id);

    CommonResponse<SupplierVO> saveOrUpdate(SupplierVO supplierVo);

    SupplierVO queryDetail(Long id);

    void deleteSupplier(List<Long> ids);

    IPage<SupplierVO> queryPageList(QueryParam queryParam,Integer billType);

    void sysSupplier(SuplSupplierVO supplierVo);

    List<SupplierVO> excelExport(QueryParam queryParam, Integer billType);

    void saveBlackList(List<Long> ids);

    void saveRedList(List<Long> ids);

    void delRedList(List<Long> ids);

    void delBlackList(List<Long> ids);

    IPage<SupplierVO> queryBlackList(QueryParam param, Integer billType);

    List<SupplierVO> blackExcelExport(QueryParam queryParam, Integer billType);

    /**
     * 劳务公司
     *      分包负责人+个人供应商合并参照
     * @param page
     * @param wrapper
     * @return
     */
    List<SupLeaderSupplierVO> refSupplierLeaderPage(Page<SupLeaderSupplierVO> page, QueryWrapper wrapper);

}
