package com.ejianc.foundation.supplier.warn;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.dto.SupplierWarnVO;
import com.ejianc.foundation.supplier.mapper.SuplSupplierMapper;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @author
 * @Description:
 * @date
 */
@RestController
@RequestMapping(value = "/supplierWarn/")
public class WarnController {
//       * * * 26 * ?
//       {"dispatchCode":"WARNING000088"}
//    dispatchWarningHandler
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private SuplSupplierMapper mapper;

    static  String  PC_URL = "/ejc-share-frontend/#/allSupplier/card?id=";

    @PostMapping(value = "majorExecute")
    public CommonResponse<String> majorExecute(@RequestBody JSONArray jsonParam) {

        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");


            QueryParam queryParam = new QueryParam();
            queryParam.setPageIndex(1);
            queryParam.setPageSize(-1);
            queryParam.getParams().put("sourceType", new Parameter(QueryParam.EQ, "proSub"));
            queryParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ, "2"));
            CommonResponse<List<Long>> listCommonResponse = contractPoolApi.querySupplierList(queryParam);

            if (listCommonResponse.isSuccess()) {
                List<Long> supplierIds = listCommonResponse.getData();
                if (ListUtil.isNotEmpty(supplierIds)) {

                    List<SupplierWarnVO> major = mapper.refSupplierWarnList(supplierIds, "major");

                    if (ListUtil.isNotEmpty(major)) {
                        for (SupplierWarnVO assessDetailVO : major) {
                            JSONObject orgSet = null;
                            JSONObject defaultSet = null;
                            Long orgId = 1502571152583692289L;
                            OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                            if (orgVO == null) {
                                continue;
                            }
                            String innerCode = orgVO.getInnerCode();
                            String[] parentIds = innerCode.split("\\|");
                            /**
                             * 如果当前组织没查到配置，则找其直接上级的配置，
                             * 再找不到，再找其上级，以此类推，
                             * 直至上级为空，还没找到则用默认配置，
                             * 默认配置为空，则不预警
                             * 使用当前组织的 innerCode 进行父级查找
                             **/
                            logger.info("parentIds______" + innerCode);
                            for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                                /** 反向查找 */
                                Long pOrgId = Long.parseLong(parentIds[i1]);
                                for (int j = 0; j < orgSettings.size(); j++) {
                                    JSONObject set = orgSettings.getJSONObject(j);
                                    if (pOrgId.equals(set.getLong("orgId"))) {
                                        orgSet = set;
                                        break;
                                    }
                                }
                                if (orgSet != null) {
                                    break;
                                }
                            }
                            /** 查找默认的 */
                            for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                                JSONObject set = orgSettings.getJSONObject(i1);
                                if (set.getBoolean("default")) {
                                    defaultSet = set;
                                    break;
                                }
                            }
                            if (orgSet == null) {
                                /** 使用默认配置 */
                                orgSet = defaultSet;
                            }
                            if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                                boolean high = false;
                                boolean meddle = false;
                                boolean low = false;
                                JSONObject useSetHigh = null;
                                JSONObject useSetMeddle = null;
                                JSONObject useSetLow = null;

                                for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                                    JSONObject set = warningSettings.getJSONObject(i1);
                                    if ("高".equals(set.getString("warningLevel"))) {
                                            high = true;
                                            useSetHigh = set;
                                    }
                                    if ("中".equals(set.getString("warningLevel"))) {
                                            meddle = true;
                                            useSetMeddle = set;
                                    }
                                    if ("低".equals(set.getString("warningLevel"))) {
                                            low = true;
                                            useSetLow = set;
                                    }
                                }

                                if (high || meddle || low) {
                                    EarlyWarnTransVO vo = new EarlyWarnTransVO();
                                    String pattern = "yyyy-MM-dd HH:mm:ss";
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                                    vo.setBillName(orgSet.getString("moduleName") + "-" +
                                            assessDetailVO.getSupplierName());
                                    vo.setPcTitle("供应商证件过期预警");
                                    vo.setPcUrl(PC_URL + assessDetailVO.getSupplierId());
                                    vo.setOrgId(1502571152583692289L);
                                    //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                                    vo.setSendOrgId("1502571152583692289");
                                    vo.setOrgName(assessDetailVO.getSupplierName());
                                    vo.setSourceId(assessDetailVO.getSupplierId().toString());
                                    vo.setTenantId(999999L);
                                    vo.setWarnSetId(orgSet.getLong("warnId"));
                                    vo.setEarlywarnName(orgSet.getString("warnName"));
                                    vo.setWarnType(orgSet.getString("warnType"));
                                    String tmpContent = orgSet.getString("warningContentTemplate");
                                    if (high) {
                                        vo.setWarnLevel("高");
                                        vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                        vo.setEarlywarnContent(
                                                tmpContent.replaceAll("#supplierName#", assessDetailVO.getSupplierName())
                                                        .replaceAll("#certName#", assessDetailVO.getCertName()));
                                    } else if (meddle) {
                                        vo.setWarnLevel("中");
                                        vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                        vo.setEarlywarnContent(
                                                tmpContent.replaceAll("#supplierName#", assessDetailVO.getSupplierName())
                                                        .replaceAll("#certName#", assessDetailVO.getCertName()));
                                    } else {
                                        vo.setWarnLevel("低");
                                        vo.setWarnSetParamId(useSetLow.getLong("id"));
                                        vo.setEarlywarnContent(
                                                tmpContent.replaceAll("#supplierName#", assessDetailVO.getSupplierName())
                                                        .replaceAll("#certName#", assessDetailVO.getCertName()));
                                    }
                                    warnList.add(vo);
                                }
                            }
                        }
                    }
                }
             }

        }
        return sendWarnToTask(warnList,warnCode);
    }
    @PostMapping(value = "laborExecute")
    public CommonResponse<String> laborExecute(@RequestBody JSONArray jsonParam) {

        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");


            QueryParam queryParam = new QueryParam();
            queryParam.setPageIndex(1);
            queryParam.setPageSize(-1);
            queryParam.getParams().put("sourceType", new Parameter(QueryParam.EQ, "laborSub"));
            queryParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ, "2"));
            CommonResponse<List<Long>> listCommonResponse = contractPoolApi.querySupplierList(queryParam);

            if (listCommonResponse.isSuccess()) {
                List<Long> supplierIds = listCommonResponse.getData();
                if (ListUtil.isNotEmpty(supplierIds)) {

                    List<SupplierWarnVO> major = mapper.refSupplierWarnList(supplierIds, "labor");

                    if (ListUtil.isNotEmpty(major)) {
                        for (SupplierWarnVO assessDetailVO : major) {
                            JSONObject orgSet = null;
                            JSONObject defaultSet = null;
                            Long orgId = 1502571152583692289L;
                            OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                            if (orgVO == null) {
                                continue;
                            }
                            String innerCode = orgVO.getInnerCode();
                            String[] parentIds = innerCode.split("\\|");
                            /**
                             * 如果当前组织没查到配置，则找其直接上级的配置，
                             * 再找不到，再找其上级，以此类推，
                             * 直至上级为空，还没找到则用默认配置，
                             * 默认配置为空，则不预警
                             * 使用当前组织的 innerCode 进行父级查找
                             **/
                            logger.info("parentIds______" + innerCode);
                            for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                                /** 反向查找 */
                                Long pOrgId = Long.parseLong(parentIds[i1]);
                                for (int j = 0; j < orgSettings.size(); j++) {
                                    JSONObject set = orgSettings.getJSONObject(j);
                                    if (pOrgId.equals(set.getLong("orgId"))) {
                                        orgSet = set;
                                        break;
                                    }
                                }
                                if (orgSet != null) {
                                    break;
                                }
                            }
                            /** 查找默认的 */
                            for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                                JSONObject set = orgSettings.getJSONObject(i1);
                                if (set.getBoolean("default")) {
                                    defaultSet = set;
                                    break;
                                }
                            }
                            if (orgSet == null) {
                                /** 使用默认配置 */
                                orgSet = defaultSet;
                            }
                            if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                                boolean high = false;
                                boolean meddle = false;
                                boolean low = false;
                                JSONObject useSetHigh = null;
                                JSONObject useSetMeddle = null;
                                JSONObject useSetLow = null;

                                for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                                    JSONObject set = warningSettings.getJSONObject(i1);
                                    if ("高".equals(set.getString("warningLevel"))) {
                                        high = true;
                                        useSetHigh = set;
                                    }
                                    if ("中".equals(set.getString("warningLevel"))) {
                                        meddle = true;
                                        useSetMeddle = set;
                                    }
                                    if ("低".equals(set.getString("warningLevel"))) {
                                        low = true;
                                        useSetLow = set;
                                    }
                                }

                                if (high || meddle || low) {
                                    EarlyWarnTransVO vo = new EarlyWarnTransVO();
                                    String pattern = "yyyy-MM-dd HH:mm:ss";
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                                    vo.setBillName(orgSet.getString("moduleName") + "-" +
                                            assessDetailVO.getSupplierName());
                                    vo.setPcTitle("供应商证件过期预警");
                                    vo.setPcUrl(PC_URL + assessDetailVO.getSupplierId());
                                    vo.setOrgId(1502571152583692289L);
                                    //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                                    vo.setSendOrgId("1502571152583692289");
                                    vo.setOrgName(assessDetailVO.getSupplierName());
                                    vo.setSourceId(assessDetailVO.getSupplierId().toString());
                                    vo.setTenantId(999999L);
                                    vo.setWarnSetId(orgSet.getLong("warnId"));
                                    vo.setEarlywarnName(orgSet.getString("warnName"));
                                    vo.setWarnType(orgSet.getString("warnType"));
                                    String tmpContent = orgSet.getString("warningContentTemplate");
                                    if (high) {
                                        vo.setWarnLevel("高");
                                        vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                        vo.setEarlywarnContent(
                                                tmpContent.replaceAll("#supplierName#", assessDetailVO.getSupplierName())
                                                        .replaceAll("#certName#", assessDetailVO.getCertName()));
                                    } else if (meddle) {
                                        vo.setWarnLevel("中");
                                        vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                        vo.setEarlywarnContent(
                                                tmpContent.replaceAll("#supplierName#", assessDetailVO.getSupplierName())
                                                        .replaceAll("#certName#", assessDetailVO.getCertName()));
                                    } else {
                                        vo.setWarnLevel("低");
                                        vo.setWarnSetParamId(useSetLow.getLong("id"));
                                        vo.setEarlywarnContent(
                                                tmpContent.replaceAll("#supplierName#", assessDetailVO.getSupplierName())
                                                        .replaceAll("#certName#", assessDetailVO.getCertName()));
                                    }
                                    warnList.add(vo);
                                }
                            }
                        }
                    }
                }
            }

        }
        return sendWarnToTask(warnList,warnCode);
    }
    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }



}