/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProjectSetExPoolEntity;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.service.IProjectSetExPoolService;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectDesktopSubParentVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectSetPool"})
public class ProjectSetPoolController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private IProjectSetExPoolService projectSetExPoolService;
    @Autowired
    private SessionManager sessionManager;
    private static String RANGE_ALL = "all";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectPoolSetVO> saveOrUpdate(@RequestBody ProjectPoolSetVO saveOrUpdateVO) {
        ProjectSetPoolEntity entity = (ProjectSetPoolEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectSetPoolEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (codeBatchByRuleCode.isSuccess()) {
                saveOrUpdateVO.setCode((String)codeBatchByRuleCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.projectSetService.saveOrUpdate((Object)entity, false);
        ProjectPoolSetVO vo = (ProjectPoolSetVO)BeanMapper.map((Object)((Object)entity), ProjectPoolSetVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectPoolSetVO> queryDetail(Long id) {
        ProjectSetPoolEntity entity = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(id));
        ProjectPoolSetVO vo = (ProjectPoolSetVO)BeanMapper.map((Object)((Object)entity), ProjectPoolSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectPoolSetVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectPoolSetVO projectPoolSetVO : vos) {
            }
        }
        this.projectSetService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectPoolSetVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (departmentIds.size() != 0) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        } else {
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)new Page(1L, (long)param.getPageSize(), 0L));
        }
        IPage page = this.projectSetService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectPoolSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.projectSetService.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectWbs-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"projectWbs-export.xlsx", (String)"\u5408\u540c\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/refProjectSetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectPoolSetVO>> refProjectSetData(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();
        param.getParams().put("attribute", new Parameter("eq", (Object)2));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            String rangeType;
            JSONObject _con = JSONObject.parseObject((String)condition);
            String parentProjectId = _con.getString("parentProjectId");
            if (StringUtils.isNotBlank((CharSequence)parentProjectId)) {
                param.getParams().put("parentProjectId", new Parameter("eq", (Object)parentProjectId));
            }
            if (StringUtils.isNotBlank((CharSequence)_con.getString("orgId"))) {
                orgId = _con.getLong("orgId");
            }
            if (StringUtils.isNotEmpty((CharSequence)(rangeType = _con.getString("range"))) && RANGE_ALL.equals(rangeType)) {
                IPage page = this.projectSetService.queryPage(param, false);
                Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
                pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectPoolSetVO.class));
                List records = pageData.getRecords();
                if (ListUtil.isNotEmpty((List)records)) {
                    records.forEach(projectSetVO -> {
                        QueryParam queryParam = new QueryParam();
                        queryParam.getParams().put("parentProjectId", new Parameter("eq", (Object)projectSetVO.getId()));
                        List entityList = this.projectSetService.queryList(queryParam, false);
                        if (ListUtil.isNotEmpty((List)entityList)) {
                            ArrayList<ProjectPoolSetVO> projectSetVOS = new ArrayList<ProjectPoolSetVO>();
                            for (int i = 0; i < entityList.size(); ++i) {
                                ProjectPoolSetVO setVO = (ProjectPoolSetVO)BeanMapper.map(entityList.get(i), ProjectPoolSetVO.class);
                                projectSetVOS.add(setVO);
                            }
                            projectSetVO.setChildren(projectSetVOS);
                        }
                    });
                }
                return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
            }
            if (StringUtils.isNotBlank((CharSequence)_con.getString("excludeCapitalStatus"))) {
                param.getParams().put("capitalStatus", new Parameter("not_in", (Object)_con.getString("excludeCapitalStatus")));
            }
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        this.logger.info("-------------------------------authOrgIds:{}", (Object)authOrgIds);
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        List orgVOList = null;
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            orgVOList.stream().forEach(org -> departmentIds.add(org.getId()));
        } else {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
        }
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        } else {
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)new Page(0L, 0L, 0L));
        }
        IPage page = this.projectSetService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectPoolSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refProjectSetProgressData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectVO>> refProjectSetProgressData(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();
        param.getParams().put("attribute", new Parameter("eq", (Object)2));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            String rangeType;
            JSONObject _con = JSONObject.parseObject((String)condition);
            String parentProjectId = _con.getString("parentProjectId");
            if (StringUtils.isNotBlank((CharSequence)parentProjectId)) {
                param.getParams().put("parentProjectId", new Parameter("eq", (Object)parentProjectId));
            }
            if (StringUtils.isNotBlank((CharSequence)_con.getString("orgId"))) {
                orgId = _con.getLong("orgId");
            }
            if (StringUtils.isNotEmpty((CharSequence)(rangeType = _con.getString("range"))) && RANGE_ALL.equals(rangeType)) {
                IPage page = this.projectSetService.queryPage(param, false);
                Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
                pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectPoolSetVO.class));
                List records = pageData.getRecords();
                Page progressPageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
                ArrayList<ProjectVO> progressProject = new ArrayList<ProjectVO>();
                if (ListUtil.isNotEmpty((List)records)) {
                    for (ProjectPoolSetVO projectSetVO : records) {
                        QueryParam queryParam = new QueryParam();
                        queryParam.getParams().put("parentProjectId", new Parameter("eq", (Object)projectSetVO.getId()));
                        List entityList = this.projectSetService.queryList(queryParam, false);
                        if (ListUtil.isNotEmpty((List)entityList)) {
                            ArrayList<ProjectPoolSetVO> projectSetVOS = new ArrayList<ProjectPoolSetVO>();
                            for (int i = 0; i < entityList.size(); ++i) {
                                ProjectPoolSetVO setVO = (ProjectPoolSetVO)BeanMapper.map(entityList.get(i), ProjectPoolSetVO.class);
                                projectSetVOS.add(setVO);
                            }
                            projectSetVO.setChildren(projectSetVOS);
                        }
                        ProjectVO map = (ProjectVO)BeanMapper.map((Object)projectSetVO, ProjectVO.class);
                        map.setProjectName(projectSetVO.getName());
                        map.setBillCode(projectSetVO.getCode());
                        map.setLeader(projectSetVO.getProjectManagementId());
                        map.setStartDate(projectSetVO.getPlanStartDate());
                        map.setEndDate(projectSetVO.getPlanEndDate());
                        progressProject.add(map);
                    }
                }
                progressPageData.setRecords(progressProject);
                return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)progressPageData);
            }
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        } else {
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)new Page(0L, 0L, 0L));
        }
        IPage page = this.projectSetService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List projectPoolSetVOS = BeanMapper.mapList((Iterable)page.getRecords(), ProjectPoolSetVO.class);
        pageData.setRecords(projectPoolSetVOS);
        Page progressPageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        ArrayList<ProjectVO> progressProject = new ArrayList<ProjectVO>();
        for (ProjectPoolSetVO projectSetVO : projectPoolSetVOS) {
            ProjectVO map = (ProjectVO)BeanMapper.map((Object)projectSetVO, ProjectVO.class);
            map.setProjectName(projectSetVO.getName());
            map.setBillCode(projectSetVO.getCode());
            map.setLeader(projectSetVO.getProjectManagementId());
            map.setStartDate(projectSetVO.getPlanStartDate());
            map.setEndDate(projectSetVO.getPlanEndDate());
            progressProject.add(map);
        }
        progressPageData.setRecords(progressProject);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)progressPageData);
    }

    @RequestMapping(value={"/refProjectParentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectPoolSetVO>> refProjectParentData(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        param.getFuzzyFields().add("orgName");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            String parentProjectId = _con.getString("parentProjectId");
            if (StringUtils.isNotBlank((CharSequence)parentProjectId)) {
                param.getParams().put("parentProjectId", new Parameter("eq", (Object)parentProjectId));
            }
            if (StringUtils.isNotBlank((CharSequence)_con.getString("orgId"))) {
                orgId = _con.getLong("orgId");
            }
        }
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        } else {
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)new Page(0L, 0L, 0L));
        }
        IPage page = this.projectSetService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectPoolSetVO.class));
        List records = pageData.getRecords();
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refParent"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectPoolSetVO>> refParent(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (StringUtils.isNotBlank((CharSequence)condition) && StringUtils.isNotBlank((CharSequence)(_con = JSONObject.parseObject((String)condition)).getString("orgId"))) {
            orgId = _con.getLong("orgId");
        }
        param.getParams().put("attribute", new Parameter("eq", (Object)1));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        } else {
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)new Page(0L, 0L, 0L));
        }
        IPage page = this.projectSetService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectPoolSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"queryProjectByProjectDepartmentId"})
    @ResponseBody
    public CommonResponse<ProjectPoolSetVO> queryProjectByProjectDepartmentId(@RequestParam(value="projectDepartmentId") Long projectDepartmentId) {
        ProjectSetPoolEntity entity = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(projectDepartmentId));
        if (entity == null) {
            QueryParam param = new QueryParam();
            param.getParams().put("project_department_id", new Parameter("eq", (Object)projectDepartmentId));
            List list = this.projectSetService.queryList(param, false);
            if (ListUtil.isNotEmpty((List)list)) {
                entity = (ProjectSetPoolEntity)((Object)list.get(0));
            }
        }
        ProjectPoolSetVO vo = null;
        if (entity != null) {
            vo = (ProjectPoolSetVO)BeanMapper.map((Object)((Object)entity), ProjectPoolSetVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    @GetMapping(value={"syncZZYJProject"})
    @ResponseBody
    public CommonResponse<String> syncZZYJProject() {
        QueryParam param = new QueryParam();
        boolean has = true;
        int pageNum = 1;
        param.setPageSize(100);
        while (has) {
            IPage page = this.projectSetService.queryPage(param, false);
            List rec = page.getRecords();
            if (ListUtil.isNotEmpty((List)rec)) {
                for (ProjectSetPoolEntity poolEntity : rec) {
                    ProjectSetExPoolEntity exPoolEntity = (ProjectSetExPoolEntity)((Object)this.projectSetExPoolService.selectById(poolEntity.getId()));
                    if (exPoolEntity != null) {
                        int version = exPoolEntity.getVersion();
                        exPoolEntity = (ProjectSetExPoolEntity)((Object)BeanMapper.map((Object)((Object)poolEntity), ProjectSetExPoolEntity.class));
                        exPoolEntity.setVersion(version);
                    } else {
                        exPoolEntity = (ProjectSetExPoolEntity)((Object)BeanMapper.map((Object)((Object)poolEntity), ProjectSetExPoolEntity.class));
                    }
                    this.projectSetExPoolService.saveOrUpdateNoES((Object)exPoolEntity);
                }
                param.setPageIndex(++pageNum);
                continue;
            }
            has = false;
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/getTotalInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> getTotalInfo(@RequestBody QueryParam param) {
        JSONObject res = new JSONObject();
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (departmentIds.size() != 0) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        } else {
            res.put("total", (Object)0);
            res.put("fatherTotal", (Object)0);
            res.put("eTotal", (Object)0);
            return CommonResponse.success((Object)res);
        }
        List setEntities = this.projectSetService.queryList(param, false);
        if (param.getParams().get("attribute") != null) {
            Parameter parameter = (Parameter)param.getParams().get("attribute");
            if ("1".equals(parameter.getValue())) {
                res.put("total", (Object)setEntities.size());
                res.put("fatherTotal", (Object)setEntities.size());
                res.put("eTotal", (Object)0);
            } else {
                res.put("total", (Object)setEntities.size());
                res.put("fatherTotal", (Object)0);
                res.put("eTotal", (Object)setEntities.size());
            }
        } else {
            if (CollectionUtils.isNotEmpty((Collection)setEntities)) {
                List projectDesktopSubVOS = BeanMapper.mapList((Iterable)setEntities, ProjectDesktopSubParentVO.class);
                List projectDesktopSubVOSParent = TreeNodeBUtil.buildTree((List)projectDesktopSubVOS);
                res.put("total", (Object)projectDesktopSubVOSParent.size());
            } else {
                res.put("total", (Object)0);
            }
            param.getParams().put("attribute", new Parameter("eq", (Object)1));
            setEntities = this.projectSetService.queryList(param, false);
            res.put("fatherTotal", (Object)setEntities.size());
            param.getParams().put("attribute", new Parameter("eq", (Object)2));
            setEntities = this.projectSetService.queryList(param, false);
            res.put("eTotal", (Object)setEntities.size());
        }
        return CommonResponse.success((Object)res);
    }

    @GetMapping(value={"getProjectByCurrentOrg"})
    public CommonResponse<ProjectPoolSetVO> getProjectByCurrentOrg() {
        QueryParam param = new QueryParam();
        param.getParams().put("projectDepartmentId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        List entities = this.projectSetService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)entities)) {
            return CommonResponse.success((Object)BeanMapper.map(entities.get(0), ProjectPoolSetVO.class));
        }
        return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u9879\u76ee");
    }
}

