package com.ejianc.foundation.share.service;

import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.response.QueryParam;

import java.util.List;
import java.util.Map;

public interface ISteelMaterialCategoryService {

	/**
	 * 查询物料分类列表
	 *
	 * @param queryParam
	 * @return
	 */
	List<MaterialCategoryEntity> queryList(QueryParam queryParam);

	/**
	 * 查询物料分类详情
	 *
	 * @param id
	 * @return
	 */
	MaterialCategoryVO queryDetail(Long id);

	/**
	 * 修改
	 *
	 * @param entity
	 */
	void update(MaterialCategoryEntity entity);
	/**
	 * 修改
	 *
	 * @param subjectId 科目id
	 * @param subjectName 科目name
	 * @param ids		本次变更数据的id
	 */
	void updateSubject(Long subjectId, String subjectName, List<Long> ids);
	/**
	 * 新增
	 *
	 * @param entity
	 */
	void save(MaterialCategoryEntity entity);

	/**
	 * 批量新增
	 *
	 * @param entity
	 */
	void insertBatch(List<MaterialCategoryEntity> entity);

	/**
	 * 根据父ID查询物料分类列表
	 *
	 * @param id
	 * @return
	 */
	List<MaterialCategoryVO> queryListByPid(Long id);

	/**
	 * 根据父ID查询物料分类列表
	 *
	 * @param id
	 * @return
	 */
	List<MaterialCategoryVO> queryListAllByPid(Long id);
	/**
	 * 删除
	 *
	 * @param id
	 */
	void delete(Long id);

	/**
	 * 修改物料分类状态
	 *
	 * @param enabled
	 * @param tenantId
	 * @param innerCode
	 */
	void updateEnabled(Integer enabled, Long tenantId, String innerCode);

	/**
	 * 根据分类编号查询分类
	 *
	 * @param code
	 * @return
	 */
	List<MaterialCategoryEntity> queryByCode(String code);

	/**
	 * 根据分类名称查询分类
	 *
	 * @param name
	 * @return
	 */
	List<MaterialCategoryEntity> queryByName(String name);

	/**
	 * 同步平台物料分类到租户下
	 */
	void insertCategoryListFromPlatform();

	/**
	 * 查询列表tree
	 *
	 * @param params
	 * @return
	 */
	List<MaterialCategoryVO> queryListTree(Map<String, Object> params);

	MaterialCategoryVO queryBySourceId(String sourceId);

	/**
	 * 根据innerCode查询子级(包含本级)
	 *
	 * @param params
	 * @return
	 */
	List<MaterialCategoryVO> queryListByInnerCode(Map<String, Object> params);

    List<MaterialCategoryVO> queryCategoryListByChildren(List<Long> ids);

	Map<Long, List<MaterialCategoryVO>> queryCategoryListByMaterialId(List<Long> ids);

	List<MaterialCategoryVO> queryCategoryListByIds(List<Long> ids);

	List<MaterialCategoryVO> queryRemoveListByIds(Long pid);

	void delete(List<Long> ids);

	List<MaterialCategoryEntity> queryListEntityTree(Map<String, Object> params);

	List<Long> queryUnenabledCategoryListId();

	void changeCategoryEnableState(Long id, Integer enabled);
}
