package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgNoAuthApi;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.consts.ProjectBusinessStatusEnum;
import com.ejianc.foundation.share.controller.param.YnsbjProjectParam;
import com.ejianc.foundation.share.controller.resp.YnsbjDataInfo;
import com.ejianc.foundation.share.mapper.ProjectSetMapper;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectDesktopSubParentVO;
import com.ejianc.foundation.share.vo.ProjectDesktopSubVO;
import com.ejianc.foundation.share.vo.ProjectDesktopVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
@Transactional
public class ProjectSetServiceImpl extends BaseServiceImpl<ProjectSetMapper, ProjectSetPoolEntity> implements IProjectSetService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());



    @Autowired
    private ProjectSetMapper projectSetMapper;


    @Autowired
    private ISupplierService iSupplierService;


    @Autowired
    private IOrgNoAuthApi iOrgNoAuthApi;

    @Autowired
    private IDefdocApi iDefdocApi;

    /**
     * 主数据插入项目信息
     */
    @Override
    public YnsbjDataInfo saveOrUpdateYnsbjProject(YnsbjProjectParam projectParam) {
        // TODO Auto-generated method stub
        logger.info("主数据插入项目信息-{}",JSONObject.toJSONString(projectParam));
        ProjectSetPoolEntity projectSetPoolEntity ;

        QueryParam param = new QueryParam();
        param.getParams().put("code", new Parameter(QueryParam.EQ, projectParam.getCode()));
        List<ProjectSetPoolEntity> projectSetPoolEntities = queryList(param);
        if (ListUtil.isNotEmpty(projectSetPoolEntities)) {
            projectSetPoolEntity = projectSetPoolEntities.get(0);
        } else {
            projectSetPoolEntity = new ProjectSetPoolEntity();
        }


        YnsbjDataInfo dataInfo = null;
        OrgVO orgVO = new OrgVO();
        /** 部门架构编码 DESC84 -->对应项目的 施工单位 */
        String code = projectParam.getOrgId();

        projectSetPoolEntity.setName(projectParam.getPrjName());
        projectSetPoolEntity.setShortName(projectParam.getPrjName());
        projectSetPoolEntity.setBillState(1);
        projectSetPoolEntity.setCode(projectParam.getCode());
        projectSetPoolEntity.setNumber(projectParam.getPrjCode());
        /** 建设单位 取值供应商 */
        QueryParam cus = new QueryParam();
        cus.getParams().put("name",new Parameter(QueryParam.EQ,projectParam.getConstructName()));
        List<SupplierEntity> supplierEntities = iSupplierService.queryList(cus);
        if(ListUtil.isNotEmpty(supplierEntities)){
            projectSetPoolEntity.setConstructId(supplierEntities.get(0).getId());
        }
        projectSetPoolEntity.setConstructName(projectParam.getConstructName());
        projectSetPoolEntity.setDesigner(projectParam.getDesignerName());
        /** 专业分类 ---》 工程类别 */
        logger.info("工程类别-{}",projectParam.getProfessionType());
        CommonResponse<List<DefdocDetailVO>> response = iDefdocApi.getDefDocDetailByDefCodeAndTenantId("pro-market-project-engineeringType",999999L);
        if (response.isSuccess() && ListUtil.isNotEmpty(response.getData())) {
            for (int i = 0; i < response.getData().size(); i++) {
                DefdocDetailVO detailVO = response.getData().get(i);
                if (detailVO.getName().equals(projectParam.getProfessionType())) {
                    projectSetPoolEntity.setEngineeringTypeId(detailVO.getId());
                }
            }
        }
        /** 监理单位名称 */
        projectSetPoolEntity.setSupervisor(projectParam.getSupervisorName());
        projectSetPoolEntity.setTaxType("简易计税".equals(projectParam.getTaxType()) ? "2" : "1");
        /** 项目类型分类 */
        logger.info("项目类型分类-{}",projectParam.getProjectTypeCategory());
        projectSetPoolEntity.setProjectNewType(projectParam.getProjectTypeCategory());

        /** 行业类别 */
        logger.info("行业类别-{}",projectParam.getIndustryType());
        response = iDefdocApi.getDefDocDetailByDefCodeAndTenantId("pro_matket_industry_type",999999L);
        if (response.isSuccess() && ListUtil.isNotEmpty(response.getData())) {
            for (int i = 0; i < response.getData().size(); i++) {
                DefdocDetailVO detailVO = response.getData().get(i);
                if (detailVO.getName().equals(projectParam.getIndustryType())) {
                    projectSetPoolEntity.setIndustryType(detailVO.getId());
                }
            }
        }else {
            logger.info("行业类别返回数据：-{}",JSONObject.toJSONString(response));
        }

        /** 承包模式 */
        logger.info("承包模式-{}",projectParam.getProjectType());
        response = iDefdocApi.getDefDocDetailByDefCodeAndTenantId("pro-market-project-type",999999L);
        if (response.isSuccess() && ListUtil.isNotEmpty(response.getData())) {
            for (int i = 0; i < response.getData().size(); i++) {
                DefdocDetailVO detailVO = response.getData().get(i);
                if (detailVO.getName().equals(projectParam.getProjectType())) {
                    projectSetPoolEntity.setProjectType(detailVO.getId());
                }
            }
        }

        /** 经营方式 */
        logger.info("经营方式-{}",projectParam.getRunType());
        response = iDefdocApi.getDefDocDetailByDefCodeAndTenantId("pro-market-project-run-type",999999L);
        if (response.isSuccess() && ListUtil.isNotEmpty(response.getData())) {
            for (int i = 0; i < response.getData().size(); i++) {
                DefdocDetailVO detailVO = response.getData().get(i);
                if (detailVO.getName().equals(projectParam.getRunType())) {
                    projectSetPoolEntity.setRunType(detailVO.getId());
                }
            }
        }
        projectSetPoolEntity.setMainDeploy(projectParam.getDevMainName());
        /** 实施主体 */
        if(StringUtils.isNotEmpty(projectParam.getOperateMainCode())){
            OrgVO mainDeploy = new OrgVO();
            mainDeploy.setCode(projectParam.getOperateMainCode());
            CommonResponse<OrgVO> r = iOrgNoAuthApi.findOneByOrgVO(mainDeploy);
            if(r.isSuccess()){
                projectSetPoolEntity.setMainDeployId(r.getData().getId());
            }else {
                logger.error("实施主体 DESC69=" + projectParam.getOperateMainCode() + "未查询到对应组织！请先同步该组织！");
            }
        }else {
            logger.error("实施主体 DESC69=" + projectParam.getOperateMainCode() + "  为空！");
        }
        if ("自营".equals(projectParam.getDevType())) {
            projectSetPoolEntity.setDevType("1");
        } else if ("联营".equals(projectParam.getDevType())) {
            projectSetPoolEntity.setDevType("2");
        }

        logger.info("融资建设-{}",projectParam.getFinanceConstruct());
        projectSetPoolEntity.setFinancingConstruction(projectParam.getFinanceConstruct());
        /** 资金来源 */
        logger.info("资金来源-{}",projectParam.getFundsSource());
        response = iDefdocApi.getDefDocDetailByDefCodeAndTenantId("pro-market-project-fine-source",999999L);
        if (response.isSuccess() && ListUtil.isNotEmpty(response.getData())) {
            for (int i = 0; i < response.getData().size(); i++) {
                DefdocDetailVO detailVO = response.getData().get(i);
                if (detailVO.getName().equals(projectParam.getFundsSource())) {
                    projectSetPoolEntity.setFundsSource(detailVO.getId());
                }
            }
        }

        /** 国家 */
        logger.info("国家-{}",projectParam.getNationalName());
        response = iDefdocApi.getDefDocDetailByDefCodeAndTenantId("sddjsprj_project_area",999999L);
        if (response.isSuccess() && ListUtil.isNotEmpty(response.getData())) {
            for (int i = 0; i < response.getData().size(); i++) {
                DefdocDetailVO detailVO = response.getData().get(i);
                if (detailVO.getName().equals(projectParam.getNationalName())) {
                    projectSetPoolEntity.setNationalId(detailVO.getId());
                    projectSetPoolEntity.setNationalName(projectParam.getNationalName());
                }
            }
        }

        projectSetPoolEntity.setAreaName((projectParam.getProvince()==null?"":projectParam.getProvince()) + "," +
                (projectParam.getCity()==null?"":projectParam.getCity()) + "," + (projectParam.getArea()==null?"":projectParam.getArea()));
        String hasParent = projectParam.getHasParent();
        CommonResponse<OrgVO> oneByOrgVO;

        /**
         *（13-1）如果“合同主体”DESC70是“总承包公司”，且“实施主体”DESC69也是“总承包公司”
         *
         * */
        if("DJB01".equals(projectParam.getContractMainCode()) && "DJB01".equals(projectParam.getOperateMainCode())){

            /** 施工单位 【主数据】“部门架构”->【项目池】施工单位（可能存在为空的情况）*/
            if(StringUtils.isNotEmpty(code)){
                orgVO = new OrgVO();
                orgVO.setCode(code);
                 oneByOrgVO = iOrgNoAuthApi.findOneByOrgVO(orgVO);
                if(oneByOrgVO.isSuccess()){
                     projectSetPoolEntity.setBuildUnitName(oneByOrgVO.getData().getName());
                     projectSetPoolEntity.setBuildUnitId(oneByOrgVO.getData().getId());
                 }
             }
            /**
             * 给【项目池】“是否有父项目”、“父项目编号”、“父项目名称”、“父项目所属公司”赋值：
             * A.【主数据】是否有父项目->【项目池】是否有父项目
             * B.【主数据】父项目编号->【项目池】父项目编号
             * C.根据【主数据】父项目编码，找PM系统【项目池】的项目id->【项目池】父项目名称
             * D.【主数据】父项目所属公司->【项目池】父项目所属公司
             * */
            if ("是".equals(hasParent)) {
                projectSetPoolEntity.setHasParent(1);
                param = new QueryParam();
                param.getParams().put("code", new Parameter(QueryParam.EQ, projectParam.getParentCode()));
                projectSetPoolEntities = queryList(param);
                if (ListUtil.isNotEmpty(projectSetPoolEntities)) {
                    projectSetPoolEntity.setParentProjectId(projectSetPoolEntities.get(0).getId());
                    projectSetPoolEntity.setParentProjectName(projectSetPoolEntities.get(0).getName());
                } else {
                    logger.error("父项目编码{}没有找到具体项目，应该没同步过来！", JSONObject.toJSONString(projectParam.getParentCode()));
                }
            }else {
                projectSetPoolEntity.setHasParent(0);
                projectSetPoolEntity.setParentProjectId(null);
                projectSetPoolEntity.setParentProjectName(null);
            }


            /**
             * 给【项目池】“项目属性”赋值：
             * A.【主数据】是否有父项目=否，且“部门架构”为空，则->【项目池】“项目属性”=父项目
             * B.【主数据】是否有父项目=是，且“部门架构”为空，则->【项目池】“项目属性”=父项目
             * C.【主数据】是否有父项目=否，且“部门架构”有值，则->【项目池】“项目属性”=执行项目
             * D.【主数据】是否有父项目=是，且“部门架构”有值，则->【项目池】“项目属性”=执行项目
             *
             * 也就是“部门架构”为空 则 ->【项目池】“项目属性”=父项目
             * */
            if (StringUtils.isEmpty(projectParam.getOrgId())) {
                projectSetPoolEntity.setAttribute("1");//父项目
                /**
                 * 给【项目池】“项目所属组织”赋值：
                 * A.如果【项目池】“项目属性”为“父项目”，则“项目所属组织”=固定值“DJB01-GSNFXM  公司内父项目”
                 * B.如果【项目池】“项目属性”为“执行项目”，则“项目所属组织”=“施工单位”
                 *
                 *  */
                orgVO = new OrgVO();
                orgVO.setCode("DJB01-GSNFXM");
                oneByOrgVO = iOrgNoAuthApi.findOneByOrgVO(orgVO);
                if(oneByOrgVO.isSuccess()){
                    projectSetPoolEntity.setOrgId(oneByOrgVO.getData().getId());
                    projectSetPoolEntity.setOrgName(oneByOrgVO.getData().getName());
                }else {
                    logger.error("DJB01-GSNFXM 公司内父项目 没有找到具体组织，应该没建立！");
                }
            }else {
                projectSetPoolEntity.setAttribute("2");//执行项目
                projectSetPoolEntity.setOrgId(projectSetPoolEntity.getBuildUnitId());
                projectSetPoolEntity.setOrgName(projectSetPoolEntity.getBuildUnitName());
            }

         /**（13-2）如果“合同主体”是“总承包公司”，但是“实施主体”不是“总承包公司” */
        }else if("DJB01".equals(projectParam.getContractMainCode()) && !"DJB01".equals(projectParam.getOperateMainCode())){

            /** 给【项目池】“施工单位”赋值：【项目池】“施工单位”为空 */
            projectSetPoolEntity.setBuildUnitId(null);
            projectSetPoolEntity.setBuildUnitName(null);
            /**
             * 给【项目池】“是否有父项目”、“父项目名称”、“父项目编号”、“父项目所属公司”、“项目属性”赋值：
             *
             * */
            if ("是".equals(hasParent)) {
                /**
                 *.如果【主数据】“是否有父项目”为“是”，且【主数据】“部门架构编码”为空，则设置
                 * a.【项目池】“是否有父项目”=“否”
                 * b.【项目池】父项目名称=空
                 * c.【项目池】父项目编号=空
                 * d.【项目池】父项目所属公司=空
                 * e.【项目池】项目属性=父项目
                 * */
                if(StringUtils.isEmpty(projectParam.getOrgId())){
                    projectSetPoolEntity.setHasParent(0);
                    projectSetPoolEntity.setParentProjectId(null);
                    projectSetPoolEntity.setParentProjectName(null);
                    projectSetPoolEntity.setAttribute("1");//父项目
                }else {
                    /**
                     * 如果【主数据】“是否有父项目”为“是”，且【主数据】“部门架构编码”有值，则设置
                     * a.【项目池】“是否有父项目”=“是”
                     * c.【主数据】父项目编号->【项目池】父项目编号
                     * b.根据【主数据】父项目编码，找PM系统【项目池】的项目id->【项目池】父项目名称
                     * c.【主数据】父项目所属公司->【项目池】父项目所属公司
                     * d.【项目池】项目属性=执行项目
                     * */
                    projectSetPoolEntity.setAttribute("2");//执行项目
                    projectSetPoolEntity.setHasParent(1);
                    param = new QueryParam();
                    param.getParams().put("code", new Parameter(QueryParam.EQ, projectParam.getParentCode()));
                    projectSetPoolEntities = queryList(param);
                    if (ListUtil.isNotEmpty(projectSetPoolEntities)) {
                        projectSetPoolEntity.setParentProjectId(projectSetPoolEntities.get(0).getId());
                        projectSetPoolEntity.setParentProjectName(projectSetPoolEntities.get(0).getName());
                    } else {
                        logger.error("父项目编码{}没有找到具体项目，应该没同步过来！", JSONObject.toJSONString(projectParam.getParentCode()));
                    }
                }

            }else {
                dataInfo = new YnsbjDataInfo(projectParam.getUuid(), projectParam.getMasterDataCode(), "1", "“合同主体”是“总承包公司”，“实施主体”不是“总承包公司”，当前数据应该是父项目！");
                return dataInfo;
            }

            /**
             * 给【项目池】“项目所属组织”赋值：
             * 同步【主数据】“组织架构”->【项目池】“项目所属组织”
             * */
            if(StringUtils.isNotEmpty(projectParam.getOrgStructureCode())){
                orgVO = new OrgVO();
                orgVO.setCode(projectParam.getOrgStructureCode());
                oneByOrgVO = iOrgNoAuthApi.findOneByOrgVO(orgVO);
                if(oneByOrgVO.isSuccess()){
                    projectSetPoolEntity.setOrgId(oneByOrgVO.getData().getId());
                    projectSetPoolEntity.setOrgName(oneByOrgVO.getData().getName());
                }else {
                    logger.error("主数据 组织架构编码{} 没有找到具体组织，应该没同步！", projectParam.getOrgStructureCode());
                }
            }else {
                logger.error("主数据 组织架构编码{} 为空！", projectParam.getOrgStructureCode());
            }

         /** 如果“合同主体”不是“总承包公司”，但是“实施主体”是“总承包公司”   */
        }else if(!"DJB01".equals(projectParam.getContractMainCode()) && "DJB01".equals(projectParam.getOperateMainCode())){

            /** 给【项目池】“施工单位”赋值：【主数据】部门架构->【项目池】“施工单位”（可能存在为空的情况）
             *
             * 给【项目池】“项目属性”赋值：
             * A.【主数据】“部门架构”为空，则->【项目池】“项目属性”=父项目
             * B.【主数据】“部门架构”有值，则->【项目池】“项目属性”=执行项目
             *
             * */
            if(StringUtils.isNotEmpty(code)){
                projectSetPoolEntity.setAttribute("2");
                orgVO = new OrgVO();
                orgVO.setCode(code);
                oneByOrgVO = iOrgNoAuthApi.findOneByOrgVO(orgVO);
                if(oneByOrgVO.isSuccess()){
                    projectSetPoolEntity.setBuildUnitId(oneByOrgVO.getData().getId());
                    projectSetPoolEntity.setBuildUnitName(oneByOrgVO.getData().getName());
                }
            }else {
                projectSetPoolEntity.setAttribute("1");
            }
            /**
             * 给【项目池】“是否有父项目”、“父项目名称”赋值：
             * 如果【主数据】“是否父项目”为“否”，则设置【项目池】“是否有父项目”=否
             *.如果【主数据】“是否父项目”为“是”，
             * a.当【项目池】“父项目名称”有值，则设置【项目池】“是否有父项目”=是 其他都是 否
             * b.当【项目池】“父项目所属公司”不是“总承包公司”，且“父项目名称”为空，则设置【项目池】“是否有父项目”=否
             * */
            param = new QueryParam();
            param.getParams().put("code", new Parameter(QueryParam.EQ, projectParam.getParentCode()));
            projectSetPoolEntities = queryList(param);
            if ("是".equals(hasParent) && ListUtil.isNotEmpty(projectSetPoolEntities)) {
                projectSetPoolEntity.setHasParent(1);
                projectSetPoolEntity.setParentProjectId(projectSetPoolEntities.get(0).getId());
                projectSetPoolEntity.setParentProjectName(projectSetPoolEntities.get(0).getName());
            }else {
                projectSetPoolEntity.setHasParent(0);
                projectSetPoolEntity.setParentProjectId(null);
                projectSetPoolEntity.setParentProjectName(null);
            }

            /**
             * 给【项目池】“项目所属组织”赋值：
             * 同步【主数据】“组织架构”->【项目池】项目所属组织
             * */
            if(StringUtils.isNotEmpty(projectParam.getOrgStructureCode())){
                orgVO = new OrgVO();
                orgVO.setCode(projectParam.getOrgStructureCode());
                oneByOrgVO = iOrgNoAuthApi.findOneByOrgVO(orgVO);
                if(oneByOrgVO.isSuccess()){
                    projectSetPoolEntity.setOrgId(oneByOrgVO.getData().getId());
                    projectSetPoolEntity.setOrgName(oneByOrgVO.getData().getName());
                }else {
                    logger.error("主数据 组织架构编码{} 没有找到具体组织，应该没同步，无法为所属组织赋值！", projectParam.getOrgStructureCode());
                }
            }else {
                logger.error("主数据 组织架构编码{} 为空,无法为所属组织赋值！", projectParam.getOrgStructureCode());
            }
        }

        //添加施工项目部
        orgVO = generateProjectDepartment(projectSetPoolEntity);
        if (orgVO != null) {
            CommonResponse<OrgVO> response1 = iOrgNoAuthApi.saveOrgInfo(orgVO);
            logger.info("云南建投 ：生成项目部----！orgVO=>{},{},{}", orgVO, JSONObject.toJSONString(projectSetPoolEntity), response1.getMsg());
            if (response1.isSuccess()) {
                orgVO = response1.getData();
                projectSetPoolEntity.setProjectDepartmentId(orgVO.getId());
                projectSetPoolEntity.setProjectDepartmentName(orgVO.getName());
            } else {
                logger.error("云南建投 ：生成项目部失败！{},{}", JSONObject.toJSONString(projectSetPoolEntity), response1.getMsg());
            }
        }

        /** 生成对应部门 */
        if (projectSetPoolEntity.getProjectDepartmentId() != null) {
            DeptVO deptVO = new DeptVO();
            deptVO.setOrgId(projectSetPoolEntity.getProjectDepartmentId());
            deptVO.setCode(projectSetPoolEntity.getCode());
            deptVO.setName(projectSetPoolEntity.getName());
            deptVO.setShortName(projectSetPoolEntity.getShortName());
            deptVO.setNote("同步主数据生成！" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            deptVO.setState(1);
            deptVO.setSequence(0);
            deptVO.setType(2);
            /** 会根据编码更新 部门 */
            iOrgNoAuthApi.saveDeptInfo(deptVO);
        }


        projectSetPoolEntity.setParentProjectNumber(projectParam.getParentCode());
        projectSetPoolEntity.setHasContract(projectParam.getContractFlag());
        projectSetPoolEntity.setContractName(projectParam.getContractName());
        projectSetPoolEntity.setContractType(projectParam.getContractType());
        projectSetPoolEntity.setContractAmount(projectParam.getContractMny());
        projectSetPoolEntity.setContractSubject(projectParam.getContractMain());
        projectSetPoolEntity.setPlanStartDate(projectParam.getPlanStartDate());
        projectSetPoolEntity.setPlanEndDate(projectParam.getPlanEndDate());
        projectSetPoolEntity.setActualStartDate(projectParam.getActualStartDate());
        projectSetPoolEntity.setActualEndDate(projectParam.getActualEndDate());
        projectSetPoolEntity.setFirstDate(projectParam.getInitVerifyDate());
        projectSetPoolEntity.setProjectManagementName(projectParam.getProjectManagementName());
        projectSetPoolEntity.setProjectManagementPhone(projectParam.getProjectManagementPhone());
        projectSetPoolEntity.setTechnologyName(projectParam.getTechnologyName());
        projectSetPoolEntity.setQualityName(projectParam.getQualityName());
        projectSetPoolEntity.setSafeName(projectParam.getSafeName());

        projectSetPoolEntity.setRelationCode(projectParam.getRelationCode());
        projectSetPoolEntity.setRelationName(projectParam.getRelationName());
        projectSetPoolEntity.setLegalPersonAccountBookCode(projectParam.getLegalPersonAccountBookCode());
        projectSetPoolEntity.setLegalPersonAccountBookName(projectParam.getLegalPersonAccountBookName());
        projectSetPoolEntity.setOrgStructureCode(projectParam.getOrgStructureCode());
        projectSetPoolEntity.setOrgStructureName(projectParam.getOrgStructureName());
        projectSetPoolEntity.setCloudBusinessTenantCode(projectParam.getCloudBusinessTenantCode());
        projectSetPoolEntity.setDeptStructureCode(projectParam.getOrgId());
        projectSetPoolEntity.setDeptStructureName(projectParam.getOrgName());

        /** 各种状态初始化
         *
         * 同步主数据项目时，【项目池】各类状态赋值如下：
         * 1. 项目状态：
         *     a. 【施工项目主数据】【项目状态】“在建工程”->【项目池】【项目状态】“在建”
         *     b. 【施工项目主数据】【项目状态】“竣工未结算”->【项目池】【项目状态】“竣工”
         *     c. 【施工项目主数据】【项目状态】“竣工已结算”->【项目池】【项目状态】“竣工”
         *     d. 【施工项目主数据】【项目状态】“签订合同”->【项目池】【项目状态】“在建”
         * 2. 业务状态：
         *     a. 【施工项目主数据】【项目施工状态】“新开工”->【项目池】【业务状态】“开工准备”
         *     b. 【施工项目主数据】【项目施工状态】“在建”->【项目池】【业务状态】“在建”
         *     c. 【施工项目主数据】【项目施工状态】“停工”->【项目池】【业务状态】“停工”
         *     d. 【施工项目主数据】【项目施工状态】“完工”->【项目池】【业务状态】“完工”
         *     e. 【施工项目主数据】【项目施工状态】“竣工”->【项目池】【业务状态】“竣工验收”
         * 3. 结算状态：
         *     a. 如果【施工项目主数据】的【项目状态】为“竣工未结算”，则赋值【项目池】【结算状态】赋值为“未决算”
         *     b. 如果【施工项目主数据】的【项目状态】为“竣工已结算”，则赋值【项目池】【结算状态】赋值为“已决算”
         *     c. 其他情况，默认“未决算”
         * 4. 资料归档状态：赋值为“资料未归档”
         * 5. 资金管控状态：赋值为“开账正常”
         *
         * */
        if(projectSetPoolEntity.getId() == null){
            /**
             * 1. 项目状态：
             *     a. 【施工项目主数据】【项目状态】“在建工程”->【项目池】【项目状态】“在建”
             *     b. 【施工项目主数据】【项目状态】“竣工未结算”->【项目池】【项目状态】“竣工”
             *     c. 【施工项目主数据】【项目状态】“竣工已结算”->【项目池】【项目状态】“竣工”
             *     d. 【施工项目主数据】【项目状态】“签订合同”->【项目池】【项目状态】“在建”
             **/
            if("在建工程".equals(projectParam.getProjectStatus())){
                projectSetPoolEntity.setProjectStatus("1");
            }else if("竣工未结算".equals(projectParam.getProjectStatus())){
                projectSetPoolEntity.setProjectStatus("3");
            }else if("竣工已结算".equals(projectParam.getProjectStatus())){
                projectSetPoolEntity.setProjectStatus("3");
            }else if("签订合同".equals(projectParam.getProjectStatus())){
                projectSetPoolEntity.setProjectStatus("1");
            }else{
                projectSetPoolEntity.setProjectStatus("1");
            }

            /**
             * 2. 业务状态：
             *     a. 【施工项目主数据】【项目施工状态】“新开工”->【项目池】【业务状态】“开工准备”
             *     b. 【施工项目主数据】【项目施工状态】“在建”->【项目池】【业务状态】“在建”
             *     c. 【施工项目主数据】【项目施工状态】“停工”->【项目池】【业务状态】“停工”
             *     d. 【施工项目主数据】【项目施工状态】“完工”->【项目池】【业务状态】“完工”
             *     e. 【施工项目主数据】【项目施工状态】“竣工”->【项目池】【业务状态】“竣工验收”
             **/
            if("新开工".equals(projectParam.getProjectBuildStatus())){
                projectSetPoolEntity.setBusinessStatus("1");
            }else if("在建".equals(projectParam.getProjectBuildStatus())){
                projectSetPoolEntity.setBusinessStatus("2");
            }else if("停工".equals(projectParam.getProjectBuildStatus())){
                projectSetPoolEntity.setBusinessStatus("3");
            }else if("完工".equals(projectParam.getProjectBuildStatus())){
                projectSetPoolEntity.setBusinessStatus("5");
            }else if("竣工".equals(projectParam.getProjectBuildStatus())){
                projectSetPoolEntity.setBusinessStatus("6");
            }else{
                projectSetPoolEntity.setBusinessStatus("1");
            }
            /**
             * 3.  结算状态
             *    a. 如果【施工项目主数据】的【项目状态】为“竣工未结算”，则赋值【项目池】【结算状态】赋值为“未决算”
             *    b. 如果【施工项目主数据】的【项目状态】为“竣工已结算”，则赋值【项目池】【结算状态】赋值为“已决算”
             * */
            if("竣工未结算".equals(projectParam.getProjectStatus())){
                projectSetPoolEntity.setSettleStatus("1");
            }else if("竣工已结算".equals(projectParam.getProjectStatus())){
                projectSetPoolEntity.setSettleStatus("9");
            }else{
                projectSetPoolEntity.setSettleStatus("1");
            }
            /**
             * 4. 资料归档状态：赋值为“资料未归档”
             * 5. 资金管控状态：赋值为“开账正常”
             * */
            projectSetPoolEntity.setArchiveStatus("10");
            projectSetPoolEntity.setCapitalStatus("14");
        }

        /** 工程度量方式 */
        response = iDefdocApi.getDefDocDetailByDefCodeAndTenantId("pro-market-project-measureType",999999L);
        if (response.isSuccess() && ListUtil.isNotEmpty(response.getData())) {
            for (int i = 0; i < response.getData().size(); i++) {
                DefdocDetailVO detailVO = response.getData().get(i);
                if (detailVO.getName().equals(projectParam.getMeasureType())) {
                    projectSetPoolEntity.setMeasureType(detailVO.getId());
                }
            }
        }
        projectSetPoolEntity.setMeasureValue(projectParam.getMeasureValue());
        projectSetPoolEntity.setTenantId(999999L);
        projectSetPoolEntity.setPaymentDate(new Date());
        projectSetPoolEntity.setKeyProject(false);
        saveOrUpdate(projectSetPoolEntity);
        dataInfo = new YnsbjDataInfo(projectParam.getUuid(), projectParam.getMasterDataCode(), "0", "操作成功");
        return dataInfo;
    }

    @Override
    public OrgVO generateProjectDepartment(ProjectSetPoolEntity projectSetVO) {
        if (projectSetVO.getOrgId() == null) {
            logger.error("保存项目信息失败，所属组织信息不存在。");
            return null;
        }
        OrgVO parentOrg = new OrgVO();
        parentOrg.setId(projectSetVO.getOrgId());
        CommonResponse<OrgVO> response = iOrgNoAuthApi.findOneByOrgVO(parentOrg);
        if (response.isSuccess()) {
            parentOrg = response.getData();
        } else {
            logger.error("保存项目信息失败，查询所属组织信息失败: " + response.getMsg());
            return null;
        }
        if (null == parentOrg) {
            logger.error("保存项目信息失败，所属组织信息不存在。");
            return null;
        }
        OrgVO projectDepartment = new OrgVO();
        projectDepartment.setCode(projectSetVO.getCode());
        response = iOrgNoAuthApi.findOneByOrgVO(projectDepartment);
        if (response.isSuccess() && response.getData() != null) {
            projectDepartment = response.getData();
            projectDepartment.setParentId(projectSetVO.getOrgId());
            projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
            projectDepartment.setName(projectSetVO.getName());
            projectDepartment.setShortName(projectSetVO.getShortName());
        } else {
            projectDepartment.setId(IdWorker.getId());
            projectDepartment.setParentId(projectSetVO.getOrgId());
            projectDepartment.setTenantId(parentOrg.getTenantId());
            projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
            projectDepartment.setIsParent(false);
            projectDepartment.setName(projectSetVO.getName());
            projectDepartment.setShortName(projectSetVO.getShortName());
            projectDepartment.setState(1);
            //项目部类型
            projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
        }

        return projectDepartment;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCount(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList) {
        ProjectDesktopVO projectDesktopVO = null;
        List<ProjectDesktopSubVO> projectDesktopSubVOS = baseMapper.countBusinessStatus(commonOrgIds, departmentIds, businessStatusList);

        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            projectDesktopVO = baseMapper.countProjectStatus(commonOrgIds, departmentIds, null);
            BigDecimal totalNum = projectDesktopVO.getTotalNum();
            BigDecimal otherNum = totalNum;
            HashMap<String, ProjectDesktopSubVO> map = new HashMap<>();

            for (ProjectDesktopSubVO t : projectDesktopSubVOS) {
                map.put(t.getBusinessStatus(), t);
                otherNum = ComputeUtil.safeSub(otherNum, t.getNum());
                t.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode(t.getBusinessStatus()));
            }
            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = map.get(businessStatus);
                if (projectDesktopSubVO == null) {
                    ProjectDesktopSubVO subVO = new ProjectDesktopSubVO();
                    subVO.setBusinessStatus(businessStatus);
                    subVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode(businessStatus));
                    subVO.setNum(BigDecimal.ZERO);
                    map.put(businessStatus, subVO);
                }
            }
            ProjectDesktopSubVO other = new ProjectDesktopSubVO();
            other.setBusinessStatus("99");
            other.setBusinessStatusName("其他");
            other.setNum(ComputeUtil.nullToZero(otherNum));
            map.put(other.getBusinessStatus(), other);


            projectDesktopVO.setDetail(new ArrayList<>(map.values()));
        }
        return projectDesktopVO;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCountParent(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList) {
        ProjectDesktopVO projectDesktopVO = null;
        List<ProjectDesktopSubParentVO> projectDesktopSubVOSParent = new ArrayList<>();
        List<ProjectDesktopSubVO> desktopSubVOS = new ArrayList<>();
        String thisYear = EJCDateUtil.getYear() + "";
        List<ProjectDesktopSubParentVO> projectDesktopSubVOS = baseMapper.countBusinessStatusParent(commonOrgIds, departmentIds);
        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            projectDesktopSubVOSParent = TreeNodeBUtil.buildTree(projectDesktopSubVOS);// 主子项目的返回数据
            projectDesktopVO = new ProjectDesktopVO();
            BigDecimal totalNum = new BigDecimal(projectDesktopSubVOSParent.size());//项目总数
            BigDecimal otherNum = totalNum;
            projectDesktopVO.setTotalNum(totalNum);
            Long buildNum = projectDesktopSubVOSParent.stream().filter(e -> null!=e.getProjectStatus()&&"1".equals(e.getProjectStatus())).count();//在建项目数
            projectDesktopVO.setBuildNum(new BigDecimal(buildNum));
            Long thisYearProjectNum = projectDesktopSubVOSParent.stream().filter(e -> null!=e.getProjectDate()&&thisYear.equals(e.getProjectDate().substring(0,4))).count();//今年新增项目数
            projectDesktopVO.setThisYearProjectNum(new BigDecimal(thisYearProjectNum));

            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = new ProjectDesktopSubVO();
                projectDesktopSubVO.setBusinessStatus(businessStatus);
                projectDesktopSubVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode(businessStatus));
                Long num = projectDesktopSubVOSParent.stream().filter(e -> null!=e.getBusinessStatus()&&businessStatus.equals(e.getBusinessStatus())).count();
                if(null!=num){
                    projectDesktopSubVO.setNum(new BigDecimal(num));
                    otherNum = ComputeUtil.safeSub(otherNum, new BigDecimal(num));
                }
                desktopSubVOS.add(projectDesktopSubVO);
            }
            ProjectDesktopSubVO other = new ProjectDesktopSubVO();
            other.setBusinessStatus("99");
            other.setBusinessStatusName("其他");
            other.setNum(ComputeUtil.nullToZero(otherNum));
            desktopSubVOS.add(other);
            projectDesktopVO.setDetail(desktopSubVOS);
        }
        return projectDesktopVO;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCountZzyj(List<Long> commonOrgIds, List<Long> departmentIds,
                                                                List<String> businessStatusList, String yearType) {
        ProjectDesktopVO projectDesktopVO = null;
        List<ProjectDesktopSubParentVO> projectDesktopSubVOSParent = new ArrayList<>();

         String year= EJCDateUtil.getYear() + "";
        if (yearType != null && "0".equals(yearType)){//上一年
            year = (EJCDateUtil.getYear()-1)+ "";
        }
        String thisYear = year;

        //在建项目数与新增项目数  需要根据父子项目过滤
        List<ProjectDesktopSubParentVO> projectDesktopSubVOS = baseMapper.countBusinessStatusParent(commonOrgIds, departmentIds);
        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            projectDesktopVO = new ProjectDesktopVO();
            BigDecimal totalNumAll = new BigDecimal(projectDesktopSubVOS.size());//项目总数所有项目包含父项目执行项目
            projectDesktopVO.setTotalNumAll(totalNumAll);

            projectDesktopSubVOSParent = TreeNodeBUtil.buildTree(projectDesktopSubVOS);// 主子项目的返回数据

            BigDecimal totalNum = new BigDecimal(projectDesktopSubVOSParent.size());//项目总数
            projectDesktopVO.setTotalNum(totalNum);
            Long buildNum = projectDesktopSubVOSParent.stream().filter(e -> null!=e.getProjectStatus()&&"1".equals(e.getProjectStatus())).count();//在建项目数
            projectDesktopVO.setBuildNum(new BigDecimal(buildNum));
            Long thisYearProjectNum = projectDesktopSubVOSParent.stream().filter(e -> null!=e.getProjectDate()&&thisYear.equals(e.getProjectDate().substring(0,4))).count();//今年新增项目数
            projectDesktopVO.setThisYearProjectNum(new BigDecimal(thisYearProjectNum));
        }

        List<ProjectDesktopSubVO> projectDesktopSubList = baseMapper.countBusinessStatus(commonOrgIds, departmentIds, businessStatusList);
        if (CollectionUtils.isNotEmpty(projectDesktopSubList)) {
            HashMap<String, ProjectDesktopSubVO> map = new HashMap<>();

            for (ProjectDesktopSubVO t : projectDesktopSubList) {
                map.put(t.getBusinessStatus(), t);
                t.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode(t.getBusinessStatus()));
            }
            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = map.get(businessStatus);
                if (projectDesktopSubVO == null) {
                    ProjectDesktopSubVO subVO = new ProjectDesktopSubVO();
                    subVO.setBusinessStatus(businessStatus);
                    subVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode(businessStatus));
                    subVO.setNum(BigDecimal.ZERO);
                    map.put(businessStatus, subVO);
                }
            }
            projectDesktopVO.setDetail(new ArrayList<>(map.values()));
        }
        return projectDesktopVO;
    }


    @Override
    public void deleteProjectById(List<Long> ids) {
        baseMapper.deleteProjectById(ids);
    }

    @Override
    public IPage<ProjectSetPoolEntity> queryMdmPage(QueryParam param) {
        Map<String, Object> condition = new HashMap<>();
        Parameter parameter = param.getParams().get("syncTime");
		if(parameter != null) {
			condition.put("syncTime", parameter.getValue());
		}
        condition.put("pageIndex",(param.getPageIndex()-1)*param.getPageSize());
        condition.put("pageSize",param.getPageSize());
        List<ProjectSetPoolEntity> poolEntities = projectSetMapper.queryMdmPage(condition);
        IPage<ProjectSetPoolEntity> page = new Page<>();
        page.setRecords(poolEntities);
        return page;
    }

    @Override
    public BigDecimal queryThisYearProjectNum(List<Long> commonOrgIds,List<Long> departmentIds,String thisYear) {
        return projectSetMapper.queryThisYearProjectNum(commonOrgIds,departmentIds,thisYear);
    }
}
