package com.ejianc.foundation.supplierChange.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 供应商变更主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_pro_supplier_change")
public class SupplierChangeEntity extends BaseEntity {

    private static final long serialVersionUID = 3508980683690165080L;

    @TableField(value="code")
    private String code; // 供方编码
    @TableField(value="name")
    private String name; // 供方名称
    @TableField(value="supply_query_type")
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub
    @TableField(value="category_id")
    private Long categoryId; // 客户分类ID
    @TableField(value="social_credit_code")
    private String socialCreditCode; // 统一社会信用代码
    @TableField(value="legal")
    private String legal; // 法定代表人
    @TableField(value="tax_payer_type")
    private Long taxPayerType; // 纳税人类型
    @TableField(value="business_scope")
    private String businessScope; // 经营范围
    @TableField(value="enabled")
    private Integer enabled; // 合作不合作（1：合作 ， 0：不合作）
    @TableField(value="area")
    private String area; // 地区
    @TableField(value="address")
    private String address; // 详细地址
    @TableField(value="telephone")
    private String telephone; // 客户电话
    @TableField(value="bank_name")
    private String bankName; // 开户行名称
    @TableField(value="bank_account")
    private String bankAccount; // 户名
    @TableField(value="bank_code")
    private String bankCode; // 开户行卡号
    @TableField(value="description")
    private String description; // 客户描述
    @TableField(value="source_id")
    private String sourceId; // 来源id
    @TableField(value="system_id")
    private String systemId; // 系统id
    @TableField(value="tenant")
    private Long tenant; // 关联租户id（供方协同）
    @TableField(value="tenant_name")
    private String tenantName; // 关联租户名称（供方协同）
    @TableField(value="tenant_phone")
    private String tenantPhone; // 生成租户手机号（供方协同）
    @TableField(value="tenant_user_name")
    private String tenantUserName; // 生成租户管理员名称（供方协同）
    @TableField(value="test")
    private Integer test; // 年龄
    @TableField(value="province")
    private String province; // 省份
    @TableField(value="city")
    private String city; // 市
    @TableField(value="region")
    private String region; // 区县
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="inside_org_id")
    private Long insideOrgId; // 内部客商--来源组织id(青岛市政）
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="enterprise_nature")
    private Long enterpriseNature; // 企业性质id
    @TableField(value="register_time")
    private Date registerTime; // 注册日期
    @TableField(value="tax_payer_identifier")
    private String taxPayerIdentifier; // 纳税人识别号
    @TableField(value="registered_capital")
    private BigDecimal registeredCapital; // 注册资金
    @TableField(value="legal_phone")
    private String legalPhone; // 法人电话
    @TableField(value="issuing_time")
    private Date issuingTime; // 发证时间
    @TableField(value="evaluation_grade")
    private Integer evaluationGrade; // 评价等级(1-合格，0-不合格)
    @TableField(value="supplier_flag")
    private Integer supplierFlag; // 是否属于物资，0-否，1-是
    @TableField(value="sub_flag")
    private Integer subFlag; // 是否属于分包，0-否，1-是
    @TableField(value="blacklist_flag")
    private Integer blacklistFlag; // 是否黑名单，0-否，1-是
    @TableField(value="operate_id")
    private Long operateId; // 操作人id
    @TableField(value="operate_name")
    private String operateName; // 操作人名称
    @TableField(value="operate_time")
    private Date operateTime; // 操作时间
    @TableField(value="operate_org_id")
    private Long operateOrgId; // 操作人所属组织id
    @TableField(value="operate_org_name")
    private String operateOrgName; // 操作人所属组织名称
    @TableField(value="bl_time")
    private Date blTime; // 营业执照有效期
    @TableField(value="spl_time")
    private Date splTime; // 安全生产许可证有效期
    @TableField(value="qc_time")
    private Date qcTime; // 资质证书有效期
    @TableField(value="sc_time")
    private Date scTime; // 安全证有效期
    @TableField(value="redlist_flag")
    private Integer redlistFlag; // 是否红名单，0-否，1-是
    @TableField(value="category_name")
    private String categoryName; // 分类名称
    @TableField(value="access_id")
    private Long accessId; // 供应商准入ID
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="supply_type")
    private String supplyType; // 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
    @TableField(value="supply_type_name")
    private String supplyTypeName; // 供方类别名称
    @TableField(value="personal")
    private String personal; // 个人：p，企业：e
    @TableField(value="group_in_or_out")
    private String groupInOrOut; // 集团内外：内in，外out
    @TableField(value="material_content_id")
    private String materialContentId; // 物资供货内容id
    @TableField(value="material_content")
    private String materialContent; // 物资供货内容名称
    @TableField(value="material_memo")
    private String materialMemo; // 物资补充描述
    @TableField(value="equipment_content_id")
    private String equipmentContentId; // 设备供货内容id
    @TableField(value="equipment_content")
    private String equipmentContent; // 设备供货内容
    @TableField(value="equipment_memo")
    private String equipmentMemo; // 设备补充描述
    @TableField(value="major_content_id")
    private String majorContentId; // 专业分包供货内容id
    @TableField(value="major_content")
    private String majorContent; // 专业分包供货内容
    @TableField(value="major_memo")
    private String majorMemo; // 专业分包补充描述
    @TableField(value="labor_content_id")
    private String laborContentId; // 劳务分包供货内容id
    @TableField(value="labor_content")
    private String laborContent; // 劳务分包供货内容
    @TableField(value="labor_memo")
    private String laborMemo; // 劳务分包补充描述
    @TableField(value="sub_content_id")
    private String subContentId; // 分包班组供货内容id
    @TableField(value="sub_content")
    private String subContent; // 分包班组供货内容
    @TableField(value="sub_memo")
    private String subMemo; // 分包班组补充描述
    @TableField(value="other_content_id")
    private String otherContentId; // 其他供货内容id
    @TableField(value="other_content")
    private String otherContent; // 其他供货内容
    @TableField(value="other_memo")
    private String otherMemo; // 其他补充描述
    @TableField(value="apply_org_name")
    private String applyOrgName; // 申请单位
    @TableField(value="apply_org_id")
    private Long applyOrgId; // 申请单位id
    @TableField(value="enterprise_nature_name")
    private String enterpriseNatureName; // 企业性质名称
    @TableField(value="register_country_id")
    private Long registerCountryId; // 注册国家id
    @TableField(value="register_country_name")
    private String registerCountryName; // 注册国家名称
    @TableField(value="legal_person")
    private String legalPerson; // 法人代表/别名
    @TableField(value="area_name")
    private String areaName; // 所在地区
    @TableField(value="in_or_out")
    private Integer inOrOut; // 国内外：1国内，2国外
    @TableField(value="grade_id")
    private Long gradeId; // 供应商等级
    @TableField(value="grade_name")
    private String gradeName; // 供应商等级
    @TableField(value="memo")
    private String memo; // 准入说明
    @TableField(value="coordination")
    private Integer coordination; // 是否协同
    @TableField(value="turnover")
    private BigDecimal turnover; // 年营业额
    @TableField(value="in_exception")
    private Integer inException; // 是否异常
    @TableField(value="exception_end_date")
    private Date exceptionEndDate; // 异常结束时间
    @TableField(value="last_co_date")
    private Date lastCoDate; // 最近合作时间
    @TableField(value="punish_type")
    private Long punishType; // 供应商状态
    @TableField(value="punish_date")
    private Date punishDate; // 处置日期
    @TableField(value="punish_apply_org")
    private String punishApplyOrg; // 处置申请单位
    @TableField(value="punish_apply_person")
    private String punishApplyPerson; // 处置申请人
    @TableField(value="punish_old_grade")
    private String punishOldGrade; // 处置原等级
    @TableField(value="punish_grade")
    private String punishGrade; // 处置等级
    @TableField(value="punish_memo")
    private String punishMemo; // 处置理由
    @TableField(value="business_person")
    private String businessPerson; // 业务代表
    @TableField(value="business_phone")
    private String businessPhone; // 业务代表电话
    @TableField(value="inside_org")
    private Integer insideOrg; // 内外部客商 true：内部，false：外部
    @TableField(value="revolv_material_content_id")
    private String revolvMaterialContentId; // 周转材供货内容id
    @TableField(value="revolv_material_content")
    private String revolvMaterialContent; // 周转材供货内容
    @TableField(value="revolv_material_memo")
    private String revolvMaterialMemo; // 周转材补充描述
    @TableField(value="consult_content_id")
    private String consultContentId; // 咨询供货内容id
    @TableField(value="consult_content")
    private String consultContent; // 咨询供货内容
    @TableField(value="consult_memo")
    private String consultMemo; // 咨询补充描述
    @TableField(value="main_business_category")
    private String mainBusinessCategory; // 主营类别
    @TableField(value="distributer_or_manufactor")
    private String distributerOrManufactor; // 厂家/经销商
    @TableField(value="taxpayer_type")
    private String taxpayerType; // 纳税人类型
    @TableField(value="billing_address")
    private String billingAddress; // 开票地址
    @TableField(value="billing_phone")
    private String billingPhone; // 开票电话
    @TableField(value="bank_account_id")
    private Long bankAccountId; // 开票银行
    @TableField(value="bank_account_name")
    private String bankAccountName; // 开票银行
    @TableField(value="bank_account_code")
    private String bankAccountCode; // 开票银行账户
    @TableField(value="custom_type")
    private Long customType; // 客户分类
    @TableField(value="custom_type_name")
    private String customTypeName; // 客户分类名称
    @TableField(value="parent_id")
    private Long parentId; // 父级客户或者父级供应商
    @TableField(value="come_from")
    private String comeFrom; // 来源标识
    @TableField(value="unit_i8_code")
    private String unitI8Code; // I8单位编码

    @TableField(value = "source_supplier_id")
    private Long sourceSupplierId; //源供应商单据Id

    @TableField(value = "save_type")
    private String saveType; //用于查询区分: 分包供应商-sub/物资设备供应商-materialEquipment/其他供应商-other

    @TableField(exist=false)
    @SubEntity(serviceName="certsChangeService")
    private List<CertsChangeEntity> certs = new ArrayList<>(); // 供应商变更-证书实体
    @TableField(exist=false)
    @SubEntity(serviceName="subleadersChangeService")
    private List<SubleadersChangeEntity> subLeaders = new ArrayList<>(); // 供应商变更-分包负责人实体

    public String getSaveType() {
        return saveType;
    }

    public void setSaveType(String saveType) {
        this.saveType = saveType;
    }

    public Long getSourceSupplierId() {
        return sourceSupplierId;
    }

    public void setSourceSupplierId(Long sourceSupplierId) {
        this.sourceSupplierId = sourceSupplierId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getLegal() {
        return legal;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }
    public Long getTaxPayerType() {
        return taxPayerType;
    }

    public void setTaxPayerType(Long taxPayerType) {
        this.taxPayerType = taxPayerType;
    }
    public String getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }
    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    public Long getTenant() {
        return tenant;
    }

    public void setTenant(Long tenant) {
        this.tenant = tenant;
    }
    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }
    public String getTenantPhone() {
        return tenantPhone;
    }

    public void setTenantPhone(String tenantPhone) {
        this.tenantPhone = tenantPhone;
    }
    public String getTenantUserName() {
        return tenantUserName;
    }

    public void setTenantUserName(String tenantUserName) {
        this.tenantUserName = tenantUserName;
    }
    public Integer getTest() {
        return test;
    }

    public void setTest(Integer test) {
        this.test = test;
    }
    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }
    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }
    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getInsideOrgId() {
        return insideOrgId;
    }

    public void setInsideOrgId(Long insideOrgId) {
        this.insideOrgId = insideOrgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEnterpriseNature() {
        return enterpriseNature;
    }

    public void setEnterpriseNature(Long enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }
    public Date getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }
    public String getTaxPayerIdentifier() {
        return taxPayerIdentifier;
    }

    public void setTaxPayerIdentifier(String taxPayerIdentifier) {
        this.taxPayerIdentifier = taxPayerIdentifier;
    }
    public BigDecimal getRegisteredCapital() {
        return registeredCapital;
    }

    public void setRegisteredCapital(BigDecimal registeredCapital) {
        this.registeredCapital = registeredCapital;
    }
    public String getLegalPhone() {
        return legalPhone;
    }

    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }
    public Date getIssuingTime() {
        return issuingTime;
    }

    public void setIssuingTime(Date issuingTime) {
        this.issuingTime = issuingTime;
    }
    public Integer getEvaluationGrade() {
        return evaluationGrade;
    }

    public void setEvaluationGrade(Integer evaluationGrade) {
        this.evaluationGrade = evaluationGrade;
    }
    public Integer getSupplierFlag() {
        return supplierFlag;
    }

    public void setSupplierFlag(Integer supplierFlag) {
        this.supplierFlag = supplierFlag;
    }
    public Integer getSubFlag() {
        return subFlag;
    }

    public void setSubFlag(Integer subFlag) {
        this.subFlag = subFlag;
    }
    public Integer getBlacklistFlag() {
        return blacklistFlag;
    }

    public void setBlacklistFlag(Integer blacklistFlag) {
        this.blacklistFlag = blacklistFlag;
    }
    public Long getOperateId() {
        return operateId;
    }

    public void setOperateId(Long operateId) {
        this.operateId = operateId;
    }
    public String getOperateName() {
        return operateName;
    }

    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }
    public Date getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = operateTime;
    }
    public Long getOperateOrgId() {
        return operateOrgId;
    }

    public void setOperateOrgId(Long operateOrgId) {
        this.operateOrgId = operateOrgId;
    }
    public String getOperateOrgName() {
        return operateOrgName;
    }

    public void setOperateOrgName(String operateOrgName) {
        this.operateOrgName = operateOrgName;
    }
    public Date getBlTime() {
        return blTime;
    }

    public void setBlTime(Date blTime) {
        this.blTime = blTime;
    }
    public Date getSplTime() {
        return splTime;
    }

    public void setSplTime(Date splTime) {
        this.splTime = splTime;
    }
    public Date getQcTime() {
        return qcTime;
    }

    public void setQcTime(Date qcTime) {
        this.qcTime = qcTime;
    }
    public Date getScTime() {
        return scTime;
    }

    public void setScTime(Date scTime) {
        this.scTime = scTime;
    }
    public Integer getRedlistFlag() {
        return redlistFlag;
    }

    public void setRedlistFlag(Integer redlistFlag) {
        this.redlistFlag = redlistFlag;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public Long getAccessId() {
        return accessId;
    }

    public void setAccessId(Long accessId) {
        this.accessId = accessId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getSupplyType() {
        return supplyType;
    }

    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }
    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }
    public String getPersonal() {
        return personal;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }
    public String getGroupInOrOut() {
        return groupInOrOut;
    }

    public void setGroupInOrOut(String groupInOrOut) {
        this.groupInOrOut = groupInOrOut;
    }
    public String getMaterialContentId() {
        return materialContentId;
    }

    public void setMaterialContentId(String materialContentId) {
        this.materialContentId = materialContentId;
    }
    public String getMaterialContent() {
        return materialContent;
    }

    public void setMaterialContent(String materialContent) {
        this.materialContent = materialContent;
    }
    public String getMaterialMemo() {
        return materialMemo;
    }

    public void setMaterialMemo(String materialMemo) {
        this.materialMemo = materialMemo;
    }
    public String getEquipmentContentId() {
        return equipmentContentId;
    }

    public void setEquipmentContentId(String equipmentContentId) {
        this.equipmentContentId = equipmentContentId;
    }
    public String getEquipmentContent() {
        return equipmentContent;
    }

    public void setEquipmentContent(String equipmentContent) {
        this.equipmentContent = equipmentContent;
    }
    public String getEquipmentMemo() {
        return equipmentMemo;
    }

    public void setEquipmentMemo(String equipmentMemo) {
        this.equipmentMemo = equipmentMemo;
    }
    public String getMajorContentId() {
        return majorContentId;
    }

    public void setMajorContentId(String majorContentId) {
        this.majorContentId = majorContentId;
    }
    public String getMajorContent() {
        return majorContent;
    }

    public void setMajorContent(String majorContent) {
        this.majorContent = majorContent;
    }
    public String getMajorMemo() {
        return majorMemo;
    }

    public void setMajorMemo(String majorMemo) {
        this.majorMemo = majorMemo;
    }
    public String getLaborContentId() {
        return laborContentId;
    }

    public void setLaborContentId(String laborContentId) {
        this.laborContentId = laborContentId;
    }
    public String getLaborContent() {
        return laborContent;
    }

    public void setLaborContent(String laborContent) {
        this.laborContent = laborContent;
    }
    public String getLaborMemo() {
        return laborMemo;
    }

    public void setLaborMemo(String laborMemo) {
        this.laborMemo = laborMemo;
    }
    public String getSubContentId() {
        return subContentId;
    }

    public void setSubContentId(String subContentId) {
        this.subContentId = subContentId;
    }
    public String getSubContent() {
        return subContent;
    }

    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }
    public String getSubMemo() {
        return subMemo;
    }

    public void setSubMemo(String subMemo) {
        this.subMemo = subMemo;
    }
    public String getOtherContentId() {
        return otherContentId;
    }

    public void setOtherContentId(String otherContentId) {
        this.otherContentId = otherContentId;
    }
    public String getOtherContent() {
        return otherContent;
    }

    public void setOtherContent(String otherContent) {
        this.otherContent = otherContent;
    }
    public String getOtherMemo() {
        return otherMemo;
    }

    public void setOtherMemo(String otherMemo) {
        this.otherMemo = otherMemo;
    }
    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }
    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    public String getEnterpriseNatureName() {
        return enterpriseNatureName;
    }

    public void setEnterpriseNatureName(String enterpriseNatureName) {
        this.enterpriseNatureName = enterpriseNatureName;
    }
    public Long getRegisterCountryId() {
        return registerCountryId;
    }

    public void setRegisterCountryId(Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }
    public String getRegisterCountryName() {
        return registerCountryName;
    }

    public void setRegisterCountryName(String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }
    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public Integer getInOrOut() {
        return inOrOut;
    }

    public void setInOrOut(Integer inOrOut) {
        this.inOrOut = inOrOut;
    }
    public Long getGradeId() {
        return gradeId;
    }

    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getCoordination() {
        return coordination;
    }

    public void setCoordination(Integer coordination) {
        this.coordination = coordination;
    }
    public BigDecimal getTurnover() {
        return turnover;
    }

    public void setTurnover(BigDecimal turnover) {
        this.turnover = turnover;
    }
    public Integer getInException() {
        return inException;
    }

    public void setInException(Integer inException) {
        this.inException = inException;
    }
    public Date getExceptionEndDate() {
        return exceptionEndDate;
    }

    public void setExceptionEndDate(Date exceptionEndDate) {
        this.exceptionEndDate = exceptionEndDate;
    }
    public Date getLastCoDate() {
        return lastCoDate;
    }

    public void setLastCoDate(Date lastCoDate) {
        this.lastCoDate = lastCoDate;
    }
    public Long getPunishType() {
        return punishType;
    }

    public void setPunishType(Long punishType) {
        this.punishType = punishType;
    }
    public Date getPunishDate() {
        return punishDate;
    }

    public void setPunishDate(Date punishDate) {
        this.punishDate = punishDate;
    }
    public String getPunishApplyOrg() {
        return punishApplyOrg;
    }

    public void setPunishApplyOrg(String punishApplyOrg) {
        this.punishApplyOrg = punishApplyOrg;
    }
    public String getPunishApplyPerson() {
        return punishApplyPerson;
    }

    public void setPunishApplyPerson(String punishApplyPerson) {
        this.punishApplyPerson = punishApplyPerson;
    }
    public String getPunishOldGrade() {
        return punishOldGrade;
    }

    public void setPunishOldGrade(String punishOldGrade) {
        this.punishOldGrade = punishOldGrade;
    }
    public String getPunishGrade() {
        return punishGrade;
    }

    public void setPunishGrade(String punishGrade) {
        this.punishGrade = punishGrade;
    }
    public String getPunishMemo() {
        return punishMemo;
    }

    public void setPunishMemo(String punishMemo) {
        this.punishMemo = punishMemo;
    }
    public String getBusinessPerson() {
        return businessPerson;
    }

    public void setBusinessPerson(String businessPerson) {
        this.businessPerson = businessPerson;
    }
    public String getBusinessPhone() {
        return businessPhone;
    }

    public void setBusinessPhone(String businessPhone) {
        this.businessPhone = businessPhone;
    }
    public Integer getInsideOrg() {
        return insideOrg;
    }

    public void setInsideOrg(Integer insideOrg) {
        this.insideOrg = insideOrg;
    }
    public String getRevolvMaterialContentId() {
        return revolvMaterialContentId;
    }

    public void setRevolvMaterialContentId(String revolvMaterialContentId) {
        this.revolvMaterialContentId = revolvMaterialContentId;
    }
    public String getRevolvMaterialContent() {
        return revolvMaterialContent;
    }

    public void setRevolvMaterialContent(String revolvMaterialContent) {
        this.revolvMaterialContent = revolvMaterialContent;
    }
    public String getRevolvMaterialMemo() {
        return revolvMaterialMemo;
    }

    public void setRevolvMaterialMemo(String revolvMaterialMemo) {
        this.revolvMaterialMemo = revolvMaterialMemo;
    }
    public String getConsultContentId() {
        return consultContentId;
    }

    public void setConsultContentId(String consultContentId) {
        this.consultContentId = consultContentId;
    }
    public String getConsultContent() {
        return consultContent;
    }

    public void setConsultContent(String consultContent) {
        this.consultContent = consultContent;
    }
    public String getConsultMemo() {
        return consultMemo;
    }

    public void setConsultMemo(String consultMemo) {
        this.consultMemo = consultMemo;
    }
    public String getMainBusinessCategory() {
        return mainBusinessCategory;
    }

    public void setMainBusinessCategory(String mainBusinessCategory) {
        this.mainBusinessCategory = mainBusinessCategory;
    }
    public String getDistributerOrManufactor() {
        return distributerOrManufactor;
    }

    public void setDistributerOrManufactor(String distributerOrManufactor) {
        this.distributerOrManufactor = distributerOrManufactor;
    }
    public String getTaxpayerType() {
        return taxpayerType;
    }

    public void setTaxpayerType(String taxpayerType) {
        this.taxpayerType = taxpayerType;
    }
    public String getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }
    public String getBillingPhone() {
        return billingPhone;
    }

    public void setBillingPhone(String billingPhone) {
        this.billingPhone = billingPhone;
    }
    public Long getBankAccountId() {
        return bankAccountId;
    }

    public void setBankAccountId(Long bankAccountId) {
        this.bankAccountId = bankAccountId;
    }
    public String getBankAccountName() {
        return bankAccountName;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
    }
    public String getBankAccountCode() {
        return bankAccountCode;
    }

    public void setBankAccountCode(String bankAccountCode) {
        this.bankAccountCode = bankAccountCode;
    }
    public Long getCustomType() {
        return customType;
    }

    public void setCustomType(Long customType) {
        this.customType = customType;
    }
    public String getCustomTypeName() {
        return customTypeName;
    }

    public void setCustomTypeName(String customTypeName) {
        this.customTypeName = customTypeName;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getComeFrom() {
        return comeFrom;
    }

    public void setComeFrom(String comeFrom) {
        this.comeFrom = comeFrom;
    }
    public String getUnitI8Code() {
        return unitI8Code;
    }

    public void setUnitI8Code(String unitI8Code) {
        this.unitI8Code = unitI8Code;
    }

    public List<CertsChangeEntity> getCerts() {
        return certs;
    }

    public void setCerts(List<CertsChangeEntity> certs) {
        this.certs = certs;
    }

    public List<SubleadersChangeEntity> getSubLeaders() {
        return subLeaders;
    }

    public void setSubLeaders(List<SubleadersChangeEntity> subLeaders) {
        this.subLeaders = subLeaders;
    }
}
