package com.ejianc.foundation.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.foundation.share.bean.MaterialCategoryEntity;

public class MaterialCategoryAsTree {
	
	public static List<MaterialCategoryEntity> createTreeData(List<MaterialCategoryEntity> list) {
		List<MaterialCategoryEntity> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();
		Map<String, MaterialCategoryEntity> listMap = new HashMap<>();
		for(MaterialCategoryEntity MaterialCategoryEntity:list) {
			listMap.put(MaterialCategoryEntity.getId().toString(), MaterialCategoryEntity);
		}
        
        for(int i =0; i<list.size(); i++) {
        	MaterialCategoryEntity MaterialCategoryEntity = list.get(i);
        	String parentId = (MaterialCategoryEntity.getParentId() != null && MaterialCategoryEntity.getParentId() > 0) ? MaterialCategoryEntity.getParentId().toString():"";
        	MaterialCategoryEntity parent = listMap.get(parentId);
        	if(parent != null) {
        		List<MaterialCategoryEntity> child = parent.getChildren();
        		if(child != null) {
        			child.add(MaterialCategoryEntity);
        		}else{
        			List<MaterialCategoryEntity> children = new ArrayList<MaterialCategoryEntity>();
        			children.add(MaterialCategoryEntity);
        			parent.setChildren(children);
        		}
        	} else {
        		rootItems.add(MaterialCategoryEntity.getId().toString());
        	}
        }
        
        for(String rootId : rootItems) {
        	resp.add(listMap.get(rootId));
        }
        
		return resp;
	}

}
