package com.ejianc.foundation.supplier.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.SubleadersEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISubleadersService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SubleadersDTO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@RestController
@RequestMapping("/api/shareSubleadersApi/")
public class SubleadersApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubleadersService subleadersService;

    @Autowired
    private ISupplierService supplierService;

    /**
     * 供应商 评级更新供应商库
     * @param subleaderId 分包负责人id
     * @param gradeId 评定等级id
     * @param gradeName 评定等级名称
     */
    @GetMapping(value = "upGradeSubleader")
    public CommonResponse<String> upGradeSubleader(@RequestParam("subleaderId") Long subleaderId,
                                                  @RequestParam("gradeId") Long gradeId,
                                                  @RequestParam("gradeName") String gradeName) {
        logger.info("评级更新分包负责人库");
        logger.info(subleaderId.toString());
        logger.info(gradeId.toString());
        logger.info(gradeName);
        SubleadersEntity subleadersEntity = subleadersService.selectById(subleaderId);
        if(subleadersEntity == null){
            return CommonResponse.error("分包负责人不存在！");
        }
        subleadersEntity.setGrade(gradeId);
        subleadersEntity.setGradeName(gradeName);

        subleadersService.saveOrUpdate(subleadersEntity,false);
        return CommonResponse.success("分包负责人评级设置成功！");
    }

    /**
     * 根据修改时间查询分包负责人信息
     *
     * @return
     */
    @GetMapping("selectByUpDateSubLeaders")
    public CommonResponse<List<SubleadersDTO>> selectByUpDateSubLeaders(@RequestParam(value = "upDate") String upDate) {
        List<SubleadersDTO> vos = supplierService.selectByUpDateSubLeaders(upDate);
        return CommonResponse.success(vos);
    }

    @PostMapping(value = "getSubleaderList")
    public CommonResponse<List<SubleadersVO>> getSubleaderList(@RequestBody Map<String,List<Long>> idsMap){
        logger.info("接收到请求参数:"+ JSONObject.toJSONString(idsMap));
        List<Long> ids = idsMap.get("ids");
        QueryWrapper<SubleadersEntity> wrapper = new QueryWrapper<>();
        wrapper.in("id",ids);
        List<SubleadersEntity> list = subleadersService.list(wrapper);
        List<SubleadersVO> subleadersVOS = BeanMapper.mapList(list, SubleadersVO.class);
        logger.info("查询结果:"+JSONObject.toJSONString(subleadersVOS));
        return CommonResponse.success("查询成功！！！！",subleadersVOS);
    }


    /**
     * 根据分包负责人Id查询供应商和分包负责人信息
     *
     * @param id 负责人Id
     * @return
     */
    @GetMapping("querySupplierByLeaderId")
    public CommonResponse<SubleadersVO> querySupplierByLeaderId(@RequestParam(value = "id") Long id) {
        SubleadersEntity subleadersEntity = subleadersService.selectById(id);
        SubleadersVO record = BeanMapper.map(subleadersEntity, SubleadersVO.class);

        SupplierEntity supplierEntity = supplierService.selectById(subleadersEntity.getPid());
        String content = "";
        if(StringUtils.isNotEmpty(supplierEntity.getLaborContent())){
            content+=supplierEntity.getLaborContent()+",";
        }
        if(StringUtils.isNotEmpty(supplierEntity.getMajorContent())){
            content+=supplierEntity.getMajorContent();
        }
        record.setSupplierContent(content);
        record.setSupplierName(supplierEntity.getName());
        record.setSupplierGrade(supplierEntity.getGradeName());
        record.setArea(supplierEntity.getAreaName());
        record.setSupplierCode(supplierEntity.getCode());
        record.setPersonal(supplierEntity.getPersonal());

        return CommonResponse.success("查询成功！！！！",record);
    }
    /**
     * 根据分包负责人idNum查询供应商和分包负责人信息
     *
     * @param idNum 负责人idNum
     * @return
     */
    @GetMapping("querySupplierByLeaderNum")
    public CommonResponse<List<SubleadersVO>> querySupplierByLeaderNum(@RequestParam(value = "idNum") String idNum) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("idNum", new Parameter(QueryParam.EQ, idNum));
        List<SubleadersEntity> subleadersEntities = subleadersService.queryList(queryParam);
        List<SubleadersVO> record = BeanMapper.mapList(subleadersEntities, SubleadersVO.class);
        if(CollectionUtils.isNotEmpty(subleadersEntities)){
            QueryParam param = new QueryParam();
            param.getParams().put("id",new Parameter(QueryParam.IN,subleadersEntities.stream().map(SubleadersEntity::getPid).collect(Collectors.toList())));
            List<SupplierEntity> supplierEntities = supplierService.queryList(param);
            //将supplierEntity的名字取出来，拼接到record对应的数据里
            for (SubleadersVO subleadersVO : record) {
                for (SupplierEntity supplierEntity : supplierEntities) {
                    if(subleadersVO.getPid().equals(supplierEntity.getId())){
                        subleadersVO.setSupplierName(supplierEntity.getName());
                    }
                }
            }
        }


        return CommonResponse.success("查询成功！！！！",record);
    }
    /**
     * 根据查询供应商tenantid获取分包负责人信息
     *
     * @param
     * @return
     */
    @PostMapping("querySupplierByLeaderId")
    public CommonResponse<List<SubleadersVO>> queryLeaderIdsByTenantId(HttpServletRequest request) {

        logger.info("根据查询供应商tenantid获取分包负责人信息接口request-{},file-{}", request);
        String leaderTenantId = request.getParameter("leaderTenantId");
        QueryParam param = new QueryParam();
        param.getParams().put("ejcTenantId",new Parameter(QueryParam.EQ,Long.parseLong(leaderTenantId)));
        param.getParams().put("dr",new Parameter(QueryParam.EQ,0));

        List<SubleadersEntity> subleadersEntities = subleadersService.queryList(param);
        List<SubleadersVO> subleadersVOS = BeanMapper.mapList(subleadersEntities, SubleadersVO.class);
        if (CollectionUtils.isNotEmpty(subleadersVOS)){
            for (SubleadersVO subleadersVO : subleadersVOS) {
                SupplierEntity supplierEntity = supplierService.selectById(subleadersVO.getPid());
                subleadersVO.setSupplierName(supplierEntity.getName());
                subleadersVO.setSupplierGrade(supplierEntity.getGradeName());
                subleadersVO.setArea(supplierEntity.getAreaName());
                subleadersVO.setSupplierCode(supplierEntity.getCode());
                subleadersVO.setPersonal(supplierEntity.getPersonal());
            }
        }
        return CommonResponse.success("查询成功！！！！",subleadersVOS);
    }
}
