/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.service.ISupplyBankService;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/zzyj/mdm/"})
public class ZzyjMdmController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private ISupplyBankService supplyBankService;
    @Autowired
    private IDefdocApi iDefdocApi;

    @RequestMapping(value={"/project/sync"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> projectSync(HttpServletRequest request, @RequestBody(required=true) QueryParam param) {
        String syncMode;
        if (param == null) {
            param = new QueryParam();
        }
        if ("increment".equals(syncMode = request.getParameter("syncMode"))) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            String syncTime = dateFormat.format(calendar.getTime()) + " 00:00:00";
            param.getParams().put("syncTime", new Parameter("eq", (Object)syncTime));
        }
        this.logger.info("\u8bfb\u53d6\u9879\u76ee\u4fe1\u606f\u53c2\u6570\uff0c{}", (Object)JSONObject.toJSONString((Object)param));
        IPage<ProjectSetPoolEntity> list = this.projectSetService.queryMdmPage(param);
        ArrayList<JSONObject> res = new ArrayList<JSONObject>();
        if (ListUtil.isNotEmpty((List)list.getRecords())) {
            for (int i = 0; i < list.getRecords().size(); ++i) {
                DefdocDetailVO detailVO;
                ProjectSetPoolEntity poolEntity = (ProjectSetPoolEntity)((Object)list.getRecords().get(i));
                JSONObject object = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)poolEntity)));
                object.put("taxType", (Object)(poolEntity.getTaxType() != null ? ("1".equals(poolEntity.getTaxType()) ? "\u4e00\u822c\u8ba1\u7a0e" : "\u7b80\u6613\u5f81\u6536") : ""));
                CommonResponse response = null;
                if (poolEntity.getProjectType() != null && (response = this.iDefdocApi.getDefDocById(poolEntity.getProjectType())).isSuccess() && response.getData() != null) {
                    detailVO = (DefdocDetailVO)response.getData();
                    object.put("projectType", (Object)detailVO.getName());
                }
                object.put("devType", (Object)(poolEntity.getDevType() != null ? ("1".equals(poolEntity.getDevType()) ? "\u81ea\u8425" : "\u8054\u8425") : ""));
                if (poolEntity.getRunType() != null && (response = this.iDefdocApi.getDefDocById(poolEntity.getRunType())).isSuccess() && response.getData() != null) {
                    detailVO = (DefdocDetailVO)response.getData();
                    object.put("runType", (Object)detailVO.getName());
                }
                if (poolEntity.getFundsSource() != null && (response = this.iDefdocApi.getDefDocById(poolEntity.getFundsSource())).isSuccess() && response.getData() != null) {
                    detailVO = (DefdocDetailVO)response.getData();
                    object.put("fundsSource", (Object)detailVO.getName());
                }
                if (poolEntity.getStructureType() != null && (response = this.iDefdocApi.getDefDocById(poolEntity.getStructureType())).isSuccess() && response.getData() != null) {
                    detailVO = (DefdocDetailVO)response.getData();
                    object.put("structureType", (Object)detailVO.getName());
                }
                if (poolEntity.getUseFor() != null && (response = this.iDefdocApi.getDefDocById(poolEntity.getUseFor())).isSuccess() && response.getData() != null) {
                    detailVO = (DefdocDetailVO)response.getData();
                    object.put("useFor", (Object)detailVO.getName());
                }
                object.put("projectStatus", (Object)(poolEntity.getProjectStatus() != null ? ("1".equals(poolEntity.getProjectStatus()) ? "\u5728\u5efa" : ("2".equals(poolEntity.getProjectStatus()) ? "\u9879\u76ee\u4e2d\u6b62" : ("3".equals(poolEntity.getProjectStatus()) ? "\u7ae3\u5de5" : ("4".equals(poolEntity.getProjectStatus()) ? "\u4fdd\u4fee" : "\u5176\u4ed6")))) : ""));
                object.put("businessStatus", (Object)(poolEntity.getBusinessStatus() != null ? ("1".equals(poolEntity.getBusinessStatus()) ? "\u5f00\u5de5\u51c6\u5907" : ("2".equals(poolEntity.getBusinessStatus()) ? "\u6b63\u5f0f\u5f00\u5de5" : ("3".equals(poolEntity.getBusinessStatus()) ? "\u505c\u5de5" : ("4".equals(poolEntity.getBusinessStatus()) ? "\u590d\u5de5" : ("5".equals(poolEntity.getBusinessStatus()) ? "\u5b8c\u5de5" : ("6".equals(poolEntity.getBusinessStatus()) ? "\u7ae3\u5de5\u9a8c\u6536" : ("7".equals(poolEntity.getBusinessStatus()) ? "\u6210\u672c\u5173\u95e8" : ("8".equals(poolEntity.getBusinessStatus()) ? "\u51b3\u7b97\u4e2d" : ("9".equals(poolEntity.getBusinessStatus()) ? "\u5df2\u51b3\u7b97" : ("10".equals(poolEntity.getBusinessStatus()) ? "\u8d44\u6599\u672a\u5f52\u6863" : ("11".equals(poolEntity.getBusinessStatus()) ? "\u8d44\u6599\u5df2\u5f52\u6863" : ("12".equals(poolEntity.getBusinessStatus()) ? "\u4fdd\u4fee\u4e2d" : ("13".equals(poolEntity.getBusinessStatus()) ? "\u4fdd\u4fee\u7ed3\u675f" : ("14".equals(poolEntity.getBusinessStatus()) ? "\u5f00\u8d26" : ("15".equals(poolEntity.getBusinessStatus()) ? "\u8d44\u91d1\u51bb\u7ed3" : ("16".equals(poolEntity.getBusinessStatus()) ? "\u8d44\u91d1\u6062\u590d" : "\u5df2\u9500\u8d26")))))))))))))))) : ""));
                res.add(object);
            }
            this.logger.info("\u8bfb\u53d6\u9879\u76ee\u4fe1\u606f\uff0c\u8fd4\u56de\u6570\u636e\uff0c{}", (Object)JSONObject.toJSONString(res));
            return CommonResponse.success(res);
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/supplier/sync"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SupplierEntity>> supplierSync(HttpServletRequest request, @RequestBody QueryParam param) {
        String syncMode = request.getParameter("syncMode");
        if ("increment".equals(syncMode)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            String syncTime = dateFormat.format(calendar.getTime()) + " 00:00:00";
            if (param == null) {
                param = new QueryParam();
            }
            param.getParams().put("syncTime", new Parameter("eq", (Object)syncTime));
        }
        IPage<SupplierEntity> list = this.supplierService.queryMdmPage(param);
        this.logger.info("\u8bfb\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u53c2\u6570\uff0c{}  \u8fd4\u56de\u6570\u636e list.size = {}", (Object)JSONObject.toJSONString((Object)param), (Object)list.getRecords().size());
        if (ListUtil.isNotEmpty((List)list.getRecords())) {
            for (int i = 0; i < list.getRecords().size(); ++i) {
                SupplierEntity entity;
                entity.setPersonal((entity = (SupplierEntity)((Object)list.getRecords().get(i))).getPersonal() != null ? ("e".equals(entity.getPersonal()) ? "\u4f01\u4e1a" : "\u4e2a\u4eba") : "");
                entity.setGroupInOrOut(entity.getGroupInOrOut() != null ? ("out".equals(entity.getGroupInOrOut()) ? "\u96c6\u56e2\u5916" : "\u96c6\u56e2\u5185") : "");
                entity.setArea(entity.getAreaName());
            }
            return CommonResponse.success((Object)list.getRecords());
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/bank/sync"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<JSONObject>> supplierBankSync(HttpServletRequest request) {
        String syncMode = request.getParameter("syncMode");
        String syncTime = null;
        if ("increment".equals(syncMode)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            syncTime = dateFormat.format(calendar.getTime()) + " 00:00:00";
        }
        List<JSONObject> supplierBankList = this.supplyBankService.querySupplyBankListBySyncTime(syncTime);
        return CommonResponse.success(supplierBankList);
    }

    @Scheduled(cron="0 10 1 * * ?")
    public void updateNoTransBankInfo() {
        this.logger.info("\u5f00\u59cb---\u5c06\u672a\u540c\u6b65\u7684\u94f6\u884c\u6570\u636e\u7684\u66f4\u65b0\u65f6\u95f4\u66f4\u65b0\u5230\u6700\u65b0\u65f6\u95f4....");
        this.supplyBankService.updateNoTransBankInfo();
        this.logger.info("...\u5c06\u672a\u540c\u6b65\u7684\u94f6\u884c\u6570\u636e\u7684\u66f4\u65b0\u65f6\u95f4\u66f4\u65b0\u5230\u6700\u65b0\u65f6\u95f4---\u7ed3\u675f\uff01");
    }
}

