/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProjectArchiveEntity;
import com.ejianc.foundation.share.service.IProjectArchiveService;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectArchive"})
public class ProjectArchiveController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Project_Archive";
    @Autowired
    private IProjectArchiveService service;
    @Autowired
    private SessionManager sessionManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectArchiveVO> saveOrUpdate(@RequestBody ProjectArchiveVO saveOrUpdateVO) {
        ProjectArchiveEntity entity = (ProjectArchiveEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectArchiveEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            System.out.println(billCode.isSuccess());
            System.out.println((String)billCode.getData());
            System.out.println(billCode.getMsg());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setCode((String)billCode.getData());
        } else if (StringUtils.isBlank((CharSequence)entity.getCode())) {
            ProjectArchiveEntity oldEntity = (ProjectArchiveEntity)((Object)this.service.selectById(entity.getId()));
            entity.setCode(oldEntity.getCode());
        } else if (this.service.checkSameBillCode(saveOrUpdateVO)) {
            throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectArchiveVO vo = (ProjectArchiveVO)BeanMapper.map((Object)((Object)entity), ProjectArchiveVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectArchiveVO> queryDetail(Long id) {
        ProjectArchiveEntity entity = (ProjectArchiveEntity)((Object)this.service.selectById(id));
        ProjectArchiveVO vo = (ProjectArchiveVO)BeanMapper.map((Object)((Object)entity), ProjectArchiveVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectArchiveVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectArchiveVO projectArchiveVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectArchiveVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("orgName");
        fuzzyFields.add("businessCustomName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("businessRound");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        page.getRecords().forEach(i -> i.setBusinessCustomName(null != i.getCustomId() ? i.getCustomName() : i.getBusinessCustomName()));
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectArchiveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("orgName");
        fuzzyFields.add("businessCustomName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("businessRound");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List projectArchiveVOList = BeanMapper.mapList((Iterable)list, ProjectArchiveVO.class);
        projectArchiveVOList.forEach(i -> {
            switch (i.getProjectStatus()) {
                case "1": {
                    i.setProjectStatusName("\u5546\u673a\u9636\u6bb5");
                    break;
                }
                case "2": {
                    i.setProjectStatusName("\u6295\u6807\u9636\u6bb5");
                    break;
                }
                case "3": {
                    i.setProjectStatusName("\u672a\u4e2d\u6807");
                    break;
                }
                case "4": {
                    i.setProjectStatusName("\u5df2\u4e2d\u6807");
                    break;
                }
                case "5": {
                    i.setProjectStatusName("\u5408\u540c\u9636\u6bb5");
                    break;
                }
                case "6": {
                    i.setProjectStatusName("\u751f\u4ea7\u9636\u6bb5");
                    break;
                }
                case "7": {
                    i.setProjectStatusName("\u4f9b\u8d27\u9636\u6bb5");
                    break;
                }
                case "8": {
                    i.setProjectStatusName("\u7ed3\u7b97\u9636\u6bb5");
                    break;
                }
                case "9": {
                    i.setProjectStatusName("\u5b8c\u5de5");
                    break;
                }
            }
            if (null != i.getBusinessRound()) {
                switch (i.getBusinessRound()) {
                    case 0: {
                        i.setBusinessRoundName("\u9879\u76ee\u7acb\u9879");
                        break;
                    }
                    case 1: {
                        i.setBusinessRoundName("\u8bbe\u8ba1\u65b9\u6848");
                        break;
                    }
                    case 2: {
                        i.setBusinessRoundName("\u4e1a\u4e3b\u62db\u6807");
                        break;
                    }
                    case 3: {
                        i.setBusinessRoundName("\u603b\u5305\u62db\u6807");
                        break;
                    }
                    case 4: {
                        i.setBusinessRoundName("\u5408\u540c\u7b7e\u8ba2");
                    }
                }
            }
            i.setBusinessCustomName(null != i.getCustomId() ? i.getCustomName() : i.getBusinessCustomName());
        });
        beans.put("records", projectArchiveVOList);
        ExcelExport.getInstance().export("ProjectArchive-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectArchiveData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectArchiveVO>> refProjectArchiveData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("projectTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        String projectStatus = "";
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"orgId")) {
                orgId = Long.valueOf(String.valueOf(_con.get((Object)"orgId")));
            }
            if (_con.containsKey((Object)"projectStatus")) {
                projectStatus = String.valueOf(_con.get((Object)"projectStatus"));
            }
        }
        this.logger.info("projectStatus:{}", (Object)projectStatus);
        if (!"all".equals(projectStatus)) {
            param.getParams().put("projectStatus", new Parameter("not_in", Arrays.asList(1, 2, 3)));
            param.getParams().put("projectDepartmentId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("and");
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("or");
            c2.getParams().put("projectStatus", new Parameter("not_in", Arrays.asList(1, 2, 3)));
            c2.getParams().put("projectDepartmentId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            c1.getComplexParams().add(c2);
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("projectStatus", new Parameter("in", Arrays.asList(1, 2, 3)));
            c1.getComplexParams().add(c3);
            param.getComplexParams().add(c1);
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List list = BeanMapper.mapList((Iterable)page.getRecords(), ProjectArchiveVO.class);
        list.forEach(i -> {
            switch (i.getProjectStatus()) {
                case "1": {
                    i.setProjectStatusName("\u5546\u673a\u9636\u6bb5");
                    break;
                }
                case "2": {
                    i.setProjectStatusName("\u6295\u6807\u9636\u6bb5");
                    break;
                }
                case "3": {
                    i.setProjectStatusName("\u672a\u4e2d\u6807");
                    break;
                }
                case "4": {
                    i.setProjectStatusName("\u5df2\u4e2d\u6807");
                    break;
                }
                case "5": {
                    i.setProjectStatusName("\u5408\u540c\u9636\u6bb5");
                    break;
                }
                case "6": {
                    i.setProjectStatusName("\u751f\u4ea7\u9636\u6bb5");
                    break;
                }
                case "7": {
                    i.setProjectStatusName("\u4f9b\u8d27\u9636\u6bb5");
                    break;
                }
                case "8": {
                    i.setProjectStatusName("\u7ed3\u7b97\u9636\u6bb5");
                    break;
                }
                case "9": {
                    i.setProjectStatusName("\u5b8c\u5de5");
                    break;
                }
            }
            i.setBusinessCustomName(null != i.getCustomId() ? i.getCustomName() : i.getBusinessCustomName());
        });
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

