/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectArchiveEntity;
import com.ejianc.foundation.share.bean.ProjectArchiveRecordEntity;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.service.IProjectArchiveRecordService;
import com.ejianc.foundation.share.service.IProjectArchiveService;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/projectArchiveApi/"})
public class ProjectArchiveApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectArchiveService projectArchiveService;
    @Autowired
    private IProjectArchiveRecordService recordService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Project_Archive";

    @PostMapping(value={"pushProjectArchive"})
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> pushProjectArchive(@RequestBody ProjectArchiveVO projectArchiveVO) {
        this.logger.info("\u63a5\u6536\u6570\u636e\uff0cpushProjectArchive----" + JSONObject.toJSONString((Object)projectArchiveVO));
        ProjectArchiveEntity entity = (ProjectArchiveEntity)((Object)BeanMapper.map((Object)projectArchiveVO, ProjectArchiveEntity.class));
        if (null == entity.getSourceUpdateId()) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)projectArchiveVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!ArchiveProjectStatusEnum.\u5546\u673a\u9636\u6bb5.getCode().equals(entity.getProjectStatus())) {
            if (null != entity.getSourceUpdateId()) {
                QueryParam param = new QueryParam();
                param.getParams().put("sourceBillId", new Parameter("eq", (Object)entity.getSourceBillId()));
                List list = this.projectArchiveService.queryList(param, false);
                if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
                    entity = this.updateData(entity, (ProjectArchiveEntity)((Object)list.get(0)));
                }
            }
            if (ArchiveProjectStatusEnum.\u5df2\u4e2d\u6807.getCode().equals(entity.getProjectStatus())) {
                OrgVO projectDepartment = null;
                projectDepartment = this.generateProjectDepartment(entity);
                entity.setProjectDepartmentId(projectDepartment.getId());
                entity.setProjectDepartmentName(projectDepartment.getName());
                if (null != projectDepartment) {
                    CommonResponse resp = this.orgApi.saveOrgInfo(projectDepartment);
                    if (!resp.isSuccess()) {
                        throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp.getMsg());
                    }
                    entity.setProjectDepartmentCode(((OrgVO)resp.getData()).getCode());
                }
            }
        }
        this.projectArchiveService.saveOrUpdate((Object)entity, false);
        ProjectArchiveRecordEntity recordEntity = new ProjectArchiveRecordEntity();
        recordEntity.setProjectArchiveId(entity.getId());
        recordEntity.setSourceId(projectArchiveVO.getSourceBillId());
        recordEntity.setProjectStatus(Integer.valueOf(entity.getProjectStatus()));
        this.recordService.saveOrUpdate((Object)recordEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    private ProjectArchiveEntity updateData(ProjectArchiveEntity entity, ProjectArchiveEntity oldEntity) {
        oldEntity.setProjectStatus(entity.getProjectStatus());
        oldEntity.setSourceUpdateId(entity.getSourceUpdateId());
        oldEntity.setName(entity.getName());
        oldEntity.setOrgId(entity.getOrgId());
        oldEntity.setOrgCode(entity.getOrgCode());
        oldEntity.setOrgName(entity.getOrgName());
        oldEntity.setProjectTypeId(entity.getProjectTypeId());
        oldEntity.setProjectTypeName(entity.getProjectTypeName());
        oldEntity.setProductType(entity.getProductType());
        oldEntity.setProductTypeName(entity.getProductTypeName());
        oldEntity.setProjectDate(entity.getProjectDate());
        oldEntity.setCustomName(entity.getCustomName());
        oldEntity.setCustomLinkName(entity.getCustomLinkName());
        oldEntity.setCustomLinkPhone(entity.getCustomLinkPhone());
        oldEntity.setDesignUnit(entity.getDesignUnit());
        oldEntity.setConstructUnit(entity.getConstructUnit());
        oldEntity.setArea(entity.getArea());
        oldEntity.setAreaName(entity.getAreaName());
        oldEntity.setAddress(entity.getAddress());
        oldEntity.setNationalId(entity.getNationalId());
        oldEntity.setNationalName(entity.getNationalName());
        oldEntity.setProjectHeight(entity.getProjectHeight());
        oldEntity.setProjectSpan(entity.getProjectSpan());
        oldEntity.setBidOpenDate(entity.getBidOpenDate());
        oldEntity.setBidDate(entity.getBidDate());
        oldEntity.setPlanProductDate(entity.getPlanProductDate());
        oldEntity.setPlanDeliverDate(entity.getPlanDeliverDate());
        oldEntity.setProductName(entity.getProductName());
        oldEntity.setSpec(entity.getSpec());
        oldEntity.setNum(entity.getNum());
        oldEntity.setSaleLeaderId(entity.getSaleLeaderId());
        oldEntity.setSaleLeaderName(entity.getSaleLeaderName());
        oldEntity.setSaleLeaderPhone(entity.getSaleLeaderPhone());
        oldEntity.setProjectSituation(entity.getProjectSituation());
        return oldEntity;
    }

    @GetMapping(value={"updateProjectStatus"})
    CommonResponse<String> updateProjectStatus(String projectStatus, Long sourceId) {
        this.logger.info("\u63a5\u6536\u53c2\u6570-projectStatus-{}\uff0csourceId-{}", (Object)projectStatus, (Object)sourceId);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        if (Integer.valueOf(projectStatus) < Integer.valueOf(ArchiveProjectStatusEnum.\u5408\u540c\u9636\u6bb5.getCode())) {
            updateWrapper.eq(ProjectArchiveEntity::getSourceBillId, (Object)sourceId);
        } else {
            updateWrapper.eq(BaseEntity::getId, (Object)sourceId);
        }
        updateWrapper.set(ProjectArchiveEntity::getProjectStatus, (Object)projectStatus);
        if (!this.projectArchiveService.update((Wrapper)updateWrapper)) {
            return CommonResponse.error((String)"\u4fee\u6539\u9879\u76ee\u9636\u6bb5\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u4fee\u6539\u9879\u76ee\u9636\u6bb5\u6210\u529f\uff01");
    }

    @GetMapping(value={"updateBusinessRound"})
    CommonResponse<String> updateBusinessRound(Integer businessRound, Long sourceId) {
        this.logger.info("\u63a5\u6536\u53c2\u6570-businessRound-{}\uff0csourceId-{}", (Object)businessRound, (Object)sourceId);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(ProjectArchiveEntity::getSourceBillId, (Object)sourceId);
        updateWrapper.set(ProjectArchiveEntity::getBusinessRound, (Object)businessRound);
        if (!this.projectArchiveService.update((Wrapper)updateWrapper)) {
            return CommonResponse.error((String)"\u4fee\u6539\u9879\u76ee\u4fe1\u606f-\u5546\u673a\u9636\u6bb5\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u4fee\u6539\u9879\u76ee\u4fe1\u606f-\u5546\u673a\u9636\u6bb5\u6210\u529f\uff01");
    }

    @GetMapping(value={"updateArchiveProjectStatus"})
    CommonResponse<String> updateArchiveProjectStatus(String projectStatus, Long sourceId, Long billId, Boolean manyFlag, Boolean updateFlag) {
        QueryWrapper recordDeleteWrapper;
        this.logger.info("\u63a5\u6536\u53c2\u6570-projectStatus-{}\uff0csourceId-{}\uff0cbillId-{}\uff0cmanyFlag-{}\uff0cupdateFlag-{}", new Object[]{projectStatus, sourceId, billId, manyFlag, updateFlag});
        ProjectArchiveEntity projectArchiveEntity = new ProjectArchiveEntity();
        if (Integer.valueOf(projectStatus) < Integer.valueOf(ArchiveProjectStatusEnum.\u5408\u540c\u9636\u6bb5.getCode())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"source_bill_id", (Object)sourceId);
            List list = this.projectArchiveService.list((Wrapper)queryWrapper);
            projectArchiveEntity = (ProjectArchiveEntity)((Object)list.get(0));
        } else {
            projectArchiveEntity = (ProjectArchiveEntity)((Object)this.projectArchiveService.selectById(sourceId));
        }
        Boolean bigFlag = false;
        Boolean existFlag = false;
        QueryWrapper recordQueryWrapper = new QueryWrapper();
        recordQueryWrapper.eq((Object)"project_archive_id", (Object)projectArchiveEntity.getId());
        recordQueryWrapper.orderByDesc((Object)"project_status");
        List list = this.recordService.list((Wrapper)recordQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0) {
            Integer nowStatus = ((ProjectArchiveRecordEntity)((Object)list.get(0))).getProjectStatus();
            List statusList = list.stream().map(ProjectArchiveRecordEntity::getProjectStatus).collect(Collectors.toList());
            if (nowStatus > Integer.valueOf(projectStatus)) {
                bigFlag = true;
            }
            if (statusList.contains(Integer.valueOf(projectStatus))) {
                existFlag = true;
            }
        }
        if (updateFlag.booleanValue()) {
            ProjectArchiveRecordEntity recordEntity;
            if (bigFlag.booleanValue()) {
                if (!existFlag.booleanValue()) {
                    recordEntity = new ProjectArchiveRecordEntity();
                    recordEntity.setProjectArchiveId(projectArchiveEntity.getId());
                    recordEntity.setSourceId(billId);
                    recordEntity.setProjectStatus(Integer.valueOf(projectStatus));
                    this.recordService.saveOrUpdate((Object)recordEntity);
                }
            } else if (!existFlag.booleanValue()) {
                recordEntity = new ProjectArchiveRecordEntity();
                recordEntity.setProjectArchiveId(projectArchiveEntity.getId());
                recordEntity.setSourceId(billId);
                recordEntity.setProjectStatus(Integer.valueOf(projectStatus));
                this.recordService.saveOrUpdate((Object)recordEntity);
                projectArchiveEntity.setProjectStatus(projectStatus);
            }
        } else if (bigFlag.booleanValue()) {
            if (!manyFlag.booleanValue()) {
                recordDeleteWrapper = new QueryWrapper();
                recordDeleteWrapper.eq((Object)"project_archive_id", (Object)projectArchiveEntity.getId());
                recordDeleteWrapper.eq((Object)"project_status", (Object)Integer.valueOf(projectStatus));
                this.recordService.remove((Wrapper)recordDeleteWrapper);
            }
        } else if (!manyFlag.booleanValue()) {
            recordDeleteWrapper = new QueryWrapper();
            recordDeleteWrapper.eq((Object)"project_archive_id", (Object)projectArchiveEntity.getId());
            recordDeleteWrapper.eq((Object)"project_status", (Object)Integer.valueOf(projectStatus));
            this.recordService.remove((Wrapper)recordDeleteWrapper);
            projectArchiveEntity.setProjectStatus(list.size() > 1 ? ((ProjectArchiveRecordEntity)((Object)list.get(1))).getProjectStatus().toString() : ArchiveProjectStatusEnum.\u5546\u673a\u9636\u6bb5.getCode());
        }
        this.projectArchiveService.saveOrUpdate((Object)projectArchiveEntity);
        return CommonResponse.success((String)"\u4fee\u6539\u9879\u76ee\u9636\u6bb5\u6210\u529f\uff01");
    }

    private OrgVO generateProjectDepartment(ProjectArchiveEntity projectArchiveEntity) {
        if (projectArchiveEntity.getOrgId() == null) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
        }
        CommonResponse response = this.orgApi.getOneById(projectArchiveEntity.getOrgId());
        OrgVO parentOrg = null;
        if (!response.isSuccess()) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: " + response.getMsg());
        }
        parentOrg = (OrgVO)response.getData();
        if (null == parentOrg) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
        }
        OrgVO projectDepartment = new OrgVO();
        OrgVO paramVo = new OrgVO();
        paramVo.setName(projectArchiveEntity.getName());
        paramVo.setOrgType(Integer.valueOf(5));
        paramVo.setTenantId(InvocationInfoProxy.getTenantid());
        response = this.orgApi.findOneByOrgVO(paramVo);
        if (response.isSuccess()) {
            if (response.getData() != null) {
                projectDepartment = (OrgVO)response.getData();
            } else {
                projectDepartment.setId(Long.valueOf(IdWorker.getId()));
                projectDepartment.setTenantId(parentOrg.getTenantId());
                projectDepartment.setName(projectArchiveEntity.getName());
                projectDepartment.setShortName(projectArchiveEntity.getShortName());
                projectDepartment.setState(Integer.valueOf(1));
                projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
            }
        } else {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u5bf9\u5e94\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: " + response.getMsg());
        }
        projectDepartment.setIsParent(Boolean.valueOf(false));
        projectDepartment.setProjectCode(projectArchiveEntity.getCode());
        projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
        projectDepartment.setParentId(projectArchiveEntity.getOrgId());
        return projectDepartment;
    }

    @PostMapping(value={"updateProjectData"})
    CommonResponse<String> updateProjectData(@RequestBody ProjectArchiveVO projectArchiveVO) {
        this.logger.info("\u63a5\u6536\u6570\u636e\uff0cpushProjectArchive----" + JSONObject.toJSONString((Object)projectArchiveVO));
        ProjectArchiveEntity projectArchiveEntity = (ProjectArchiveEntity)((Object)this.projectArchiveService.selectById(projectArchiveVO.getId()));
        projectArchiveEntity.setCustomId(projectArchiveVO.getCustomId());
        projectArchiveEntity.setCustomName(projectArchiveVO.getCustomName());
        projectArchiveEntity.setCustomCode(projectArchiveVO.getCustomCode());
        projectArchiveEntity.setProjectStatus(projectArchiveVO.getProjectStatus());
        this.projectArchiveService.saveOrUpdate((Object)projectArchiveEntity, false);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @GetMapping(value={"getProjectArchiveByCode"})
    CommonResponse<ProjectArchiveVO> getProjectArchiveByCode(@RequestParam String code) {
        this.logger.info("\u63a5\u6536\u53c2\u6570-code-{}", (Object)code);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("code", new Parameter("eq", (Object)code));
        List projectArchiveEntityList = this.projectArchiveService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)projectArchiveEntityList) && projectArchiveEntityList.size() > 0) {
            return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u6210\u529f\uff01", (Object)BeanMapper.map(projectArchiveEntityList.get(0), ProjectArchiveVO.class));
        }
        return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\uff01");
    }

    @GetMapping(value={"getProjectArchiveById"})
    CommonResponse<ProjectArchiveVO> getProjectArchiveById(@RequestParam Long id) {
        this.logger.info("\u63a5\u6536\u53c2\u6570-id-{}", (Object)id);
        ProjectArchiveEntity projectArchiveEntity = (ProjectArchiveEntity)((Object)this.projectArchiveService.selectById(id));
        if (null != projectArchiveEntity && null != projectArchiveEntity.getId()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)projectArchiveEntity), ProjectArchiveVO.class));
        }
        return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570\uff01");
    }

    @GetMapping(value={"getProjectArchiveBySourceId"})
    CommonResponse<ProjectArchiveVO> getProjectArchiveBySourceId(@RequestParam Long sourceId) {
        this.logger.info("\u63a5\u6536\u53c2\u6570-sourceId-{}", (Object)sourceId);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceBillId", new Parameter("eq", (Object)sourceId));
        List projectArchiveEntityList = this.projectArchiveService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)projectArchiveEntityList) && projectArchiveEntityList.size() > 0) {
            return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u6210\u529f\uff01", (Object)BeanMapper.map(projectArchiveEntityList.get(0), ProjectArchiveVO.class));
        }
        return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570\uff01");
    }

    @PostMapping(value={"getProjectArchiveByIds"})
    CommonResponse<List<ProjectArchiveVO>> getProjectArchiveByIds(@RequestBody List<Long> ids) {
        this.logger.info("\u63a5\u6536\u53c2\u6570-ids-{}", (Object)JSONObject.toJSONString(ids));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List projectArchiveEntityList = this.projectArchiveService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)projectArchiveEntityList) && projectArchiveEntityList.size() > 0) {
            return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)projectArchiveEntityList, ProjectArchiveVO.class));
        }
        return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u53c2\u6570\uff01");
    }

    @PostMapping(value={"queryProjectArchivePage"})
    @ResponseBody
    public CommonResponse<Page<ProjectArchiveVO>> queryProjectArchivePage(@RequestBody QueryParam param) {
        this.logger.info("\u63a5\u6536\u53c2\u6570-param-{}", (Object)JSONObject.toJSONString((Object)param));
        List orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectDepartmentId", new Parameter("in", orgIds));
        IPage page = this.projectArchiveService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectArchiveVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }
}

