/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.bean.CustomerEntity;
import com.ejianc.foundation.share.bean.CustomerLinkerEntity;
import com.ejianc.foundation.share.mapper.CustomerMapper;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.service.ICustomerLinkerService;
import com.ejianc.foundation.share.service.ICustomerService;
import com.ejianc.foundation.share.vo.CustomerLinkerVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerServiceImpl
extends BaseServiceImpl<CustomerMapper, CustomerEntity>
implements ICustomerService {
    private static final String CUSTOMER_BILL_CODE = "SUPPORT_CUSTOMER";
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private ICustomerLinkerService customerLinkerService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ICustomerCategoryService customerCategoryService;

    @Override
    public List<CustomerVO> queryListByCategoryId(Long categoryId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"category_id", (Object)categoryId);
        List entities = this.customerMapper.selectList((Wrapper)wrapper);
        if (entities != null) {
            return BeanMapper.mapList((Iterable)entities, CustomerVO.class);
        }
        return null;
    }

    @Override
    public CommonResponse<String> saveOrUpdate(CustomerVO customerVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CustomerEntity entity = null;
        String operateType = null;
        if (customerVo.getCategoryId() == null) {
            return CommonResponse.error((String)"\u5ba2\u6237\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.check(customerVo);
        if (customerVo.getId() != null && customerVo.getId() > 0L) {
            entity = (CustomerEntity)((Object)this.customerMapper.selectById(customerVo.getId()));
            entity.setCode(customerVo.getCode());
            entity.setCategoryId(customerVo.getCategoryId());
            entity.setCategoryName(customerVo.getCategoryName());
            entity.setName(customerVo.getName());
            entity.setSocialCreditCode(customerVo.getSocialCreditCode());
            entity.setLegal(customerVo.getLegal());
            entity.setTaxPayerType(customerVo.getTaxPayerType());
            entity.setTaxPayerTypeName(customerVo.getTaxPayerTypeName());
            entity.setCustomerType(customerVo.getCustomerType());
            entity.setCustomerTypeName(customerVo.getCustomerTypeName());
            entity.setArea(customerVo.getArea());
            entity.setAddress(customerVo.getAddress());
            entity.setTelephone(customerVo.getTelephone());
            entity.setBankName(customerVo.getBankName());
            entity.setBankAccount(customerVo.getBankAccount());
            entity.setBankCode(customerVo.getBankCode());
            entity.setDescription(customerVo.getDescription());
            entity.setAreaStr(customerVo.getAreaStr());
            entity.setAddressAndPhone(customerVo.getAddressAndPhone());
            operateType = "edit";
        } else {
            BillCodeParam billCodeParam = BillCodeParam.build((String)CUSTOMER_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)customerVo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            customerVo.setCode((String)billCode.getData());
            entity = (CustomerEntity)((Object)BeanMapper.map((Object)customerVo, CustomerEntity.class));
            operateType = "add";
        }
        super.saveOrUpdate((Object)entity);
        List customerLinkerVos = customerVo.getGridheaders();
        ArrayList<CustomerLinkerEntity> saveOrUpldates = new ArrayList<CustomerLinkerEntity>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        for (CustomerLinkerVO customerLinkerVo : customerLinkerVos) {
            CustomerLinkerEntity customerLinkerEntity;
            if ("add".equals(customerLinkerVo.getRowState())) {
                customerLinkerEntity = (CustomerLinkerEntity)((Object)BeanMapper.map((Object)customerLinkerVo, CustomerLinkerEntity.class));
                customerLinkerEntity.setCustomerId(entity.getId());
                saveOrUpldates.add(customerLinkerEntity);
                continue;
            }
            if ("edit".equals(customerLinkerVo.getRowState())) {
                customerLinkerEntity = (CustomerLinkerEntity)((Object)BeanMapper.map((Object)customerLinkerVo, CustomerLinkerEntity.class));
                saveOrUpldates.add(customerLinkerEntity);
                continue;
            }
            if (!"del".equals(customerLinkerVo.getRowState())) continue;
            deleteIds.add(customerLinkerVo.getId());
        }
        if (saveOrUpldates.size() > 0) {
            this.customerLinkerService.saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        }
        if (deleteIds.size() > 0) {
            this.customerLinkerService.removeByIds(deleteIds, false);
        }
        if ("add".equals(operateType)) {
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    private void check(CustomerVO customerVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (customerVo.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)customerVo.getId());
        }
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"social_credit_code", (Object)customerVo.getSocialCreditCode());
        List list = this.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            throw new BusinessException("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5df2\u5b58\u5728\uff01\uff01\uff01");
        }
    }

    @Override
    public CustomerVO queryDetail(Long id) {
        CustomerEntity entity = (CustomerEntity)((Object)this.customerMapper.selectById(id));
        if (entity != null) {
            CustomerVO customerVo = (CustomerVO)BeanMapper.map((Object)((Object)entity), CustomerVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("customerId", new Parameter("eq", (Object)customerVo.getId()));
            queryParam.getOrderMap().put("createTime", "desc");
            List customerLinkers = this.customerLinkerService.queryList(queryParam, false);
            if (customerLinkers != null && customerLinkers.size() > 0) {
                List customerLinkerVos = BeanMapper.mapList((Iterable)customerLinkers, CustomerLinkerVO.class);
                customerVo.setGridheaders(customerLinkerVos);
            }
            return customerVo;
        }
        return null;
    }

    @Override
    public void deleteCustomer(List<Long> ids) {
        for (Long id : ids) {
            this.customerLinkerService.deleteByCustomerId(id);
            this.customerMapper.deleteById(id);
        }
    }

    @Override
    public IPage<CustomerVO> queryPageList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            if ("categoryId".equals(entry.getKey())) {
                CustomerCategoryEntity categoryEntity;
                if (!StringUtils.isNotBlank((CharSequence)((Parameter)entry.getValue()).getValue().toString()) || (categoryEntity = this.customerCategoryService.queryDetail(Long.parseLong(((Parameter)entry.getValue()).getValue().toString()))) == null) continue;
                condition.put("innerCode", categoryEntity.getInnerCode());
                continue;
            }
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        if (StringUtils.isNotBlank((CharSequence)queryParam.getSearchText())) {
            condition.put("searchText", queryParam.getSearchText());
        }
        List<CustomerEntity> customerEntities = this.customerMapper.queryList(condition);
        Long count = this.customerMapper.queryCount(condition);
        ArrayList<CustomerVO> customerVos = new ArrayList<CustomerVO>();
        CustomerVO customerVo = null;
        HashMap defMap = new HashMap();
        for (CustomerEntity entity : customerEntities) {
            customerVo = (CustomerVO)BeanMapper.map((Object)((Object)entity), CustomerVO.class);
            customerVos.add(customerVo);
        }
        Page resultPage = new Page();
        resultPage.setCurrent((long)queryParam.getPageIndex());
        resultPage.setRecords(customerVos);
        resultPage.setTotal(count.longValue());
        return resultPage;
    }

    @Override
    public List<CustomerVO> queryExportList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        List<CustomerEntity> customerEntities = this.customerMapper.queryExportList(condition);
        ArrayList<CustomerVO> customerVos = new ArrayList<CustomerVO>();
        CustomerVO customerVo = null;
        CommonResponse defDocDetailListResp = this.defdocApi.getDefDocByDefCode("customer_type");
        Map<Object, Object> defDocDetailMap = new HashMap();
        if (defDocDetailListResp.isSuccess()) {
            List defDocDetailList = (List)defDocDetailListResp.getData();
            if (CollectionUtils.isNotEmpty((Collection)defDocDetailList)) {
                defDocDetailMap = defDocDetailList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, Function.identity(), (key1, key2) -> key2));
            }
        } else {
            throw new BusinessException("\u83b7\u53d6\u5ba2\u6237\u7c7b\u578b\u81ea\u5b9a\u4e49\u6863\u6848\u4fe1\u606f\u5931\u8d25\uff01");
        }
        for (CustomerEntity entity : customerEntities) {
            customerVo = (CustomerVO)BeanMapper.map((Object)((Object)entity), CustomerVO.class);
            if (defDocDetailMap.containsKey(customerVo.getCustomerType())) {
                customerVo.setCustomerTypeName(((DefdocDetailVO)defDocDetailMap.get(customerVo.getCustomerType())).getName());
            }
            QueryParam linkerQueryParam = new QueryParam();
            linkerQueryParam.getParams().put("customerId", new Parameter("eq", (Object)customerVo.getId()));
            List linkerEntities = this.customerLinkerService.queryList(linkerQueryParam, false);
            if (linkerEntities != null && linkerEntities.size() > 0) {
                CustomerLinkerEntity linkerEntity = (CustomerLinkerEntity)((Object)linkerEntities.get(0));
                customerVo.setLinkman(linkerEntity.getLinkman());
                customerVo.setCellphone(linkerEntity.getCellphone());
            }
            customerVos.add(customerVo);
        }
        return customerVos;
    }

    @Override
    public CustomerVO queryDetailBySocialCode(String socialCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"social_credit_code", (Object)socialCode);
        queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List entities = this.customerMapper.selectList((Wrapper)queryWrapper);
        if (entities != null && entities.size() > 0) {
            return (CustomerVO)BeanMapper.map(entities.get(0), CustomerVO.class);
        }
        return null;
    }
}

