package com.ejianc.foundation.share.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.foundation.share.bean.ProjectArchiveEntity;
import com.ejianc.foundation.share.service.IProjectArchiveService;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;

/**
 * 项目档案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectArchive")
public class ProjectArchiveController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Project_Archive";//此处需要根据实际修改

    @Autowired
    private IProjectArchiveService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectArchiveVO> saveOrUpdate(@RequestBody ProjectArchiveVO saveOrUpdateVO) {
    	ProjectArchiveEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectArchiveEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            System.out.println(billCode.isSuccess());
            System.out.println(billCode.getData());
            System.out.println(billCode.getMsg());

            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //校验编码
            if (StringUtils.isBlank(entity.getCode())){
                ProjectArchiveEntity oldEntity = service.selectById(entity.getId());
                entity.setCode(oldEntity.getCode());
            }else {
                //验证编码是否唯一
                if (service.checkSameBillCode(saveOrUpdateVO)){
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }
        }
    	service.saveOrUpdate(entity, false);
    	ProjectArchiveVO vo = BeanMapper.map(entity, ProjectArchiveVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectArchiveVO> queryDetail(Long id) {
    	ProjectArchiveEntity entity = service.selectById(id);
    	ProjectArchiveVO vo = BeanMapper.map(entity, ProjectArchiveVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectArchiveVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProjectArchiveVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProjectArchiveVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectArchiveVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("orgName");
        fuzzyFields.add("businessCustomName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("businessRound");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProjectArchiveEntity> page = service.queryPage(param,false);
        IPage<ProjectArchiveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        page.getRecords().forEach(i->{
            i.setBusinessCustomName(null != i.getCustomId() ? i.getCustomName() : i.getBusinessCustomName());
        });
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectArchiveVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("orgName");
        fuzzyFields.add("businessCustomName");
        fuzzyFields.add("projectTypeName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("saleLeaderName");
        fuzzyFields.add("businessRound");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectArchiveEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<ProjectArchiveVO> projectArchiveVOList = BeanMapper.mapList(list, ProjectArchiveVO.class);
        projectArchiveVOList.forEach(i -> {
            // 4、已中标 5、合同阶段 6、生产阶段 7、供货阶段 8、结算阶段 9、完工
            switch (i.getProjectStatus()) {
                case "1":
                    i.setProjectStatusName("商机阶段");
                    break;
                case "2":
                    i.setProjectStatusName("投标阶段");
                    break;
                case "3":
                    i.setProjectStatusName("未中标");
                    break;
                case "4":
                    i.setProjectStatusName("已中标");
                    break;
                case "5":
                    i.setProjectStatusName("合同阶段");
                    break;
                case "6":
                    i.setProjectStatusName("生产阶段");
                    break;
                case "7":
                    i.setProjectStatusName("供货阶段");
                    break;
                case "8":
                    i.setProjectStatusName("结算阶段");
                    break;
                case "9":
                    i.setProjectStatusName("完工");
                    break;
                default:
                    break;
            }
            if (null != i.getBusinessRound()){
                switch (i.getBusinessRound()) {
                    case 0:
                        i.setBusinessRoundName("项目立项");
                        break;
                    case 1:
                        i.setBusinessRoundName("设计方案");
                        break;
                    case 2:
                        i.setBusinessRoundName("业主招标");
                        break;
                    case 3:
                        i.setBusinessRoundName("总包招标");
                        break;
                    case 4:
                        i.setBusinessRoundName("合同签订");
                        break;
                }
            }
            i.setBusinessCustomName(null != i.getCustomId() ? i.getCustomName() : i.getBusinessCustomName());
        });
        beans.put("records", projectArchiveVOList);
        ExcelExport.getInstance().export("ProjectArchive-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProjectArchiveData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectArchiveVO>> refProjectArchiveData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        //设置模糊查询
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("projectTypeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        String projectStatus = "";
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("orgId")) {
                orgId = Long.valueOf(String.valueOf(_con.get("orgId")));
            }
            if (_con.containsKey("projectStatus")) {
                projectStatus = String.valueOf(_con.get("projectStatus"));
            }
        }
        logger.info("projectStatus:{}", projectStatus);
        if (!"all".equals(projectStatus)){
            param.getParams().put("projectStatus", new Parameter(QueryParam.NOT_IN, Arrays.asList(1,2,3)));
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else {
            ComplexParam c1 = new ComplexParam();
            c1.setLogic(ComplexParam.AND);
            //已中标的按组织过滤
            ComplexParam c2 = new ComplexParam();
            c2.setLogic(ComplexParam.OR);
            c2.getParams().put("projectStatus", new Parameter(QueryParam.NOT_IN, Arrays.asList(1,2,3)));
            c2.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            c1.getComplexParams().add(c2);
            //未中标的按
            ComplexParam c3 = new ComplexParam();
            c3.setLogic(ComplexParam.OR);
            c3.getParams().put("projectStatus", new Parameter(QueryParam.IN, Arrays.asList(1,2,3)));
            c1.getComplexParams().add(c3);
            param.getComplexParams().add(c1);
        }
        param.getOrderMap().put("createTime", QueryParam.DESC);
        IPage<ProjectArchiveEntity> page = service.queryPage(param, false);
        IPage<ProjectArchiveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<ProjectArchiveVO> list = BeanMapper.mapList(page.getRecords(), ProjectArchiveVO.class);

        list.forEach(i -> {
            // 4、已中标 5、合同阶段 6、生产阶段 7、供货阶段 8、结算阶段 9、完工
            switch (i.getProjectStatus()) {
                case "1":
                    i.setProjectStatusName("商机阶段");
                    break;
                case "2":
                    i.setProjectStatusName("投标阶段");
                    break;
                case "3":
                    i.setProjectStatusName("未中标");
                    break;
                case "4":
                    i.setProjectStatusName("已中标");
                    break;
                case "5":
                    i.setProjectStatusName("合同阶段");
                    break;
                case "6":
                    i.setProjectStatusName("生产阶段");
                    break;
                case "7":
                    i.setProjectStatusName("供货阶段");
                    break;
                case "8":
                    i.setProjectStatusName("结算阶段");
                    break;
                case "9":
                    i.setProjectStatusName("完工");
                    break;
                default:
                    break;
            }
            i.setBusinessCustomName(null != i.getCustomId() ? i.getCustomName() : i.getBusinessCustomName());
        });
        pageData.setRecords(list);
        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
