package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.share.bean.ProjectArchiveEntity;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.ProjectWbsEntity;
import com.ejianc.foundation.share.service.IProjectArchiveService;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.IProjectWbsService;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.foundation.util.SeparatorUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目WBS
 *
 * @author generator
 */
@Controller
@RequestMapping("projectWbs")
public class ProjectWbsController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    //白名单
    private static final String PARAM_LOAD_APPLY_VIEW_CODE = "P-50U29j0017";

    @Autowired
    private IRoleApi roleApi;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IProjectWbsService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProjectArchiveService projectSetService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectWbsVO> saveOrUpdate(@RequestBody ProjectWbsVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectWbsVO> queryDetail(Long id) {
        ProjectWbsEntity entity = service.selectById(id);
        ProjectWbsVO vo = BeanMapper.map(entity, ProjectWbsVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody ProjectWbsVO projectWbsVO) {
        List<Long> ids = projectWbsVO.getIds();
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse<String> resp = billTypeApi.checkQuote("EJCBT202206000006", id);
                if (!resp.isSuccess()) {
                    return CommonResponse.error("删除失败！" + resp.getMsg());
                }
            }
            service.removeByIds(ids);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject jsonObject = new JSONObject();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

     /*   UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            List<Long> longs = Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
            //没有组织则设定为当前用户组织
            if(!param.getParams().containsKey("orgId")){
                param.getParams().put("orgId", new Parameter(QueryParam.IN, longs));
            }
        }else {//pc端查询
            authOrgIds = String.valueOf(InvocationInfoProxy.getOrgId());
            //没有组织则设定为当前用户组织
            if(!param.getParams().containsKey("orgId")){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, authOrgIds));
            }
        }*/

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        List<ProjectWbsEntity> wbsEntityList = service.queryList(param, false);
        if (CollectionUtils.isNotEmpty(wbsEntityList) && !canViewAll()) {
            //如果不是白名单的用户，则查询负责人为该用户的数据
            //获取当前用户
            String userIdStr = sessionManager.getUserContext().getEmployeeId().toString();
            //获取当前用户为负责人的数据id
            List<Long> userDataIdList = wbsEntityList.stream().filter(e -> null != e.getHeadId() && e.getHeadId().contains(userIdStr)).map(ProjectWbsEntity::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(userDataIdList)) {
                //获取上级
                List<String> innerCodeIdList = wbsEntityList.stream().filter(e -> null != e.getHeadId() && e.getHeadId().contains(userIdStr)).map(ProjectWbsEntity::getInnerCode).collect(Collectors.toList());
                HashSet<String> returnIds = new HashSet<>();
                for (String idStr : innerCodeIdList) {
                    List<String> list = Arrays.asList(idStr.split(","));
                    returnIds.addAll(list);
                }
                //获取本下
                for (Long dataId : userDataIdList) {
                    List<Long> idList = wbsEntityList.stream().filter(e -> dataId != e.getId() && null != e.getInnerCode() && e.getInnerCode().contains(dataId.toString())).map(ProjectWbsEntity::getId).collect(Collectors.toList());
                    idList.forEach(e -> {
                        returnIds.add(e.toString());
                    });
                }

                wbsEntityList = wbsEntityList.stream().filter(e -> returnIds.contains(e.getId().toString())).collect(Collectors.toList());
            } else {
                //负责人没有该用户则返回空
                jsonObject.put("records", "");
                return CommonResponse.success("查询列表数据成功！", jsonObject);
            }
        }


        //如果当前项目没有wbs，则需要预置一个
        if (param.getParams().containsKey("projectId")) {
            Parameter projectIdParam = param.getParams().get("projectId");
            if (projectIdParam.getValue() != null) {
                Long projectId = Long.valueOf(projectIdParam.getValue().toString());
                this.addDefaultOne(projectId, wbsEntityList);
            }
        }

        List<Map> resultMapList = BeanMapper.mapList(wbsEntityList, Map.class);

        jsonObject.put("records", ResultAsTree.createTreeData(resultMapList));

        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectWbsEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectWbs-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "projectWbs-export.xlsx", "合同清单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Long projectId) {
        return service.excelImport(request, response, projectId);
    }

    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<ProjectWbsVO> importVOS) {
        return CommonResponse.success((String) service.saveImportExcel(request, importVOS));
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProjectWbsData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refProjectWbsData(@RequestParam(value = "searchText", required = false) String searchText,
                                                       @RequestParam(value = "condition", required = false) String condition
    ) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        param.setSearchText(searchText);
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));

        Long projectId = null;
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("wbsTypeList")) {
                String wbsType = String.valueOf(conditionMap.get("wbsTypeList").toString());
                logger.info("接收wbsType-{}", wbsType);
                List<String> wbsTypeList = Arrays.asList(wbsType.split(","));
                param.getParams().put("wbsType", new Parameter(QueryParam.IN, wbsTypeList));
            }
            if (null != conditionMap.get("parentId")) {
                String parentId = String.valueOf(conditionMap.get("parentId").toString());
                logger.info("接收parentId-{}", parentId);
                param.getParams().put("parentId", new Parameter(QueryParam.EQ, parentId));
            }
        }

        List<ProjectWbsEntity> wbsEntityList = service.queryList(param, false);

        //如果当前项目没有wbs，则需要预置一个
        this.addDefaultOne(projectId, wbsEntityList);

        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        for (ProjectWbsEntity entity : wbsEntityList) {
            String name = entity.getName();
            if (null != entity.getWbsType() && (3 == entity.getWbsType() || 4 == entity.getWbsType())) {
                name = name + "（" + (3 == entity.getWbsType() ? "产品" : "构件") + "）";
            }
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", name);
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("innerCode", entity.getInnerCode());
            map.put("wbsType", entity.getWbsType());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }


    /**
     * 根据叶子结点查询整棵树
     */
    @RequestMapping(value = "queryWBSWholeTreeItemsById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryWBSWholeTreeItemsById(@RequestParam(value = "idStr") String idStr) {
        return service.queryWBSWholeTreeItemsById(idStr);
    }

    public Boolean canViewAll() {
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(PARAM_LOAD_APPLY_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            if (StringUtils.isNotEmpty(valueData)) {
                Long userid = InvocationInfoProxy.getUserid();
                CommonResponse<List<RoleVO>> roleRes = roleApi.queryRoleByUserId(userid);
                if (roleRes.isSuccess() && CollectionUtils.isNotEmpty(roleRes.getData())) {
                    List<String> valList = Arrays.asList(valueData.split(",|，"));
                    for (RoleVO roleVO : roleRes.getData()) {
                        if (valList.contains(roleVO.getCode()))
                            return Boolean.TRUE;
                    }
                }
            }
        }
        return Boolean.FALSE;
    }

    /**
     * @Description 进度管理-总计划-项目WBS参照
     * @Return void
     */
    @RequestMapping(value = "/refProjectWbsTotal", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refProjectWbsTotal(@RequestParam(value = "searchText", required = false) String searchText,
                                                        @RequestParam(value = "condition", required = false) String condition) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        param.setSearchText(searchText);
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));

        Long projectId = null;
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        List<ProjectWbsEntity> wbsEntityList = service.queryList(param, false);

        // 如果当前项目没有wbs，则需要预置一个
        this.addDefaultOne(projectId, wbsEntityList);

        // 如果不是白名单的用户，则查询负责人为该用户的数据
        if (CollectionUtils.isNotEmpty(wbsEntityList) && !canViewAll()) {
            // 根据当前用户进行过滤
            wbsEntityList = this.filterWbsList(wbsEntityList);
        }

        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        for (ProjectWbsEntity entity : wbsEntityList) {
            String name = entity.getName();
            if (null != entity.getWbsType() && (3 == entity.getWbsType() || 4 == entity.getWbsType())) {
                name = name + "（" + (3 == entity.getWbsType() ? "产品" : "构件") + "）";
            }
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", name);
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("innerCode", entity.getInnerCode());
            map.put("wbsType", entity.getWbsType());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     * @Description 报表
     * @Return void
     */
    @RequestMapping(value = "/reportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectArchiveVO>> reportList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("customName");
        return CommonResponse.success(service.reportList(param, false));
    }

    /***
     * @description: 获取未编写WBS的项目
     *
     */
    @GetMapping(value = "/api/shareProjectWbsApi/getProjectIdsNoWbs")
    public CommonResponse<List<ProjectArchiveVO>> getProjectIdsNoWbs(){
        return CommonResponse.success(service.getProjectIdsNoWbs());

    }

    /**
     * 根据当前用户进行过滤
     *
     * @param wbsList
     * @return
     */
    private List<ProjectWbsEntity> filterWbsList(List<ProjectWbsEntity> wbsList) {
        // 获取当前用户为负责人的数据id
        List<Long> ids = wbsList.stream().filter(e -> null != e.getHeadId() && e.getHeadId().contains(
                InvocationInfoProxy.getEmployeeId().toString())).map(ProjectWbsEntity::getId).collect(Collectors.toList());
        // 责任人是自己及其上级和下级
        List<String> codes = wbsList.stream().filter(x -> ids.contains(x.getId())).map(x -> x.getInnerCode()).collect(Collectors.toList());
        Set<String> innerCodes = codes.stream().flatMap(x -> SeparatorUtil.substringPre(x, ",").stream()).collect(Collectors.toSet());
        Set<ProjectWbsEntity> result = wbsList.stream().filter(x -> innerCodes.contains(x.getInnerCode())).collect(Collectors.toSet());// 本上
        for (ProjectWbsEntity detail : wbsList) {
            for (String code : codes) {
                if (detail.getInnerCode().startsWith(code)) {
                    result.add(detail);// 本下
                }
            }
        }
        return new ArrayList<>(result);
    }

    /**
     * 如果当前项目没有wbs，则需要预置一个
     *
     * @param projectId
     * @param wbsList
     */
    private void addDefaultOne(Long projectId, List<ProjectWbsEntity> wbsList) {
        if (projectId == null) {
            return;
        }
        QueryWrapper<ProjectWbsEntity> ew = new QueryWrapper<>();
        ew.eq("project_id", projectId);
        int count = service.count(ew);
        if (count > 0) {
            return;
        }
        ProjectArchiveEntity projectSetPoolEntity = projectSetService.selectById(projectId);
        ProjectWbsVO vo = new ProjectWbsVO();
        vo.setId(IdWorker.getId());
        vo.setCode(projectSetPoolEntity.getCode());
        vo.setName(projectSetPoolEntity.getName());
        vo.setProjectId(projectId);
        vo.setOrgId(projectSetPoolEntity.getOrgId());
        vo.setEnabled(1);
        vo.setInnerCode(String.valueOf(vo.getId()));
        ProjectWbsEntity entity = BeanMapper.map(vo, ProjectWbsEntity.class);
        if (service.saveOrUpdate(entity)) {
            wbsList.add(entity);
        }
    }


}
