package com.ejianc.foundation.share.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.StandardProcessEntity;
import com.ejianc.foundation.share.service.IStandardProcessService;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.util.StandardProcessCategoryAsTree;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.share.bean.StandardProcessCategoryEntity;
import com.ejianc.foundation.share.service.IStandardProcessCategoryService;
import com.ejianc.foundation.share.vo.StandardProcessCategoryVO;

/**
 * 标准工序档案分类表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("standardProcessCategory")
public class StandardProcessCategoryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "STANDARD_PROCESS_CATEGORY";//此处需要根据实际修改

    @Autowired
    private IStandardProcessCategoryService service;
    @Autowired
    private IStandardProcessService standardProcessService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StandardProcessCategoryVO> saveOrUpdate(@RequestBody StandardProcessCategoryVO saveOrUpdateVO) {
        StandardProcessCategoryEntity entity = BeanMapper.map(saveOrUpdateVO, StandardProcessCategoryEntity.class);
        if(StringUtils.isNoneBlank(entity.getCode())){
            List<StandardProcessCategoryEntity> codeData = service.queryByCode(entity.getCode(), entity.getId());
            if(codeData!=null && codeData.size()>0){
                throw new BusinessException("分类编码已存在,请重新填写");
            }
        }
        if(entity.getId() == null || entity.getId() == 0){
            if (null == entity.getCode()){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity.setId(IdWorker.getId());
            if(entity.getParentId() != null && entity.getParentId() > 0) {
                StandardProcessCategoryEntity uniqueBean = service.selectById(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
        }else {
            StandardProcessCategoryEntity standardProcessCategoryEntity = service.selectById(entity.getId());
            standardProcessCategoryEntity.setName(saveOrUpdateVO.getName());
            standardProcessCategoryEntity.setCode(saveOrUpdateVO.getCode());
            standardProcessCategoryEntity.setCodePlan(saveOrUpdateVO.getCodePlan());
            standardProcessCategoryEntity.setDescription(saveOrUpdateVO.getDescription());
            standardProcessCategoryEntity.setSequence(saveOrUpdateVO.getSequence());
            entity = standardProcessCategoryEntity;
        }
        service.saveOrUpdate(entity, false);
        StandardProcessCategoryVO vo = BeanMapper.map(service.selectById(entity.getId()), StandardProcessCategoryVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StandardProcessCategoryVO> queryDetail(Long id) {
    	StandardProcessCategoryEntity entity = service.selectById(id);
    	StandardProcessCategoryVO vo = BeanMapper.map(entity, StandardProcessCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {


        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                StandardProcessCategoryVO standardProcessCategoryVO = BeanMapper.map(service.selectById(id), StandardProcessCategoryVO.class);
                //分类下有物料了不允许删除
                List<StandardProcessEntity> standardProcessList = standardProcessService.queryListByCategoryId(id);
                if(standardProcessList != null && standardProcessList.size() > 0) {
                    return CommonResponse.error("分类【" + standardProcessCategoryVO.getName() + "】下有标准工序档案了，不允许删除");
                }
                //如果分类有子节点并且所有子节点也包含在删除项内，允许删除
                List<StandardProcessCategoryVO> children = service.queryListByPid(id);
                if(children != null && children.size() > 0) {
                    for (StandardProcessCategoryVO child : children) {
                        if(!ids.contains(child.getId())){
                            return CommonResponse.error("分类【" + standardProcessCategoryVO.getName() + "】下有子分类不允许删除");
                        }
                    }
                }
            }
        } else {
            return CommonResponse.error("删除失败：主键为空!");
        }
        service.removeByIds(ids);
        return CommonResponse.success("删除成功");

    }

    /**
     * 查询标准工序档案分类列表
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {

        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("sequence", "asc");
        List<StandardProcessCategoryEntity> dataList = service.queryProcessCategoryList(queryParam);

        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l-> {
            if(l.get("isLeaf").equals(false)){
                l.put("children", new ArrayList<>());
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));

        return CommonResponse.success(jsonObject);
    }

    /**
     * 查询待分页的列表
     *
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<StandardProcessCategoryEntity> pageData = service.queryPage(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success(jsonObject);
    }


    /**
     * 更新父节点状态，同时更新子节点状态
     *
     * @return
     */
    @RequestMapping(value = "/enabled/update", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateEnabled(@RequestBody StandardProcessCategoryVO standardProcessCategoryVO) {
        StandardProcessCategoryEntity condition = service.selectById(standardProcessCategoryVO.getId());
        service.updateEnabled(standardProcessCategoryVO.getEnabled(), condition.getInnerCode());
        return CommonResponse.success("更新成功");
    }


    /**
     * 更改分类启停用状态
     */
    @RequestMapping(value = "/changeCategoryEnableState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> changeCategoryEnableState(@RequestParam("id") Long id, @RequestParam("enabled") Integer enabled) {
        service.changeCategoryEnableState(id, enabled);
        return CommonResponse.success("操作成功！");
    }



    /**
     * 标准工序档案分类树（同物料档案分类一样）
     *
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryStandardProcessRefTree", method = RequestMethod.GET)
    @ResponseBody
    public List<StandardProcessCategoryEntity> queryStandardProcessRefTree(@RequestParam(required = false) String searchText) {
        List<StandardProcessCategoryEntity> dataList = null;
        long start = System.currentTimeMillis();
        try {
            Map<String,Object> params = new HashMap<>();
            if(StringUtils.isNotBlank(searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            dataList = service.queryListEntityTree(params);
            System.out.println("查询耗时:"+(System.currentTimeMillis()-start));
            if(dataList != null && dataList.size() > 0) {
                List<StandardProcessCategoryEntity> resultList = StandardProcessCategoryAsTree.createTreeData(dataList);
                System.out.println("总耗时："+(System.currentTimeMillis()-start));
                return resultList;
            }
        } catch (Exception e) {}
        return null;
    }












    /**
     * 查询标准工序档案分类树
     *
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/queryStandardProcessCategoryRefTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> queryStandardProcessCategoryRefTree(@RequestParam(required = false) String searchText) {
        try {
            QueryParam queryParam = new QueryParam();
            if(StringUtils.isNotBlank(searchText)) {
                queryParam.getParams().put("name", new Parameter(QueryParam.LIKE, searchText));
            }
            queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            queryParam.getOrderMap().put("sequence", "asc");
            List<StandardProcessCategoryEntity> dataList = service.queryList(queryParam, false);

            List<Map> resultMapList = new ArrayList<>();
            Map map = null;
            for(StandardProcessCategoryEntity entity: dataList) {
                map = new HashMap<>();
                map.put("id", entity.getId());
                map.put("key", entity.getId());
                map.put("code", entity.getCode());
                map.put("name", entity.getName());
                map.put("title", entity.getName());
                map.put("parentId", entity.getParentId());
                resultMapList.add(map);
            }
            List<Map<String, Object>> result =  ResultAsTree.createTreeData(resultMapList);
            return result;
        } catch (Exception e) {
            return null;
        }
    }










    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<StandardProcessCategoryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("StandardProcessCategory-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refStandardProcessCategoryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StandardProcessCategoryVO>> refStandardProcessCategoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<StandardProcessCategoryEntity> page = service.queryPage(param,false);
        IPage<StandardProcessCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StandardProcessCategoryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * 参照异步（懒加载）树----物资分类树
     *
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/lazyStandardProcessCategoryTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> lazyStandardProcessCategoryTree(@RequestParam(required=false) String condition,
                                                              @RequestParam(required=false) Long pid, @RequestParam(required = false) String searchText) {
        List<StandardProcessCategoryVO> dataList = null;
        try {
            Map<String,Object> params = new HashMap<>();
            if(StringUtils.isNotBlank(searchText)) {
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
                if(StringUtils.isNotBlank(condition)){
                    JSONObject con = JSONObject.parseObject(condition);
                    Object categoryIdObj = con.get("categoryId");
                    if (null != categoryIdObj) {
                        List<Long> asList = new ArrayList<>();
                        String categoryId = ((String) categoryIdObj);
                        if (categoryId.indexOf(",") > 0) {
                            String[] strings = categoryId.split(",");
                            for (String str : strings) {
                                asList.add(Long.valueOf(str));
                            }
                        } else {
                            asList.add(Long.valueOf(categoryId));
                        }
                        List<StandardProcessCategoryVO> categoryList = new ArrayList<>();
                        for(Long parentId : asList){
                            categoryList.addAll(service.queryListByPid(parentId));
                        }
                        asList = categoryList.stream().map(StandardProcessCategoryVO::getId).collect(Collectors.toList());
                        params.put("ids", asList);
                    }
                }
                List<StandardProcessCategoryEntity> standardProcessCategoryEntities = service.queryListEntityTree(params);
                if (CollectionUtils.isNotEmpty(standardProcessCategoryEntities) && standardProcessCategoryEntities.size() > 0){
                    dataList = BeanMapper.mapList(standardProcessCategoryEntities, StandardProcessCategoryVO.class);
                }

            }else{
                dataList = service.queryListByPid(pid);
                if(StringUtils.isNotBlank(condition)){
                    /** 处理condition */
                    JSONObject con = JSONObject.parseObject(condition);
                    Object categoryIdObj = con.get("categoryId");
                    if (null != categoryIdObj && pid == null) {
                        List<Long> asList = new ArrayList<>();
                        String categoryId = ((String) categoryIdObj);
                        if(categoryId.indexOf(",") > 0){
                            String[] strings = categoryId.split(",");
                            for(String str : strings){
                                asList.add(Long.valueOf(str));
                            }
                        }else{
                            asList.add(Long.valueOf(categoryId));
                        }
                        QueryParam queryParam = new QueryParam();
                        queryParam.getParams().put("id",new Parameter(QueryParam.IN, asList));
                        List<StandardProcessCategoryEntity> standardProcessCategoryEntities = service.queryList(queryParam);
                        if (CollectionUtils.isNotEmpty(standardProcessCategoryEntities) && standardProcessCategoryEntities.size() > 0){
                            dataList = BeanMapper.mapList(standardProcessCategoryEntities, StandardProcessCategoryVO.class);
                        }
                    }
                }
            }
            List<Map> map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData(map);
        } catch (Exception e) {
            return null;
        }
    }


}
