package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgNoAuthApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.consts.ProjectBusinessStatusEnum;
import com.ejianc.foundation.share.mapper.ProjectSetMapper;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectDesktopSubParentVO;
import com.ejianc.foundation.share.vo.ProjectDesktopSubVO;
import com.ejianc.foundation.share.vo.ProjectDesktopVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

@Service
@Transactional
public class ProjectSetServiceImpl extends BaseServiceImpl<ProjectSetMapper, ProjectSetPoolEntity> implements IProjectSetService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());



    @Autowired
    private ProjectSetMapper projectSetMapper;




    @Autowired
    private IOrgNoAuthApi iOrgNoAuthApi;

    @Autowired
    private IDefdocApi iDefdocApi;

    @Override
    public OrgVO generateProjectDepartment(ProjectSetPoolEntity projectSetVO, boolean jt) {
        if (projectSetVO.getOrgId() == null) {
            logger.error("保存项目信息失败，所属组织信息不存在。");
            return null;
        }
        OrgVO parentOrg = new OrgVO();
        parentOrg.setId(projectSetVO.getOrgId());
        CommonResponse<OrgVO> response = iOrgNoAuthApi.findOneByOrgVO(parentOrg);
        if (response.isSuccess()) {
            parentOrg = response.getData();
        } else {
            logger.error("保存项目信息失败，查询所属组织信息失败: " + response.getMsg());
            return null;
        }
        if (null == parentOrg) {
            logger.error("保存项目信息失败，所属组织信息不存在。");
            return null;
        }
        OrgVO projectDepartment = new OrgVO();
        projectDepartment.setCode(projectSetVO.getCode());
        response = iOrgNoAuthApi.findOneByOrgVO(projectDepartment);
        if (response.isSuccess() && response.getData() != null) {
            projectDepartment = response.getData();
            projectDepartment.setParentId(projectSetVO.getOrgId());
            projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
            projectDepartment.setName(projectSetVO.getName());
            projectDepartment.setShortName(projectSetVO.getShortName());
            projectDepartment.setProjectState(1);
        } else {
            if (jt) {//集团 再加上-EL查询一遍
                projectDepartment.setCode(projectSetVO.getCode() + "-EL");
                response = iOrgNoAuthApi.findOneByOrgVO(projectDepartment);
                if (response.isSuccess() && response.getData() != null) {
                    projectDepartment = response.getData();
                    projectDepartment.setParentId(projectSetVO.getOrgId());
                    projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
                    projectDepartment.setName(projectSetVO.getName());
                    projectDepartment.setShortName(projectSetVO.getShortName());
                    projectDepartment.setProjectState(1);
                } else {
                    projectDepartment.setId(IdWorker.getId());
                    projectDepartment.setParentId(projectSetVO.getOrgId());
                    projectDepartment.setTenantId(parentOrg.getTenantId());
                    projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
                    projectDepartment.setIsParent(false);
                    projectDepartment.setName(projectSetVO.getName());
                    projectDepartment.setShortName(projectSetVO.getShortName());
                    projectDepartment.setState(1);
                    //项目部类型
                    projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
                    projectDepartment.setProjectState(1);
                }
            } else {
                projectDepartment.setId(IdWorker.getId());
                projectDepartment.setParentId(projectSetVO.getOrgId());
                projectDepartment.setTenantId(parentOrg.getTenantId());
                projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
                projectDepartment.setIsParent(false);
                projectDepartment.setName(projectSetVO.getName());
                projectDepartment.setShortName(projectSetVO.getShortName());
                projectDepartment.setState(1);
                //项目部类型
                projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
                projectDepartment.setProjectState(1);
            }
        }

        return projectDepartment;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCount(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList) {
        ProjectDesktopVO projectDesktopVO = null;
        List<ProjectDesktopSubVO> projectDesktopSubVOS = baseMapper.countBusinessStatus(commonOrgIds, departmentIds, businessStatusList);

        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            projectDesktopVO = baseMapper.countProjectStatus(commonOrgIds, departmentIds, null);
            BigDecimal totalNum = projectDesktopVO.getTotalNum();
            BigDecimal otherNum = totalNum;
            HashMap<String, ProjectDesktopSubVO> map = new HashMap<>();

            for (ProjectDesktopSubVO t : projectDesktopSubVOS) {
                map.put(t.getBusinessStatus(), t);
                otherNum = ComputeUtil.safeSub(otherNum, t.getNum());
                t.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode(t.getBusinessStatus()));
            }
            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = map.get(businessStatus);
                if (projectDesktopSubVO == null) {
                    ProjectDesktopSubVO subVO = new ProjectDesktopSubVO();
                    subVO.setBusinessStatus(businessStatus);
                    subVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode(businessStatus));
                    subVO.setNum(BigDecimal.ZERO);
                    map.put(businessStatus, subVO);
                }
            }
            ProjectDesktopSubVO other = new ProjectDesktopSubVO();
            other.setBusinessStatus("99");
            other.setBusinessStatusName("其他");
            other.setNum(ComputeUtil.nullToZero(otherNum));
            map.put(other.getBusinessStatus(), other);


            projectDesktopVO.setDetail(new ArrayList<>(map.values()));
        }
        return projectDesktopVO;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCountParent(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList) {
        ProjectDesktopVO projectDesktopVO = null;
        List<ProjectDesktopSubParentVO> projectDesktopSubVOSParent = new ArrayList<>();
        List<ProjectDesktopSubVO> desktopSubVOS = new ArrayList<>();
        String thisYear = EJCDateUtil.getYear() + "";
        List<ProjectDesktopSubParentVO> projectDesktopSubVOS = baseMapper.countBusinessStatusParent(commonOrgIds, departmentIds);
        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            projectDesktopSubVOSParent = TreeNodeBUtil.buildTree(projectDesktopSubVOS);// 主子项目的返回数据
            projectDesktopVO = new ProjectDesktopVO();
            BigDecimal totalNum = new BigDecimal(projectDesktopSubVOSParent.size());//项目总数
            BigDecimal otherNum = totalNum;
            projectDesktopVO.setTotalNum(totalNum);
            Long buildNum = projectDesktopSubVOSParent.stream().filter(e -> null!=e.getProjectStatus()&&"1".equals(e.getProjectStatus())).count();//在建项目数
            projectDesktopVO.setBuildNum(new BigDecimal(buildNum));
            Long thisYearProjectNum = projectDesktopSubVOSParent.stream().filter(e -> null!=e.getProjectDate()&&thisYear.equals(e.getProjectDate().substring(0,4))).count();//今年新增项目数
            projectDesktopVO.setThisYearProjectNum(new BigDecimal(thisYearProjectNum));

            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = new ProjectDesktopSubVO();
                projectDesktopSubVO.setBusinessStatus(businessStatus);
                projectDesktopSubVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode(businessStatus));
                Long num = projectDesktopSubVOSParent.stream().filter(e -> null!=e.getBusinessStatus()&&businessStatus.equals(e.getBusinessStatus())).count();
                if(null!=num){
                    projectDesktopSubVO.setNum(new BigDecimal(num));
                    otherNum = ComputeUtil.safeSub(otherNum, new BigDecimal(num));
                }
                desktopSubVOS.add(projectDesktopSubVO);
            }
            ProjectDesktopSubVO other = new ProjectDesktopSubVO();
            other.setBusinessStatus("99");
            other.setBusinessStatusName("其他");
            other.setNum(ComputeUtil.nullToZero(otherNum));
            desktopSubVOS.add(other);
            projectDesktopVO.setDetail(desktopSubVOS);
        }
        return projectDesktopVO;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCountZzyj(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList) {
        ProjectDesktopVO projectDesktopVO = null;
        List<ProjectDesktopSubParentVO> projectDesktopSubVOSParent = new ArrayList<>();
        String thisYear = EJCDateUtil.getYear() + "";
        //在建项目数与新增项目数  需要根据父子项目过滤
        List<ProjectDesktopSubParentVO> projectDesktopSubVOS = baseMapper.countBusinessStatusParent(commonOrgIds, departmentIds);
        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            projectDesktopSubVOSParent = TreeNodeBUtil.buildTree(projectDesktopSubVOS);// 主子项目的返回数据
            projectDesktopVO = new ProjectDesktopVO();
            BigDecimal totalNum = new BigDecimal(projectDesktopSubVOSParent.size());//项目总数
            projectDesktopVO.setTotalNum(totalNum);
            Long buildNum = projectDesktopSubVOSParent.stream().filter(e -> null!=e.getProjectStatus()&&"1".equals(e.getProjectStatus())).count();//在建项目数
            projectDesktopVO.setBuildNum(new BigDecimal(buildNum));
            Long thisYearProjectNum = projectDesktopSubVOSParent.stream().filter(e -> null!=e.getProjectDate()&&thisYear.equals(e.getProjectDate().substring(0,4))).count();//今年新增项目数
            projectDesktopVO.setThisYearProjectNum(new BigDecimal(thisYearProjectNum));
        }

        List<ProjectDesktopSubVO> projectDesktopSubList = baseMapper.countBusinessStatus(commonOrgIds, departmentIds, businessStatusList);
        if (CollectionUtils.isNotEmpty(projectDesktopSubList)) {
            HashMap<String, ProjectDesktopSubVO> map = new HashMap<>();

            for (ProjectDesktopSubVO t : projectDesktopSubList) {
                map.put(t.getBusinessStatus(), t);
                t.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode(t.getBusinessStatus()));
            }
            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = map.get(businessStatus);
                if (projectDesktopSubVO == null) {
                    ProjectDesktopSubVO subVO = new ProjectDesktopSubVO();
                    subVO.setBusinessStatus(businessStatus);
                    subVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode(businessStatus));
                    subVO.setNum(BigDecimal.ZERO);
                    map.put(businessStatus, subVO);
                }
            }
            projectDesktopVO.setDetail(new ArrayList<>(map.values()));
        }
        return projectDesktopVO;
    }


    @Override
    public void deleteProjectById(List<Long> ids) {
        baseMapper.deleteProjectById(ids);
    }

    @Override
    public IPage<ProjectSetPoolEntity> queryMdmPage(QueryParam param) {
        Map<String, Object> condition = new HashMap<>();
        Parameter parameter = param.getParams().get("syncTime");
		if(parameter != null) {
			condition.put("syncTime", parameter.getValue());
		}
        condition.put("pageIndex",(param.getPageIndex()-1)*param.getPageSize());
        condition.put("pageSize",param.getPageSize());
        List<ProjectSetPoolEntity> poolEntities = projectSetMapper.queryMdmPage(condition);
        IPage<ProjectSetPoolEntity> page = new Page<>();
        page.setRecords(poolEntities);
        return page;
    }

    @Override
    public BigDecimal queryThisYearProjectNum(List<Long> commonOrgIds,List<Long> departmentIds,String thisYear) {
        return projectSetMapper.queryThisYearProjectNum(commonOrgIds,departmentIds,thisYear);
    }
}
