/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgNoAuthApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.consts.ProjectBusinessStatusEnum;
import com.ejianc.foundation.share.mapper.ProjectSetMapper;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectDesktopSubParentVO;
import com.ejianc.foundation.share.vo.ProjectDesktopSubVO;
import com.ejianc.foundation.share.vo.ProjectDesktopVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProjectSetServiceImpl
extends BaseServiceImpl<ProjectSetMapper, ProjectSetPoolEntity>
implements IProjectSetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProjectSetMapper projectSetMapper;
    @Autowired
    private IOrgNoAuthApi iOrgNoAuthApi;
    @Autowired
    private IDefdocApi iDefdocApi;

    @Override
    public OrgVO generateProjectDepartment(ProjectSetPoolEntity projectSetVO, boolean jt) {
        if (projectSetVO.getOrgId() == null) {
            this.logger.error("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
            return null;
        }
        OrgVO parentOrg = new OrgVO();
        parentOrg.setId(projectSetVO.getOrgId());
        CommonResponse response = this.iOrgNoAuthApi.findOneByOrgVO(parentOrg);
        if (!response.isSuccess()) {
            this.logger.error("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: " + response.getMsg());
            return null;
        }
        parentOrg = (OrgVO)response.getData();
        if (null == parentOrg) {
            this.logger.error("\u4fdd\u5b58\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
            return null;
        }
        OrgVO projectDepartment = new OrgVO();
        projectDepartment.setCode(projectSetVO.getCode());
        response = this.iOrgNoAuthApi.findOneByOrgVO(projectDepartment);
        if (response.isSuccess() && response.getData() != null) {
            projectDepartment = (OrgVO)response.getData();
            projectDepartment.setParentId(projectSetVO.getOrgId());
            projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
            projectDepartment.setName(projectSetVO.getName());
            projectDepartment.setShortName(projectSetVO.getShortName());
            projectDepartment.setProjectState(Integer.valueOf(1));
        } else if (jt) {
            projectDepartment.setCode(projectSetVO.getCode() + "-EL");
            response = this.iOrgNoAuthApi.findOneByOrgVO(projectDepartment);
            if (response.isSuccess() && response.getData() != null) {
                projectDepartment = (OrgVO)response.getData();
                projectDepartment.setParentId(projectSetVO.getOrgId());
                projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
                projectDepartment.setName(projectSetVO.getName());
                projectDepartment.setShortName(projectSetVO.getShortName());
                projectDepartment.setProjectState(Integer.valueOf(1));
            } else {
                projectDepartment.setId(Long.valueOf(IdWorker.getId()));
                projectDepartment.setParentId(projectSetVO.getOrgId());
                projectDepartment.setTenantId(parentOrg.getTenantId());
                projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
                projectDepartment.setIsParent(Boolean.valueOf(false));
                projectDepartment.setName(projectSetVO.getName());
                projectDepartment.setShortName(projectSetVO.getShortName());
                projectDepartment.setState(Integer.valueOf(1));
                projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
                projectDepartment.setProjectState(Integer.valueOf(1));
            }
        } else {
            projectDepartment.setId(Long.valueOf(IdWorker.getId()));
            projectDepartment.setParentId(projectSetVO.getOrgId());
            projectDepartment.setTenantId(parentOrg.getTenantId());
            projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
            projectDepartment.setIsParent(Boolean.valueOf(false));
            projectDepartment.setName(projectSetVO.getName());
            projectDepartment.setShortName(projectSetVO.getShortName());
            projectDepartment.setState(Integer.valueOf(1));
            projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
            projectDepartment.setProjectState(Integer.valueOf(1));
        }
        return projectDepartment;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCount(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList) {
        ProjectDesktopVO projectDesktopVO = null;
        List<ProjectDesktopSubVO> projectDesktopSubVOS = ((ProjectSetMapper)this.baseMapper).countBusinessStatus(commonOrgIds, departmentIds, businessStatusList);
        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            BigDecimal totalNum;
            projectDesktopVO = ((ProjectSetMapper)this.baseMapper).countProjectStatus(commonOrgIds, departmentIds, null);
            BigDecimal otherNum = totalNum = projectDesktopVO.getTotalNum();
            HashMap<String, ProjectDesktopSubVO> map = new HashMap<String, ProjectDesktopSubVO>();
            for (ProjectDesktopSubVO t : projectDesktopSubVOS) {
                map.put(t.getBusinessStatus(), t);
                otherNum = ComputeUtil.safeSub((BigDecimal)otherNum, (BigDecimal)t.getNum());
                t.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)t.getBusinessStatus()));
            }
            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = (ProjectDesktopSubVO)map.get(businessStatus);
                if (projectDesktopSubVO != null) continue;
                ProjectDesktopSubVO subVO = new ProjectDesktopSubVO();
                subVO.setBusinessStatus(businessStatus);
                subVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)businessStatus));
                subVO.setNum(BigDecimal.ZERO);
                map.put(businessStatus, subVO);
            }
            ProjectDesktopSubVO other = new ProjectDesktopSubVO();
            other.setBusinessStatus("99");
            other.setBusinessStatusName("\u5176\u4ed6");
            other.setNum(ComputeUtil.nullToZero((BigDecimal)otherNum));
            map.put(other.getBusinessStatus(), other);
            projectDesktopVO.setDetail(new ArrayList(map.values()));
        }
        return projectDesktopVO;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCountParent(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList) {
        ProjectDesktopVO projectDesktopVO = null;
        List projectDesktopSubVOSParent = new ArrayList();
        ArrayList<ProjectDesktopSubVO> desktopSubVOS = new ArrayList<ProjectDesktopSubVO>();
        String thisYear = EJCDateUtil.getYear() + "";
        List<ProjectDesktopSubParentVO> projectDesktopSubVOS = ((ProjectSetMapper)this.baseMapper).countBusinessStatusParent(commonOrgIds, departmentIds);
        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            BigDecimal totalNum;
            projectDesktopSubVOSParent = TreeNodeBUtil.buildTree(projectDesktopSubVOS);
            projectDesktopVO = new ProjectDesktopVO();
            BigDecimal otherNum = totalNum = new BigDecimal(projectDesktopSubVOSParent.size());
            projectDesktopVO.setTotalNum(totalNum);
            Long buildNum = projectDesktopSubVOSParent.stream().filter(e -> null != e.getProjectStatus() && "1".equals(e.getProjectStatus())).count();
            projectDesktopVO.setBuildNum(new BigDecimal(buildNum));
            Long thisYearProjectNum = projectDesktopSubVOSParent.stream().filter(e -> null != e.getProjectDate() && thisYear.equals(e.getProjectDate().substring(0, 4))).count();
            projectDesktopVO.setThisYearProjectNum(new BigDecimal(thisYearProjectNum));
            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = new ProjectDesktopSubVO();
                projectDesktopSubVO.setBusinessStatus(businessStatus);
                projectDesktopSubVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)businessStatus));
                Long num = projectDesktopSubVOSParent.stream().filter(e -> null != e.getBusinessStatus() && businessStatus.equals(e.getBusinessStatus())).count();
                if (null != num) {
                    projectDesktopSubVO.setNum(new BigDecimal(num));
                    otherNum = ComputeUtil.safeSub((BigDecimal)otherNum, (BigDecimal)new BigDecimal(num));
                }
                desktopSubVOS.add(projectDesktopSubVO);
            }
            ProjectDesktopSubVO other = new ProjectDesktopSubVO();
            other.setBusinessStatus("99");
            other.setBusinessStatusName("\u5176\u4ed6");
            other.setNum(ComputeUtil.nullToZero((BigDecimal)otherNum));
            desktopSubVOS.add(other);
            projectDesktopVO.setDetail(desktopSubVOS);
        }
        return projectDesktopVO;
    }

    @Override
    public ProjectDesktopVO queryProjectBusinessStatusCountZzyj(List<Long> commonOrgIds, List<Long> departmentIds, List<String> businessStatusList) {
        List<ProjectDesktopSubVO> projectDesktopSubList;
        ProjectDesktopVO projectDesktopVO = null;
        List projectDesktopSubVOSParent = new ArrayList();
        String thisYear = EJCDateUtil.getYear() + "";
        List<ProjectDesktopSubParentVO> projectDesktopSubVOS = ((ProjectSetMapper)this.baseMapper).countBusinessStatusParent(commonOrgIds, departmentIds);
        if (CollectionUtils.isNotEmpty(projectDesktopSubVOS)) {
            projectDesktopSubVOSParent = TreeNodeBUtil.buildTree(projectDesktopSubVOS);
            projectDesktopVO = new ProjectDesktopVO();
            BigDecimal totalNum = new BigDecimal(projectDesktopSubVOSParent.size());
            projectDesktopVO.setTotalNum(totalNum);
            Long buildNum = projectDesktopSubVOSParent.stream().filter(e -> null != e.getProjectStatus() && "1".equals(e.getProjectStatus())).count();
            projectDesktopVO.setBuildNum(new BigDecimal(buildNum));
            Long thisYearProjectNum = projectDesktopSubVOSParent.stream().filter(e -> null != e.getProjectDate() && thisYear.equals(e.getProjectDate().substring(0, 4))).count();
            projectDesktopVO.setThisYearProjectNum(new BigDecimal(thisYearProjectNum));
        }
        if (CollectionUtils.isNotEmpty(projectDesktopSubList = ((ProjectSetMapper)this.baseMapper).countBusinessStatus(commonOrgIds, departmentIds, businessStatusList))) {
            HashMap<String, ProjectDesktopSubVO> map = new HashMap<String, ProjectDesktopSubVO>();
            for (ProjectDesktopSubVO t : projectDesktopSubList) {
                map.put(t.getBusinessStatus(), t);
                t.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)t.getBusinessStatus()));
            }
            for (String businessStatus : businessStatusList) {
                ProjectDesktopSubVO projectDesktopSubVO = (ProjectDesktopSubVO)map.get(businessStatus);
                if (projectDesktopSubVO != null) continue;
                ProjectDesktopSubVO subVO = new ProjectDesktopSubVO();
                subVO.setBusinessStatus(businessStatus);
                subVO.setBusinessStatusName(ProjectBusinessStatusEnum.getNameByCode((String)businessStatus));
                subVO.setNum(BigDecimal.ZERO);
                map.put(businessStatus, subVO);
            }
            projectDesktopVO.setDetail(new ArrayList(map.values()));
        }
        return projectDesktopVO;
    }

    @Override
    public void deleteProjectById(List<Long> ids) {
        ((ProjectSetMapper)this.baseMapper).deleteProjectById(ids);
    }

    @Override
    public IPage<ProjectSetPoolEntity> queryMdmPage(QueryParam param) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        Parameter parameter = (Parameter)param.getParams().get("syncTime");
        if (parameter != null) {
            condition.put("syncTime", parameter.getValue());
        }
        condition.put("pageIndex", (param.getPageIndex() - 1) * param.getPageSize());
        condition.put("pageSize", param.getPageSize());
        List<ProjectSetPoolEntity> poolEntities = this.projectSetMapper.queryMdmPage(condition);
        Page page = new Page();
        page.setRecords(poolEntities);
        return page;
    }

    @Override
    public BigDecimal queryThisYearProjectNum(List<Long> commonOrgIds, List<Long> departmentIds, String thisYear) {
        return this.projectSetMapper.queryThisYearProjectNum(commonOrgIds, departmentIds, thisYear);
    }
}

