package com.ejianc.foundation.customer.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.customer.bean.CustClassEntity;
import com.ejianc.foundation.customer.service.ICustClassService;
import com.ejianc.foundation.customer.vo.CustClassVO;

/**
 * 客户基本分类
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("custClass")
public class CustClassController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ICustClassService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CustClassVO> saveOrUpdate(@RequestBody CustClassVO custClassVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (custClassVO.getId() != null && custClassVO.getId() > 0) {
            CustClassEntity uniqueBean = service.queryDetail(custClassVO.getId());
            uniqueBean.setCode(custClassVO.getCode());
            uniqueBean.setName(custClassVO.getName());
            uniqueBean.setSequence(custClassVO.getSequence());
            uniqueBean.setMemo(custClassVO.getMemo());
            service.saveOrUpdate(uniqueBean, false);

            return CommonResponse.success("修改成功");
        } else {
            CustClassEntity custClassEntity = BeanMapper.map(custClassVO, CustClassEntity.class);
            custClassEntity.setId(IdWorker.getId());
            if (custClassEntity.getParentId() != null && custClassEntity.getParentId() > 0) {
                CustClassEntity uniqueBean = service.queryDetail(custClassEntity.getParentId());
                custClassEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + custClassEntity.getId());
            } else {
                custClassEntity.setInnerCode(custClassEntity.getId().toString());
            }

            service.saveOrUpdate(custClassEntity, false);

            return CommonResponse.success("保存成功");
        }

    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CustClassVO> queryDetail(Long id) {
        CustClassEntity entity = service.selectById(id);
        CustClassVO vo = BeanMapper.map(entity, CustClassVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CustClassVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CustClassVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CustClassVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        param.getOrderMap().put("sequence", "asc");
        /** 模糊搜索*/
        param.getParams().put("name", new Parameter(QueryParam.LIKE, param.getSearchText()));

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        List<CustClassEntity> dataList = service.queryList(param, false);
        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", ResultAsTree.createTreeData(resultMapList));


        return CommonResponse.success(jsonObject);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CustClassEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CustClass-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCustClassData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String,Object>> refCustClassData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.setSearchText(searchText);

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("enablestate", new Parameter(QueryParam.EQ, 2));
        /** 租户隔离 */
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        List<CustClassEntity> custClassEntities = service.queryList(param, false);
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;

        for (CustClassEntity entity : custClassEntities) {
            String name = entity.getName();

            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", name);
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("innerCode", entity.getInnerCode());
            resultMapList.add(map);
        }

        return ResultAsTree.createTreeData(resultMapList);

    }
}
