package com.ejianc.foundation.share.service;

import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.vo.SupplierCategoryVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

public interface ISupplierCategoryService extends IBaseService<SupplierCategoryEntity> {

	/**
	 * 根据Id查询供方分类详情
	 * 
	 * @param id
	 * @return
	 */
	SupplierCategoryEntity queryDetail(Long id);

	/**
	 * 根据父Id查询子节点列表
	 * 
	 * @param id
	 * @return
	 */
	List<SupplierCategoryVO> queryListByPid(Long id);

	/**
	 * 根据主键删除数据
	 * 
	 * @param id
	 */
	void delete(Long id);

	/**
	 * 根据供方分类编号查询实体
	 * 
	 * @param code
	 * @return
	 */
	SupplierCategoryVO queryByCode(String code);

}
