/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.share.bean.SupplierCategoryEntity;
import com.ejianc.foundation.share.service.ISupplierCategoryService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierCategoryVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.api.IJuliApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/supplier/category/"})
public class SupplierCategoryController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    private static final String SUPPLIER_CATEGORY_BILL_CODE = "SUPPORT_SUPPLIER_CATEGORY";
    @Autowired
    private ISupplierCategoryService supplierCategoryService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value(value="${juli.bip.pkOrg:0001A11000000000NKRQ}")
    private String juliBipPkOrg;
    private static final String SYNC_SUPPLY_TYPE_URL = "nccloud/api/uapbd/supplierclassmanage/supplierclass/supplierclassquery";
    @Autowired
    private IJuliApi juliApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody SupplierCategoryVO supplierCategoryVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (supplierCategoryVo.getId() != null && supplierCategoryVo.getId() > 0L) {
            SupplierCategoryEntity uniqueBean = this.supplierCategoryService.queryDetail(supplierCategoryVo.getId());
            uniqueBean.setCode(supplierCategoryVo.getCode());
            uniqueBean.setName(supplierCategoryVo.getName());
            uniqueBean.setSequence(supplierCategoryVo.getSequence());
            uniqueBean.setDescription(supplierCategoryVo.getDescription());
            this.supplierCategoryService.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        BillCodeParam billCodeParam = BillCodeParam.build((String)SUPPLIER_CATEGORY_BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)supplierCategoryVo);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        supplierCategoryVo.setCode((String)billCode.getData());
        SupplierCategoryEntity supplierCategoryEntity = (SupplierCategoryEntity)((Object)BeanMapper.map((Object)supplierCategoryVo, SupplierCategoryEntity.class));
        supplierCategoryEntity.setId(IdWorker.getId());
        if (supplierCategoryEntity.getParentId() != null && supplierCategoryEntity.getParentId() > 0L) {
            SupplierCategoryEntity uniqueBean = this.supplierCategoryService.queryDetail(supplierCategoryEntity.getParentId());
            supplierCategoryEntity.setInnerCode(uniqueBean.getInnerCode() + "|" + supplierCategoryEntity.getId());
        } else {
            supplierCategoryEntity.setInnerCode(supplierCategoryEntity.getId().toString());
        }
        this.supplierCategoryService.saveOrUpdate((Object)supplierCategoryEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierCategoryVO> queryDetail(@RequestParam Long id) {
        SupplierCategoryEntity entity = this.supplierCategoryService.queryDetail(id);
        if (entity != null) {
            return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), SupplierCategoryVO.class));
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        List<SupplierCategoryVO> children = this.supplierCategoryService.queryListByPid(id);
        if (children != null && children.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u6709\u5b50\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        List<SupplierVO> supplierList = this.supplierService.queryListByCategoryId(id);
        if (supplierList != null && supplierList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u4e0b\u5df2\u6709\u4f9b\u65b9\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.supplierCategoryService.delete(id);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("sequence", "asc");
        List dataList = this.supplierCategoryService.queryList(queryParam, false);
        List resultMapList = BeanMapper.mapList((Iterable)dataList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/querySupplierRefTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> querySupplierRefTree(@RequestParam(required=false) String searchText) {
        try {
            QueryParam queryParam = new QueryParam();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                queryParam.getParams().put("name", new Parameter("like", (Object)searchText));
            }
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            queryParam.getOrderMap().put("sequence", "asc");
            List dataList = this.supplierCategoryService.queryList(queryParam, false);
            ArrayList resultMapList = new ArrayList();
            HashMap<String, Object> map = null;
            for (SupplierCategoryEntity entity : dataList) {
                map = new HashMap<String, Object>();
                map.put("id", entity.getId());
                map.put("key", entity.getId());
                map.put("name", entity.getName());
                map.put("title", entity.getName());
                map.put("parentId", entity.getParentId());
                resultMapList.add(map);
            }
            List result = ResultAsTree.createTreeData(resultMapList);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    @GetMapping(value={"syncSupplierCategory"})
    @ResponseBody
    public CommonResponse<String> syncSupplierCategory() {
        JSONObject param = new JSONObject();
        JSONObject postData = new JSONObject();
        JSONObject ufinterface = new JSONObject();
        ufinterface.put("sender", (Object)"pm");
        JSONObject data = new JSONObject();
        JSONArray pk_org = new JSONArray();
        pk_org.add((Object)this.juliBipPkOrg);
        data.put("pk_org", (Object)pk_org);
        ufinterface.put("data", (Object)data);
        postData.put("ufinterface", (Object)ufinterface);
        param.put("url", (Object)SYNC_SUPPLY_TYPE_URL);
        param.put("postData", (Object)postData.toJSONString());
        CommonResponse res = this.juliApi.getDataFromBip(param);
        this.logger.info("\u540c\u6b65\u4f9b\u5e94\u5546\u5206\u7c7b\uff1a\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\uff1a{}", new Object[]{SYNC_SUPPLY_TYPE_URL, postData.toJSONString(), JSONObject.toJSONString((Object)res.getData())});
        if (res.isSuccess()) {
            JSONObject supplierTypeResp = JSONObject.parseObject((String)((String)res.getData()));
            if (supplierTypeResp.getBoolean("success").booleanValue()) {
                JSONArray supplierTypeList = supplierTypeResp.getJSONArray("data");
                if (supplierTypeList != null && !supplierTypeList.isEmpty()) {
                    for (Object o : supplierTypeList) {
                        SupplierCategoryEntity supplierCategoryEntity;
                        JSONObject supplierObject = (JSONObject)o;
                        String pk = supplierObject.getString("pk_supplierclass");
                        QueryParam param1 = QueryParam.getInstance();
                        param1.getParams().put("sourceId", new Parameter("eq", (Object)pk));
                        List supplierCategoryList = this.supplierCategoryService.queryList(param1, false);
                        if (ListUtil.isEmpty((List)supplierCategoryList)) {
                            supplierCategoryEntity = new SupplierCategoryEntity();
                            Long id = IdWorker.getId();
                            supplierCategoryEntity.setId(id);
                            supplierCategoryEntity.setInnerCode(id.toString());
                            supplierCategoryEntity.setSourceId(pk);
                            supplierCategoryEntity.setDescription("bip\u6570\u636e\u540c\u6b65\u751f\u6210\uff01" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()));
                            supplierCategoryEntity.setTenantId(999999L);
                        } else {
                            supplierCategoryEntity = (SupplierCategoryEntity)((Object)supplierCategoryList.get(0));
                        }
                        supplierCategoryEntity.setCode(supplierObject.getString("code"));
                        supplierCategoryEntity.setName(supplierObject.getString("name"));
                        this.supplierCategoryService.saveOrUpdate((Object)supplierCategoryEntity);
                    }
                }
            } else {
                return CommonResponse.error((String)("\u540c\u6b65\u4f9b\u5e94\u5546\u5206\u7c7b\u5931\u8d25\uff01" + supplierTypeResp.getString("message")));
            }
        }
        return CommonResponse.success((String)"\u540c\u6b65\u4f9b\u5e94\u5546\u5206\u7c7b\u6210\u529f\uff01");
    }
}

