package com.ejianc.foundation.share.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.service.IStandardProcessCategoryService;
import com.ejianc.foundation.share.vo.StandardProcessCategoryVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.share.bean.StandardProcessEntity;
import com.ejianc.foundation.share.service.IStandardProcessService;
import com.ejianc.foundation.share.vo.StandardProcessVO;

/**
 * 标准工序档案表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("standardProcess")
public class StandardProcessController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "STANDARD_PROCESS";//此处需要根据实际修改

    @Autowired
    private IStandardProcessService service;
    @Autowired
    private IStandardProcessCategoryService standardProcessCategoryService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StandardProcessVO> saveOrUpdate(@RequestBody StandardProcessVO saveOrUpdateVO) {
        StandardProcessEntity entity = BeanMapper.map(saveOrUpdateVO, StandardProcessEntity.class);
        if(StringUtils.isNoneBlank(entity.getCode())){
            List<StandardProcessEntity> codeData = service.queryByCode(entity.getCode(), entity.getId());
            if(codeData!=null && codeData.size()>0){
                throw new BusinessException("分类编码已存在,请重新填写");
            }
        }
        if(entity.getId() == null || entity.getId() == 0){
            if (null == entity.getCode()){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        }else {
            StandardProcessEntity standardProcessEntity = service.selectById(entity.getId());
            standardProcessEntity.setName(saveOrUpdateVO.getName());
            standardProcessEntity.setCode(saveOrUpdateVO.getCode());
            standardProcessEntity.setPlanWorkHour(saveOrUpdateVO.getPlanWorkHour());
            standardProcessEntity.setProcessWorkHour(saveOrUpdateVO.getProcessWorkHour());
            standardProcessEntity.setMemo(saveOrUpdateVO.getMemo());
            entity = standardProcessEntity;
        }
        service.saveOrUpdate(entity, false);
        StandardProcessVO vo = BeanMapper.map(service.selectById(entity.getId()), StandardProcessVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StandardProcessVO> queryDetail(Long id) {
    	StandardProcessEntity entity = service.selectById(id);
    	StandardProcessVO vo = BeanMapper.map(entity, StandardProcessVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse<String> response = billTypeApi.checkQuote("EJCBT202404000016", id);
                if (!response.isSuccess()) {
                    return CommonResponse.error("删除失败：" + response.getMsg());
                }
            }
        } else {
            return CommonResponse.error("删除失败：主键为空!");
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }


    /**
     * 查询待分页的列表
     *
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<StandardProcessEntity> pageData = service.queryPage(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", pageData);
        return CommonResponse.success(jsonObject);

    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "material-import.xlsx", "物料导入模板");
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<StandardProcessVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<StandardProcessEntity> page = service.queryPage(param,false);
        IPage<StandardProcessVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), StandardProcessVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<StandardProcessEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("StandardProcess-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refStandardProcessData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StandardProcessVO>> refStandardProcessData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<StandardProcessEntity> page = service.queryPage(param,false);
        IPage<StandardProcessVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StandardProcessVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * 参照列表
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "refStandardProcessPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StandardProcessVO>> refStandardProcessPage(@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
                                                             @RequestParam(required = false) String relyCondition,
                                                             @RequestParam(required = false) String searchText,
                                                             @RequestParam(required = false) String condition,
                                                             @RequestParam(required = false) String searchObject
    ) {
        Map<String, Object> params = new HashMap<>();
        if (StringUtils.isNotBlank(relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            StandardProcessCategoryVO standardProcessCategoryVO = BeanMapper.map(standardProcessCategoryService.selectById(categoryId), StandardProcessCategoryVO.class);
            if (standardProcessCategoryVO != null) {
                params.put("innerCode", standardProcessCategoryVO.getInnerCode());
            }else{
                return CommonResponse.error("当前分类不存在档案！");
            }
        }

        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            if (search.get("categoryCode") != null) {
                params.put("categoryCode", search.get("categoryCode").toString());
            }
            if (search.get("categoryName") != null) {
                params.put("categoryName", search.get("categoryName").toString());
            }
            if (search.get("code") != null) {
                params.put("code", search.get("code").toString());
            }
            if (search.get("name") != null) {
                params.put("name", search.get("name").toString());
            }
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<StandardProcessVO> pageData = service.queryRefStandardProcessPage(params);
        pageData.setCurrent(pageNumber);
        pageData.setSize(pageSize);

        return CommonResponse.success("查询成功！", pageData);
    }


    /**
     * 更改 启停用状态
     */
    @RequestMapping(value = "/changeStandardProcessEnableState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> changeStandardProcessEnableState(@RequestParam("id") Long id, @RequestParam("enabled") Integer enabled) {
        StandardProcessEntity entity = service.selectById(id);
        if (entity == null) {
            return CommonResponse.error("单据不存在！");
        }
        entity.setEnabled(enabled);
        service.saveOrUpdate(entity);
        return CommonResponse.success("操作成功！");
    }
}
