package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.CustomerCategoryEntity;
import com.ejianc.foundation.share.mapper.CustomerCategoryMapper;
import com.ejianc.foundation.share.service.ICustomerCategoryService;
import com.ejianc.foundation.share.vo.CustomerCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CustomerCategoryServiceImpl extends BaseServiceImpl<CustomerCategoryMapper, CustomerCategoryEntity> implements ICustomerCategoryService {

	@Autowired
	private CustomerCategoryMapper customerCategoryMapper;
	
	@Override
	public CustomerCategoryEntity queryDetail(Long id) {
		CustomerCategoryEntity entity = customerCategoryMapper.selectById(id);
		return entity;
	}

	@Override
	public List<CustomerCategoryVO> queryListByPid(Long id) {
		QueryWrapper<CustomerCategoryEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("parent_id", id);
		List<CustomerCategoryEntity> entities = customerCategoryMapper.selectList(wrapper);
		if(entities != null) {
			return BeanMapper.mapList(entities, CustomerCategoryVO.class);
		}
		return null;
	}

	@Override
	public void delete(Long id) {
		customerCategoryMapper.deleteById(id);
	}

	@Override
	public CustomerCategoryVO queryByCode(String code) {
		QueryWrapper<CustomerCategoryEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("code", code);
		queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
		List<CustomerCategoryEntity> list = customerCategoryMapper.selectList(queryWrapper);
		if(list != null && list.size() > 0) {
			return BeanMapper.map(list.get(0), CustomerCategoryVO.class);
		}
		return null;
	}

}
