/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.StandardProcessEntity;
import com.ejianc.foundation.share.service.IStandardProcessCategoryService;
import com.ejianc.foundation.share.service.IStandardProcessService;
import com.ejianc.foundation.share.vo.StandardProcessCategoryVO;
import com.ejianc.foundation.share.vo.StandardProcessVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"standardProcess"})
public class StandardProcessController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "STANDARD_PROCESS";
    @Autowired
    private IStandardProcessService service;
    @Autowired
    private IStandardProcessCategoryService standardProcessCategoryService;
    @Autowired
    private SessionManager sessionManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StandardProcessVO> saveOrUpdate(@RequestBody StandardProcessVO saveOrUpdateVO) {
        List<StandardProcessEntity> codeData;
        StandardProcessEntity entity = (StandardProcessEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, StandardProcessEntity.class));
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entity.getCode()}) && (codeData = this.service.queryByCode(entity.getCode(), entity.getId())) != null && codeData.size() > 0) {
            throw new BusinessException("\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            if (null == entity.getCode()) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                entity.setCode((String)billCode.getData());
            }
        } else {
            StandardProcessEntity standardProcessEntity = (StandardProcessEntity)((Object)this.service.selectById(entity.getId()));
            standardProcessEntity.setName(saveOrUpdateVO.getName());
            standardProcessEntity.setCode(saveOrUpdateVO.getCode());
            standardProcessEntity.setPlanWorkHour(saveOrUpdateVO.getPlanWorkHour());
            standardProcessEntity.setProcessWorkHour(saveOrUpdateVO.getProcessWorkHour());
            standardProcessEntity.setMemo(saveOrUpdateVO.getMemo());
            entity = standardProcessEntity;
        }
        this.service.saveOrUpdate((Object)entity, false);
        StandardProcessVO vo = (StandardProcessVO)BeanMapper.map((Object)this.service.selectById(entity.getId()), StandardProcessVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StandardProcessVO> queryDetail(Long id) {
        StandardProcessEntity entity = (StandardProcessEntity)((Object)this.service.selectById(id));
        StandardProcessVO vo = (StandardProcessVO)BeanMapper.map((Object)((Object)entity), StandardProcessVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse response = this.billTypeApi.checkQuote("EJCBT202404000016", id);
                if (response.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + response.getMsg()));
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.service.queryPage(queryParam);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)pageData);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"material-import.xlsx", (String)"\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StandardProcessVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StandardProcessVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("StandardProcess-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refStandardProcessData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StandardProcessVO>> refStandardProcessData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StandardProcessVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"refStandardProcessPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StandardProcessVO>> refStandardProcessPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            StandardProcessCategoryVO standardProcessCategoryVO = (StandardProcessCategoryVO)BeanMapper.map((Object)this.standardProcessCategoryService.selectById(categoryId), StandardProcessCategoryVO.class);
            if (standardProcessCategoryVO != null) {
                params.put("innerCode", standardProcessCategoryVO.getInnerCode());
            } else {
                return CommonResponse.error((String)"\u5f53\u524d\u5206\u7c7b\u4e0d\u5b58\u5728\u6863\u6848\uff01");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            if (search.get((Object)"categoryCode") != null) {
                params.put("categoryCode", search.get((Object)"categoryCode").toString());
            }
            if (search.get((Object)"categoryName") != null) {
                params.put("categoryName", search.get((Object)"categoryName").toString());
            }
            if (search.get((Object)"code") != null) {
                params.put("code", search.get((Object)"code").toString());
            }
            if (search.get((Object)"name") != null) {
                params.put("name", search.get((Object)"name").toString());
            }
        }
        params.put("pageIndex", pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        params.put("pageSize", pageSize);
        params.put("searchText", searchText);
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        IPage<StandardProcessVO> pageData = this.service.queryRefStandardProcessPage(params);
        pageData.setCurrent((long)pageNumber);
        pageData.setSize((long)pageSize);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pageData);
    }

    @RequestMapping(value={"/changeStandardProcessEnableState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> changeStandardProcessEnableState(@RequestParam(value="id") Long id, @RequestParam(value="enabled") Integer enabled) {
        StandardProcessEntity entity = (StandardProcessEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01");
        }
        entity.setEnabled(enabled);
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

