package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.CooperateEntity;
import com.ejianc.foundation.share.mapper.CooperateMapper;
import com.ejianc.foundation.share.service.ICooperateService;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.util.BillShareHelper;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/api/shareCooperateApi/")
public class CooperateApi {

    @Autowired
    private ICooperateService service;

    @Autowired
    private CooperateMapper cooperateMapper;

    @Autowired
    private BillShareHelper billShareHelper;



    /**
     * 根据模块id 查询 协同设置列表
     *
     * @param moduleId
     * @return List<CooperateVO>
     */
    @GetMapping("queryCooperateListByModuleId")
    public CommonResponse<List<CooperateVO>> queryCooperateListByModuleId(@RequestParam(value = "moduleId") Long moduleId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("moduleId",new Parameter(QueryParam.EQ, moduleId));
        List<CooperateEntity> cooperateEntities = service.queryList(queryParam);
        List<CooperateVO> cooperateVos = BeanMapper.mapList(cooperateEntities, CooperateVO.class);
        return CommonResponse.success("查询成功！", cooperateVos);
    }
    /**
     * 根据模块单据编号 查询 协同设置
     *
     * @param billTypeCode
     * @return CooperateVO
     */

    @GetMapping("queryCooperateBybillTypeCode")
    public CommonResponse<CooperateVO> queryCooperateBybillTypeCode(@RequestParam(value = "billTypeCode") String billTypeCode){
        QueryWrapper<CooperateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("bill_type_code",billTypeCode);
        CooperateEntity cooperateEntity = cooperateMapper.selectOne(queryWrapper);
        CooperateVO vo = new CooperateVO();
        if (cooperateEntity!=null){
            vo = BeanMapper.map(cooperateEntity, CooperateVO.class);
        }
        return CommonResponse.success("查询成功！", vo);
    }

    /**
     * 获取单据分享连接
     *
     * @param billId  单据Id
     * @param supplierId 单据供应商Id
     * @param billTypeCode 单据类型编码
     * @param h5FrontUrl 单据供方详情h5页路由地址
     * @param wxFrontUrl 单据供方详情微信页路由地址
     * @return
     */
    @GetMapping(value = "getShareLink")
    public CommonResponse<JSONObject> getShareLink(@RequestParam(value = "billId") Long billId,
                                                   @RequestParam(value = "billTypeCode") String billTypeCode,
                                                   @RequestParam(value = "supplierId") String supplierId,
                                                   @RequestParam(value = "h5FrontUrl") String h5FrontUrl,
                                                   @RequestParam(value = "wxFrontUrl", required = false) String wxFrontUrl) {
        return billShareHelper.getBillShareLink(billId, billTypeCode, supplierId, h5FrontUrl, wxFrontUrl);
    }
}
