package com.ejianc.foundation.share.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.UnitEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.service.IUnitService;
import com.ejianc.foundation.share.vo.MaterialVO;
//import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankService;
//import com.ejianc.foundation.support.vo.DefdocDetailVO;
//import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 中核华泰消息拉取监听类
 */
@Component
public class ZhHtCommonListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private IUnitService unitService;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private IBankService bankService;

//    @Autowired
//    private IDefdocApi defdocApi;

    /**
     * 监听物料同步
     * @param message
     * @throws IOException
     */
    @JmsListener(destination="cnecht.zh.itemcode")
    public void receive_cnecht_zh_itemcode(String message){
        String msg= null;
        try {
            msg = URLDecoder.decode(message, "utf-8");
        } catch (UnsupportedEncodingException e) {
            throw new BusinessException(e.getMessage());
        }
        msg = msg.substring(12);   // outputValue={....} 去除字符串中的outputValue=
        logger.info("cnecht.zh.itemcode message: " + msg);
        JSONObject json = JSONObject.parseObject(msg);
        JSONArray array = json.getJSONArray("data");
        List<String> codes = array.stream().map(x->((JSONObject)x).getString("CODE")).collect(Collectors.toList());
        Map<String, MaterialVO> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(codes)){
            List<MaterialVO> list = materialService.queryMaterialListByCodes(codes, 999999L);
            if(CollectionUtils.isNotEmpty(list)){
                map = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x));
            }
        }

        List<String> categoryCodes = array.stream().map(x->((JSONObject)x).getString("CATEGORYCODE")).collect(Collectors.toList());
        Map<String, MaterialCategoryEntity> categoryMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(codes)){
            List<MaterialCategoryEntity> list = categoryService.queryCategoryListByCodes(categoryCodes, 999999L);
            if(CollectionUtils.isNotEmpty(list)){
                categoryMap = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x));
            }
        }

        List<String> unitNames = array.stream().map(x->((JSONObject)x).getString("DESC11")).distinct().collect(Collectors.toList());
        Map<String, UnitEntity> unitMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(unitNames)){
            QueryParam param = new QueryParam();
            param.getParams().put("unitName", new Parameter(QueryParam.IN, unitNames));
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, 999999L));
            List<UnitEntity> list = unitService.queryList(param);
            if(CollectionUtils.isNotEmpty(list)){
                unitMap = list.stream().collect(Collectors.toMap(x->x.getUnitName(), x->x));
            }
        }

        List<MaterialVO> saveList = new ArrayList<>();
        for(Object o : array){
            JSONObject obj = (JSONObject)o;
            String code = obj.getString("CODE");
            MaterialVO vo = new MaterialVO();
            vo.setCreateUserCode("adminzhht");
            vo.setCreateTime(new Date());
            vo.setTenantId(999999L);
            if(map.containsKey(code)){
                vo = map.get(code);
            }
            vo.setCode(code);// 编码
            vo.setName(obj.getString("NAME"));// 名称
            vo.setCategoryCode(obj.getString("CATEGORYCODE"));// 分类名称
            vo.setCategoryName(obj.getString("CATEGORYNAME"));// 分类名称
            if(categoryMap.containsKey(vo.getCategoryName())){
                MaterialCategoryEntity category = categoryMap.get(vo.getCategoryName());
                vo.setUnitId(category.getId());// 分类主键
                vo.setSubjectId(category.getSubjectId());// 成本科目主键
                vo.setSubjectName(category.getSubjectName());// 成本科目名称
                vo.setFinancialId(category.getFinancialId());// 财务科目主键
                vo.setFinancialName(category.getFinancialName());// 财务科目名称
            }
            vo.setUnitName(obj.getString("DESC11"));// 单位名称
            if(unitMap.containsKey(vo.getUnitName())){
                vo.setUnitId(unitMap.get(vo.getUnitName()).getId());// 单位主键
            }
            vo.setSpec(obj.getString("SPECS"));// 规格/型号
            vo.setDef1(obj.getString("MATERIAL"));// 材质
            vo.setDef4(obj.getString("STANDARD "));// 标准
            vo.setDef5(obj.getString("MATERIAL"));// 材质
//            vo.setDef6(obj.getString("FEATURECODE"));// 特征
            vo.setDef7(obj.getString("DESCLONG"));// 长描述
            vo.setDef8(obj.getString("DESCSHORT"));// 短描述
            vo.setDef9(obj.getString("DESC10"));// 单位编码
            vo.setDef10(obj.getString("DESC11"));// 单位名称
            vo.setEnabled("停用".equals(obj.getString("DESC20")) ? 2 : 1);
            vo.setSourceId(obj.getString("UUID"));// 来源主键
            vo.setSystemId("cnecht.zh.itemcode");// 来源系统主键
            saveList.add(vo);
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            materialService.insertBatch(saveList);
        }
    }

    /**
     * 监听物料分类同步
     * @param message
     * @throws IOException
     */
    @JmsListener(destination="cnecht.zh.itemtype")
    public void receive_cnecht_zh_itemtype(String message){
        String msg= null;
        try {
            msg = URLDecoder.decode(message, "utf-8");
        } catch (UnsupportedEncodingException e) {
            throw new BusinessException(e.getMessage());
        }
        msg = msg.substring(12);   // outputValue={....} 去除字符串中的outputValue=
        logger.info("cnecht.zh.itemtype message: " + msg);
        JSONObject json = JSONObject.parseObject(msg);
        JSONArray array = json.getJSONArray("data");
        List<MaterialCategoryEntity> list = categoryService.queryCategoryListByCodes(null);
        Map<String, MaterialCategoryEntity> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(list)){
            map = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x));
        }
        List<MaterialCategoryEntity> saveList = new ArrayList<>();
        for(Object o : array){
            JSONObject obj = (JSONObject)o;
            String code = obj.getString("CODE");
            MaterialCategoryEntity vo = new MaterialCategoryEntity();
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode("adminzhht");
            vo.setCreateTime(new Date());
            vo.setTenantId(999999L);
            if(map.containsKey(code)){
                vo = map.get(code);
            }
            vo.setCode(code);// 编码
            // 父级编码临时存储到单位名称
            vo.setUnitName(obj.getString("PARENTCODE"));
            vo.setName(obj.getString("DESC1"));// 名称
            vo.setDescription(obj.getString("DESC2"));// 描述
            vo.setEnabled("停用".equals(obj.getString("DESC3")) ? 2 : 1);
            vo.setSourceId(obj.getString("UUID"));// 来源主键
            vo.setSystemId("cnecht.zh.itemtype");// 来源系统主键
            if(!"物资".equals(obj.getString("DESC4"))){
                continue;
            }
            saveList.add(vo);
        }
        // 处理树形结构
        list.addAll(saveList);
        map = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x));
        for(MaterialCategoryEntity vo : saveList){
            String parentCode = vo.getUnitName();
            if(map.containsKey(parentCode)){
                vo.setParentId(map.get(parentCode).getId());
                vo.setInnerCode(map.get(parentCode).getInnerCode() + "|" + vo.getId());
            } else {
                vo.setInnerCode(vo.getId().toString());
            }
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            categoryService.insertBatch(saveList);
        }
    }

    /**
     * 监听供应商同步
     * @param message
     * @throws IOException
     */
    @JmsListener(destination="cnecht.zh.supplier")
    public void receive_cnecht_zh_supplier(String message){
        String msg= null;
        try {
            msg = URLDecoder.decode(message, "utf-8");
        } catch (UnsupportedEncodingException e) {
            throw new BusinessException(e.getMessage());
        }
        msg = msg.substring(12);   // outputValue={....} 去除字符串中的outputValue=
        logger.info("cnecht.zh.supplier message: " + msg);
        JSONObject json = JSONObject.parseObject(msg);
        JSONArray content = json.getJSONArray("content");
        List<String> codes = content.stream().map(x->((JSONObject)x).getJSONObject("basic").getString("companyNum")).collect(Collectors.toList());
        Map<String, SupplierEntity> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(codes)){
            QueryParam param = new QueryParam();
            param.getParams().put("code", new Parameter(QueryParam.IN, codes));
            List<SupplierEntity> list = supplierService.queryList(param);
            if(CollectionUtils.isNotEmpty(list)){
                map = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x));
            }
        }

//        CommonResponse<List<DefdocDetailVO>> response = defdocApi.getDefDocByDefId(489892533129330724L);
//        Map<String, Long> defMap = new HashMap<>();
//        if(!response.isSuccess()) {
//            defMap = response.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getId));
//        } else {
//            logger.error(response.getMsg());
//        }

        List<SupplierEntity> saveList = new ArrayList<>();
        for(Object o : content){
            JSONObject obj = (JSONObject)o;
            JSONObject basic = obj.getJSONObject("basic");// 基本信息
            String code = basic.getString("companyNum");// 供应商编号
            SupplierEntity vo = new SupplierEntity();
            vo.setSourceId(basic.getString("companyId"));// 供应商来源主键
            vo.setBillState(1);// 默认已提交
            vo.setSupplierFlag(1);// 客商属性：1供应商，2客户，3客商
            vo.setBlacklistFlag(0);// 是否黑名单，0-否，1-是
            vo.setRedlistFlag(0);// 是否红名单，0-否，1-是
            vo.setInsideOrg(false);// 内外部客商 true：内部，false：外部
            vo.setCoordination(false);// 是否协同
            vo.setInException(false);// 是否异常
            vo.setSupplyQueryType("laborSub,materialEquipment,other");// 供应商分类
            vo.setSupplyType("major,labor,material,other");// 供方类别
            vo.setSupplyTypeName("专业供应商,劳务供应商,货物类供应商,其他供应商");// 供方类别名称
            vo.setPersonal("e");// 个人：p，企业：e
            vo.setApplyOrgId(1247777316689256450L);// 申请单位id
            vo.setApplyOrgName("中核华泰建设有限公司");// 申请单位
            vo.setEnabled(1);// 启用
            vo.setCreateUserCode("adminzhht");
            vo.setCreateTime(new Date());
            vo.setTenantId(999999L);
            if(map.containsKey(code)){
                vo = map.get(code);
            }
            vo.setCode(basic.getString("companyNum"));// 供应商编码
            vo.setName(basic.getString("companyName"));// 供应商名称
            vo.setSocialCreditCode(basic.getString("unifiedSocialCode"));// 统一社会信用代码
            vo.setLegal(basic.getString("legalRepName"));// 法人
            vo.setLegalPhone(basic.getString("organizationType"));// 法人电话
            vo.setAddress(basic.getString("addressDetail"));// 详细地址
            vo.setTaxPayerIdentifier(basic.getString("unifiedSocialCode"));// 纳税人识别号
            vo.setRegisterTime(basic.getDate("buildDate"));// 注册日期
            vo.setRegisteredCapital(basic.getBigDecimal("registeredCapital"));// 注册资金
            vo.setBusinessScope(basic.getString("businessScope"));// 经营范围
            vo.setInOrOut(!"境内".equals(basic.getString("domesticForeignRelation")) ? 2 : 1);// 国内外：1国内，2国外
            vo.setTaxpayerType(!"一般纳税人".equals(basic.getString("taxpayerType")) ? "smallScale" : "commonly");// 纳税人类型 commonly 一般纳税人 smallScale 小规模纳税
            vo.setRegisterCountryName(basic.getString("registeredCountryName"));// 注册国家名称
//            if(defMap.containsKey(vo.getRegisterCountryName())){
//                vo.setRegisterCountryId(defMap.get(vo.getRegisterCountryName()));
//            }
            vo.setArea(basic.getString("registeredRegionName"));// 地区

            JSONArray contacts = obj.getJSONArray("contacts");// 联系人信息
            if(CollectionUtils.isNotEmpty(contacts)){
                vo.setBusinessPerson(contacts.getJSONObject(0).getString("name"));// 业务代表
                vo.setBusinessPhone(contacts.getJSONObject(0).getString("mobilephone"));// 业务代表电话
            }

            JSONArray invoice = obj.getJSONArray("invoice");// 开票信息
            if(CollectionUtils.isNotEmpty(invoice)){
                vo.setBillingAddress(invoice.getJSONObject(0).getString("taxRegistrationAddress"));// 开票地址
                vo.setBillingPhone(invoice.getJSONObject(0).getString("taxRegistrationPhone"));// 开票电话
                vo.setBankAccountCode(invoice.getJSONObject(0).getString("bankAccountNum"));// 银行账号
                vo.setBankAccountName(invoice.getJSONObject(0).getString("depositBank"));// 开户银行
                BankEntity bank = this.getBankByName(vo.getBankAccountName());
                vo.setBankAccountId(bank.getId());
            }

            // 临时存储companyId
            vo.setUnitI8Code(basic.getString("companyId"));
//            vo.setSourceId(basic.getString("companyId"));// 供应商来源主键
            vo.setSystemId("cnecht.zh.supplier");// 来源系统主键
            saveList.add(vo);
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            supplierService.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
    }

    /**
     * 根据银行名称获取银行实体
     * @param bankName
     * @return
     */
    private BankEntity getBankByName(String bankName) {
        QueryParam param = new QueryParam();
        param.getParams().put("name", new Parameter(QueryParam.EQ, bankName));
        List<BankEntity> bankList = bankService.queryList(param);
        if(CollectionUtils.isNotEmpty(bankList)){
            return bankList.get(0);
        }
        return new BankEntity();
    }
}
