/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.config;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.SimpleJmsListenerContainerFactory;

@Configuration
public class ActiveMQConfig {
    @Value(value="${spring.activemq.broker-url}")
    private String brokerUrl;
    @Value(value="${spring.activemq.user}")
    private String user;
    @Value(value="${spring.activemq.password}")
    private String password;

    @Bean(value={"mqConnectionFactory"})
    public ConnectionFactory connectionFactory() {
        return new ActiveMQConnectionFactory(this.user, this.password, this.brokerUrl);
    }

    @Bean(value={"queueListener"})
    public JmsListenerContainerFactory<?> queueJmsListenerContainerFactory(@Qualifier(value="mqConnectionFactory") ConnectionFactory connectionFactory) {
        SimpleJmsListenerContainerFactory factory = new SimpleJmsListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setPubSubDomain(Boolean.valueOf(false));
        return factory;
    }

    @Bean(value={"topicListener"})
    public JmsListenerContainerFactory<?> topicJmsListenerContainerFactory(@Qualifier(value="mqConnectionFactory") ConnectionFactory connectionFactory) {
        SimpleJmsListenerContainerFactory factory = new SimpleJmsListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setPubSubDomain(Boolean.valueOf(true));
        return factory;
    }

    @Bean
    public JmsListenerContainerFactory<?> jmsListenerContainerFactory(@Qualifier(value="mqConnectionFactory") ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        return factory;
    }
}

