/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.UnitEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.service.IUnitService;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

@Component
public class ZhHtCommonListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Long TENANT_ID = 999999L;
    private static final String USER_CODE = "adminzhht";
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IUnitService unitService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IBankService bankService;

    @JmsListener(destination="cnecht.zh.itemcode")
    public void receive_cnecht_zh_itemcode(String message) {
        List<MaterialCategoryEntity> list;
        List<MaterialVO> list2;
        String msg = this.transferMessage(message);
        msg = msg.substring(12);
        this.logger.info("cnecht.zh.itemcode message: " + msg);
        JSONObject json = JSONObject.parseObject((String)msg);
        JSONArray array = json.getJSONArray("data");
        List<String> codes = array.stream().map(x -> ((JSONObject)x).getString("CODE")).collect(Collectors.toList());
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(codes) && CollectionUtils.isNotEmpty(list2 = this.materialService.queryMaterialListByCodes(codes, TENANT_ID))) {
            map = list2.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
        }
        List<String> categoryCodes = array.stream().map(x -> ((JSONObject)x).getString("CATEGORYCODE")).collect(Collectors.toList());
        Map<Object, Object> categoryMap = new HashMap();
        if (CollectionUtils.isNotEmpty(codes) && CollectionUtils.isNotEmpty(list = this.categoryService.queryCategoryListByCodes(categoryCodes, TENANT_ID))) {
            categoryMap = list.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
        }
        List<String> unitNames = array.stream().map(x -> ((JSONObject)x).getString("DESC11")).distinct().collect(Collectors.toList());
        Map<String, UnitEntity> unitMap = new HashMap<String, UnitEntity>();
        if (CollectionUtils.isNotEmpty(unitNames)) {
            QueryParam param = new QueryParam();
            param.getParams().put("unitName", new Parameter("in", unitNames));
            param.getParams().put("tenantId", new Parameter("eq", (Object)TENANT_ID));
            List list3 = this.unitService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)list3)) {
                unitMap = list3.stream().collect(Collectors.toMap(x -> x.getUnitName(), x -> x));
            }
            this.saveUnit(unitNames, unitMap);
        }
        ArrayList<MaterialVO> saveList = new ArrayList<MaterialVO>();
        for (Object o : array) {
            JSONObject obj = (JSONObject)o;
            String code = obj.getString("CODE");
            MaterialVO vo = new MaterialVO();
            vo.setId(Long.valueOf(IdWorker.getId()));
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            if (map.containsKey(code)) {
                vo = (MaterialVO)map.get(code);
                vo.setUpdateUserCode(USER_CODE);
                vo.setUpdateTime(new Date());
            }
            vo.setCode(code);
            vo.setName(obj.getString("NAME"));
            vo.setCategoryCode(obj.getString("CATEGORYCODE"));
            vo.setCategoryName(obj.getString("CATEGORYNAME"));
            if (categoryMap.containsKey(vo.getCategoryName())) {
                MaterialCategoryEntity category = (MaterialCategoryEntity)categoryMap.get(vo.getCategoryName());
                vo.setCategoryId(category.getId());
                vo.setSubjectId(category.getSubjectId());
                vo.setSubjectName(category.getSubjectName());
                vo.setFinancialId(category.getFinancialId());
                vo.setFinancialName(category.getFinancialName());
            }
            vo.setUnitName(obj.getString("DESC11"));
            if (unitMap.containsKey(vo.getUnitName())) {
                vo.setUnitId(unitMap.get(vo.getUnitName()).getId());
            }
            vo.setSpec(obj.getString("SPECS"));
            vo.setDef1(obj.getString("MATERIAL"));
            vo.setDef4(obj.getString("STANDARD "));
            vo.setDef5(obj.getString("MATERIAL"));
            vo.setDef7(obj.getString("DESCLONG"));
            vo.setDef8(obj.getString("DESCSHORT"));
            vo.setDef9(obj.getString("DESC10"));
            vo.setDef10(obj.getString("DESC11"));
            vo.setEnabled(Integer.valueOf("\u505c\u7528".equals(obj.getString("DESC20")) ? 2 : 1));
            vo.setSourceId(obj.getString("UUID"));
            vo.setSystemId("cnecht.zh.itemcode");
            saveList.add(vo);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.materialService.insertBatch(saveList, TENANT_ID);
        }
        this.logger.info("\u76d1\u542c\u7269\u6599\u540c\u6b65\u6267\u884c\u6210\u529f-{}\u6761\uff01", (Object)saveList.size());
    }

    @JmsListener(destination="cnecht.zh.itemtype")
    public void receive_cnecht_zh_itemtype(String message) {
        String msg = this.transferMessage(message);
        msg = msg.substring(12);
        this.logger.info("cnecht.zh.itemtype message: " + msg);
        JSONObject json = JSONObject.parseObject((String)msg);
        JSONArray array = json.getJSONArray("data");
        List<MaterialCategoryEntity> list = this.categoryService.queryCategoryListByCodes(null);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(list)) {
            map = list.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
        }
        ArrayList<MaterialCategoryEntity> saveList = new ArrayList<MaterialCategoryEntity>();
        for (Object o : array) {
            JSONObject obj = (JSONObject)o;
            String code = obj.getString("CODE");
            MaterialCategoryEntity vo = new MaterialCategoryEntity();
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            if (map.containsKey(code)) {
                vo = (MaterialCategoryEntity)map.get(code);
                vo.setUpdateUserCode(USER_CODE);
                vo.setUpdateTime(new Date());
            }
            vo.setCode(code);
            vo.setUnitName(obj.getString("PARENTCODE"));
            vo.setName(obj.getString("DESC1"));
            vo.setDescription(obj.getString("DESC2"));
            vo.setEnabled("\u505c\u7528".equals(obj.getString("DESC3")) ? 2 : 1);
            vo.setSourceId(obj.getString("UUID"));
            vo.setSystemId("cnecht.zh.itemtype");
            if (!"\u7269\u8d44".equals(obj.getString("DESC4"))) continue;
            saveList.add(vo);
        }
        list.addAll(saveList);
        map = list.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
        for (MaterialCategoryEntity vo : saveList) {
            String parentCode = vo.getUnitName();
            if (map.containsKey(parentCode)) {
                vo.setParentId(((MaterialCategoryEntity)map.get(parentCode)).getId());
                vo.setInnerCode(((MaterialCategoryEntity)map.get(parentCode)).getInnerCode() + "|" + vo.getId());
                continue;
            }
            vo.setInnerCode(vo.getId().toString());
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.categoryService.insertBatch(saveList);
        }
        this.logger.info("\u76d1\u542c\u7269\u6599\u5206\u7c7b\u540c\u6b65\u6267\u884c\u6210\u529f-{}\u6761\uff01", (Object)saveList.size());
    }

    @JmsListener(destination="cnechc.zh.supplier")
    public void receive_cnecht_zh_supplier(String message) {
        String msg = this.transferMessage(message);
        this.logger.info("cnecht.zh.supplier message: " + msg);
        JSONArray content = JSONObject.parseArray((String)msg);
        List codes = content.stream().map(x -> ((JSONObject)x).getJSONObject("basic").getString("companyNum")).collect(Collectors.toList());
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(codes)) {
            QueryParam param = new QueryParam();
            param.getParams().put("code", new Parameter("in", codes));
            List list = this.supplierService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                map = list.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x, (v1, v2) -> v2));
            }
        }
        ArrayList<SupplierEntity> saveList = new ArrayList<SupplierEntity>();
        for (Object o : content) {
            JSONArray invoiceList;
            JSONObject obj = (JSONObject)o;
            JSONObject basic = obj.getJSONObject("basic");
            String code = basic.getString("companyNum");
            SupplierEntity vo = new SupplierEntity();
            vo.setSourceId(basic.getString("companyId"));
            vo.setBillState(1);
            vo.setSupplierFlag(1);
            vo.setBlacklistFlag(0);
            vo.setRedlistFlag(0);
            vo.setInsideOrg(false);
            vo.setCoordination(false);
            vo.setInException(false);
            vo.setSupplyQueryType("laborSub,materialEquipment,other");
            vo.setSupplyType("major,labor,material,other");
            vo.setSupplyTypeName("\u4e13\u4e1a\u4f9b\u5e94\u5546,\u52b3\u52a1\u4f9b\u5e94\u5546,\u8d27\u7269\u7c7b\u4f9b\u5e94\u5546,\u5176\u4ed6\u4f9b\u5e94\u5546");
            vo.setPersonal("e");
            vo.setApplyOrgId(1247777316689256450L);
            vo.setApplyOrgName("\u4e2d\u6838\u534e\u6cf0\u5efa\u8bbe\u6709\u9650\u516c\u53f8");
            vo.setEnabled(1);
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            if (map.containsKey(code)) {
                vo = (SupplierEntity)((Object)map.get(code));
                vo.setUpdateUserCode(USER_CODE);
                vo.setUpdateTime(new Date());
            }
            vo.setCode(basic.getString("companyNum"));
            vo.setName(basic.getString("companyName"));
            vo.setSocialCreditCode(basic.getString("unifiedSocialCode"));
            vo.setLegal(basic.getString("legalRepName"));
            vo.setLegalPhone(basic.getString("corporateTelephone"));
            vo.setAddress(basic.getString("addressDetail"));
            vo.setTaxPayerIdentifier(basic.getString("unifiedSocialCode"));
            vo.setRegisterTime(basic.getDate("buildDate"));
            vo.setRegisteredCapital(basic.getBigDecimal("registeredCapital"));
            vo.setBusinessScope(basic.getString("businessScope"));
            vo.setInOrOut(!"\u5883\u5185".equals(basic.getString("domesticForeignRelation")) ? 2 : 1);
            vo.setTaxpayerType(!"\u4e00\u822c\u7eb3\u7a0e\u4eba".equals(basic.getString("taxpayerType")) ? "smallScale" : "commonly");
            vo.setRegisterCountryName(basic.getString("registeredCountryName"));
            vo.setArea(basic.getString("registeredRegionName"));
            JSONArray contactsList = obj.getJSONArray("contactsList");
            if (CollectionUtils.isNotEmpty((Collection)contactsList)) {
                vo.setBusinessPerson(contactsList.getJSONObject(0).getString("name"));
                vo.setBusinessPhone(contactsList.getJSONObject(0).getString("mobilephone"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(invoiceList = obj.getJSONArray("invoiceList")))) {
                vo.setBillingAddress(invoiceList.getJSONObject(0).getString("taxRegistrationAddress"));
                vo.setBillingPhone(invoiceList.getJSONObject(0).getString("taxRegistrationPhone"));
                vo.setBankAccountCode(invoiceList.getJSONObject(0).getString("bankAccountNum"));
                vo.setBankAccountName(invoiceList.getJSONObject(0).getString("depositBank"));
                BankEntity bank = this.getBankByName(vo.getBankAccountName());
                vo.setBankAccountId(bank.getId());
            }
            vo.setUnitI8Code(basic.getString("companyId"));
            vo.setSystemId("cnecht.zh.supplier");
            saveList.add(vo);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.supplierService.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
        this.logger.info("\u76d1\u542c\u4f9b\u5e94\u5546\u540c\u6b65\u6267\u884c\u6210\u529f-{}\u6761\uff01", (Object)saveList.size());
    }

    private BankEntity getBankByName(String bankName) {
        QueryParam param = new QueryParam();
        param.getParams().put("name", new Parameter("eq", (Object)bankName));
        List bankList = this.bankService.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)bankList)) {
            return (BankEntity)((Object)bankList.get(0));
        }
        return new BankEntity();
    }

    private String transferMessage(String message) {
        message = message.replaceAll("%(![0-9a-fA-F]{2})", "%25");
        message = message.replaceAll("\\+", "%2B");
        String msg = null;
        try {
            msg = URLDecoder.decode(message, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BusinessException(e.getMessage());
        }
        return msg;
    }

    private void saveUnit(List<String> unitNames, Map<String, UnitEntity> unitMap) {
        unitNames.removeAll(unitMap.keySet());
        if (CollectionUtils.isEmpty(unitNames)) {
            return;
        }
        ArrayList<UnitEntity> saveList = new ArrayList<UnitEntity>();
        for (String name : unitNames) {
            UnitEntity vo = new UnitEntity();
            vo.setUnitName(name);
            vo.setUnitCode(name);
            vo.setEnabled(1);
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            saveList.add(vo);
        }
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        this.unitService.saveOrUpdateBatch(saveList);
        Map<String, UnitEntity> saveMap = saveList.stream().collect(Collectors.toMap(x -> x.getUnitName(), x -> x));
        unitMap.putAll(saveMap);
    }

    public static void main(String[] args) {
        String msg = "[{\"basic\":{\"companyId\":315813,\"companyNum\":\"G00242530\",\"domesticForeignRelation\":\"\u5883\u5185\",\"unifiedSocialCode\":\"91310120332784577T\",\"organizingInstitutionCode\":\"91310120332784577T\",\"businessLicenseNum\":\"26000000202402220213\",\"taxRegistrationNum\":\"91310120332784577T\",\"isThreeCertificatesInOne\":1,\"companyName\":\"\u4e0a\u6d77\u6e2f\u6f9c\u5b9e\u4e1a\u6709\u9650\u516c\u53f8\",\"shortName\":\"\u4e0a\u6d77\u6e2f\u6f9c\u5b9e\u4e1a\u6709\u9650\u516c\u53f8\",\"companyType\":\"\u6709\u9650\u8d23\u4efb\u516c\u53f8\",\"registeredCountryName\":\"\u4e2d\u56fd\",\"registeredRegionName\":\"\u5949\u8d24\u533a\",\"addressDetail\":\"\u4e0a\u6d77\u5e02\u5949\u8d24\u533a\u91d1\u6d77\u516c\u8def6055\u53f711\u5e625\u5c42\",\"taxpayerType\":\"\u4e00\u822c\u7eb3\u7a0e\u4eba\",\"buildDate\":\"2015-02-28 00:00:00\",\"registeredCapital\":800.000000,\"currencyName\":\"\u4eba\u6c11\u5e01\",\"businessScope\":\"\u8bb8\u53ef\u9879\u76ee\uff1a\u5efa\u8bbe\u5de5\u7a0b\u65bd\u5de5\u3002\uff08\u4f9d\u6cd5\u987b\u7ecf\u6279\u51c6\u7684\u9879\u76ee\uff0c\u7ecf\u76f8\u5173\u90e8\u95e8\u6279\u51c6\u540e\u65b9\u53ef\u5f00\u5c55\u7ecf\u8425\u6d3b\u52a8\uff0c\u5177\u4f53\u7ecf\u8425\u9879\u76ee\u4ee5\u76f8\u5173\u90e8\u95e8\u6279\u51c6\u6587\u4ef6\u6216\u8bb8\u53ef\u8bc1\u4ef6\u4e3a\u51c6\uff09\u4e00\u822c\u9879\u76ee\uff1a\u6280\u672f\u670d\u52a1\u3001\u6280\u672f\u5f00\u53d1\u3001\u6280\u672f\u54a8\u8be2\u3001\u6280\u672f\u4ea4\u6d41\u3001\u6280\u672f\u8f6c\u8ba9\u3001\u6280\u672f\u63a8\u5e7f\uff1b\u56ed\u6797\u7eff\u5316\u5de5\u7a0b\u65bd\u5de5\uff1b\u4fe1\u606f\u54a8\u8be2\u670d\u52a1\uff08\u4e0d\u542b\u8bb8\u53ef\u7c7b\u4fe1\u606f\u54a8\u8be2\u670d\u52a1\uff09\uff1b\u5e7f\u544a\u8bbe\u8ba1\u3001\u4ee3\u7406\uff1b\u5e7f\u544a\u5236\u4f5c\uff1b\u5e7f\u544a\u53d1\u5e03\uff1b\u673a\u68b0\u8bbe\u5907\u79df\u8d41\uff1b\u4f4f\u623f\u79df\u8d41\uff1b\u975e\u5c45\u4f4f\u623f\u5730\u4ea7\u79df\u8d41\uff1b\u6c34\u6ce5\u5236\u54c1\u9500\u552e\uff1b\u673a\u68b0\u8bbe\u5907\u9500\u552e\uff1b\u73af\u5883\u4fdd\u62a4\u4e13\u7528\u8bbe\u5907\u9500\u552e\uff1b\u7535\u6c14\u8bbe\u5907\u9500\u552e\uff1b\u7535\u5b50\u4ea7\u54c1\u9500\u552e\uff1b\u4eea\u5668\u4eea\u8868\u9500\u552e\uff1b\u7535\u7ebf\u3001\u7535\u7f06\u7ecf\u8425\uff1b\u5bb6\u7528\u7535\u5668\u96f6\u914d\u4ef6\u9500\u552e\uff1b\u6a61\u80f6\u5236\u54c1\u9500\u552e\uff1b\u4e94\u91d1\u4ea7\u54c1\u6279\u53d1\uff1b\u5efa\u7b51\u88c5\u9970\u6750\u6599\u9500\u552e\uff1b\u901a\u8baf\u8bbe\u5907\u9500\u552e\uff1b\u52b3\u52a8\u4fdd\u62a4\u7528\u54c1\u9500\u552e\uff1b\u5de5\u827a\u7f8e\u672f\u54c1\u53ca\u6536\u85cf\u54c1\u6279\u53d1\uff08\u8c61\u7259\u53ca\u5176\u5236\u54c1\u9664\u5916\uff09\uff1b\u5305\u88c5\u6750\u6599\u53ca\u5236\u54c1\u9500\u552e\uff1b\u5851\u6599\u5236\u54c1\u9500\u552e\uff1b\u6587\u5177\u7528\u54c1\u6279\u53d1\uff1b\u529e\u516c\u7528\u54c1\u9500\u552e\uff1b\u65e5\u7528\u767e\u8d27\u9500\u552e\uff1b\u9488\u7eba\u7ec7\u54c1\u9500\u552e\uff1b\u978b\u5e3d\u6279\u53d1\uff1b\u670d\u88c5\u670d\u9970\u6279\u53d1\uff1b\u98df\u7528\u519c\u4ea7\u54c1\u6279\u53d1\u3002\uff08\u9664\u4f9d\u6cd5\u987b\u7ecf\u6279\u51c6\u7684\u9879\u76ee\u5916\uff0c\u51ed\u8425\u4e1a\u6267\u7167\u4f9d\u6cd5\u81ea\u4e3b\u5f00\u5c55\u7ecf\u8425\u6d3b\u52a8\uff09\",\"longTermFlag\":1,\"licenceUrl\":\"https://www.cnncsrm.com/minio/hz-private-bucket/spfm-comp/0/022cf3a06f42434989507d91d0e5de1e@\u6e2f\u6f9c\u8425\u4e1a\u6267\u7167.pdf\",\"organizationType\":\"\u6cd5\u4eba\",\"legalRepName\":\"\u9648\u7f8e\u541b\",\"legalRepNumber\":\"33072119820103602X\",\"authorizedName\":\"\u9648\u7f8e\u541b\",\"authorizedNumber\":\"33072119820103602X\",\"unitNature\":\"\u4f01\u4e1a\",\"institutionType\":\"111\",\"corporateTelephone\":\"13621649895\",\"employeesNum\":10,\"isStateOwnedEnterprise\":0,\"isForeignEquity\":0,\"operationNature\":\"\u8d38\u6613\u5546\",\"majorIndustries\":\"729\",\"sysdataid\":\"316b02a218c243b8addefeb8513670ba\",\"sysid\":\"3e1d192180d14110913a9329712c2a10\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"},\"contactsList\":[{\"companyId\":315813,\"companyContactId\":242363,\"name\":\"\u9648\u7f8e\u541b\",\"mail\":\"madrin@163.com\",\"mobilephone\":\"13621649895\",\"idType\":\"\u8eab\u4efd\u8bc1\",\"idNum\":\"33072119820103602X\",\"defaultFlag\":1,\"sysdataid\":\"23bc22123c1c4bf3af1c9dc649050d2c\",\"sysid\":\"b51e6b0268a941d09fe8cc48f2f562c9\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"}],\"addressList\":[{\"companyId\":315813,\"companyAddressId\":218099,\"country\":\"\u4e2d\u56fd\",\"region\":\"\u5949\u8d24\u533a\",\"addressType\":\"register\",\"sysdataid\":\"35d43102488b48a29ae395cd5f7764e9\",\"sysid\":\"d63a20156e3b4778bb4a258a6bc0d011\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"}],\"bankList\":[{\"companyId\":315813,\"companyBankAccountId\":177559,\"bankBranchName\":\"\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8\u4e0a\u6d77\u5e02\u6d66\u6c5f\u652f\u884c\",\"bankAccountName\":\"\u4e0a\u6d77\u6e2f\u6f9c\u5b9e\u4e1a\u6709\u9650\u516c\u53f8\",\"bankAccountNum\":\"1001236219300069403\",\"masterFlag\":1,\"bankFirm\":\"102290023627\",\"sysdataid\":\"40febd66401242acadb2b56388eafbab\",\"sysid\":\"eb9f9637d99d4c1b9c30e883448bc8ab\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"}],\"financeList\":[{\"year\":\"2023\",\"revenue\":273.23,\"companyId\":315813,\"companyFinanceId\":102220,\"totalAssets\":190.85,\"totalLiabilities\":190.85,\"currentAssets\":190.85,\"currentLiabilities\":136.71,\"netProfit\":79.86,\"sysdataid\":\"d001dc07ef9c4c3382a84e8deb3527cb\",\"sysid\":\"7fe70fc2777c42bf9750e755fce12b74\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"},{\"year\":\"2021\",\"revenue\":113.20,\"companyId\":315813,\"companyFinanceId\":115045,\"totalAssets\":110.32,\"totalLiabilities\":110.32,\"currentAssets\":110.32,\"currentLiabilities\":17.14,\"netProfit\":46.78,\"sysdataid\":\"c8275eb369364100aeb3ddb6bc5418a8\",\"sysid\":\"db54015eb74a469e9e50d6fe110ee8c0\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"},{\"year\":\"2022\",\"revenue\":200.00,\"companyId\":315813,\"companyFinanceId\":115046,\"totalAssets\":112.05,\"totalLiabilities\":112.05,\"currentAssets\":112.05,\"currentLiabilities\":17.14,\"netProfit\":58.60,\"sysdataid\":\"5b77e80262e34e4eb4a617dde58545fe\",\"sysid\":\"38c93f14f3644acda14862582c255972\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"}],\"invoiceList\":[{\"companyInvoiceId\":210121,\"companyId\":315813,\"invoiceHeader\":\"\u4e0a\u6d77\u6e2f\u6f9c\u5b9e\u4e1a\u6709\u9650\u516c\u53f8\",\"taxRegistrationNumber\":\"91310120332784577T\",\"depositBank\":\"\u4e2d\u56fd\u5de5\u5546\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8\u4e0a\u6d77\u5e02\u6d66\u6c5f\u652f\u884c\",\"bankAccountNum\":\"1001236219300069403\",\"taxRegistrationAddress\":\"\u4e0a\u6d77\u5e02\u5949\u8d24\u533a\u91d1\u6d77\u516c\u8def6055\u53f711\u5e625\u5c42\",\"receiveMail\":\"madrin@163.com\",\"receivePhone\":\"13621649895\",\"sysdataid\":\"5d5ab8fb068f4640a6e180b4f7b27b31\",\"sysid\":\"3cc6d69033654a59a86c0132773c1cb0\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"}],\"qualificationList\":[],\"statusList\":[{\"companyId\":315813,\"status\":\"\u6ce8\u518c\",\"belongCompanyCode\":\"10000\",\"belongCompanyName\":\"\u4e2d\u56fd\u6838\u5de5\u4e1a\u96c6\u56e2\u6709\u9650\u516c\u53f8\",\"sysdataid\":\"4e9d173ed56d48b4948a254fff771faf\",\"sysid\":\"06d40999bf7f48b5bcf5a8749d26ed85\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"},{\"listId\":1882005,\"companyId\":315813,\"status\":\"\u5408\u683c\",\"belongCompanyCode\":\"99280563919161110119\",\"belongCompanyName\":\"\u4e2d\u56fd\u6838\u5de5\u4e1a\u4e8c\u4e09\u5efa\u8bbe\u6709\u9650\u516c\u53f8\",\"validityDateFrom\":\"2024-04-25 00:00:00\",\"validityDateTo\":\"2027-03-01 00:00:00\",\"evaluationScope\":\"\u4e09\u7c7b\uff1a\u6838\u80fd\uff1a\u5efa\u7b51\u6750\u6599\u3001\u7535\u6c14\u8bbe\u5907\u3001\u4eea\u5668\u4eea\u8868\u3001\u4e94\u91d1\u4ea7\u54c1\u3001\u5de5\u673a\u5177\u3001\u52b3\u52a8\u4fdd\u62a4\u7528\u54c1\u3001\u65e5\u7528\u767e\u8d27\u3001\u7535\u7f06\u3001\u7535\u7ebf\u3001\u901a\u8baf\u8bbe\u5907\u3001\u5305\u88c5\u6750\u6599\u53ca\u5236\u54c1\u3001\u529e\u516c\u7528\u54c1\u3001\u978b\u5e3d\u670d\u88c5\u3001\u9488\u7eba\u7ec7\u54c1\u3001\u98df\u7528\u519c\u4ea7\u54c1\u3001\u6587\u5177\u7528\u54c1\u3001\u6a61\u80f6\u5236\u54c1\u53ca\u7535\u5b50\u4ea7\u54c1\u7684\u9500\u552e\u3002\uff08\u9646\u4e30\u5f15\u5165\uff09\",\"sysdataid\":\"6e7967da92124f51a11c2f07b26c88a6\",\"sysid\":\"ae227a88753e4162ac38bd86eae364e0\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"}]}]";
        JSONArray content = JSONObject.parseArray((String)msg);
        List codes = content.stream().map(x -> ((JSONObject)x).getJSONObject("basic").getString("companyNum")).collect(Collectors.toList());
        ArrayList<SupplierEntity> saveList = new ArrayList<SupplierEntity>();
        for (Object o : content) {
            JSONArray invoice;
            JSONObject obj = (JSONObject)o;
            JSONObject basic = obj.getJSONObject("basic");
            String code = basic.getString("companyNum");
            SupplierEntity vo = new SupplierEntity();
            vo.setSourceId(basic.getString("companyId"));
            vo.setBillState(1);
            vo.setSupplierFlag(1);
            vo.setBlacklistFlag(0);
            vo.setRedlistFlag(0);
            vo.setInsideOrg(false);
            vo.setCoordination(false);
            vo.setInException(false);
            vo.setSupplyQueryType("laborSub,materialEquipment,other");
            vo.setSupplyType("major,labor,material,other");
            vo.setSupplyTypeName("\u4e13\u4e1a\u4f9b\u5e94\u5546,\u52b3\u52a1\u4f9b\u5e94\u5546,\u8d27\u7269\u7c7b\u4f9b\u5e94\u5546,\u5176\u4ed6\u4f9b\u5e94\u5546");
            vo.setPersonal("e");
            vo.setApplyOrgId(1247777316689256450L);
            vo.setApplyOrgName("\u4e2d\u6838\u534e\u6cf0\u5efa\u8bbe\u6709\u9650\u516c\u53f8");
            vo.setEnabled(1);
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            vo.setCode(basic.getString("companyNum"));
            vo.setName(basic.getString("companyName"));
            vo.setSocialCreditCode(basic.getString("unifiedSocialCode"));
            vo.setLegal(basic.getString("legalRepName"));
            vo.setLegalPhone(basic.getString("corporateTelephone"));
            vo.setAddress(basic.getString("addressDetail"));
            vo.setTaxPayerIdentifier(basic.getString("unifiedSocialCode"));
            vo.setRegisterTime(basic.getDate("buildDate"));
            vo.setRegisteredCapital(basic.getBigDecimal("registeredCapital"));
            vo.setBusinessScope(basic.getString("businessScope"));
            vo.setInOrOut(!"\u5883\u5185".equals(basic.getString("domesticForeignRelation")) ? 2 : 1);
            vo.setTaxpayerType(!"\u4e00\u822c\u7eb3\u7a0e\u4eba".equals(basic.getString("taxpayerType")) ? "smallScale" : "commonly");
            vo.setRegisterCountryName(basic.getString("registeredCountryName"));
            vo.setArea(basic.getString("registeredRegionName"));
            JSONArray contacts = obj.getJSONArray("contactsList");
            if (CollectionUtils.isNotEmpty((Collection)contacts)) {
                vo.setBusinessPerson(contacts.getJSONObject(0).getString("name"));
                vo.setBusinessPhone(contacts.getJSONObject(0).getString("mobilephone"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(invoice = obj.getJSONArray("invoiceList")))) {
                vo.setBillingAddress(invoice.getJSONObject(0).getString("taxRegistrationAddress"));
                vo.setBillingPhone(invoice.getJSONObject(0).getString("taxRegistrationPhone"));
                vo.setBankAccountCode(invoice.getJSONObject(0).getString("bankAccountNum"));
                vo.setBankAccountName(invoice.getJSONObject(0).getString("depositBank"));
            }
            vo.setUnitI8Code(basic.getString("companyId"));
            vo.setSystemId("cnecht.zh.supplier");
            saveList.add(vo);
        }
        System.out.println(JSONObject.toJSONString(saveList));
    }
}

