package com.ejianc.foundation.share.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.UnitEntity;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.service.IUnitService;
import com.ejianc.foundation.share.vo.MaterialVO;
//import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankService;
//import com.ejianc.foundation.support.vo.DefdocDetailVO;
//import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 中核华泰消息拉取监听类
 */
@Component
public class ZhHtCommonListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final static Long TENANT_ID = 999999L;
    private final static String USER_CODE = "adminzhht";

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private IUnitService unitService;

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private IBankService bankService;

//    @Autowired
//    private IDefdocApi defdocApi;

    /**
     * 监听物料同步
     * @param message
     * @throws IOException
     */
    @JmsListener(destination="cnecht.zh.itemcode")
    public void receive_cnecht_zh_itemcode(String message){
        String msg = this.transferMessage(message);
        msg = msg.substring(12);   // outputValue={....} 去除字符串中的outputValue=
        logger.info("cnecht.zh.itemcode message: " + msg);
        JSONObject json = JSONObject.parseObject(msg);
        JSONArray array = json.getJSONArray("data");
        List<String> codes = array.stream().map(x->((JSONObject)x).getString("CODE")).collect(Collectors.toList());
        Map<String, MaterialVO> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(codes)){
            List<MaterialVO> list = materialService.queryMaterialListByCodes(codes, TENANT_ID);
            if(CollectionUtils.isNotEmpty(list)){
                map = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x));
            }
        }

        List<String> categoryCodes = array.stream().map(x->((JSONObject)x).getString("CATEGORYCODE")).collect(Collectors.toList());
        Map<String, MaterialCategoryEntity> categoryMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(categoryCodes)){
            List<MaterialCategoryEntity> list = categoryService.queryCategoryListByCodes(categoryCodes, TENANT_ID);
            if(CollectionUtils.isNotEmpty(list)){
                categoryMap = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x));
            }
        }

        List<String> unitNames = array.stream().map(x->((JSONObject)x).getString("DESC11")).distinct().collect(Collectors.toList());
        Map<String, UnitEntity> unitMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(unitNames)){
            QueryParam param = new QueryParam();
            param.getParams().put("unitName", new Parameter(QueryParam.IN, unitNames));
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, TENANT_ID));
            List<UnitEntity> list = unitService.queryList(param);
            if(CollectionUtils.isNotEmpty(list)){
                unitMap = list.stream().collect(Collectors.toMap(x->x.getUnitName(), x->x));
            }
            // 如果单位档案没有则新增
            this.saveUnit(unitNames, unitMap);
        }

        List<MaterialVO> saveList = new ArrayList<>();
        for(Object o : array){
            JSONObject obj = (JSONObject)o;
            String code = obj.getString("CODE");
            MaterialVO vo = new MaterialVO();
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            if(map.containsKey(code)){
                vo = map.get(code);
                vo.setUpdateUserCode(USER_CODE);
                vo.setUpdateTime(new Date());
            }
            vo.setCode(code);// 编码
            vo.setName(obj.getString("NAME"));// 名称
            vo.setCategoryCode(obj.getString("CATEGORYCODE"));// 分类名称
            vo.setCategoryName(obj.getString("CATEGORYNAME"));// 分类名称
            if(categoryMap.containsKey(vo.getCategoryCode())){
                MaterialCategoryEntity category = categoryMap.get(vo.getCategoryCode());
                vo.setCategoryId(category.getId());// 分类主键
                vo.setSubjectId(category.getSubjectId());// 成本科目主键
                vo.setSubjectName(category.getSubjectName());// 成本科目名称
                vo.setFinancialId(category.getFinancialId());// 财务科目主键
                vo.setFinancialName(category.getFinancialName());// 财务科目名称
            }
            vo.setUnitName(obj.getString("DESC11"));// 单位名称
            if(unitMap.containsKey(vo.getUnitName())){
                vo.setUnitId(unitMap.get(vo.getUnitName()).getId());// 单位主键
            }
            vo.setSpec(obj.getString("SPECS"));// 规格/型号
            vo.setDef1(obj.getString("MATERIAL"));// 材质
            vo.setDef4(obj.getString("STANDARD "));// 标准
            vo.setDef5(obj.getString("MATERIAL"));// 材质
//            vo.setDef6(obj.getString("FEATURECODE"));// 特征
            vo.setDef7(obj.getString("DESCLONG"));// 长描述
            vo.setDef8(obj.getString("DESCSHORT"));// 短描述
            vo.setDef9(obj.getString("DESC10"));// 单位编码
            vo.setDef10(obj.getString("DESC11"));// 单位名称
            vo.setEnabled("停用".equals(obj.getString("DESC20")) ? 2 : 1);
            vo.setSourceId(obj.getString("UUID"));// 来源主键
            vo.setSystemId("cnecht.zh.itemcode");// 来源系统主键
            saveList.add(vo);
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            materialService.insertBatch(saveList, TENANT_ID);
        }
        logger.info("监听物料同步执行成功-{}条！", saveList.size());
    }

    /**
     * 监听物料分类同步
     * @param message
     * @throws IOException
     */
    @JmsListener(destination="cnecht.zh.itemtype")
    public void receive_cnecht_zh_itemtype(String message){
        String msg = this.transferMessage(message);
        msg = msg.substring(12);   // outputValue={....} 去除字符串中的outputValue=
        logger.info("cnecht.zh.itemtype message: " + msg);
        JSONObject json = JSONObject.parseObject(msg);
        JSONArray array = json.getJSONArray("data");
        List<MaterialCategoryEntity> list = categoryService.queryCategoryListByCodes(null);
        Map<String, MaterialCategoryEntity> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(list)){
            map = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x));
        }
        List<MaterialCategoryEntity> saveList = new ArrayList<>();
        for(Object o : array){
            JSONObject obj = (JSONObject)o;
            String code = obj.getString("CODE");
            MaterialCategoryEntity vo = new MaterialCategoryEntity();
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            if(map.containsKey(code)){
                vo = map.get(code);
                vo.setUpdateUserCode(USER_CODE);
                vo.setUpdateTime(new Date());
            }
            vo.setCode(code);// 编码
            // 父级编码临时存储到单位名称
            vo.setUnitName(obj.getString("PARENTCODE"));
            vo.setName(obj.getString("DESC1"));// 名称
            vo.setDescription(obj.getString("DESC2"));// 描述
            vo.setEnabled("停用".equals(obj.getString("DESC3")) ? 2 : 1);
            vo.setSourceId(obj.getString("UUID"));// 来源主键
            vo.setSystemId("cnecht.zh.itemtype");// 来源系统主键
            if(!"物资".equals(obj.getString("DESC4"))){
                continue;
            }
            saveList.add(vo);
        }
        // 处理树形结构
        list.addAll(saveList);
        map = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x));
        for(MaterialCategoryEntity vo : saveList){
            String parentCode = vo.getUnitName();
            if(map.containsKey(parentCode)){
                vo.setParentId(map.get(parentCode).getId());
                vo.setInnerCode(map.get(parentCode).getInnerCode() + "|" + vo.getId());
            } else {
                vo.setInnerCode(vo.getId().toString());
            }
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            categoryService.insertBatch(saveList);
        }
        logger.info("监听物料分类同步执行成功-{}条！", saveList.size());
    }

    /**
     * 监听供应商同步
     * @param message
     * @throws IOException
     */
    @JmsListener(destination="cnechc.zh.supplier")
    public void receive_cnecht_zh_supplier(String message){
        String msg = this.transferMessage(message);
//        msg = msg.substring(12);   // outputValue={....} 去除字符串中的outputValue=
        logger.info("cnecht.zh.supplier message: " + msg);
        JSONArray content = JSONObject.parseArray(msg);
        List<String> codes = content.stream().map(x->((JSONObject)x).getJSONObject("basic").getString("companyNum")).collect(Collectors.toList());
        Map<String, SupplierEntity> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(codes)){
            QueryParam param = new QueryParam();
            param.getParams().put("code", new Parameter(QueryParam.IN, codes));
            List<SupplierEntity> list = supplierService.queryList(param);
            if(CollectionUtils.isNotEmpty(list)){
                map = list.stream().collect(Collectors.toMap(x->x.getCode(), x->x, (v1, v2)->v2));
            }
        }

//        CommonResponse<List<DefdocDetailVO>> response = defdocApi.getDefDocByDefId(489892533129330724L);
//        Map<String, Long> defMap = new HashMap<>();
//        if(!response.isSuccess()) {
//            defMap = response.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getId));
//        } else {
//            logger.error(response.getMsg());
//        }

        List<SupplierEntity> saveList = new ArrayList<>();
        for(Object o : content){
            JSONObject obj = (JSONObject)o;
            JSONObject basic = obj.getJSONObject("basic");// 基本信息
            String code = basic.getString("companyNum");// 供应商编号
            SupplierEntity vo = new SupplierEntity();
            vo.setSourceId(basic.getString("companyId"));// 供应商来源主键
            vo.setBillState(1);// 默认已提交
            vo.setSupplierFlag(1);// 客商属性：1供应商，2客户，3客商
            vo.setBlacklistFlag(0);// 是否黑名单，0-否，1-是
            vo.setRedlistFlag(0);// 是否红名单，0-否，1-是
            vo.setInsideOrg(false);// 内外部客商 true：内部，false：外部
            vo.setCoordination(false);// 是否协同
            vo.setInException(false);// 是否异常
            vo.setSupplyQueryType("laborSub,materialEquipment,other");// 供应商分类
            vo.setSupplyType("major,labor,material,other");// 供方类别
            vo.setSupplyTypeName("专业供应商,劳务供应商,货物类供应商,其他供应商");// 供方类别名称
            vo.setPersonal("e");// 个人：p，企业：e
            vo.setApplyOrgId(1247777316689256450L);// 申请单位id
            vo.setApplyOrgName("中核华泰建设有限公司");// 申请单位
            vo.setEnabled(1);// 启用
            vo.setGradeId(918885557151469613L);// 默认B级
            vo.setGradeName("B");
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            if(map.containsKey(code)){
                vo = map.get(code);
                vo.setUpdateUserCode(USER_CODE);
                vo.setUpdateTime(new Date());
            }
            vo.setCode(basic.getString("companyNum"));// 供应商编码
            vo.setName(basic.getString("companyName"));// 供应商名称
            vo.setSocialCreditCode(basic.getString("unifiedSocialCode"));// 统一社会信用代码
            vo.setLegal(basic.getString("legalRepName"));// 法人
            vo.setLegalPhone(basic.getString("corporateTelephone"));// 法人电话
            vo.setAddress(basic.getString("addressDetail"));// 详细地址
            vo.setTaxPayerIdentifier(basic.getString("unifiedSocialCode"));// 纳税人识别号
            vo.setRegisterTime(basic.getDate("buildDate"));// 注册日期
            vo.setRegisteredCapital(basic.getBigDecimal("registeredCapital"));// 注册资金
            vo.setBusinessScope(basic.getString("businessScope"));// 经营范围
            vo.setInOrOut(!"境内".equals(basic.getString("domesticForeignRelation")) ? 2 : 1);// 国内外：1国内，2国外
            vo.setTaxpayerType(!"一般纳税人".equals(basic.getString("taxpayerType")) ? "smallScale" : "commonly");// 纳税人类型 commonly 一般纳税人 smallScale 小规模纳税
            vo.setRegisterCountryName(basic.getString("registeredCountryName"));// 注册国家名称
//            if(defMap.containsKey(vo.getRegisterCountryName())){
//                vo.setRegisterCountryId(defMap.get(vo.getRegisterCountryName()));
//            }
//            vo.setArea(basic.getString("registeredRegionName"));// 地区

            JSONArray contactsList = obj.getJSONArray("contactsList");// 联系人信息
            if(CollectionUtils.isNotEmpty(contactsList)){
                vo.setBusinessPerson(contactsList.getJSONObject(0).getString("name"));// 业务代表
                vo.setBusinessPhone(contactsList.getJSONObject(0).getString("mobilephone"));// 业务代表电话
            }

            JSONArray invoiceList = obj.getJSONArray("invoiceList");// 开票信息
            if(CollectionUtils.isNotEmpty(invoiceList)){
                vo.setBillingAddress(invoiceList.getJSONObject(0).getString("taxRegistrationAddress"));// 开票地址
                vo.setBillingPhone(invoiceList.getJSONObject(0).getString("taxRegistrationPhone"));// 开票电话
                vo.setBankAccountCode(invoiceList.getJSONObject(0).getString("bankAccountNum"));// 银行账号
                vo.setBankAccountName(invoiceList.getJSONObject(0).getString("depositBank"));// 开户银行
                BankEntity bank = this.getBankByName(vo.getBankAccountName());
                vo.setBankAccountId(bank.getId());
            }

            // 临时存储companyId
            vo.setUnitI8Code(basic.getString("companyId"));
//            vo.setSourceId(basic.getString("companyId"));// 供应商来源主键
            vo.setSystemId("cnecht.zh.supplier");// 来源系统主键
            saveList.add(vo);
        }
        if(CollectionUtils.isNotEmpty(saveList)){
            supplierService.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
        logger.info("监听供应商同步执行成功-{}条！", saveList.size());
    }

    /**
     * 根据银行名称获取银行实体
     * @param bankName
     * @return
     */
    private BankEntity getBankByName(String bankName) {
        QueryParam param = new QueryParam();
        param.getParams().put("name", new Parameter(QueryParam.EQ, bankName));
        List<BankEntity> bankList = bankService.queryList(param);
        if(CollectionUtils.isNotEmpty(bankList)){
            return bankList.get(0);
        }
        return new BankEntity();
    }

    /**
     * message转换
     * @param message
     * @return
     */
    private String transferMessage(String message) {
        message = message.replaceAll("%(![0-9a-fA-F]{2})", "%25");
        message = message.replaceAll("\\+", "%2B");
        String msg= null;
        try {
            msg = URLDecoder.decode(message, "utf-8");
        } catch (UnsupportedEncodingException e) {
            throw new BusinessException(e.getMessage());
        }
        return msg;
    }

    /**
     * 如果单位档案没有则新增
     * @param unitNames
     * @param unitMap
     */
    private void saveUnit(List<String> unitNames, Map<String, UnitEntity> unitMap) {
        // 没有的单位则新增
        unitNames.removeAll(unitMap.keySet());
        if(CollectionUtils.isEmpty(unitNames)){
            return;
        }
        List<UnitEntity> saveList = new ArrayList<>();
        for(String name : unitNames){
            UnitEntity vo = new UnitEntity();
            vo.setUnitName(name);
            vo.setUnitCode(name);
            vo.setEnabled(1);
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            saveList.add(vo);
        }
        if(CollectionUtils.isEmpty(saveList)){
            return;
        }
        unitService.saveOrUpdateBatch(saveList);
        Map<String, UnitEntity> saveMap = saveList.stream().collect(Collectors.toMap(x->x.getUnitName(), x->x));
        unitMap.putAll(saveMap);
    }

    public static void main(String[] args) {
        String msg = "[{\"basic\":{\"companyId\":315813,\"companyNum\":\"G00242530\",\"domesticForeignRelation\":\"境内\",\"unifiedSocialCode\":\"91310120332784577T\",\"organizingInstitutionCode\":\"91310120332784577T\",\"businessLicenseNum\":\"26000000202402220213\",\"taxRegistrationNum\":\"91310120332784577T\",\"isThreeCertificatesInOne\":1,\"companyName\":\"上海港澜实业有限公司\",\"shortName\":\"上海港澜实业有限公司\",\"companyType\":\"有限责任公司\",\"registeredCountryName\":\"中国\",\"registeredRegionName\":\"奉贤区\",\"addressDetail\":\"上海市奉贤区金海公路6055号11幢5层\",\"taxpayerType\":\"一般纳税人\",\"buildDate\":\"2015-02-28 00:00:00\",\"registeredCapital\":800.000000,\"currencyName\":\"人民币\",\"businessScope\":\"许可项目：建设工程施工。（依法须经批准的项目，经相关部门批准后方可开展经营活动，具体经营项目以相关部门批准文件或许可证件为准）一般项目：技术服务、技术开发、技术咨询、技术交流、技术转让、技术推广；园林绿化工程施工；信息咨询服务（不含许可类信息咨询服务）；广告设计、代理；广告制作；广告发布；机械设备租赁；住房租赁；非居住房地产租赁；水泥制品销售；机械设备销售；环境保护专用设备销售；电气设备销售；电子产品销售；仪器仪表销售；电线、电缆经营；家用电器零配件销售；橡胶制品销售；五金产品批发；建筑装饰材料销售；通讯设备销售；劳动保护用品销售；工艺美术品及收藏品批发（象牙及其制品除外）；包装材料及制品销售；塑料制品销售；文具用品批发；办公用品销售；日用百货销售；针纺织品销售；鞋帽批发；服装服饰批发；食用农产品批发。（除依法须经批准的项目外，凭营业执照依法自主开展经营活动）\",\"longTermFlag\":1,\"licenceUrl\":\"https://www.cnncsrm.com/minio/hz-private-bucket/spfm-comp/0/022cf3a06f42434989507d91d0e5de1e@港澜营业执照.pdf\",\"organizationType\":\"法人\",\"legalRepName\":\"陈美君\",\"legalRepNumber\":\"33072119820103602X\",\"authorizedName\":\"陈美君\",\"authorizedNumber\":\"33072119820103602X\",\"unitNature\":\"企业\",\"institutionType\":\"111\",\"corporateTelephone\":\"13621649895\",\"employeesNum\":10,\"isStateOwnedEnterprise\":0,\"isForeignEquity\":0,\"operationNature\":\"贸易商\",\"majorIndustries\":\"729\",\"sysdataid\":\"316b02a218c243b8addefeb8513670ba\",\"sysid\":\"3e1d192180d14110913a9329712c2a10\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"},\"contactsList\":[{\"companyId\":315813,\"companyContactId\":242363,\"name\":\"陈美君\",\"mail\":\"madrin@163.com\",\"mobilephone\":\"13621649895\",\"idType\":\"身份证\",\"idNum\":\"33072119820103602X\",\"defaultFlag\":1,\"sysdataid\":\"23bc22123c1c4bf3af1c9dc649050d2c\",\"sysid\":\"b51e6b0268a941d09fe8cc48f2f562c9\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"}],\"addressList\":[{\"companyId\":315813,\"companyAddressId\":218099,\"country\":\"中国\",\"region\":\"奉贤区\",\"addressType\":\"register\",\"sysdataid\":\"35d43102488b48a29ae395cd5f7764e9\",\"sysid\":\"d63a20156e3b4778bb4a258a6bc0d011\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"}],\"bankList\":[{\"companyId\":315813,\"companyBankAccountId\":177559,\"bankBranchName\":\"中国工商银行股份有限公司上海市浦江支行\",\"bankAccountName\":\"上海港澜实业有限公司\",\"bankAccountNum\":\"1001236219300069403\",\"masterFlag\":1,\"bankFirm\":\"102290023627\",\"sysdataid\":\"40febd66401242acadb2b56388eafbab\",\"sysid\":\"eb9f9637d99d4c1b9c30e883448bc8ab\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"}],\"financeList\":[{\"year\":\"2023\",\"revenue\":273.23,\"companyId\":315813,\"companyFinanceId\":102220,\"totalAssets\":190.85,\"totalLiabilities\":190.85,\"currentAssets\":190.85,\"currentLiabilities\":136.71,\"netProfit\":79.86,\"sysdataid\":\"d001dc07ef9c4c3382a84e8deb3527cb\",\"sysid\":\"7fe70fc2777c42bf9750e755fce12b74\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"},{\"year\":\"2021\",\"revenue\":113.20,\"companyId\":315813,\"companyFinanceId\":115045,\"totalAssets\":110.32,\"totalLiabilities\":110.32,\"currentAssets\":110.32,\"currentLiabilities\":17.14,\"netProfit\":46.78,\"sysdataid\":\"c8275eb369364100aeb3ddb6bc5418a8\",\"sysid\":\"db54015eb74a469e9e50d6fe110ee8c0\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"},{\"year\":\"2022\",\"revenue\":200.00,\"companyId\":315813,\"companyFinanceId\":115046,\"totalAssets\":112.05,\"totalLiabilities\":112.05,\"currentAssets\":112.05,\"currentLiabilities\":17.14,\"netProfit\":58.60,\"sysdataid\":\"5b77e80262e34e4eb4a617dde58545fe\",\"sysid\":\"38c93f14f3644acda14862582c255972\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"}],\"invoiceList\":[{\"companyInvoiceId\":210121,\"companyId\":315813,\"invoiceHeader\":\"上海港澜实业有限公司\",\"taxRegistrationNumber\":\"91310120332784577T\",\"depositBank\":\"中国工商银行股份有限公司上海市浦江支行\",\"bankAccountNum\":\"1001236219300069403\",\"taxRegistrationAddress\":\"上海市奉贤区金海公路6055号11幢5层\",\"receiveMail\":\"madrin@163.com\",\"receivePhone\":\"13621649895\",\"sysdataid\":\"5d5ab8fb068f4640a6e180b4f7b27b31\",\"sysid\":\"3cc6d69033654a59a86c0132773c1cb0\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"}],\"qualificationList\":[],\"statusList\":[{\"companyId\":315813,\"status\":\"注册\",\"belongCompanyCode\":\"10000\",\"belongCompanyName\":\"中国核工业集团有限公司\",\"sysdataid\":\"4e9d173ed56d48b4948a254fff771faf\",\"sysid\":\"06d40999bf7f48b5bcf5a8749d26ed85\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"},{\"listId\":1882005,\"companyId\":315813,\"status\":\"合格\",\"belongCompanyCode\":\"99280563919161110119\",\"belongCompanyName\":\"中国核工业二三建设有限公司\",\"validityDateFrom\":\"2024-04-25 00:00:00\",\"validityDateTo\":\"2027-03-01 00:00:00\",\"evaluationScope\":\"三类：核能：建筑材料、电气设备、仪器仪表、五金产品、工机具、劳动保护用品、日用百货、电缆、电线、通讯设备、包装材料及制品、办公用品、鞋帽服装、针纺织品、食用农产品、文具用品、橡胶制品及电子产品的销售。（陆丰引入）\",\"sysdataid\":\"6e7967da92124f51a11c2f07b26c88a6\",\"sysid\":\"ae227a88753e4162ac38bd86eae364e0\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-19 16:51:47\",\"modifytime\":\"2025-02-19 16:51:47\",\"sourceappcode\":\"srm\"}]}]";
        JSONArray content = JSONObject.parseArray(msg);
        List<String> codes = content.stream().map(x->((JSONObject)x).getJSONObject("basic").getString("companyNum")).collect(Collectors.toList());
        List<SupplierEntity> saveList = new ArrayList<>();
        for(Object o : content){
            JSONObject obj = (JSONObject)o;
            JSONObject basic = obj.getJSONObject("basic");// 基本信息
            String code = basic.getString("companyNum");// 供应商编号
            SupplierEntity vo = new SupplierEntity();
            vo.setSourceId(basic.getString("companyId"));// 供应商来源主键
            vo.setBillState(1);// 默认已提交
            vo.setSupplierFlag(1);// 客商属性：1供应商，2客户，3客商
            vo.setBlacklistFlag(0);// 是否黑名单，0-否，1-是
            vo.setRedlistFlag(0);// 是否红名单，0-否，1-是
            vo.setInsideOrg(false);// 内外部客商 true：内部，false：外部
            vo.setCoordination(false);// 是否协同
            vo.setInException(false);// 是否异常
            vo.setSupplyQueryType("laborSub,materialEquipment,other");// 供应商分类
            vo.setSupplyType("major,labor,material,other");// 供方类别
            vo.setSupplyTypeName("专业供应商,劳务供应商,货物类供应商,其他供应商");// 供方类别名称
            vo.setPersonal("e");// 个人：p，企业：e
            vo.setApplyOrgId(1247777316689256450L);// 申请单位id
            vo.setApplyOrgName("中核华泰建设有限公司");// 申请单位
            vo.setEnabled(1);// 启用
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            vo.setCode(basic.getString("companyNum"));// 供应商编码
            vo.setName(basic.getString("companyName"));// 供应商名称
            vo.setSocialCreditCode(basic.getString("unifiedSocialCode"));// 统一社会信用代码
            vo.setLegal(basic.getString("legalRepName"));// 法人
            vo.setLegalPhone(basic.getString("corporateTelephone"));// 法人电话
            vo.setAddress(basic.getString("addressDetail"));// 详细地址
            vo.setTaxPayerIdentifier(basic.getString("unifiedSocialCode"));// 纳税人识别号
            vo.setRegisterTime(basic.getDate("buildDate"));// 注册日期
            vo.setRegisteredCapital(basic.getBigDecimal("registeredCapital"));// 注册资金
            vo.setBusinessScope(basic.getString("businessScope"));// 经营范围
            vo.setInOrOut(!"境内".equals(basic.getString("domesticForeignRelation")) ? 2 : 1);// 国内外：1国内，2国外
            vo.setTaxpayerType(!"一般纳税人".equals(basic.getString("taxpayerType")) ? "smallScale" : "commonly");// 纳税人类型 commonly 一般纳税人 smallScale 小规模纳税
            vo.setRegisterCountryName(basic.getString("registeredCountryName"));// 注册国家名称
//            if(defMap.containsKey(vo.getRegisterCountryName())){
//                vo.setRegisterCountryId(defMap.get(vo.getRegisterCountryName()));
//            }
            vo.setArea(basic.getString("registeredRegionName"));// 地区

            JSONArray contacts = obj.getJSONArray("contactsList");// 联系人信息
            if(CollectionUtils.isNotEmpty(contacts)){
                vo.setBusinessPerson(contacts.getJSONObject(0).getString("name"));// 业务代表
                vo.setBusinessPhone(contacts.getJSONObject(0).getString("mobilephone"));// 业务代表电话
            }

            JSONArray invoice = obj.getJSONArray("invoiceList");// 开票信息
            if(CollectionUtils.isNotEmpty(invoice)){
                vo.setBillingAddress(invoice.getJSONObject(0).getString("taxRegistrationAddress"));// 开票地址
                vo.setBillingPhone(invoice.getJSONObject(0).getString("taxRegistrationPhone"));// 开票电话
                vo.setBankAccountCode(invoice.getJSONObject(0).getString("bankAccountNum"));// 银行账号
                vo.setBankAccountName(invoice.getJSONObject(0).getString("depositBank"));// 开户银行
//                BankEntity bank = this.getBankByName(vo.getBankAccountName());
//                vo.setBankAccountId(bank.getId());
            }

            // 临时存储companyId
            vo.setUnitI8Code(basic.getString("companyId"));
//            vo.setSourceId(basic.getString("companyId"));// 供应商来源主键
            vo.setSystemId("cnecht.zh.supplier");// 来源系统主键
            saveList.add(vo);
        }
        System.out.println(JSONObject.toJSONString(saveList));
    }
}
