/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BPMTaskInfoVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.controller.param.RequestParams;
import com.ejianc.foundation.share.controller.resp.InformationPortletContent;
import com.ejianc.foundation.share.controller.resp.InformationPortletData;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@Component
@WebService(serviceName="PortalService", targetNamespace="http://testpm.cni-ht.com/")
public class PortalHandler {
    @Autowired
    private IBpmApi bpmApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;

    public PortalHandler() {
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)this);
    }

    @WebMethod(operationName="Todo")
    public String todo(@WebParam(name="parameters") RequestParams wrapper) {
        String userId2 = wrapper.getUserId();
        String userCode1 = wrapper.getUserCode();
        Long userId = 1247777316689256450L;
        this.getUserContext(userId);
        InvocationInfoProxy.getTenantid();
        InformationPortletData data = new InformationPortletData();
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        queryParam.put("userId", "1247777316689256450");
        queryParam.put("pageIndex", 1);
        queryParam.put("pageSize", 10);
        CommonResponse approveList = this.bpmApi.queryWaitList(queryParam);
        if (!approveList.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5f85\u529e\u4fe1\u606f\u5931\u8d25!");
        }
        List records = (List)approveList.getData();
        ArrayList<InformationPortletContent> items = new ArrayList<InformationPortletContent>();
        for (BPMTaskInfoVO bpmTaskInfoVO : records) {
            InformationPortletContent item = new InformationPortletContent();
            item.setContentTitle(bpmTaskInfoVO.getProcInstTitle());
            try {
                XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
                item.setDateTime(cal);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            items.add(item);
        }
        data.setItems(items.toArray(new InformationPortletContent[0]));
        data.setTotal(items.size());
        return this.convertToXml(data);
    }

    private void getUserContext(Long userId) {
        JSONObject userContext = this.getToken(userId);
        StringBuilder authtoken = new StringBuilder();
        authtoken.append("userType=").append(userContext.get((Object)"userType")).append(";userCode=").append(userContext.get((Object)"userCode")).append(";orgId=").append(userContext.get((Object)"orgId")).append(";tenantid=").append(userContext.get((Object)"tenantid")).append(";token=").append(userContext.get((Object)"token")).append(";u_logints=").append(userContext.get((Object)"u_logints")).append(";u_usercode=").append(userContext.get((Object)"u_usercode")).append(";userId=").append(userContext.get((Object)"userId"));
        if (authtoken.length() > 0) {
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authtoken.toString());
        }
        if (null != userContext) {
            InvocationInfoProxy.setTenantid((Long)userContext.getLong("tenantid"));
            InvocationInfoProxy.setUserid((Long)userContext.getLong("userId"));
            InvocationInfoProxy.setUsercode((String)userContext.getString("userCode"));
            InvocationInfoProxy.setOrgId((Long)userContext.getLong("orgId"));
        }
    }

    private JSONObject getToken(Long userId) {
        if (null != this.baseHost) {
            String initContextUrl = this.baseHost + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
            if (null != InvocationInfoProxy.getUserid()) {
                initContextUrl = initContextUrl + "&userId=" + userId;
            }
            String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
            CommonResponse userContextResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
            try {
                if (userContextResponse.isSuccess()) {
                    return ((JSONObject)userContextResponse.getData()).getJSONObject("userContext");
                }
            }
            catch (Exception e) {
                this.logger.error("\u521d\u59cb\u5316\u5f02\u6b65\u4efb\u52a1\u4e0a\u4e0b\u6587\u5f02\u5e38\uff1a", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private String convertToXml(InformationPortletData data) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{InformationPortletData.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.schemaLocation", (Object)" ");
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)data, (Writer)sw);
            return sw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("XML\u751f\u6210\u5931\u8d25", e);
        }
    }

    private Map<String, String> parseParams(String paramStr) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (paramStr != null) {
            String[] pairs;
            for (String pair : pairs = paramStr.split("&")) {
                String[] kv = pair.split("=");
                if (kv.length != 2) continue;
                params.put(kv[0], kv[1]);
            }
        }
        return params;
    }
}

