/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.bean.UnitEntity;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.service.IMaterialCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.service.IUnitService;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;

public class ZhHtCommonListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Long TENANT_ID = 999999L;
    private static final String USER_CODE = "adminzhht";
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private MaterialCategoryMapper categoryMapper;
    @Autowired
    private IUnitService unitService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IBankService bankService;

    @JmsListener(destination="cnecht.zh.itemcode")
    public void receive_cnecht_zh_itemcode(String message) {
        List<MaterialCategoryEntity> list;
        List<MaterialVO> list2;
        String msg = ZhHtCommonListener.transferMessage(message);
        msg = msg.substring(12);
        this.logger.info("cnecht.zh.itemcode message: " + msg);
        JSONObject json = JSONObject.parseObject((String)msg);
        JSONArray array = json.getJSONArray("data");
        List<String> codes = array.stream().map(x -> ((JSONObject)x).getString("CODE")).collect(Collectors.toList());
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(codes) && CollectionUtils.isNotEmpty(list2 = this.materialService.queryMaterialListByCodes(codes, TENANT_ID))) {
            map = list2.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
        }
        List<String> categoryCodes = array.stream().map(x -> ((JSONObject)x).getString("CATEGORYCODE")).collect(Collectors.toList());
        Map<Object, Object> categoryMap = new HashMap();
        if (CollectionUtils.isNotEmpty(categoryCodes) && CollectionUtils.isNotEmpty(list = this.categoryService.queryCategoryListByCodes(categoryCodes, TENANT_ID))) {
            categoryMap = list.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
        }
        List<String> unitNames = array.stream().map(x -> ((JSONObject)x).getString("DESC11")).distinct().collect(Collectors.toList());
        Map<String, UnitEntity> unitMap = new HashMap<String, UnitEntity>();
        if (CollectionUtils.isNotEmpty(unitNames)) {
            QueryParam param = new QueryParam();
            param.getParams().put("unitName", new Parameter("in", unitNames));
            param.getParams().put("tenantId", new Parameter("eq", (Object)TENANT_ID));
            List list3 = this.unitService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)list3)) {
                unitMap = list3.stream().collect(Collectors.toMap(x -> x.getUnitName(), x -> x));
            }
            this.saveUnit(unitNames, unitMap);
        }
        ArrayList<MaterialVO> saveList = new ArrayList<MaterialVO>();
        ArrayList<MaterialVO> updateList = new ArrayList<MaterialVO>();
        for (Object o : array) {
            JSONObject obj = (JSONObject)o;
            String code = obj.getString("CODE");
            MaterialVO vo2 = new MaterialVO();
            vo2.setId(Long.valueOf(IdWorker.getId()));
            vo2.setCreateUserCode(USER_CODE);
            vo2.setCreateTime(new Date());
            vo2.setTenantId(TENANT_ID);
            if (map.containsKey(code)) {
                vo2 = (MaterialVO)map.get(code);
                vo2.setUpdateUserCode(USER_CODE);
                vo2.setUpdateTime(new Date());
            }
            vo2.setCode(code);
            vo2.setName(obj.getString("NAME"));
            vo2.setCategoryCode(obj.getString("CATEGORYCODE"));
            vo2.setCategoryName(obj.getString("CATEGORYNAME"));
            if (categoryMap.containsKey(vo2.getCategoryCode())) {
                MaterialCategoryEntity category = (MaterialCategoryEntity)categoryMap.get(vo2.getCategoryCode());
                vo2.setCategoryId(category.getId());
                vo2.setSubjectId(category.getSubjectId());
                vo2.setSubjectName(category.getSubjectName());
                vo2.setFinancialId(category.getFinancialId());
                vo2.setFinancialName(category.getFinancialName());
            }
            vo2.setUnitName(obj.getString("DESC11"));
            if (unitMap.containsKey(vo2.getUnitName())) {
                vo2.setUnitId(unitMap.get(vo2.getUnitName()).getId());
            }
            vo2.setSpec(obj.getString("SPECS"));
            vo2.setDef1(obj.getString("MATERIAL"));
            vo2.setDef4(obj.getString("STANDARD "));
            vo2.setDef5(obj.getString("MATERIAL"));
            vo2.setDef7(obj.getString("DESCLONG"));
            vo2.setDef8(obj.getString("DESCSHORT"));
            vo2.setDef9(obj.getString("DESC10"));
            vo2.setDef10(obj.getString("DESC11"));
            vo2.setEnabled(Integer.valueOf("\u505c\u7528".equals(obj.getString("DESC20")) ? 2 : 1));
            vo2.setSourceId(obj.getString("UUID"));
            vo2.setSystemId("cnecht.zh.itemcode");
            if (map.containsKey(code)) {
                updateList.add(vo2);
                continue;
            }
            saveList.add(vo2);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.materialService.insertBatch(saveList, TENANT_ID);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            updateList.forEach(vo -> this.materialService.update((MaterialVO)vo));
        }
        this.logger.info("\u76d1\u542c\u7269\u6599\u540c\u6b65\u6267\u884c\u6210\u529f-\u65b0\u589e{}\u6761\uff01", (Object)saveList.size());
        this.logger.info("\u76d1\u542c\u7269\u6599\u540c\u6b65\u6267\u884c\u6210\u529f-\u4fee\u6539{}\u6761\uff01", (Object)updateList.size());
    }

    @JmsListener(destination="cnecht.zh.itemtype")
    public void receive_cnecht_zh_itemtype(String message) {
        String msg = ZhHtCommonListener.transferMessage(message);
        msg = msg.substring(12);
        this.logger.info("cnecht.zh.itemtype message: " + msg);
        JSONObject json = JSONObject.parseObject((String)msg);
        JSONArray array = json.getJSONArray("data");
        List<MaterialCategoryEntity> list = this.categoryService.queryCategoryListByCodes(null, TENANT_ID);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(list)) {
            map = list.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
        }
        ArrayList<MaterialCategoryEntity> saveList = new ArrayList<MaterialCategoryEntity>();
        ArrayList<MaterialCategoryEntity> updateList = new ArrayList<MaterialCategoryEntity>();
        for (Object o : array) {
            JSONObject obj = (JSONObject)o;
            String code = obj.getString("CODE");
            MaterialCategoryEntity vo2 = new MaterialCategoryEntity();
            vo2.setId(IdWorker.getId());
            vo2.setCreateUserCode(USER_CODE);
            vo2.setCreateTime(new Date());
            vo2.setTenantId(TENANT_ID);
            if (map.containsKey(code)) {
                vo2 = (MaterialCategoryEntity)map.get(code);
                vo2.setUpdateUserCode(USER_CODE);
                vo2.setUpdateTime(new Date());
            }
            vo2.setCode(code);
            vo2.setUnitName(obj.getString("PARENTCODE"));
            vo2.setName(obj.getString("DESC1"));
            vo2.setDescription(obj.getString("DESC2"));
            vo2.setEnabled("\u505c\u7528".equals(obj.getString("DESC3")) ? 2 : 1);
            vo2.setSourceId(obj.getString("UUID"));
            vo2.setSystemId("cnecht.zh.itemtype");
            if (map.containsKey(code)) {
                updateList.add(vo2);
                continue;
            }
            saveList.add(vo2);
        }
        list.addAll(saveList);
        map = list.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x));
        for (MaterialCategoryEntity vo3 : saveList) {
            String parentCode = vo3.getUnitName();
            if (map.containsKey(parentCode)) {
                vo3.setParentId(((MaterialCategoryEntity)map.get(parentCode)).getId());
                vo3.setInnerCode(((MaterialCategoryEntity)map.get(parentCode)).getInnerCode() + "|" + vo3.getId());
                continue;
            }
            vo3.setInnerCode(vo3.getId().toString());
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.categoryService.insertBatch(saveList, TENANT_ID);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            updateList.forEach(vo -> this.categoryMapper.update((MaterialCategoryEntity)vo));
        }
        this.logger.info("\u76d1\u542c\u7269\u6599\u5206\u7c7b\u540c\u6b65\u6267\u884c\u6210\u529f-\u65b0\u589e{}\u6761\uff01", (Object)saveList.size());
        this.logger.info("\u76d1\u542c\u7269\u6599\u5206\u7c7b\u540c\u6b65\u6267\u884c\u6210\u529f-\u4fee\u6539{}\u6761\uff01", (Object)updateList.size());
    }

    @JmsListener(destination="cnechc.zh.supplier")
    public void receive_cnecht_zh_supplier(String message) {
        this.logger.info("cnecht.zh.supplier message: " + message);
        JSONArray content = JSONObject.parseArray((String)message);
        List codes = content.stream().map(x -> ((JSONObject)x).getJSONObject("basic").getString("companyNum")).collect(Collectors.toList());
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty(codes)) {
            QueryParam param = new QueryParam();
            param.getParams().put("code", new Parameter("in", codes));
            List list = this.supplierService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                map = list.stream().collect(Collectors.toMap(x -> x.getCode(), x -> x, (v1, v2) -> v2));
            }
        }
        ArrayList<SupplierEntity> saveList = new ArrayList<SupplierEntity>();
        for (Object o : content) {
            JSONArray invoiceList;
            JSONObject obj = (JSONObject)o;
            JSONObject basic = obj.getJSONObject("basic");
            String code = basic.getString("companyNum");
            SupplierEntity vo = new SupplierEntity();
            vo.setSourceId(basic.getString("companyId"));
            vo.setBillState(1);
            vo.setSupplierFlag(1);
            vo.setBlacklistFlag(0);
            vo.setRedlistFlag(0);
            vo.setInsideOrg(false);
            vo.setCoordination(false);
            vo.setInException(false);
            vo.setSupplyQueryType("laborSub,materialEquipment,other");
            vo.setSupplyType("major,labor,material,other");
            vo.setSupplyTypeName("\u4e13\u4e1a\u4f9b\u5e94\u5546,\u52b3\u52a1\u4f9b\u5e94\u5546,\u8d27\u7269\u7c7b\u4f9b\u5e94\u5546,\u5176\u4ed6\u4f9b\u5e94\u5546");
            vo.setPersonal("e");
            vo.setApplyOrgId(1247777316689256450L);
            vo.setApplyOrgName("\u4e2d\u6838\u534e\u6cf0\u5efa\u8bbe\u6709\u9650\u516c\u53f8");
            vo.setEnabled(1);
            vo.setGradeId(918885557151469613L);
            vo.setGradeName("B");
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            if (map.containsKey(code)) {
                vo = (SupplierEntity)((Object)map.get(code));
                vo.setUpdateUserCode(USER_CODE);
                vo.setUpdateTime(new Date());
            }
            vo.setCode(basic.getString("companyNum"));
            vo.setName(basic.getString("companyName"));
            vo.setSocialCreditCode(basic.getString("unifiedSocialCode"));
            vo.setLegal(basic.getString("legalRepName"));
            vo.setLegalPhone(basic.getString("corporateTelephone"));
            vo.setAddress(basic.getString("addressDetail"));
            vo.setTaxPayerIdentifier(basic.getString("unifiedSocialCode"));
            vo.setRegisterTime(basic.getDate("buildDate"));
            vo.setRegisteredCapital(basic.getBigDecimal("registeredCapital"));
            vo.setBusinessScope(basic.getString("businessScope"));
            vo.setInOrOut(!"\u5883\u5185".equals(basic.getString("domesticForeignRelation")) ? 2 : 1);
            vo.setTaxpayerType(!"\u4e00\u822c\u7eb3\u7a0e\u4eba".equals(basic.getString("taxpayerType")) ? "smallScale" : "commonly");
            vo.setRegisterCountryName(basic.getString("registeredCountryName"));
            JSONArray contactsList = obj.getJSONArray("contactsList");
            if (CollectionUtils.isNotEmpty((Collection)contactsList)) {
                vo.setBusinessPerson(contactsList.getJSONObject(0).getString("name"));
                vo.setBusinessPhone(contactsList.getJSONObject(0).getString("mobilephone"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(invoiceList = obj.getJSONArray("invoiceList")))) {
                vo.setBillingAddress(invoiceList.getJSONObject(0).getString("taxRegistrationAddress"));
                vo.setBillingPhone(invoiceList.getJSONObject(0).getString("taxRegistrationPhone"));
                vo.setBankAccountCode(invoiceList.getJSONObject(0).getString("bankAccountNum"));
                vo.setBankAccountName(invoiceList.getJSONObject(0).getString("depositBank"));
                BankEntity bank = this.getBankByName(vo.getBankAccountName());
                vo.setBankAccountId(bank.getId());
            }
            vo.setUnitI8Code(basic.getString("companyId"));
            vo.setSystemId("cnecht.zh.supplier");
            saveList.add(vo);
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.supplierService.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
        this.logger.info("\u76d1\u542c\u4f9b\u5e94\u5546\u540c\u6b65\u6267\u884c\u6210\u529f-{}\u6761\uff01", (Object)saveList.size());
    }

    private BankEntity getBankByName(String bankName) {
        QueryParam param = new QueryParam();
        param.getParams().put("name", new Parameter("eq", (Object)bankName));
        List bankList = this.bankService.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)bankList)) {
            return (BankEntity)((Object)bankList.get(0));
        }
        return new BankEntity();
    }

    public static String transferMessage(String message) {
        message = message.replaceAll("%(![0-9a-fA-F]{2})", "%25");
        message = message.replaceAll("\\+", "%2B");
        String msg = null;
        try {
            msg = URLDecoder.decode(message, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BusinessException(e.getMessage());
        }
        return msg;
    }

    private void saveUnit(List<String> unitNames, Map<String, UnitEntity> unitMap) {
        unitNames.removeAll(unitMap.keySet());
        if (CollectionUtils.isEmpty(unitNames)) {
            return;
        }
        ArrayList<UnitEntity> saveList = new ArrayList<UnitEntity>();
        for (String name : unitNames) {
            UnitEntity vo = new UnitEntity();
            vo.setUnitName(name);
            vo.setUnitCode(name);
            vo.setEnabled(1);
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            saveList.add(vo);
        }
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        this.unitService.saveOrUpdateBatch(saveList);
        Map<String, UnitEntity> saveMap = saveList.stream().collect(Collectors.toMap(x -> x.getUnitName(), x -> x));
        unitMap.putAll(saveMap);
    }

    public static void main(String[] args) {
        String msg = "[{\"basic\":{\"companyId\":44792,\"companyNum\":\"G00088997\",\"domesticForeignRelation\":\"\u5883\u5185\",\"unifiedSocialCode\":\"91341322152460452W\",\"organizingInstitutionCode\":\"91341322152460452W\",\"businessLicenseNum\":\"91341322152460452W\",\"taxRegistrationNum\":\"91341322152460452W\",\"isThreeCertificatesInOne\":1,\"companyName\":\"\u5b89\u5fbd\u7533\u8fbe\u5efa\u8bbe\u5de5\u7a0b\u6709\u9650\u516c\u53f8\",\"companyType\":\"\u6709\u9650\u8d23\u4efb\u516c\u53f8\",\"registeredCountryName\":\"\u4e2d\u56fd\",\"registeredRegionName\":\"\u8427\u53bf\",\"addressDetail\":\"\u8427\u53bf\u9f99\u57ce\u9547\u6c11\u6cbb\u885726#\",\"taxpayerType\":\"\u4e00\u822c\u7eb3\u7a0e\u4eba\",\"buildDate\":\"1994-05-23 00:00:00\",\"registeredCapital\":6500.000000,\"currencyName\":\"\u4eba\u6c11\u5e01\",\"businessScope\":\"\u9632\u6c34\u9632\u8150\u4fdd\u6e29\u5de5\u7a0b\u3001\u5efa\u7b51\u88c5\u4fee\u88c5\u9970\u5de5\u7a0b\u3001\u4eae\u5316\u5de5\u7a0b\u3001\u673a\u7535\u5b89\u88c5\u5de5\u7a0b\u3001\u77f3\u6cb9\u5316\u5de5\u5de5\u7a0b\u3001\u5efa\u7b51\u5de5\u7a0b\u3001\u7535\u529b\u5de5\u7a0b\u65bd\u5de5\u3001\u5730\u57fa\u57fa\u7840\u5de5\u7a0b\u3001\u94a2\u7ed3\u6784\u5de5\u7a0b\u3001\u6d88\u9632\u8bbe\u65bd\u5de5\u7a0b\u3001\u571f\u77f3\u65b9\u5de5\u7a0b\u65bd\u5de5\u3001\u65bd\u5de5\u52b3\u52a1\u3001\u6a21\u677f\u811a\u624b\u67b6\u642d\u8bbe\u3001\u56fd\u5185\u52b3\u52a1\u6d3e\u9063\uff1b\u5de5\u4e1a\u8bbe\u5907\u3001\u5efa\u7b51\uff08\u4e0d\u542b\u77f3\u6599\u548c\u9ec4\u6c99\uff09\u53ca\u9632\u8150\u4fdd\u6e29\u6750\u6599\u7684\u9500\u552e\uff1b\u7ba1\u9053\u548c\u8bbe\u5907\u5316\u5b66\u6e05\u6d17\uff1b\u91d1\u5c5e\u548c\u975e\u91d1\u5c5e\u70ed\u55b7\u6d82\uff1b\u5de5\u4e1a\u8bbe\u5907\u68c0\u7ef4\u4fee\uff1b\u516c\u4ea4\u7ad9\u4ead\u751f\u4ea7\u5236\u4f5c\u5b89\u88c5\uff1b\u673a\u68b0\u8bbe\u5907\u53ca\u6c7d\u8f66\u79df\u8d41\uff1b\u552e\u7535\u53ca\u552e\u7535\u670d\u52a1\uff1b\u8ba1\u7b97\u673a\u4fe1\u606f\u7cfb\u7edf\u96c6\u6210\u3001\u5efa\u7b51\u667a\u80fd\u5316\u7cfb\u7edf\u3001\u81ea\u52a8\u5316\u63a7\u5236\u7cfb\u7edf\u3001\u8ba1\u7b97\u673a\u7f51\u7edc\u53ca\u8f6f\u786c\u4ef6\u4ea7\u54c1\u7684\u5f00\u53d1\u4e0e\u9500\u552e\uff1b\u97f3\u54cd\u8bbe\u5907\u3001\u6821\u56ed\u5e7f\u64ad\u8bbe\u5907\u3001\u7535\u5b50\u8bbe\u5907\u3001\u6570\u7801\u4ea7\u54c1\u3001\u901a\u8baf\u4ea7\u54c1\u3001\u6570\u5b66\u8bbe\u5907\u4eea\u5668\u3001\u5b89\u9632\u76d1\u63a7\u8bbe\u5907\u3001\u8ba1\u7b97\u673a\u76f8\u5173\u4ea7\u54c1\u7684\u9500\u552e\uff1b\u4f53\u80b2\u8bbe\u65bd\u8bbe\u8ba1\u4e0e\u65bd\u5de5\uff1b\u8def\u706f\u3001\u7167\u660e\u8bbe\u5907\u3001\u65b0\u80fd\u6e90\u8bbe\u5907\u7684\u5b89\u88c5\uff1b\u8d27\u7269\uff08\u4e0d\u542b\u5371\u9669\u5316\u5b66\u54c1\uff09\u7684\u4ed3\u50a8\u3001\u88c5\u5378\u3001\u8fd0\u8f93\u3001\u5305\u88c5\u670d\u52a1\uff1b\u673a\u7535\u8bbe\u5907\u7ef4\u4fee\u3001\u7ef4\u62a4\u3002\uff08\u4f9d\u6cd5\u987b\u7ecf\u6279\u51c6\u7684\u9879\u76ee\uff0c\u7ecf\u76f8\u5173\u90e8\u95e8\u6279\u51c6\u540e\u65b9\u53ef\u5f00\u5c55\u7ecf\u8425\u6d3b\u52a8\uff09\",\"longTermFlag\":1,\"licenceUrl\":\"https://www.cnncsrm.com/minio/hz-private-bucket/spfm-comp/39520/bd9ae1aeca404d9f80df850d96068b9b@\u8425\u4e1a\u6267\u7167-20201217\uff08\u526f\u672c\uff09.jpg\",\"organizationType\":\"\u6cd5\u4eba\",\"legalRepName\":\"\u675c\u5f00\u989c\",\"legalRepNumber\":\"341322197808092039\",\"authorizedName\":\"\u9c81\u5cf0\",\"institutionType\":\"111\",\"corporateTelephone\":\"05575023987\",\"employeesNum\":2150,\"isStateOwnedEnterprise\":0,\"isForeignEquity\":0,\"operationNature\":\"\u5236\u9020\u5546\",\"companyProfile\":\"\u5b89\u5fbd\u7533\u8fbe\u5efa\u8bbe\u5de5\u7a0b\u6709\u9650\u516c\u53f8\u7cfb\u56fd\u5bb6\u4e00\u7ea7\u65bd\u5de5\u4f01\u4e1a\uff0c\u662f\u5728\u539f\u56fd\u6709\u4f01\u4e1a\u5b89\u5fbd\u7533\u8fbe\u9632\u8150\u4fdd\u6e29\u5de5\u7a0b\u516c\u53f8\u57fa\u7840\u4e0a\u6539\u5236\u800c\u6210\u7684\u96c6\u79d1\u7814\u3001\u751f\u4ea7\u3001\u65bd\u5de5\u3001\u670d\u52a1\u4e0e\u4e00\u4f53\u7684\u5de5\u7a0b\u65bd\u5de5\u4f01\u4e1a\u3002\u591a\u5e74\u6765\u516c\u53f8\u5168\u4f53\u5458\u5de5\u56e2\u7ed3\u4e00\u81f4\uff0c\u8270\u82e6\u594b\u6597\uff0c\u59cb\u7ec8\u4ee5\\\"\u4ee5\u8d28\u91cf\u6c42\u751f\u5b58\uff0c\u4ee5\u4fe1\u8a89\u6c42\u53d1\u5c55\\\"\u7684\u4f01\u4e1a\u5b97\u65e8\uff0c\u53d6\u5f97\u4e86\u826f\u597d\u7684\u7ecf\u6d4e\u6548\u76ca\u548c\u793e\u4f1a\u6548\u76ca\uff0c\u5728\u56fd\u5185\u5916\u5e02\u573a\u4eab\u6709\u8f83\u9ad8\u7684\u58f0\u8a89\u3002\\n\u76ee\u524d\uff0c\u516c\u53f8\u603b\u8d44\u4ea79276\u4e07\u5143\uff0c\u4ece\u4e1a\u4eba\u54582500\u4f59\u4eba\uff0c\u5176\u4e2d\u5de5\u7a0b\u6280\u672f\u548c\u7ecf\u6d4e\u7ba1\u7406\u4eba\u5458460\u4eba\uff0c\u62e5\u6709\u5404\u79cd\u7c7b\u578b\u7684\u5148\u8fdb\u65bd\u5de5\u8bbe\u5907\u548c\u8d28\u91cf\u68c0\u6d4b\u4eea\u5668656\u53f0(\u4ef6)\uff0c\u6280\u672f\u88c5\u5907\u73874116\u5143/\u4eba\uff0c\u662f\u540c\u884c\u4e1a\u4e2d\u5b9e\u529b\u8f83\u5f3a\u7684\u7efc\u5408\u6027\u65bd\u5de5\u4f01\u4e1a\uff0c\u516c\u53f8\u4e0b\u8bbe\u515a\u59d4\u3001\u5de5\u4f1a\u3001\u5b89\u5168\u6280\u672f\u90e8\u3001\u6750\u6599\u4f9b\u5e94\u90e8\u3001\u673a\u68b0\u8bbe\u5907\u90e8\u3001\u8d22\u52a1\u90e8\u3001\u5de5\u7a0b\u90e8\u3001\u5e02\u573a\u5f00\u53d1\u90e8\u3001\u8d28\u91cf\u7ba1\u7406\u90e8\u3001\u529e\u516c\u5ba4\u548c\u9632\u8150\u6280\u672f\u7814\u7a76\u6240\uff0c10\u4e2a\u5206\u516c\u53f8\u53ca26\u4e2a\u9879\u76ee\u90e8\u3002\\n\u6211\u516c\u53f8\u4ee5\u4e2d\u56fd\u5de5\u4e1a\u9632\u8150\u8680\u6280\u672f\u534f\u4f1a\u3001\u5929\u6d25\u5927\u5b66\u3001\u5317\u4eac\u79d1\u6280\u5927\u5b66\u4e3a\u6280\u672f\u4f9d\u6258\uff0c\u4f9d\u9760\u79d1\u6280\u8fdb\u6b65\uff0c\u6ce8\u91cd\u65b0\u6280\u672f\u3001\u65b0\u5de5\u827a\u3001\u65b0\u6750\u6599\u7684\u5f00\u53d1\u548c\u63a8\u5e7f\u5e94\u7528\uff0c\u80fd\u591f\u72ec\u7acb\u627f\u62c5\u77f3\u6cb9\u3001\u5316\u5de5\u3001\u7535\u529b\u3001\u51b6\u70bc\u3001\u673a\u68b0\u3001\u533b\u836f\u3001\u7eba\u7ec7\u3001\u6709\u8272\u91d1\u5c5e\u7b49\u8bf8\u591a\u884c\u4e1a\u7684\u9632\u8150\u4fdd\u6e29\u3001\u55b7\u6d82\u3001\u6a61\u80f6\u886c\u91cc\u3001\u7816\u677f\u8d34\u886c\u3001\u5316\u5de5\u8010\u9178\u3001\u78b1\u3001\u76d0\u53ca\u5316\u5de5\u77f3\u6cb9\u8bbe\u5907\u7ba1\u9053\u5b89\u88c5\uff0c\u673a\u7535\u7535\u6c14\u4eea\u8868\u5b89\u88c5\u3001\u9632\u6c34\u53ca\u5efa\u7b51\u88c5\u9970\u88c5\u4fee\u5de5\u7a0b\u65bd\u5de5\u3002\u5e76\u5efa\u7acb\u89c4\u8303\u5316\u7684\u73b0\u4ee3\u4f01\u4e1a\u5236\u5ea6\u548c\u79d1\u5b66\u7ba1\u7406\u4f53\u5236\uff0c\u5177\u6709\u96c4\u539a\u7684\u6280\u672f\u529b\u91cf\u548c\u65bd\u5de5\u529b\u91cf\uff0c\u5148\u8fdb\u7684\u65bd\u5de5\u5de5\u827a\u548c\u5b8c\u5584\u7684\u8d28\u91cf\u4fdd\u8bc1\u4f53\u7cfb\uff0c\u6210\u4e3a\u4ee5\u9632\u8150\u5b89\u88c5\u4e3a\u4e3b\u7684\u7efc\u5408\u6027\u5927\u578b\u65bd\u5de5\u4f01\u4e1a\u3002\\n\u7ecf\u8fc7\u4e8c\u5341\u591a\u5e74\u7684\u8270\u82e6\u594b\u6597\uff0c\u65bd\u5de5\u8db3\u8ff9\u904d\u5e03\u5168\u56fd\u4e8c\u5341\u591a\u4e2a\u7701\u3001\u5e02\u3001\u81ea\u6cbb\u533a\uff0c\u6211\u4eec\u59cb\u7ec8\u606a\u5b88\u4f01\u4e1a\u7ecf\u8425\u7406\u5ff5\uff0c\u5373:\u7cbe\u5fc3\u7ec4\u7ec7\uff0c\u5efa\u5ba2\u6237\u6ee1\u610f\u5de5\u7a0b;\u6301\u7eed\u6539\u8fdb,\u94f8\u884c\u4e1a\u4e00\u6d41\u54c1\u724c\u3002\\n\u516c\u53f8\u59cb\u7ec8\u575a\u6301\\\"\u767e\u5e74\u5927\u8ba1\u3001\u8d28\u91cf\u7b2c\u4e00\u3001\u987e\u5ba2\u81f3\u4e0a\\\"\u7684\u539f\u5219\uff0c\u7279\u522b\u6ce8\u91cd\u5de5\u7a0b\u8d28\u91cf\u548c\u5b89\u5168\u8ddf\u8e2a\u8c03\u67e5\uff0c\u4e3a\u4e0d\u65ad\u63d0\u9ad8\u4f01\u4e1a\u7684\u7ba1\u7406\u6c34\u5e73\u548c\u4e1a\u52a1\u7d20\u8d28\uff0c\u516c\u53f8\u957f\u671f\u5f00\u5c55\u804c\u5de5\u6559\u80b2\u53ca\u65b0\u6280\u672f\u8bb2\u5ea7\uff0c\u79ef\u6781\u5f15\u8fdb\u65b0\u6280\u672f\u3001\u65b0\u5de5\u827a\u3001\u65b0\u8bbe\u5907\u3001\u6bcf\u5e74\u9009\u6d3e\u7cbe\u5e72\u4eba\u5458\u5230\u4e13\u4e1a\u9662\u6821\u8fdb\u4fee\u3001\u5b66\u4e60\uff0c\u5e76\u4e0e\u4e2d\u56fd\u5de5\u4e1a\u9632\u8150\u8680\u6280\u672f\u534f\u4f1a\u7b49\u591a\u5bb6\u5355\u4f4d\u5efa\u7acb\u957f\u671f\u534f\u4f5c\u5173\u7cfb\u3002\u4e3a\u516c\u53f8\u7684\u53d1\u5c55\u63d0\u4f9b\u6280\u672f\u652f\u6301\u3002\\n\u4f01\u4e1a\u5728\u6539\u9769\u4e2d\u53d1\u5c55\uff0c\u5b9e\u529b\u5728\u7ade\u4e89\u4e2d\u589e\u5f3a\uff0c\u516c\u53f8\u65bd\u5de5\u7684\u4e3b\u8981\u5de5\u7a0b\u9879\u76ee\u6709:\u56fd\u5bb6\u897f\u6c14\u4e1c\u8f93\u3001\u6da9\u5b81\u5170\u8f93\u6c14\u7ba1\u9053\u3001\u897f\u5357\u6210\u54c1\u6cb9\u7ba1\u9053\u7b49\u5de5\u7a0b;\u5854\u91cc\u6728\u3001\u514b\u62c9\u739b\u4f9d\u3001\u5410\u54c8\u7b49\u5404\u5927\u6cb9\u7530\u7684\u7ba1\u9053\u3001\u50a8\u6cb9\u7f50\u5b89\u88c5\u9632\u8150\u4fdd\u6e29\u5de5\u7a0b;\u4e4c\u9c81\u6728\u9f50\u3001\u5b89\u5e86\u3001\u626c\u5b50\u7b49\u56fd\u5bb6\u5927\u578b\u70bc\u5316\u4f01\u4e1a\u7684\u8bbe\u5907\u3001\u50a8\u6cb9\u7f50\u9632\u8150\u4fdd\u6e29\u5de5\u7a0b;\u4e0a\u6d77\u3001\u6c5f\u82cf\u3001\u5b89\u5fbd\u7b49\u5927\u578b\u7535\u5382\u7684\u9632\u8150\u4fdd\u6e29\u5de5\u7a0b;\u65b0\u7586\u3001\u5927\u5e86\u3001\u4e2d\u539f\u7b49\u5316\u5de5\u7ba1\u7ebf\u5b89\u88c5\u9632\u8150\u4fdd\u6e29\u5de5\u7a0b;\u5929\u6d25\u3001\u592a\u539f\u3001\u5927\u8fde\u7b49\u7164\u6c14\u516c\u53f8\u7684\u6c14\u67dc\u3001\u7ba1\u9053\u9632\u8150\u5de5\u7a0b;\u5357\u4eac\u3001\u5f90\u5dde\u7b49\u6c61\u6c34\u5904\u7406\u5382\u9632\u8150\u5de5\u7a0b;\u8427\u53bf\u7ecf\u6d4e\u5f00\u53d1\u533a\u529e\u516c\u697c\u3001\u6dee\u5317\u5730\u7a0e\u5c40\u529e\u516c\u697c\u88c5\u4fee\u88c5\u9970\u5de5\u7a0b;\u5f90\u5dde\u56fd\u5bb6\u7cae\u98df\u50a8\u5907\u5e93\u3001\u90d1\u5dde\u76f4\u5c5e\u5e93\u7b49\u5c4b\u9762\u9632\u6c34\u5de5\u7a0b\u4ee5\u53ca\u5229\u6bd4\u4e9a\u70bc\u6cb9\u5382\u3001\u6c99\u7279\u8fbe\u66fc\u5316\u5de5\u5382\u7b49\u56fd\u5185\u5916\u91cd\u70b9\u9879\u76ee\uff0c\u65bd\u5de5\u5408\u683c\u7387100%\uff0c\u4f18\u826f\u738785%\uff0c\u5e76\u83b7\u5956\u676f\u3001\u5956\u65d7\u7b49200\u591a\u9762(\u679a)\uff0c\u4e45\u6cf0\u80fd\u6e9020\u4e07\u5428/\u5e74\u7532\u919a\u66ff\u4ee3\u77f3\u6cb9\u9879\u76ee\u9632\u8150\u4fdd\u6e29\u5de5\u7a0b\u8363\u83b72008\u5e74\u5ea6\u5168\u56fd\u5341\u5927\u9632\u8150\u8680\u7cbe\u54c1\u5de5\u7a0b\u3002\\n\u7531\u4e8e\u516c\u53f8\u91cd\u5408\u540c\u5b88\u4fe1\u7528\uff0c\u5e76\u4e25\u683c\u6267\u884c\u56fd\u5bb6\u53ca\u884c\u4e1a\u89c4\u8303\u3001\u89c4\u7a0b\u548c\u6807\u51c6\uff0c\u591a\u6b21\u53d7\u5230\u5efa\u8bbe\u5355\u4f4d\u548c\u884c\u4e1a\u4e3b\u7ba1\u90e8\u95e8\u597d\u8bc4\u548c\u5956\u52b1\uff0c\u5148\u540e\u8363\u83b7\\\"\u5168\u56fd\u8d28\u91cf\u5b89\u5168\u5148\u8fdb\u65bd\u5de5\u4f01\u4e1a\\\",\u591a\u6b21\u88ab\u7701\u59d4\u3001\u7701\u653f\u5e9c\u547d\u540d\u4e3a\\\"\u660e\u661f\u4f01\u4e1a\\\"\\\"\u4e94\u5341\u5f3a\u4f01\u4e1a\\\"\\\"\u4f18\u79c0\u5efa\u7b51\u4e1a\u4f01\u4e1a\\\"\\\"\u5b89\u5168\u751f\u4ea7\u5148\u8fdb\u96c6\u4f53\\\"\u8fde\u7eed\u5341\u5e74\u88ab\u7701\u5de5\u5546\u884c\u653f\u7ba1\u7406\u5c40\u8bc4\u4e3a\\\"\u91cd\u5408\u540c\u5b88\u4fe1\u7528\u5355\u4f4d\\\"\u5e76\u88ab\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u5b89\u5fbd\u7701\u5206\u884c\u8bc4\u4e3aAAA\u7ea7\u4fe1\u7528\u4f01\u4e1a\uff0c\u516c\u53f8\u7684\u5148\u8fdb\u4e8b\u8ff9\u5148\u540e\u89c1\u8bf8\u56fd\u5185\u591a\u5bb6\u65b0\u95fb\u5a92\u4f53\u3002\\n\u516c\u53f8\u5728\u540c\u884c\u4e1a\u7387\u5148\u901a\u8fc7ISO9001\u300a\u8d28\u91cf\u7ba1\u7406\u4f53\u7cfb\u300b\u3001ISO14001\u300a\u73af\u5883\u7ba1\u7406\u4f53\u7cfb\u300b\u3001GB/T28001\u300a\u804c\u4e1a\u5065\u5eb7\u5b89\u5168\u7ba1\u7406\u4f53\u7cfb\u300bQEO\u4e09\u6807\u4e00\u4f53\u7ba1\u7406\u4f53\u7cfb\u8ba4\u8bc1\uff0c\u4e3a\u786e\u4fdd\u5de5\u7a0b\u8d28\u91cf\u53ca\u73af\u5883\u4fdd\u62a4\u3001\u4e3a\u987e\u5ba2\u63d0\u4f9b\u4f18\u8d28\u670d\u52a1\u53d1\u6325\u79ef\u6781\u4f5c\u7528\uff0c\u5e76\u4f7f\u516c\u53f8\u7684\u7ba1\u7406\u66f4\u52a0\u89c4\u8303\uff0c\u4f01\u4e1a\u66f4\u5177\u5e02\u573a\u7ade\u4e89\u529b\u3002\",\"majorIndustries\":\"499\",\"sysdataid\":\"4c17f0ad93d44451827d10662a36c0f7\",\"sysid\":\"9b1319bc324e4ef6bc309b83bf192e9c\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},\"contactsList\":[{\"companyId\":44792,\"companyContactId\":44780,\"name\":\"\u4e25\u4e3d\u5a77\",\"mail\":\"yueda2006@163.com\",\"mobilephone\":\"15215943971\",\"idType\":\"\u8eab\u4efd\u8bc1\",\"idNum\":\"330424199505090049\",\"defaultFlag\":0,\"sysdataid\":\"d7e7f001db20470490c630839f4ff53f\",\"sysid\":\"48a81210cd2545a39379ec56f5b12ebf\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"companyId\":44792,\"companyContactId\":174181,\"name\":\"\u9c81\u5cf0\",\"mail\":\"yueda2006@163.com\",\"mobilephone\":\"13600568110\",\"telephone\":\"0557-5023987\",\"idType\":\"\u8eab\u4efd\u8bc1\",\"idNum\":\"220104196806171570\",\"defaultFlag\":1,\"sysdataid\":\"0ad058854e03420b8328a7d9dc8eb83e\",\"sysid\":\"5b9497cc3c554ba78b40997c389f6bda\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"}],\"addressList\":[{\"companyId\":44792,\"companyAddressId\":44779,\"country\":\"\u4e2d\u56fd\",\"region\":\"\u7f3a\u7701\",\"postalCode\":\"235200\",\"addressType\":\"register\",\"sysdataid\":\"eeed942d54ce4cefbb899a9bc14cae80\",\"sysid\":\"bf6401af08c840ac8dda8a2ecddb28e1\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"companyId\":44792,\"companyAddressId\":149489,\"country\":\"\u4e2d\u56fd\",\"region\":\"\u8427\u53bf\",\"postalCode\":\"235200\",\"addressType\":\"operate\",\"sysdataid\":\"1173172ffa11442d994c4aba34319be6\",\"sysid\":\"acb4ff11aec4471cbdf74037fbba4a6d\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"}],\"bankList\":[{\"companyId\":44792,\"companyBankAccountId\":40603,\"bankBranchName\":\"\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8\u8427\u53bf\u652f\u884c\",\"bankAccountName\":\"\u5b89\u5fbd\u7533\u8fbe\u5efa\u8bbe\u5de5\u7a0b\u6709\u9650\u516c\u53f8\",\"bankAccountNum\":\"34001727308053000332\",\"masterFlag\":1,\"bankFirm\":\"105374350014\",\"iban\":\"\u5b89\u5fbd\u7533\u8fbe\u5efa\u8bbe\u5de5\u7a0b\u6709\u9650\u516c\u53f8\",\"sysdataid\":\"87d2999cc25244609d10855810c8479c\",\"sysid\":\"d7876db93d2843b9aa03c66b4fe4a68c\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"companyId\":44792,\"companyBankAccountId\":205559,\"bankBranchName\":\"\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8\u6d77\u76d0\u79e6\u5c71\u652f\u884c\",\"bankAccountName\":\"\u5b89\u5fbd\u7533\u8fbe\u5efa\u8bbe\u5de5\u7a0b\u6709\u9650\u516c\u53f8\",\"bankAccountNum\":\"33050163715200000005\",\"masterFlag\":0,\"bankFirm\":\"105335300649\",\"iban\":\"\u5b89\u5fbd\u7533\u8fbe\u5efa\u8bbe\u5de5\u7a0b\u6709\u9650\u516c\u53f8\",\"sysdataid\":\"032a0880d95f4004a799bf86f7c4433d\",\"sysid\":\"0a2b753fb25b4bab883b0910b57a88d6\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"}],\"financeList\":[{\"year\":\"2023\",\"revenue\":112000.24,\"companyId\":44792,\"companyFinanceId\":140622,\"totalAssets\":23388.20,\"totalLiabilities\":12949.86,\"currentAssets\":22902.88,\"currentLiabilities\":12949.86,\"netProfit\":2120.05,\"sysdataid\":\"30ef5d77f3dd4d89960a650cae832195\",\"sysid\":\"ab027b97bc694910a818a4d6c808b863\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"}],\"invoiceList\":[{\"companyInvoiceId\":40601,\"companyId\":44792,\"invoiceHeader\":\"\u5b89\u5fbd\u7533\u8fbe\u5efa\u8bbe\u5de5\u7a0b\u6709\u9650\u516c\u53f8\",\"taxRegistrationNumber\":\"91341322152460452W\",\"depositBank\":\"\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\",\"bankAccountNum\":\"34001727308053000332\",\"taxRegistrationAddress\":\"\u5b89\u5fbd\u7701\u8427\u53bf\u9f99\u57ce\u9547\u6c11\u6cbb\u885726#\",\"taxRegistrationPhone\":\"05575023987\",\"receiveMail\":\"yueda2006@163.com\",\"receivePhone\":\"13600568110\",\"sysdataid\":\"aee28e66fb98401ba75056113381d100\",\"sysid\":\"98c462c62ff9461dac29a11783987a98\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"}],\"qualificationList\":[],\"statusList\":[{\"companyId\":44792,\"status\":\"\u6ce8\u518c\",\"belongCompanyCode\":\"10000\",\"belongCompanyName\":\"\u4e2d\u56fd\u6838\u5de5\u4e1a\u96c6\u56e2\u6709\u9650\u516c\u53f8\",\"sysdataid\":\"810f3eb3e49347aea7429dcd48471497\",\"sysid\":\"b5c780719de24934bc9bc31a9614b6e1\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":70991,\"companyId\":44792,\"status\":\"\u5408\u683c\",\"belongCompanyCode\":\"99280563919161110119\",\"belongCompanyName\":\"\u4e2d\u56fd\u6838\u5de5\u4e1a\u4e8c\u4e09\u5efa\u8bbe\u6709\u9650\u516c\u53f8\",\"validityDateFrom\":\"2023-02-15 00:00:00\",\"validityDateTo\":\"2025-12-01 00:00:00\",\"evaluationScope\":\"\u4e8c\u7c7b\uff1a\u7ba1\u9053\u3001\u673a\u68b0\u3001\u975e\u6838\u3001\u9884\u5236\u7f50\u4e13\u4e1a\u52b3\u52a1\u5206\u5305\u3002\",\"sysdataid\":\"e78ee971c11c4554a9d79866d11298ee\",\"sysid\":\"d89a1e0932564efea2077c0f0ee50fe6\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":2071520,\"companyId\":44792,\"status\":\"\u5408\u683c\",\"belongCompanyCode\":\"99280563919161110121\",\"belongCompanyName\":\"\u4e2d\u56fd\u6838\u5de5\u4e1a\u7b2c\u4e94\u5efa\u8bbe\u6709\u9650\u516c\u53f8\",\"validityDateFrom\":\"2024-05-24 00:00:00\",\"validityDateTo\":\"2027-05-17 00:00:00\",\"evaluationScope\":\"\u52b3\u52a1\u5206\u5305\uff08\u6309\u5de5\u7a0b\u91cf\u8ba1\u7b97\uff09\uff08\u6f33\u5dde\u6838\u7535 2027.05.17\uff09\",\"sysdataid\":\"54b0755b219147468ab135b413be3a68\",\"sysid\":\"b263aad5daaa425b859080a94ea76b32\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":69577,\"companyId\":44792,\"status\":\"\u5408\u683c\",\"belongCompanyCode\":\"99280563919161110120\",\"belongCompanyName\":\"\u4e2d\u56fd\u6838\u5de5\u4e1a\u4e8c\u56db\u5efa\u8bbe\u6709\u9650\u516c\u53f8\",\"validityDateFrom\":\"2023-01-09 00:00:00\",\"validityDateTo\":\"2026-01-10 00:00:00\",\"evaluationScope\":\"\u6321\u571f\u5899\u5efa\u8bbe\",\"sysdataid\":\"bed07447bd0a4d8cb64714053fd43755\",\"sysid\":\"3e9c534290fd49f8b5700d7b3e4cdd48\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":69578,\"companyId\":44792,\"status\":\"\u5408\u683c\",\"belongCompanyCode\":\"99280563919161110120\",\"belongCompanyName\":\"\u4e2d\u56fd\u6838\u5de5\u4e1a\u4e8c\u56db\u5efa\u8bbe\u6709\u9650\u516c\u53f8\",\"validityDateFrom\":\"2023-01-09 00:00:00\",\"validityDateTo\":\"2026-01-10 00:00:00\",\"evaluationScope\":\"\u524d\u671f\u4e34\u5efa\u5de5\u7a0b\",\"sysdataid\":\"5b773e2deaeb47a389a79b9ca0906e56\",\"sysid\":\"f698c9eebfb3458f866fd8776539cd03\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":879450,\"companyId\":44792,\"status\":\"\u5408\u683c\",\"belongCompanyCode\":\"99280563919161110118\",\"belongCompanyName\":\"\u4e2d\u56fd\u6838\u5de5\u4e1a\u7b2c\u4e8c\u4e8c\u5efa\u8bbe\u6709\u9650\u516c\u53f8\",\"validityDateFrom\":\"2023-11-25 00:00:00\",\"validityDateTo\":\"2026-11-14 00:00:00\",\"evaluationScope\":\"\u52b3\u52a1\u5206\u5305\\n\",\"sysdataid\":\"f65d06e394f34438aa8e4ba757a04d08\",\"sysid\":\"859da91fb65e489fb12a72dec60b1559\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":2108890,\"companyId\":44792,\"status\":\"\u5408\u683c\",\"belongCompanyCode\":\"99280563919161110392\",\"belongCompanyName\":\"\u4e2d\u6838\u4e8c\u5341\u4e94\u5efa\u8bbe\u6709\u9650\u516c\u53f8\",\"validityDateFrom\":\"2024-07-08 00:00:00\",\"validityDateTo\":\"2025-07-08 00:00:00\",\"evaluationScope\":\"\u9632\u6c34\u9632\u8150\u6d82\u6599\u5de5\u7a0b\u4e13\u4e1a\u5206\u5305\",\"sysdataid\":\"206e33ce793244c8a2df281eaa1ac90a\",\"sysid\":\"9d7ac661caaa40cba5459770b7d49b08\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":2391561,\"companyId\":44792,\"status\":\"\u5408\u683c\",\"belongCompanyCode\":\"99280563919161110005\",\"belongCompanyName\":\"\u4e2d\u56fd\u6838\u5de5\u4e1a\u5efa\u8bbe\u80a1\u4efd\u6709\u9650\u516c\u53f8\",\"validityDateFrom\":\"2024-05-24 00:00:00\",\"validityDateTo\":\"2027-05-17 00:00:00\",\"evaluationScope\":\"\u52b3\u52a1\u5206\u5305\",\"sysdataid\":\"4b8ed38f51144a0b8de48a245b706001\",\"sysid\":\"7732b672688d463a88eded2153c1d5cb\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"},{\"listId\":2578495,\"companyId\":44792,\"status\":\"\u5408\u683c\",\"belongCompanyCode\":\"99280563919161110005\",\"belongCompanyName\":\"\u4e2d\u56fd\u6838\u5de5\u4e1a\u5efa\u8bbe\u80a1\u4efd\u6709\u9650\u516c\u53f8\",\"validityDateFrom\":\"2024-05-24 00:00:00\",\"validityDateTo\":\"2027-05-17 00:00:00\",\"evaluationScope\":\"\u9632\u6c34\u9632\u8150\u6d82\u6599\u5de5\u7a0b\u4e13\u4e1a\u5206\u5305\uff0c\u52b3\u52a1\u5206\u5305\uff0c\u5730\u57fa\u57fa\u7840\u5de5\u7a0b\",\"sysdataid\":\"c83b606afc604175a776819239a6c44e\",\"sysid\":\"b4240351873f43e5a83ca555c5b1d4e2\",\"version\":\"1\",\"versionstatus\":\"0\",\"isusedcode\":\"0\",\"createuser\":\"\",\"createtime\":\"2025-02-25 19:29:23\",\"modifytime\":\"2025-02-25 19:29:23\",\"sourceappcode\":\"srm\"}]}]";
        JSONArray content = JSONObject.parseArray((String)msg);
        List codes = content.stream().map(x -> ((JSONObject)x).getJSONObject("basic").getString("companyNum")).collect(Collectors.toList());
        ArrayList<SupplierEntity> saveList = new ArrayList<SupplierEntity>();
        for (Object o : content) {
            JSONArray invoice;
            JSONObject obj = (JSONObject)o;
            JSONObject basic = obj.getJSONObject("basic");
            String code = basic.getString("companyNum");
            SupplierEntity vo = new SupplierEntity();
            vo.setSourceId(basic.getString("companyId"));
            vo.setBillState(1);
            vo.setSupplierFlag(1);
            vo.setBlacklistFlag(0);
            vo.setRedlistFlag(0);
            vo.setInsideOrg(false);
            vo.setCoordination(false);
            vo.setInException(false);
            vo.setSupplyQueryType("laborSub,materialEquipment,other");
            vo.setSupplyType("major,labor,material,other");
            vo.setSupplyTypeName("\u4e13\u4e1a\u4f9b\u5e94\u5546,\u52b3\u52a1\u4f9b\u5e94\u5546,\u8d27\u7269\u7c7b\u4f9b\u5e94\u5546,\u5176\u4ed6\u4f9b\u5e94\u5546");
            vo.setPersonal("e");
            vo.setApplyOrgId(1247777316689256450L);
            vo.setApplyOrgName("\u4e2d\u6838\u534e\u6cf0\u5efa\u8bbe\u6709\u9650\u516c\u53f8");
            vo.setEnabled(1);
            vo.setId(IdWorker.getId());
            vo.setCreateUserCode(USER_CODE);
            vo.setCreateTime(new Date());
            vo.setTenantId(TENANT_ID);
            vo.setCode(basic.getString("companyNum"));
            vo.setName(basic.getString("companyName"));
            vo.setSocialCreditCode(basic.getString("unifiedSocialCode"));
            vo.setLegal(basic.getString("legalRepName"));
            vo.setLegalPhone(basic.getString("corporateTelephone"));
            vo.setAddress(basic.getString("addressDetail"));
            vo.setTaxPayerIdentifier(basic.getString("unifiedSocialCode"));
            vo.setRegisterTime(basic.getDate("buildDate"));
            vo.setRegisteredCapital(basic.getBigDecimal("registeredCapital"));
            vo.setBusinessScope(basic.getString("businessScope"));
            vo.setInOrOut(!"\u5883\u5185".equals(basic.getString("domesticForeignRelation")) ? 2 : 1);
            vo.setTaxpayerType(!"\u4e00\u822c\u7eb3\u7a0e\u4eba".equals(basic.getString("taxpayerType")) ? "smallScale" : "commonly");
            vo.setRegisterCountryName(basic.getString("registeredCountryName"));
            vo.setArea(basic.getString("registeredRegionName"));
            JSONArray contacts = obj.getJSONArray("contactsList");
            if (CollectionUtils.isNotEmpty((Collection)contacts)) {
                vo.setBusinessPerson(contacts.getJSONObject(0).getString("name"));
                vo.setBusinessPhone(contacts.getJSONObject(0).getString("mobilephone"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(invoice = obj.getJSONArray("invoiceList")))) {
                vo.setBillingAddress(invoice.getJSONObject(0).getString("taxRegistrationAddress"));
                vo.setBillingPhone(invoice.getJSONObject(0).getString("taxRegistrationPhone"));
                vo.setBankAccountCode(invoice.getJSONObject(0).getString("bankAccountNum"));
                vo.setBankAccountName(invoice.getJSONObject(0).getString("depositBank"));
            }
            vo.setUnitI8Code(basic.getString("companyId"));
            vo.setSystemId("cnecht.zh.supplier");
            saveList.add(vo);
        }
        System.out.println(JSONObject.toJSONString(saveList));
    }
}

