/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.LabsubCategoryEntity;
import com.ejianc.foundation.share.bean.LabsubItemEntity;
import com.ejianc.foundation.share.service.ILabsubCategoryService;
import com.ejianc.foundation.share.service.ILabsubItemService;
import com.ejianc.foundation.share.vo.LabsubItemImportVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/labsubItem"})
public class LabsubItemController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "LSI_CODE";
    @Autowired
    private ILabsubItemService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ILabsubCategoryService labsubCategoryService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LabsubItemVO> saveOrUpdate(@RequestBody LabsubItemVO saveorUpdateVO) {
        CommonResponse<LabsubItemVO> response = this.service.saveOrUpdateLabsubItem(saveorUpdateVO);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LabsubItemVO> queryDetail(Long id) {
        LabsubItemEntity entity = (LabsubItemEntity)((Object)this.service.selectById(id));
        LabsubItemVO vo = (LabsubItemVO)BeanMapper.map((Object)((Object)entity), LabsubItemVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LabsubItemVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/bandSubject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List ids = (List)map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String)map.get("subjectName");
        this.service.updateSubject(subjectId, subjectName, ids);
        return CommonResponse.success((String)"\u7ed1\u5b9a\u6210\u529f!");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LabsubItemVO>> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        Map paramMap = param.getParams();
        paramMap.put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (paramMap.get("categoryId") != null) {
            Object categoryId = ((Parameter)paramMap.get("categoryId")).getValue();
            if (categoryId != null) {
                LabsubCategoryEntity categoryEntity = (LabsubCategoryEntity)((Object)this.labsubCategoryService.selectById((Serializable)((Object)categoryId.toString())));
                if (categoryEntity != null) {
                    paramMap.put("innerCode", new Parameter("like_right", (Object)categoryEntity.getInnerCode()));
                    paramMap.remove("categoryId");
                }
            } else {
                param.getParams().remove("categoryId");
            }
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<LabsubItemVO> list = this.service.queryLabsubItemList((Page<LabsubItemVO>)page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(list, LabsubItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<LabsubCategoryEntity> categoryvos;
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        ArrayList allCategoryIds = null;
        if (null != param.getParams() && null != param.getParams().get("categoryIds") && CollectionUtils.isNotEmpty(categoryvos = this.labsubCategoryService.queryListByPids(JSONArray.parseArray((String)JSONObject.toJSONString((Object)((Parameter)param.getParams().get("categoryIds")).getValue()), Long.class)))) {
            allCategoryIds = new ArrayList();
            allCategoryIds.addAll(categoryvos.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        List<LabsubItemVO> list = this.service.queryAllByCategoryIds(allCategoryIds, InvocationInfoProxy.getTenantid(), 0);
        HashMap<String, List<LabsubItemVO>> beans = new HashMap<String, List<LabsubItemVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("laborSub-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refLabsubItemData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<LabsubItemVO>> refLabsubItemData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LabsubItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"labsub-import.xlsx", (String)"\u52b3\u52a1\u5206\u5305\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelProsubImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelProsubImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response = this.service.excelProsubImport(request);
        return response;
    }

    @RequestMapping(value={"/saveImportExceLabsubItem"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelProsubItem(@RequestBody List<LabsubItemImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList list = new ArrayList();
        importVos.forEach(importVO -> {
            LabsubItemEntity entity = (LabsubItemEntity)((Object)((Object)BeanMapper.map((Object)importVO, LabsubItemEntity.class)));
            entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
            entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
            entity.setEnabled(0);
            list.add(entity);
        });
        this.service.saveBatch(list, list.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/changeState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody ProsubItemVO saveorUpdateVO) {
        LabsubItemEntity entity = (LabsubItemEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, LabsubItemEntity.class));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
        updateWrapper.set(LabsubItemEntity::getEnabled, (Object)entity.getEnabled());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"refLabSubItemPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<LabsubItemVO>> refLabSubItemPage(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setFuzzyFields(Arrays.asList("categoryName", "trawlingCode", "trawlingName", "priceType", "unitName", "jobContent", "remarks"));
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            LabsubCategoryEntity labsubCategoryEntity = (LabsubCategoryEntity)((Object)this.labsubCategoryService.selectById(categoryId));
            if (labsubCategoryEntity != null) {
                String innerCode = labsubCategoryEntity.getInnerCode();
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("inner_code", new Parameter("like", (Object)innerCode));
                List labsubCategoryEntitys = this.labsubCategoryService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty((Collection)labsubCategoryEntitys)) {
                    List ids = labsubCategoryEntitys.stream().filter(s -> s.getId() != null).map(BaseEntity::getId).collect(Collectors.toList());
                    param.getParams().put("category_id", new Parameter("in", ids));
                }
            } else {
                return CommonResponse.error((String)"\u5f53\u524d\u5206\u7c7b\u4e0d\u5b58\u5728\u6863\u6848\uff01");
            }
        }
        param.getParams().put("enabled", new Parameter("eq", (Object)0));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("trawlingCode", "asc");
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LabsubItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"labSubItemPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<LabsubItemVO>> labSubItemPage(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String categoryId, @RequestParam(required=false) String enabled) {
        LabsubCategoryEntity labsubCategoryEntity;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setFuzzyFields(Arrays.asList("trawlingCode", "trawlingName", "priceType", "unitName", "jobContent", "remarks"));
        if (StringUtils.isNotBlank((CharSequence)categoryId) && (labsubCategoryEntity = (LabsubCategoryEntity)((Object)this.labsubCategoryService.selectById((Serializable)((Object)categoryId)))) != null) {
            String innerCode = labsubCategoryEntity.getInnerCode();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("inner_code", new Parameter("like", (Object)innerCode));
            List labsubCategoryEntitys = this.labsubCategoryService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)labsubCategoryEntitys)) {
                List ids = labsubCategoryEntitys.stream().filter(s -> s.getId() != null).map(BaseEntity::getId).collect(Collectors.toList());
                param.getParams().put("category_id", new Parameter("in", ids));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)enabled)) {
            param.getParams().put("enabled", new Parameter("eq", (Object)enabled));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LabsubItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"queryWholeTreeItemsById"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryWholeTreeItemsById(@RequestBody Map<String, String> param) {
        return this.service.queryWholeTreeItemsById(param.get("idStr"), param.get("type"));
    }
}

