/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.PriceDepotPowerSetEntity;
import com.ejianc.foundation.share.service.IPriceDepotPowerSetService;
import com.ejianc.foundation.share.vo.PriceDepotPowerSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"priceDepotPowerSet"})
public class PriceDepotPowerSetController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPriceDepotPowerSetService service;
    private static final String BILL_CODE = "PRICE_DEPOT_POWER";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PriceDepotPowerSetVO> saveOrUpdate(@RequestBody PriceDepotPowerSetVO saveOrUpdateVO) {
        PriceDepotPowerSetEntity entity = (PriceDepotPowerSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PriceDepotPowerSetEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            Long orgId = entity.getOrgId();
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"org_id", (Object)orgId);
            List list = this.service.list((Wrapper)wrapper);
            if (list.size() > 0) {
                return CommonResponse.error((String)"\u8be5\u7ec4\u7ec7\u5df2\u7ecf\u5b58\u5728\u914d\u7f6e\uff01");
            }
            CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!codeBatchByRuleCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setCode((String)codeBatchByRuleCode.getData());
        } else {
            String[] split;
            Long thisOrgId = InvocationInfoProxy.getOrgId();
            Long orgId = entity.getOrgId();
            CommonResponse oneById = this.iOrgApi.getOneById(orgId);
            if (!oneById.isSuccess() || oneById.getData() == null) {
                return CommonResponse.error((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            Boolean result = false;
            OrgVO data = (OrgVO)oneById.getData();
            String innerCode = data.getInnerCode();
            for (String s : split = innerCode.split("\\|")) {
                if (!Long.valueOf(s).equals(thisOrgId)) continue;
                result = true;
            }
            if (!result.booleanValue()) {
                return CommonResponse.error((String)"\u975e\u672c\u4e0a\u7ec4\u7ec7\u4e0d\u53ef\u64cd\u4f5c\uff01");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PriceDepotPowerSetVO vo = (PriceDepotPowerSetVO)BeanMapper.map((Object)((Object)entity), PriceDepotPowerSetVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PriceDepotPowerSetVO> queryDetail(Long id) {
        PriceDepotPowerSetEntity entity = (PriceDepotPowerSetEntity)((Object)this.service.selectById(id));
        PriceDepotPowerSetVO vo = (PriceDepotPowerSetVO)BeanMapper.map((Object)((Object)entity), PriceDepotPowerSetVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam List<Long> ids) {
        List vos = new ArrayList();
        if (ListUtil.isNotEmpty(ids)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"id", ids);
            List list = this.service.list((Wrapper)wrapper);
            vos = BeanMapper.mapList((Iterable)list, PriceDepotPowerSetVO.class);
            for (PriceDepotPowerSetVO vo : vos) {
                String[] split;
                Long thisOrgId = InvocationInfoProxy.getOrgId();
                Long orgId = vo.getOrgId();
                CommonResponse oneById = this.iOrgApi.getOneById(orgId);
                if (!oneById.isSuccess() || oneById.getData() == null) {
                    return CommonResponse.error((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                Boolean result = false;
                OrgVO data = (OrgVO)oneById.getData();
                String innerCode = data.getInnerCode();
                for (String s : split = innerCode.split("\\|")) {
                    if (!Long.valueOf(s).equals(thisOrgId)) continue;
                    result = true;
                }
                if (result.booleanValue()) continue;
                return CommonResponse.error((String)(vo.getCode() + ",\u975e\u672c\u4e0a\u7ec4\u7ec7\u4e0d\u53ef\u64cd\u4f5c\uff01"));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PriceDepotPowerSetVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        List orgids = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        CommonResponse oneById = this.iOrgApi.getOneById(orgId);
        if (oneById.isSuccess() && oneById.getData() != null) {
            String[] split;
            OrgVO data = (OrgVO)oneById.getData();
            String innerCode = data.getInnerCode();
            for (String s : split = innerCode.split("\\|")) {
                orgids.add(Long.valueOf(s));
            }
        }
        param.getParams().put("orgId", new Parameter("in", orgids));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List priceDepotPowerSetVOS = BeanMapper.mapList((Iterable)page.getRecords(), PriceDepotPowerSetVO.class);
        priceDepotPowerSetVOS.forEach(item -> {
            if (item.getPowerType() == 1) {
                item.setPowerTypeName("\u4ef7\u683c\u4fdd\u5bc6");
            }
        });
        pageData.setRecords(priceDepotPowerSetVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("priceDepotPowerSet-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refpriceDepotPowerSetData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PriceDepotPowerSetVO>> refpriceDepotPowerSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PriceDepotPowerSetVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

