/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.SubjectProjectEntity;
import com.ejianc.foundation.share.service.ISubjectProjectService;
import com.ejianc.foundation.share.vo.SubjectProjectImportVO;
import com.ejianc.foundation.share.vo.SubjectProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subjectProject"})
public class SubjectProjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    private static final String SUBJECT_PROJECT = "EJCBT202205000001";
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISubjectProjectService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubjectProjectVO> saveOrUpdate(@RequestBody SubjectProjectVO saveorUpdateVO) {
        return this.service.saveOrUpdate(saveorUpdateVO);
    }

    @RequestMapping(value={"/updateEn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubjectProjectVO> updateEn(@RequestBody SubjectProjectVO saveorUpdateVO) {
        return this.service.updateEn(saveorUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubjectProjectVO> queryDetail(Long id) {
        SubjectProjectEntity entity = (SubjectProjectEntity)((Object)this.service.selectById(id));
        SubjectProjectVO vo = (SubjectProjectVO)BeanMapper.map((Object)((Object)entity), SubjectProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubjectProjectVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long billId : ids) {
            CommonResponse res = this.billTypeApi.checkQuote(SUBJECT_PROJECT, billId);
            this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
            if (res.isSuccess()) continue;
            throw new BusinessException("\u5b58\u5728\u88ab\u7ed3\u7b97\u5355\u5f15\u7528\u7684\u6863\u6848\uff0c\u8bf7\u5904\u7406\u540e\u518d\u5220\u9664\uff01");
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("subjectName");
        fuzzyFields.add("subjectCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("subjectCode", "asc");
        List list = this.service.queryList(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("subjectCode", "asc");
        List list = this.service.queryList(param, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subjectProject-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubjectProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refSubjectProjectData(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("subjectName");
        param.getFuzzyFields().add("subjectCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter("eq", (Object)0));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("projectId")) {
            Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        param.getOrderMap().put("subjectCode", "asc");
        List list = this.service.queryList(param, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (SubjectProjectEntity entity : list) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getSubjectName());
            map.put("code", entity.getSubjectCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("orgSubjectId", entity.getOrgSubjectId());
            map.put("innerCode", entity.getInnerCode());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/importOrgSubject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> importOrgSubject(@RequestBody SubjectProjectImportVO importVo) {
        this.service.importOrgSubject(importVo);
        return CommonResponse.success((String)"\u5f15\u5165\u6210\u529f\uff01");
    }
}

