/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.foundation.share.bean.SubjectProjectEntity;
import com.ejianc.foundation.share.mapper.SubjectProjectMapper;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.service.ISubjectProjectService;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.share.vo.SubjectProjectImportVO;
import com.ejianc.foundation.share.vo.SubjectProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subjectProjectService")
public class SubjectProjectServiceImpl
extends BaseServiceImpl<SubjectProjectMapper, SubjectProjectEntity>
implements ISubjectProjectService {
    @Autowired
    private ISubjectOrgService subjectOrgService;

    @Override
    public CommonResponse<SubjectProjectVO> saveOrUpdate(SubjectProjectVO saveorUpdateVO) {
        SubjectProjectEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (SubjectProjectEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SubjectProjectEntity.class));
            super.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        entity = (SubjectProjectEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SubjectProjectEntity.class));
        entity.setId(IdWorker.getId());
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            SubjectProjectEntity uniqueBean = (SubjectProjectEntity)((Object)((SubjectProjectMapper)this.baseMapper).selectById(entity.getParentId()));
            entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @Override
    public Boolean delRefCheck(List<Long> ids) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(SubjectProjectEntity::getOrgSubjectId, ids);
        List list = super.list((Wrapper)lambda);
        return list != null && list.size() > 0;
    }

    @Override
    public List<SubjectProjectVO> getChildrenByPid(Long id) {
        SubjectProjectEntity parent = (SubjectProjectEntity)((Object)this.selectById(id));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter("like_right", (Object)parent.getInnerCode()));
        List list = super.queryList(queryParam, false);
        return BeanMapper.mapList((Iterable)list, SubjectProjectVO.class);
    }

    @Override
    public void importOrgSubject(SubjectProjectImportVO importVo) {
        List detailList = importVo.getDetailList();
        List ids = detailList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<String> innerCodeList = detailList.stream().map(SubjectOrgVO::getInnerCode).collect(Collectors.toList());
        ArrayList innerCodes = new ArrayList();
        innerCodeList.forEach(x -> {
            if (StringUtils.isNotEmpty((CharSequence)x)) {
                innerCodes.addAll(Arrays.asList(x.split(",")).stream().map(y -> Long.valueOf(y)).filter(y -> !ids.contains(y)).collect(Collectors.toList()));
            }
        });
        if (CollectionUtils.isNotEmpty(innerCodes)) {
            List innerList = (List)this.subjectOrgService.listByIds(innerCodes);
            ids.addAll(innerCodes);
            detailList.addAll(BeanMapper.mapList((Iterable)innerList, SubjectOrgVO.class));
        }
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.eq(SubjectProjectEntity::getProjectId, (Object)importVo.getProjectId());
        lambda.in(SubjectProjectEntity::getOrgSubjectId, ids);
        List list = super.list((Wrapper)lambda);
        ArrayList<Long> oldIds = new ArrayList<Long>();
        HashMap<Long, Long> parentMap = new HashMap<Long, Long>();
        for (SubjectProjectEntity spe : list) {
            parentMap.put(spe.getOrgSubjectId(), spe.getId());
            oldIds.add(spe.getOrgSubjectId());
        }
        ArrayList<SubjectProjectEntity> saveList = new ArrayList<SubjectProjectEntity>();
        for (SubjectOrgVO vo : detailList) {
            if (oldIds.contains(vo.getId())) continue;
            SubjectProjectEntity entity = new SubjectProjectEntity();
            long id = IdWorker.getId();
            entity.setId(id);
            entity.setSubjectCode(vo.getSubjectCode());
            entity.setSubjectName(vo.getSubjectName());
            entity.setMemo(vo.getMemo());
            entity.setOrgId(importVo.getOrgId());
            entity.setOrgName(importVo.getOrgName());
            entity.setProjectId(importVo.getProjectId());
            entity.setProjectName(importVo.getProjectName());
            entity.setOrgSubjectId(vo.getId());
            entity.setParentId(vo.getParentId());
            entity.setInnerCode(vo.getInnerCode());
            parentMap.put(vo.getId(), id);
            saveList.add(entity);
        }
        if (saveList.size() > 0) {
            for (SubjectProjectEntity spe : saveList) {
                spe.setParentId((Long)parentMap.get(spe.getParentId()));
                String innerCode = spe.getInnerCode();
                String[] split = innerCode.split(",");
                String newInnerCode = "";
                for (int i = 0; i < split.length; ++i) {
                    Long aLong = (Long)parentMap.get(Long.parseLong(split[i]));
                    newInnerCode = i == 0 ? aLong.toString() : newInnerCode + "," + aLong.toString();
                }
                spe.setInnerCode(newInnerCode);
            }
            super.saveBatch(saveList);
        }
    }

    @Override
    public CommonResponse<SubjectProjectVO> updateEn(SubjectProjectVO saveorUpdateVO) {
        List list = BeanMapper.mapList(this.getChildrenByPid(saveorUpdateVO.getId()), SubjectProjectEntity.class);
        for (SubjectProjectEntity entity : list) {
            entity.setEnabled(saveorUpdateVO.getEnabled());
        }
        this.saveOrUpdateBatch(list);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }
}

