/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.ItemDocApplyDetailEntity;
import com.ejianc.foundation.share.mapper.ItemDocApplyDetailMapper;
import com.ejianc.foundation.share.service.IItemDocApplyDetailService;
import com.ejianc.foundation.share.service.ILabsubCategoryService;
import com.ejianc.foundation.share.service.ILabsubItemService;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.service.IUnitService;
import com.ejianc.foundation.share.vo.ItemDocApplyDetailVO;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="itemDocApplyDetailService")
public class ItemDocApplyDetailServiceImpl
extends BaseServiceImpl<ItemDocApplyDetailMapper, ItemDocApplyDetailEntity>
implements IItemDocApplyDetailService {
    @Autowired
    private ILabsubCategoryService labsubCategoryService;
    @Autowired
    private ILabsubItemService labsubItemService;
    @Autowired
    private IProsubCategoryService prosubCategoryService;
    @Autowired
    private IProsubItemService prosubItemService;
    @Autowired
    private IUnitService unitService;

    @Override
    public CommonResponse<JSONObject> excelItemDocImport(HttpServletRequest request) {
        String itemDocType = request.getParameter("itemDocType");
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<ItemDocApplyDetailVO> successList = new ArrayList<ItemDocApplyDetailVO>();
        ArrayList<ItemDocApplyDetailVO> processList = new ArrayList<ItemDocApplyDetailVO>();
        ArrayList<ItemDocApplyDetailVO> errorList = new ArrayList<ItemDocApplyDetailVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5bfc\u5165\u6e05\u5355\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap caListMap = new HashMap();
            HashMap materialMap = new HashMap();
            HashMap materialBeanMap = new HashMap();
            ArrayList<String> categoryCodes = new ArrayList<String>();
            ArrayList<String> itemCodes = new ArrayList<String>();
            ArrayList<String> unitNames = new ArrayList<String>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ItemDocApplyDetailVO importVo = new ItemDocApplyDetailVO();
                importVo.setId(Long.valueOf(IdWorker.getId()));
                importVo.setCategoryCode((String)datas.get(0));
                importVo.setItemCode((String)datas.get(1));
                importVo.setItemName((String)datas.get(2));
                importVo.setPriceType((String)datas.get(3));
                importVo.setUnitName((String)datas.get(4));
                importVo.setJobContent((String)datas.get(5));
                importVo.setSpec((String)datas.get(6));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    importVo.setErrMsg("\u3010\u6240\u5c5e\u5206\u7c7b\u7f16\u7801\u3011\u4e3a\u7a7a\uff01");
                    errorList.add(importVo);
                    continue;
                }
                if (!categoryCodes.contains(datas.get(0))) {
                    categoryCodes.add((String)datas.get(0));
                }
                if (StringUtils.isBlank((CharSequence)importVo.getItemCode())) {
                    importVo.setErrMsg("\u3010\u6e05\u5355\u7f16\u7801\u3011\u4e3a\u7a7a\uff01");
                    errorList.add(importVo);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    if (itemCodes.contains(datas.get(1))) {
                        importVo.setErrMsg("\u3010\u6e05\u5355\u7f16\u7801\u3011\u91cd\u590d\uff01");
                        errorList.add(importVo);
                        continue;
                    }
                    itemCodes.add((String)datas.get(1));
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    importVo.setErrMsg("\u3010\u6e05\u5355\u540d\u79f0\u3011\u4e3a\u7a7a\uff01");
                    errorList.add(importVo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)importVo.getJobContent())) {
                    importVo.setErrMsg("\u3010\u8ba1\u91cf\u89c4\u5219\u3011\u4e3a\u7a7a\uff01");
                    errorList.add(importVo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)importVo.getSpec())) {
                    importVo.setErrMsg("\u3010\u89c4\u683c\u578b\u53f7/\u9879\u76ee\u7279\u5f81\u3011\u4e3a\u7a7a\uff01");
                    errorList.add(importVo);
                    continue;
                }
                if (!"\u56fa\u5b9a\u5355\u4ef7".equals(importVo.getPriceType()) && !"\u56fa\u5b9a\u603b\u4ef7".equals(importVo.getPriceType())) {
                    importVo.setErrMsg("\u3010\u4ef7\u683c\u7c7b\u578b\u3011\u503c\u9519\u8bef\uff01");
                    errorList.add(importVo);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)importVo.getUnitName()) && !unitNames.contains(importVo.getUnitName())) {
                    unitNames.add(importVo.getUnitName());
                }
                importVo.setDetailType(itemDocType);
                processList.add(importVo);
            }
            if (CollectionUtils.isNotEmpty(processList)) {
                if ("labsub".equals(itemDocType)) {
                    this.checkLabSubCategory(unitNames, itemCodes, categoryCodes, processList, successList, errorList);
                } else {
                    this.checkProSubCategory(unitNames, itemCodes, categoryCodes, processList, successList, errorList);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public String validateLabSubItem(List<ItemDocApplyDetailEntity> detailList) {
        ArrayList<String> codeList = new ArrayList<String>();
        for (ItemDocApplyDetailEntity detail : detailList) {
            if ("del".equals(detail.getRowState())) continue;
            if (codeList.contains(detail.getItemCode())) {
                return "\u64cd\u4f5c\u5931\u8d25\uff0c\u6e05\u5355\u7f16\u7801\u3010" + detail.getItemCode() + "\u3011\u91cd\u590d";
            }
            codeList.add(detail.getItemCode());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"trawling_name", (Object)detail.getItemName());
            if (StringUtils.isNotBlank((CharSequence)detail.getPriceType())) {
                queryWrapper.eq((Object)"price_type", (Object)detail.getPriceType());
            }
            queryWrapper.eq((Object)"unit_name", (Object)detail.getUnitName());
            if (StringUtils.isBlank((CharSequence)detail.getJobContent())) {
                queryWrapper.isNull((Object)"job_content");
            } else {
                queryWrapper.eq((Object)"job_content", (Object)detail.getJobContent());
            }
            if (StringUtils.isBlank((CharSequence)detail.getSpec())) {
                queryWrapper.isNull((Object)"detail_measurement_rules");
            } else {
                queryWrapper.eq((Object)"detail_measurement_rules", (Object)detail.getSpec());
            }
            queryWrapper.eq((Object)"category_id", (Object)detail.getCategoryId());
            List list = this.labsubItemService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                return "\u6e05\u5355-\u540d\u79f0\uff1a\u3010" + detail.getItemName() + "\u3011\uff0c\u7f16\u7801\uff1a\u3010" + detail.getItemCode() + "\u3011\uff0c\u89c4\u683c\u578b\u53f7/\u9879\u76ee\u7279\u5f81\u3010" + detail.getSpec() + "\u3011\u5df2\u5165\u5e93\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7\uff01";
            }
            QueryWrapper applyQueryWrapper = new QueryWrapper();
            applyQueryWrapper.eq((Object)"item_name", (Object)detail.getItemName());
            if (StringUtils.isNotBlank((CharSequence)detail.getPriceType())) {
                applyQueryWrapper.eq((Object)"price_type", (Object)detail.getPriceType());
            }
            applyQueryWrapper.eq((Object)"unit_name", (Object)detail.getUnitName());
            if (StringUtils.isBlank((CharSequence)detail.getJobContent())) {
                applyQueryWrapper.isNull((Object)"job_content");
            } else {
                applyQueryWrapper.eq((Object)"job_content", (Object)detail.getJobContent());
            }
            if (StringUtils.isBlank((CharSequence)detail.getSpec())) {
                applyQueryWrapper.isNull((Object)"spec");
            } else {
                applyQueryWrapper.eq((Object)"spec", (Object)detail.getSpec());
            }
            applyQueryWrapper.eq((Object)"category_id", (Object)detail.getCategoryId());
            applyQueryWrapper.eq((Object)"detail_type", (Object)"labsub");
            List dbList = super.list((Wrapper)applyQueryWrapper);
            if (!CollectionUtils.isNotEmpty((Collection)dbList)) continue;
            return "\u6e05\u5355-\u540d\u79f0\uff1a\u3010" + detail.getItemName() + "\u3011\uff0c\u7f16\u7801\uff1a\u3010" + detail.getItemCode() + "\u3011\uff0c\u89c4\u683c\u578b\u53f7/\u9879\u76ee\u7279\u5f81\u3010" + detail.getSpec() + "\u3011\u5df2\u5b58\u5728\u5165\u5e93\u8bb0\u5f55\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7\uff01";
        }
        HashSet existsCodes = new HashSet();
        if (CollectionUtils.isNotEmpty(codeList)) {
            List<ItemDocApplyDetailVO> applyVos;
            List<LabsubItemVO> labsubItems = this.labsubItemService.queryAllByCodes(codeList);
            if (CollectionUtils.isNotEmpty(labsubItems)) {
                existsCodes.addAll(labsubItems.stream().map(LabsubItemVO::getTrawlingCode).distinct().collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty(applyVos = this.queryAllByCodeAndType(codeList, "labsub"))) {
                existsCodes.addAll(applyVos.stream().map(ItemDocApplyDetailVO::getItemCode).distinct().collect(Collectors.toList()));
            }
        }
        return null;
    }

    @Override
    public void generateCodeBatch(List<ItemDocApplyDetailEntity> empCodeList) {
        HashMap<Long, ItemDocApplyDetailEntity> eMap = new HashMap<Long, ItemDocApplyDetailEntity>();
        for (ItemDocApplyDetailEntity e : empCodeList) {
            if (null == e.getId()) {
                e.setId(IdWorker.getId());
            }
            eMap.put(e.getId(), e);
        }
        List vos = BeanMapper.mapList(empCodeList, ItemDocApplyDetailVO.class);
        this.labsubItemService.generateCodeBatch(vos);
        for (ItemDocApplyDetailVO v : vos) {
            ((ItemDocApplyDetailEntity)((Object)eMap.get(v.getId()))).setItemCode(v.getItemCode());
        }
    }

    private void checkProSubCategory(List<String> unitNames, List<String> itemCodes, List<String> categoryCode, List<ItemDocApplyDetailVO> processList, List<ItemDocApplyDetailVO> sucList, List<ItemDocApplyDetailVO> errList) {
        ArrayList<ItemDocApplyDetailVO> empCodeList = new ArrayList<ItemDocApplyDetailVO>();
        ArrayList<String> itemBeanMap = new ArrayList<String>();
        List<ProsubCategoryVO> categoryVOS = this.prosubCategoryService.queryAllByCodes(categoryCode);
        Map categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(ProsubCategoryVO::getCategoryCode, Function.identity()));
        ArrayList existsCodes = new ArrayList();
        if (CollectionUtils.isNotEmpty(itemCodes)) {
            List<ItemDocApplyDetailVO> applyVos;
            List<ProsubItemVO> labsubItems = this.prosubItemService.queryAllByCodes(itemCodes);
            if (CollectionUtils.isNotEmpty(labsubItems)) {
                existsCodes.addAll(labsubItems.stream().map(ProsubItemVO::getTrawlingCode).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty(applyVos = this.queryAllByCodeAndType(itemCodes, "labsub"))) {
                existsCodes.addAll(applyVos.stream().map(ItemDocApplyDetailVO::getItemCode).collect(Collectors.toList()));
            }
        }
        ProsubCategoryVO materialCategoryVo = null;
        for (ItemDocApplyDetailVO importVo : processList) {
            materialCategoryVo = (ProsubCategoryVO)categoryVOMap.get(importVo.getCategoryCode());
            if (null == materialCategoryVo) {
                importVo.setErrMsg("\u6863\u6848\u5206\u7c7b\u7f16\u53f7\u4e0d\u5b58\u5728\uff01");
                errList.add(importVo);
                continue;
            }
            importVo.setCategoryId(materialCategoryVo.getId());
            importVo.setCategoryName(materialCategoryVo.getCategoryName());
            importVo.setExtField1(materialCategoryVo.getSubjectIds());
            importVo.setExtField2(materialCategoryVo.getSubjectNames());
            importVo.setExtField3(materialCategoryVo.getSubjectRelations());
            if (StringUtils.isNotBlank((CharSequence)importVo.getItemCode())) {
                if (existsCodes.contains(importVo.getItemCode())) {
                    importVo.setErrMsg("\u6863\u6848\u7f16\u7801\u91cd\u590d\uff01");
                    errList.add(importVo);
                    continue;
                }
            } else {
                empCodeList.add(importVo);
            }
            if (itemBeanMap.contains(importVo.getItemName() + importVo.getPriceType() + importVo.getUnitName() + importVo.getCategoryId() + (StringUtils.isNotBlank((CharSequence)importVo.getJobContent()) ? importVo.getJobContent() : "") + (StringUtils.isNotBlank((CharSequence)importVo.getSpec()) ? importVo.getSpec() : ""))) {
                importVo.setErrMsg("\u8be5\u6e05\u5355\u5df2\u5165\u5e93\u6216\u5df2\u5b58\u5728\u5165\u5e93\u7533\u8bf7\u8bb0\u5f55\uff01");
                errList.add(importVo);
                continue;
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"trawling_name", (Object)importVo.getItemName());
            if (StringUtils.isNotBlank((CharSequence)importVo.getPriceType())) {
                queryWrapper.eq((Object)"price_type", (Object)importVo.getPriceType());
            }
            queryWrapper.eq((Object)"unit_name", (Object)importVo.getUnitName());
            if (StringUtils.isBlank((CharSequence)importVo.getJobContent())) {
                queryWrapper.isNull((Object)"job_content");
            } else {
                queryWrapper.eq((Object)"job_content", (Object)importVo.getJobContent());
            }
            if (StringUtils.isBlank((CharSequence)importVo.getSpec())) {
                queryWrapper.isNull((Object)"detail_measurement_rules");
            } else {
                queryWrapper.eq((Object)"detail_measurement_rules", (Object)importVo.getSpec());
            }
            queryWrapper.eq((Object)"category_id", (Object)importVo.getCategoryId());
            List list = this.prosubItemService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                importVo.setErrMsg("\u8be5\u6e05\u5355\u5df2\u5165\u5e93\uff01");
                errList.add(importVo);
                continue;
            }
            QueryWrapper applyQueryWrapper = new QueryWrapper();
            applyQueryWrapper.eq((Object)"item_name", (Object)importVo.getItemName());
            if (StringUtils.isNotBlank((CharSequence)importVo.getPriceType())) {
                applyQueryWrapper.eq((Object)"price_type", (Object)importVo.getPriceType());
            }
            applyQueryWrapper.eq((Object)"unit_name", (Object)importVo.getUnitName());
            if (StringUtils.isBlank((CharSequence)importVo.getJobContent())) {
                applyQueryWrapper.isNull((Object)"job_content");
            } else {
                applyQueryWrapper.eq((Object)"job_content", (Object)importVo.getJobContent());
            }
            if (StringUtils.isBlank((CharSequence)importVo.getSpec())) {
                applyQueryWrapper.isNull((Object)"spec");
            } else {
                applyQueryWrapper.eq((Object)"spec", (Object)importVo.getSpec());
            }
            applyQueryWrapper.eq((Object)"category_id", (Object)importVo.getCategoryId());
            applyQueryWrapper.eq((Object)"detail_type", (Object)"prosub");
            List dbList = super.list((Wrapper)applyQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)dbList)) {
                importVo.setErrMsg("\u8be5\u6e05\u5355\u5df2\u5b58\u5728\u5165\u5e93\u7533\u8bf7\u8bb0\u5f55\uff01");
                errList.add(importVo);
                continue;
            }
            itemBeanMap.add(importVo.getItemName() + importVo.getPriceType() + importVo.getUnitName() + importVo.getCategoryId() + (StringUtils.isNotBlank((CharSequence)importVo.getJobContent()) ? importVo.getJobContent() : "") + (StringUtils.isNotBlank((CharSequence)importVo.getSpec()) ? importVo.getSpec() : ""));
            sucList.add(importVo);
        }
    }

    private void checkLabSubCategory(List<String> unitNames, List<String> itemCodes, List<String> categoryCode, List<ItemDocApplyDetailVO> processList, List<ItemDocApplyDetailVO> sucList, List<ItemDocApplyDetailVO> errList) {
        ArrayList<ItemDocApplyDetailVO> empCodeList = new ArrayList<ItemDocApplyDetailVO>();
        ArrayList<String> itemBeanMap = new ArrayList<String>();
        List<LabsubCategoryVO> categoryVOS = this.labsubCategoryService.queryAllByCodes(categoryCode);
        Map categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(LabsubCategoryVO::getCategoryCode, Function.identity()));
        ArrayList existsCodes = new ArrayList();
        if (CollectionUtils.isNotEmpty(itemCodes)) {
            List<ItemDocApplyDetailVO> applyVos;
            List<LabsubItemVO> labsubItems = this.labsubItemService.queryAllByCodes(itemCodes);
            if (CollectionUtils.isNotEmpty(labsubItems)) {
                existsCodes.addAll(labsubItems.stream().map(LabsubItemVO::getTrawlingCode).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty(applyVos = this.queryAllByCodeAndType(itemCodes, "labsub"))) {
                existsCodes.addAll(applyVos.stream().map(ItemDocApplyDetailVO::getItemCode).collect(Collectors.toList()));
            }
        }
        LabsubCategoryVO materialCategoryVo = null;
        for (ItemDocApplyDetailVO importVo : processList) {
            materialCategoryVo = (LabsubCategoryVO)categoryVOMap.get(importVo.getCategoryCode());
            if (null == materialCategoryVo) {
                importVo.setErrMsg("\u6863\u6848\u5206\u7c7b\u7f16\u53f7\u4e0d\u5b58\u5728\uff01");
                errList.add(importVo);
                continue;
            }
            importVo.setCategoryId(materialCategoryVo.getId());
            importVo.setCategoryName(materialCategoryVo.getCategoryName());
            importVo.setExtField1(materialCategoryVo.getSubjectIds());
            importVo.setExtField2(materialCategoryVo.getSubjectNames());
            importVo.setExtField3(materialCategoryVo.getSubjectRelations());
            if (StringUtils.isNotBlank((CharSequence)importVo.getItemCode())) {
                if (existsCodes.contains(importVo.getItemCode())) {
                    importVo.setErrMsg("\u6863\u6848\u7f16\u7801\u91cd\u590d\uff01");
                    errList.add(importVo);
                    continue;
                }
            } else {
                empCodeList.add(importVo);
            }
            if (itemBeanMap.contains(importVo.getItemName() + importVo.getPriceType() + importVo.getUnitName() + importVo.getCategoryId() + (StringUtils.isNotBlank((CharSequence)importVo.getJobContent()) ? importVo.getJobContent() : "") + (StringUtils.isNotBlank((CharSequence)importVo.getSpec()) ? importVo.getSpec() : ""))) {
                importVo.setErrMsg("\u8be5\u6e05\u5355\u5df2\u5165\u5e93\u6216\u5df2\u5b58\u5728\u5165\u5e93\u7533\u8bf7\u8bb0\u5f55\uff01");
                errList.add(importVo);
                continue;
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"trawling_name", (Object)importVo.getItemName());
            if (StringUtils.isNotBlank((CharSequence)importVo.getPriceType())) {
                queryWrapper.eq((Object)"price_type", (Object)importVo.getPriceType());
            }
            queryWrapper.eq((Object)"unit_name", (Object)importVo.getUnitName());
            if (StringUtils.isBlank((CharSequence)importVo.getJobContent())) {
                queryWrapper.isNull((Object)"job_content");
            } else {
                queryWrapper.eq((Object)"job_content", (Object)importVo.getJobContent());
            }
            if (StringUtils.isBlank((CharSequence)importVo.getSpec())) {
                queryWrapper.isNull((Object)"detail_measurement_rules");
            } else {
                queryWrapper.eq((Object)"detail_measurement_rules", (Object)importVo.getSpec());
            }
            queryWrapper.eq((Object)"category_id", (Object)importVo.getCategoryId());
            Object one = null;
            List list = this.labsubItemService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                importVo.setErrMsg("\u8be5\u6e05\u5355\u5df2\u5165\u5e93\uff01");
                errList.add(importVo);
                continue;
            }
            QueryWrapper applyQueryWrapper = new QueryWrapper();
            applyQueryWrapper.eq((Object)"item_name", (Object)importVo.getItemName());
            if (StringUtils.isNotBlank((CharSequence)importVo.getPriceType())) {
                applyQueryWrapper.eq((Object)"price_type", (Object)importVo.getPriceType());
            }
            applyQueryWrapper.eq((Object)"unit_name", (Object)importVo.getUnitName());
            if (StringUtils.isBlank((CharSequence)importVo.getJobContent())) {
                applyQueryWrapper.isNull((Object)"job_content");
            } else {
                applyQueryWrapper.eq((Object)"job_content", (Object)importVo.getJobContent());
            }
            if (StringUtils.isBlank((CharSequence)importVo.getSpec())) {
                applyQueryWrapper.isNull((Object)"spec");
            } else {
                applyQueryWrapper.eq((Object)"spec", (Object)importVo.getSpec());
            }
            applyQueryWrapper.eq((Object)"category_id", (Object)importVo.getCategoryId());
            applyQueryWrapper.eq((Object)"detail_type", (Object)"labsub");
            List dbList = super.list((Wrapper)applyQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)dbList)) {
                importVo.setErrMsg("\u8be5\u6e05\u5355\u5df2\u5b58\u5728\u5165\u5e93\u7533\u8bf7\u8bb0\u5f55\uff01");
                errList.add(importVo);
                continue;
            }
            itemBeanMap.add(importVo.getItemName() + importVo.getPriceType() + importVo.getUnitName() + importVo.getCategoryId() + (StringUtils.isNotBlank((CharSequence)importVo.getJobContent()) ? importVo.getJobContent() : "") + (StringUtils.isNotBlank((CharSequence)importVo.getSpec()) ? importVo.getSpec() : ""));
            sucList.add(importVo);
        }
    }

    private List<ItemDocApplyDetailVO> queryAllByCodeAndType(List<String> itemCodes, String itemType) {
        ArrayList<ItemDocApplyDetailVO> resp = new ArrayList<ItemDocApplyDetailVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"item_code", itemCodes);
        query.in((Object)"detail_type", new Object[]{itemType});
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            return BeanMapper.mapList((Iterable)dbList, ItemDocApplyDetailVO.class);
        }
        return resp;
    }

    @Override
    public String validateProSubItem(List<ItemDocApplyDetailEntity> detailList) {
        ArrayList<String> codeList = new ArrayList<String>();
        for (ItemDocApplyDetailEntity detail : detailList) {
            if (codeList.contains(detail.getItemCode())) {
                return "\u64cd\u4f5c\u5931\u8d25\uff0c\u7f16\u7801\u3010" + detail.getItemCode() + "\u3011\u91cd\u590d";
            }
            codeList.add(detail.getItemCode());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"trawling_name", (Object)detail.getItemName());
            if (StringUtils.isNotBlank((CharSequence)detail.getPriceType())) {
                queryWrapper.eq((Object)"price_type", (Object)detail.getPriceType());
            }
            queryWrapper.eq((Object)"unit_name", (Object)detail.getUnitName());
            if (StringUtils.isBlank((CharSequence)detail.getJobContent())) {
                queryWrapper.isNull((Object)"job_content");
            } else {
                queryWrapper.eq((Object)"job_content", (Object)detail.getJobContent());
            }
            if (StringUtils.isBlank((CharSequence)detail.getSpec())) {
                queryWrapper.isNull((Object)"detail_measurement_rules");
            } else {
                queryWrapper.eq((Object)"detail_measurement_rules", (Object)detail.getSpec());
            }
            queryWrapper.eq((Object)"category_id", (Object)detail.getCategoryId());
            List list = this.prosubItemService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                return "\u6e05\u5355-\u540d\u79f0\uff1a\u3010" + detail.getItemName() + "\u3011\uff0c\u7f16\u7801\uff1a\u3010" + detail.getItemCode() + "\u3011\uff0c\u89c4\u683c\u578b\u53f7/\u9879\u76ee\u7279\u5f81\u3010" + detail.getSpec() + "\u3011\u5df2\u5165\u5e93\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7\uff01";
            }
            QueryWrapper applyQueryWrapper = new QueryWrapper();
            applyQueryWrapper.eq((Object)"item_name", (Object)detail.getItemName());
            if (StringUtils.isNotBlank((CharSequence)detail.getPriceType())) {
                applyQueryWrapper.eq((Object)"price_type", (Object)detail.getPriceType());
            }
            applyQueryWrapper.eq((Object)"unit_name", (Object)detail.getUnitName());
            if (StringUtils.isBlank((CharSequence)detail.getJobContent())) {
                applyQueryWrapper.isNull((Object)"job_content");
            } else {
                applyQueryWrapper.eq((Object)"job_content", (Object)detail.getJobContent());
            }
            if (StringUtils.isBlank((CharSequence)detail.getSpec())) {
                applyQueryWrapper.isNull((Object)"spec");
            } else {
                applyQueryWrapper.eq((Object)"spec", (Object)detail.getSpec());
            }
            applyQueryWrapper.eq((Object)"category_id", (Object)detail.getCategoryId());
            applyQueryWrapper.eq((Object)"detail_type", (Object)"prosub");
            List dbList = super.list((Wrapper)applyQueryWrapper);
            if (!CollectionUtils.isNotEmpty((Collection)dbList)) continue;
            return "\u6e05\u5355-\u540d\u79f0\uff1a\u3010" + detail.getItemName() + "\u3011\uff0c\u7f16\u7801\uff1a\u3010" + detail.getItemCode() + "\u3011\uff0c\u89c4\u683c\u578b\u53f7/\u9879\u76ee\u7279\u5f81\u3010" + detail.getSpec() + "\u3011\u5df2\u5b58\u5728\u5165\u5e93\u8bb0\u5f55\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7\uff01";
        }
        HashSet existsCodes = new HashSet();
        if (CollectionUtils.isNotEmpty(codeList)) {
            List<ItemDocApplyDetailVO> applyVos;
            List<ProsubItemVO> labsubItems = this.prosubItemService.queryAllByCodes(codeList);
            if (CollectionUtils.isNotEmpty(labsubItems)) {
                existsCodes.addAll(labsubItems.stream().map(ProsubItemVO::getTrawlingCode).distinct().collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty(applyVos = this.queryAllByCodeAndType(codeList, "labsub"))) {
                existsCodes.addAll(applyVos.stream().map(ItemDocApplyDetailVO::getItemCode).distinct().collect(Collectors.toList()));
            }
        }
        if (CollectionUtils.isNotEmpty(existsCodes)) {
            return "\u64cd\u4f5c\u5931\u8d25\uff0c\u7f16\u7801\u3010" + StringUtils.join(existsCodes, (String)",") + "\u3011\u91cd\u590d!";
        }
        return null;
    }
}

