/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.ProsubCategoryEntity;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import com.ejianc.foundation.share.bean.SubjectOrgEntity;
import com.ejianc.foundation.share.mapper.ProsubCategoryMapper;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.vo.ProsubCategoryImportVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="prosubCategoryService")
public class ProsubCategoryServiceImpl
extends BaseServiceImpl<ProsubCategoryMapper, ProsubCategoryEntity>
implements IProsubCategoryService {
    @Autowired
    private IProsubCategoryService service;
    @Autowired
    private IProsubItemService prosubItemService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PSC_CODE";
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ProsubCategoryMapper prosubCategoryMapper;
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private ISubjectOrgService subjectOrgService;

    @Override
    public CommonResponse<String> deleteById(List<ProsubCategoryVO> vos) {
        List collect = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("category_id", new Parameter("in", collect));
        List prosubItemEntities = this.prosubItemService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)prosubItemEntities)) {
            return CommonResponse.error((String)"\u5206\u7c7b\u4e0b\u5173\u8054\u4e13\u4e1a\u5206\u5305\u6863\u6848\uff01");
        }
        QueryParam queryClassifyParam = new QueryParam();
        queryClassifyParam.getParams().put("parent_id", new Parameter("in", collect));
        List prosubItems = this.service.queryList(queryClassifyParam);
        if (CollectionUtils.isNotEmpty((Collection)prosubItems)) {
            return CommonResponse.error((String)"\u5206\u7c7b\u4e0b\u5173\u8054\u5b50\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public List<ProsubCategoryVO> queryProsubCategoryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<ProsubCategoryVO> resultList = ((ProsubCategoryMapper)this.baseMapper).queryProsubCategoryList(condition);
        return resultList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<ProsubCategoryVO> saveOrUpdateProsubCategory(ProsubCategoryVO saveorUpdateVO) {
        ProsubCategoryEntity prosubCategoryEntity;
        ProsubCategoryEntity entity = (ProsubCategoryEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProsubCategoryEntity.class));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("categoryCode", new Parameter("eq", (Object)saveorUpdateVO.getCategoryCode()));
        List prosubCategoryEntityList = this.service.queryList(queryParam);
        if (saveorUpdateVO.getId() != null ? !(prosubCategoryEntity = (ProsubCategoryEntity)((Object)this.service.selectById(saveorUpdateVO.getId()))).getCategoryCode().equals(saveorUpdateVO.getCategoryCode()) && CollectionUtils.isNotEmpty((Collection)prosubCategoryEntityList) : CollectionUtils.isNotEmpty((Collection)prosubCategoryEntityList)) {
            return CommonResponse.error((String)"\u5206\u7c7b\u7f16\u7801\u91cd\u590d\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getCategoryCode())) {
                entity.setCategoryCode((String)billCode.getData());
            } else {
                entity.setCategoryCode(saveorUpdateVO.getCategoryCode());
            }
        } else {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            updateWrapper.set(ProsubCategoryEntity::getCategoryCode, (Object)saveorUpdateVO.getCategoryCode());
            updateWrapper.set(ProsubCategoryEntity::getCategoryName, (Object)saveorUpdateVO.getCategoryName());
            updateWrapper.set(ProsubCategoryEntity::getOrgId, (Object)this.sessionManager.getUserContext().getOrgId());
            updateWrapper.set(ProsubCategoryEntity::getOrgName, (Object)this.sessionManager.getUserContext().getOrgName());
            updateWrapper.set(ProsubCategoryEntity::getRemarks, (Object)saveorUpdateVO.getRemarks());
            updateWrapper.set(ProsubCategoryEntity::getSubjectId, (Object)saveorUpdateVO.getSubjectId());
            updateWrapper.set(ProsubCategoryEntity::getSubjectName, (Object)saveorUpdateVO.getSubjectName());
            updateWrapper.set(ProsubCategoryEntity::getSubjectIds, (Object)saveorUpdateVO.getSubjectIds());
            updateWrapper.set(ProsubCategoryEntity::getSubjectNames, (Object)saveorUpdateVO.getSubjectNames());
            updateWrapper.set(ProsubCategoryEntity::getSubjectRelations, (Object)saveorUpdateVO.getSubjectRelations());
            updateWrapper.set(ProsubCategoryEntity::getSequence, (Object)saveorUpdateVO.getSequence());
            this.service.update((Wrapper)updateWrapper);
            Long tenantId = InvocationInfoProxy.getTenantid();
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(entity.getId());
            List<ProsubCategoryEntity> prosubCategoryEntities = this.prosubCategoryMapper.queryByInnerCodes(tenantId, ids);
            ids.clear();
            prosubCategoryEntities.forEach(item -> {
                ids.add(item.getId());
                this.prosubItemService.updateByCategoryId(item.getId(), entity.getSubjectIds(), entity.getSubjectNames(), entity.getSubjectRelations());
            });
            this.prosubCategoryMapper.updateSubject(tenantId, entity.getSubjectIds(), entity.getSubjectNames(), ids, entity.getSubjectRelations());
            ProsubCategoryEntity prosubCategoryEntity2 = (ProsubCategoryEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
            if (prosubCategoryEntity2 != null) {
                LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
                lambdaUpdateWrapper.eq(ProsubItemEntity::getCategoryId, (Object)saveorUpdateVO.getId());
                lambdaUpdateWrapper.set(ProsubItemEntity::getCategoryName, (Object)prosubCategoryEntity2.getCategoryName());
                this.prosubItemService.update((Wrapper)lambdaUpdateWrapper);
            }
            ProsubCategoryEntity dbEntity = (ProsubCategoryEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
            ProsubCategoryVO vo = (ProsubCategoryVO)BeanMapper.map((Object)((Object)dbEntity), ProsubCategoryVO.class);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
        }
        entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
        entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
        entity.setId(IdWorker.getId());
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            prosubCategoryEntity = (ProsubCategoryEntity)((Object)this.service.selectById(entity.getParentId()));
            entity.setInnerCode(prosubCategoryEntity.getInnerCode() + "|" + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        this.service.save((Object)entity);
        ProsubCategoryVO vo = (ProsubCategoryVO)BeanMapper.map((Object)((Object)entity), ProsubCategoryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList successList = new ArrayList();
        ArrayList<ProsubCategoryImportVO> processList = new ArrayList<ProsubCategoryImportVO>();
        ArrayList<ProsubCategoryImportVO> errorList = new ArrayList<ProsubCategoryImportVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, ArrayList<ProsubCategoryImportVO>> mapChildren = new HashMap<String, ArrayList<ProsubCategoryImportVO>>();
            HashMap<String, ProsubCategoryImportVO> codeToData = new HashMap<String, ProsubCategoryImportVO>();
            HashMap codeNotExistData = new HashMap();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ProsubCategoryImportVO prosubCategoryImportVO = new ProsubCategoryImportVO();
                prosubCategoryImportVO.setId(IdWorker.getId());
                prosubCategoryImportVO.setCategoryCode((String)datas.get(0));
                prosubCategoryImportVO.setParentCode((String)datas.get(1));
                prosubCategoryImportVO.setCategoryName((String)datas.get(2));
                prosubCategoryImportVO.setRemarks((String)datas.get(3));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    prosubCategoryImportVO.setRemarks("\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a\uff01");
                    errorList.add(prosubCategoryImportVO);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    prosubCategoryImportVO.setRemarks("\u5206\u7c7b\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(prosubCategoryImportVO);
                    continue;
                }
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("categoryCode", new Parameter("eq", (Object)String.valueOf(datas.get(0))));
                List list = this.service.queryList(queryParam, false);
                if (ListUtil.isEmpty((List)list)) {
                    List<ProsubCategoryImportVO> list1;
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        prosubCategoryImportVO.setInnerCode(prosubCategoryImportVO.getId().toString());
                    }
                    prosubCategoryImportVO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    prosubCategoryImportVO.setCreateTime(new Date());
                    prosubCategoryImportVO.setTenantId(InvocationInfoProxy.getTenantid());
                    processList.add(prosubCategoryImportVO);
                    codeToData.put(prosubCategoryImportVO.getCategoryCode(), prosubCategoryImportVO);
                    if (StringUtils.isBlank((CharSequence)prosubCategoryImportVO.getParentCode())) {
                        list1 = (ArrayList<ProsubCategoryImportVO>)mapChildren.get("null");
                        if (ListUtil.isEmpty((List)list1)) {
                            list1 = new ArrayList<ProsubCategoryImportVO>();
                            mapChildren.put("null", (ArrayList<ProsubCategoryImportVO>)list1);
                        }
                        list1.add(prosubCategoryImportVO);
                        continue;
                    }
                    list1 = (List)mapChildren.get(prosubCategoryImportVO.getParentCode());
                    if (ListUtil.isEmpty((List)list1)) {
                        list1 = new ArrayList();
                        mapChildren.put(prosubCategoryImportVO.getParentCode(), (ArrayList<ProsubCategoryImportVO>)list1);
                    }
                    list1.add(prosubCategoryImportVO);
                    continue;
                }
                prosubCategoryImportVO.setRemarks("\u5206\u7c7b\u7f16\u7801\u91cd\u590d\uff01");
                errorList.add(prosubCategoryImportVO);
            }
            if (ListUtil.isNotEmpty(processList)) {
                processList.forEach(p -> {
                    if (p.getCategoryCode().equals(p.getParentCode())) {
                        p.setRemarks("\u5206\u7c7b\u7f16\u7801\u548c\u7236\u5206\u7c7b\u7f16\u7801\u4e00\u81f4");
                        errorList.add((ProsubCategoryImportVO)p);
                    } else if (StringUtils.isNotEmpty((CharSequence)p.getParentCode())) {
                        ProsubCategoryImportVO parentVo = (ProsubCategoryImportVO)codeToData.get(p.getParentCode());
                        if (parentVo == null) {
                            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)codeNotExistData.get(p.getParentCode())))) {
                                p.setRemarks("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                errorList.add((ProsubCategoryImportVO)p);
                            } else {
                                QueryParam queryParam = new QueryParam();
                                queryParam.getParams().put("categoryCode", new Parameter("eq", (Object)p.getParentCode()));
                                List list = this.service.queryList(queryParam, false);
                                if (ListUtil.isEmpty((List)list)) {
                                    codeNotExistData.put(p.getParentCode(), p.getParentCode());
                                    p.setRemarks("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                    errorList.add((ProsubCategoryImportVO)p);
                                } else {
                                    p.setInnerCode(((ProsubCategoryEntity)((Object)((Object)list.get(0)))).getInnerCode() + "|" + p.getId());
                                    p.setParentId(((ProsubCategoryEntity)((Object)((Object)list.get(0)))).getId());
                                    successList.add(p);
                                }
                            }
                        } else if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                            this.setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
                            if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                                p.setRemarks("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                errorList.add((ProsubCategoryImportVO)p);
                            } else {
                                p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                                p.setParentId(parentVo.getId());
                                successList.add(p);
                            }
                        } else {
                            p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                            p.setParentId(parentVo.getId());
                            successList.add(p);
                        }
                    } else {
                        successList.add(p);
                    }
                });
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public void updateSubject(String subjectIds, String subjectNames, List<Long> ids, String subjectRelations) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<ProsubCategoryEntity> prosubCategoryEntities = this.prosubCategoryMapper.queryByInnerCodes(tenantId, ids);
        ids.clear();
        prosubCategoryEntities.forEach(item -> {
            ids.add(item.getId());
            this.prosubItemService.updateByCategoryId(item.getId(), subjectIds, subjectNames, subjectRelations);
        });
        this.prosubCategoryMapper.updateSubject(tenantId, subjectIds, subjectNames, ids, subjectRelations);
    }

    @Override
    public List<Map> queryMajorSubList(QueryWrapper wrapper) {
        return ((ProsubCategoryMapper)this.baseMapper).queryMajorSubList(wrapper);
    }

    @Override
    public List<ProsubCategoryVO> queryCategoryListByIds(List<Long> ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(CollectionUtils.isNotEmpty(ids), BaseEntity::getId, ids);
        List prosubCategoryEntityList = this.list((Wrapper)queryWrapper);
        if (prosubCategoryEntityList != null && prosubCategoryEntityList.size() > 0) {
            return BeanMapper.mapList((Iterable)prosubCategoryEntityList, ProsubCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<ProsubCategoryEntity> queryListByPids(List<Long> asList) {
        return this.prosubCategoryMapper.queryByInnerCodes(InvocationInfoProxy.getTenantid(), asList);
    }

    @Override
    public void getDefaultSubject(List<ProsubCategoryVO> prosubCategoryVOS, Long projectId) {
        ProjectSetPoolEntity project = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(projectId));
        if (null != project.getSubjectOrgCategoryId()) {
            ArrayList subjectIds = new ArrayList(prosubCategoryVOS.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getSubjectIds())).map(item -> item.getSubjectIds()).flatMap(idStr -> Arrays.stream(idStr.split(","))).map(id -> Long.valueOf(id)).collect(Collectors.toSet()));
            if (CollectionUtils.isEmpty(subjectIds)) {
                return;
            }
            List subjectList = (List)this.subjectOrgService.listByIds(subjectIds);
            if (CollectionUtils.isNotEmpty((Collection)subjectList)) {
                Map<Long, SubjectOrgEntity> subjectMap = subjectList.stream().filter(item -> null != item.getCategoryId() && project.getSubjectOrgCategoryId().equals(item.getCategoryId())).collect(Collectors.toMap(item -> item.getId(), item -> item));
                SubjectOrgEntity tmpSubject = null;
                for (ProsubCategoryVO m : prosubCategoryVOS) {
                    if (StringUtils.isBlank((CharSequence)m.getSubjectIds())) continue;
                    for (String subjectIdStr : m.getSubjectIds().split(",")) {
                        tmpSubject = subjectMap.get(Long.valueOf(subjectIdStr));
                        if (null == tmpSubject) continue;
                        m.setSubjectId(tmpSubject.getId());
                        m.setSubjectName(tmpSubject.getSubjectName());
                    }
                }
            }
        }
    }

    @Override
    public List<ProsubCategoryVO> queryAllByCodes(List<String> categoryCodes) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"category_code", categoryCodes);
        List categoryEntityList = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)categoryEntityList)) {
            return BeanMapper.mapList((Iterable)categoryEntityList, ProsubCategoryVO.class);
        }
        return new ArrayList<ProsubCategoryVO>();
    }

    private void setInnerCodeAndParentId(ProsubCategoryImportVO vo, Map<String, ProsubCategoryImportVO> codeToData, Map<String, String> codeNotExistData) {
        ProsubCategoryImportVO parentVo = codeToData.get(vo.getParentCode());
        if (parentVo == null) {
            if (StringUtils.isNotEmpty((CharSequence)codeNotExistData.get(vo.getParentCode()))) {
                vo.setRemarks("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("categoryCode", new Parameter("eq", (Object)vo.getParentCode()));
                List list = this.service.queryList(queryParam, false);
                if (ListUtil.isEmpty((List)list)) {
                    codeNotExistData.put(vo.getParentCode(), vo.getParentCode());
                    vo.setRemarks("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                } else {
                    vo.setInnerCode(((ProsubCategoryEntity)((Object)list.get(0))).getInnerCode() + "|" + vo.getId());
                    vo.setParentId(((ProsubCategoryEntity)((Object)list.get(0))).getId());
                }
            }
        } else if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
            this.setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
            if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                vo.setRemarks("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
                vo.setParentId(parentVo.getId());
            }
        } else {
            vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
            vo.setParentId(parentVo.getId());
        }
    }
}

