package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.*;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipCategoryParam;
import com.ejianc.foundation.share.controller.param.YnsbjMaterialAndEquipParam;
import com.ejianc.foundation.share.controller.resp.YnsbjDataInfo;
import com.ejianc.foundation.share.enums.MaterialFuzzyMatchEnum;
import com.ejianc.foundation.share.mapper.EquipmentCategoryMapper;
import com.ejianc.foundation.share.mapper.EquipmentMapper;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.mapper.MaterialMapper;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.MaterialFuzzyMatchVO;
import com.ejianc.foundation.share.vo.MaterialPlusVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;

import com.google.common.base.Stopwatch;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.concurrent.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Service
@Transactional
public class MaterialServiceImpl implements IMaterialService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private MaterialMapper materialMapper;
	@Autowired
	private EquipmentMapper equipmentMapper;
	@Autowired
	private MaterialCategoryMapper materialCategoryMapper;
	@Autowired
	private EquipmentCategoryMapper equipmentCategoryMapper;

	@Autowired
	private IProjectSetService projectSetService;

	@Autowired
	private ISubjectOrgService subjectOrgService;

	private static final ExecutorService executorService = new ThreadPoolExecutor(
			8, 8, 0L, TimeUnit.MILLISECONDS,
			new LinkedBlockingDeque<>(1024),
			new CustomizableThreadFactory("fuzzyMatch-pool-"),
			new ThreadPoolExecutor.AbortPolicy()
	);

	@Override
	public List<MaterialVO> queryListByCategoryId(Long categoryId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialEntity> entities = materialMapper.queryListByCategoryId(tenantId, categoryId);
		if(entities != null && entities.size() > 0) {
			return BeanMapper.mapList(entities, MaterialVO.class);
		}
		return null;
	}

	@Override
	public CommonResponse updateByCategoryId(Long categoryId, String subjectIds, String subjectNames, String subjectRelations) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		int i = materialMapper.updateByCategoryId(tenantId, categoryId, subjectIds, subjectNames, subjectRelations, null, null);
		return CommonResponse.success();
	}

	@Override
	public CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		int i = materialMapper.updateCategoryCodeByCategoryId(tenantId, categoryId, categoryCode, null, null);
		return CommonResponse.success();
	}

	@Override
	public CommonResponse updateCategoryCodeByCategoryId(Long categoryId, String categoryCode, Long financialId, String financialName) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		int i = materialMapper.updateCategoryCodeByCategoryId(tenantId, categoryId, categoryCode, financialId, financialName);
		return CommonResponse.success();
	}
	@Override
	public MaterialVO queryDetail(Long id) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MaterialEntity entity = materialMapper.queryDetail(tenantId, id);
		if(entity != null) {
			return BeanMapper.map(entity, MaterialVO.class);
		}
		return null;
	}


	@Override
	public List<MaterialVO> queryItem(List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialEntity> materialEntities = materialMapper.queryItem(tenantId, ids);
		if(materialEntities != null && materialEntities.size() > 0) {
			return BeanMapper.mapList(materialEntities, MaterialVO.class);
		}
		return null;
	}

	@Override
	public void update(MaterialVO uniqueBean) {
		materialMapper.update(uniqueBean);
	}

	@Override
	public void updateSubject(Long subjectId, String subjectName, List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialEntity> materialEntities = materialMapper.queryMaterialByIds(ids,tenantId);
		List<MaterialVO> list = new ArrayList<>();
		materialEntities.forEach(entity -> list.add(BeanMapper.map(entity, MaterialVO.class)));
		list.forEach(vo -> {
			vo.setSubjectId(subjectId);
			vo.setSubjectName(subjectName);
		});
		list.forEach(vo -> {
			materialMapper.update(vo);
		});
	}

	@Override
	public void updateFinancial(Long financialId, String financialName, List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialEntity> materialEntities = materialMapper.queryMaterialByIds(ids,tenantId);
		List<MaterialVO> list = new ArrayList<>();
		materialEntities.forEach(entity -> list.add(BeanMapper.map(entity, MaterialVO.class)));
		list.forEach(vo -> {
			vo.setFinancialId(financialId);
			vo.setFinancialName(financialName);
		});
		list.forEach(vo -> {
			materialMapper.update(vo);
		});
	}

	@Override
	public void save(MaterialVO materialVo) {
		materialMapper.save(materialVo);
	}

	/**
	 * 批量保存
	 *
	 * @param materialVOList
	 */
	@Override
	public void insertBatch(List<MaterialVO> materialVOList) {
		if(ListUtil.isNotEmpty(materialVOList)){
			List<MaterialVO> toInsert = new ArrayList<>();
			for (MaterialVO materialVO : materialVOList) {
				if (toInsert.size()>0 && toInsert.size() % 1000 == 0) {
					materialMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
					toInsert = new ArrayList<>();
				}
				toInsert.add(materialVO);
			}
			if(toInsert.size()>0){
				materialMapper.insertBatch(InvocationInfoProxy.getTenantid(),toInsert);
			}
		}
	}

	/**
	 * 批量保存
	 *
	 * @param materialVOList
	 */
	@Override
	public void insertBatch(List<MaterialVO> materialVOList, Long tenantId) {
		if(ListUtil.isNotEmpty(materialVOList)){
			List<MaterialVO> toInsert = new ArrayList<>();
			for (MaterialVO materialVO : materialVOList) {
				if (toInsert.size()>0 && toInsert.size() % 1000 == 0) {
					materialMapper.insertBatch(tenantId, toInsert);
					toInsert = new ArrayList<>();
				}
				toInsert.add(materialVO);
			}
			if(toInsert.size()>0){
				materialMapper.insertBatch(tenantId, toInsert);
			}
		}
	}

	@Override
	public void amend(Long id,Long property,String propertyName) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialMapper.amend(id,property,propertyName,tenantId);
	}

	@Override
	public void delete(List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		for(Long id:ids) {
			materialMapper.delete(tenantId, id);
		}
	}

	@Override
	public IPage<MaterialEntity> queryPage(QueryParam queryParam) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			if("categoryId".equals(entry.getKey())) {
				Parameter parameter = entry.getValue();
				if(StringUtils.isBlank(parameter.getValue()+"")) {
					continue;
				}
				Object value = parameter.getValue();
				if (value==null){
					continue;
				}
				MaterialCategoryEntity categoryEntity = materialCategoryMapper.queryDetail(tenantId, Long.parseLong(parameter.getValue().toString()));
				if(categoryEntity != null) {
					condition.put("innerCode", categoryEntity.getInnerCode());
				}
			}else{
				condition.put(entry.getKey(), entry.getValue().getValue());
			}
		}
		condition.put("pageIndex", (queryParam.getPageIndex()-1)*queryParam.getPageSize());
		condition.put("pageSize", queryParam.getPageSize());

		List<MaterialEntity> records = materialMapper.queryList(condition);
		Long count = materialMapper.queryCount(condition);

		IPage<MaterialEntity> page = new Page<>();
		page.setCurrent(queryParam.getPageIndex());
		page.setSize(queryParam.getPageSize());
		page.setTotal(count);
		page.setRecords(records);
		return page;
	}

	@Override
	public MaterialVO queryExitFlag(String name, String spec, String unitName, Long categoryId) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		MaterialVO materialVo = materialMapper.queryExitFlag(tenantId, name, spec, unitName, categoryId);
		return materialVo;
	}

	@Override
	public List<MaterialVO> queryExcelFlag(String name, String spec, String unitName, String categoryName) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialVO> list = materialMapper.queryExcelFlag(tenantId, name, spec, unitName, categoryName);
		return list;
	}

	/**
	 * 根据code查询物料
	 *
	 * @param code
	 * @return
	 */
	@Override
	public MaterialVO queryByCode(String code) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		return materialMapper.queryByCode(tenantId, code);
	}

	@Override
	public List<MaterialEntity> queryList(QueryParam queryParam) {
		Map<String, Parameter> paramMap = queryParam.getParams();

		Map<String, Object> condition = new HashMap<String, Object>();
		for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
			condition.put(entry.getKey(), entry.getValue().getValue());
		}
		List<MaterialEntity> records = materialMapper.queryExportList(condition);
		return records;
	}

	@Override
	public void insertMaterialListFromPlatform() {
		Long tenantId = InvocationInfoProxy.getTenantid();
		materialMapper.insertMaterialListFromPlatform(tenantId);
	}

	@Override
	public IPage<MaterialVO> queryRefMaterialPage(Map<String, Object> params) {
		List<MaterialEntity> dataList = materialMapper.queryRefMaterialList(params);
		Long dataCount = materialMapper.queryRefMaterialCount(params);
		List<MaterialVO> materialVOS = BeanMapper.mapList(dataList, MaterialVO.class);
		IPage<MaterialVO> page = new Page<>();
		page.setRecords(materialVOS);

		page.setTotal(dataCount);
		return page;
	}

	@Override
	public MaterialEntity queryBySourceId(String sourceId) {
		return materialMapper.queryBySourceId(sourceId,InvocationInfoProxy.getTenantid());
	}

	@Override
	public List<MaterialEntity> queryMaterialByIds(List<Long> ids) {
		return materialMapper.queryMaterialByIds(ids,InvocationInfoProxy.getTenantid());
	}

	@Override
	public IPage<MaterialEntity> queryZjwjRefMaterialPage(Map<String, Object> params) {
		IPage<MaterialEntity> page = new Page<>();
		if (params.containsKey("sourceOrgId") && null !=params.get("sourceOrgId")) {
			List<MaterialEntity> dataList = materialMapper.queryZjwjRefMaterialList(params);
			Long dataCount = materialMapper.queryZjwjRefMaterialCount(params);
			page.setRecords(dataList);
			page.setTotal(dataCount);
		}
		return page;
	}

	/**
	 * 保存或修改物料和设备分类
	 *
	 * @param categoryParam
	 * @return
	 */
	@Override
	public YnsbjDataInfo saveOrUpdateYnsbjMaterialAndEquipCategory(YnsbjMaterialAndEquipCategoryParam categoryParam) {
		String categoryCode = categoryParam.getCategoryCode();
		System.out.println("云南物资设备分类参数：---"+JSONObject.toJSONString(categoryParam));
		if(StringUtils.isNotBlank(categoryCode)) {
			String prefixCode = categoryCode.substring(0, 1);
			if("1".equals(prefixCode)) { //物料分类
				//根据code查看当前分类是否存在，如果存在则修改
				List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryByCode(999999L, categoryCode);
				MaterialCategoryEntity materialCategory = null;
				String operateMethod="";
				if(materialCategoryList != null && materialCategoryList.size() > 0) {
					materialCategory = materialCategoryList.get(0);
					materialCategory.setName(categoryParam.getCategoryName());
					materialCategory.setDescription(categoryParam.getDescription());
					if(StringUtils.isNotBlank(categoryParam.getState())) {
						if("正常".equals(categoryParam.getState())){
							materialCategory.setEnabled(1);
						}else {
							materialCategory.setEnabled(2);
						}
					}else {
						materialCategory.setEnabled(1);
					}
					operateMethod = "update";
				}else{
					materialCategory = new MaterialCategoryEntity();
					materialCategory.setId(IdWorker.getId());
					materialCategory.setCode(categoryParam.getCategoryCode());
					materialCategory.setName(categoryParam.getCategoryName());
					materialCategory.setDescription(categoryParam.getDescription());
					if(StringUtils.isNotBlank(categoryParam.getState())) {
						if("正常".equals(categoryParam.getState())){
							materialCategory.setEnabled(1);
						}else {
							materialCategory.setEnabled(2);
						}
					}else {
						materialCategory.setEnabled(1);
					}
					operateMethod="add";
				}
				MaterialCategoryEntity parentMaterialCategory = null;
				if(StringUtils.isNotBlank(categoryParam.getParentCode())) {
					List<MaterialCategoryEntity> parentMaterialCategoryList = materialCategoryMapper.queryByCode(999999L, categoryParam.getParentCode());
					if(parentMaterialCategoryList != null && parentMaterialCategoryList.size() > 0) {
						parentMaterialCategory = parentMaterialCategoryList.get(0);
					}
					if(parentMaterialCategory != null) {
						materialCategory.setParentId(parentMaterialCategory.getId());
						materialCategory.setInnerCode(parentMaterialCategory.getInnerCode()+"|"+materialCategory.getId());
					}else {
						materialCategory.setInnerCode("有上级，但是没有先推过来，没查到，所以成了现在这样子");
					}
				}else {
					materialCategory.setInnerCode(materialCategory.getId()+"");

				}
				materialCategory.setTenantId(999999L);
				if("add".equals(operateMethod)) {
					materialCategoryMapper.insert(materialCategory);
				}else{
					materialCategoryMapper.update(materialCategory);
				}
			} else { //设备分类
				//根据code查看当前分类是否存在，如果存在则修改
				List<EquipmentCategoryEntity> equipmentCategoryList = equipmentCategoryMapper.queryByCode(999999L, categoryCode);
				EquipmentCategoryEntity equipmentCategory = null;
				String operateMethod="";
				if(equipmentCategoryList != null && equipmentCategoryList.size() > 0) {
					equipmentCategory = equipmentCategoryList.get(0);
					equipmentCategory.setName(categoryParam.getCategoryName());
					equipmentCategory.setDescription(categoryParam.getDescription());
					if(StringUtils.isNotBlank(categoryParam.getState())) {
						if("正常".equals(categoryParam.getState())){
							equipmentCategory.setEnabled(1);
						}else {
							equipmentCategory.setEnabled(2);
						}
					}else {
						equipmentCategory.setEnabled(1);
					}
					operateMethod = "update";
				}else{
					equipmentCategory = new EquipmentCategoryEntity();
					equipmentCategory.setId(IdWorker.getId());
					equipmentCategory.setCode(categoryParam.getCategoryCode());
					equipmentCategory.setName(categoryParam.getCategoryName());
					equipmentCategory.setDescription(categoryParam.getDescription());
					if(StringUtils.isNotBlank(categoryParam.getState())) {
						if("正常".equals(categoryParam.getState())){
							equipmentCategory.setEnabled(1);
						}else {
							equipmentCategory.setEnabled(2);
						}
					}else {
						equipmentCategory.setEnabled(1);
					}
					operateMethod="add";
				}
				EquipmentCategoryEntity parentEquipmentCategory = null;
				if(StringUtils.isNotBlank(categoryParam.getParentCode())) {
					System.out.println("云南设备分类上级1：---"+parentEquipmentCategory);
					List<EquipmentCategoryEntity> parentMaterialCategoryList = equipmentCategoryMapper.queryByCode(999999L, categoryParam.getParentCode());
					if(parentMaterialCategoryList != null && parentMaterialCategoryList.size() > 0) {
						parentEquipmentCategory = parentMaterialCategoryList.get(0);
					}
					System.out.println("云南设备分类上级2：---"+JSONObject.toJSONString(parentMaterialCategoryList));
					if(parentEquipmentCategory != null) {
						System.out.println("云南设备分类上级3：---"+JSONObject.toJSONString(parentEquipmentCategory));
						equipmentCategory.setParentId(parentEquipmentCategory.getId());
						equipmentCategory.setInnerCode(parentEquipmentCategory.getInnerCode()+"|"+equipmentCategory.getId());
						System.out.println("云南设备分类上级4InnerCode：---"+equipmentCategory.getInnerCode());
					}else {
						equipmentCategory.setInnerCode("有上级，但是没有先推过来，没查到，所以成了现在这样子");
					}
				}else {
					System.out.println("云南设备分类没有上级：---");
					equipmentCategory.setInnerCode(""+equipmentCategory.getId());
					System.out.println("云南设备分类没有上级InnerCode：---"+equipmentCategory.getInnerCode());
				}
				equipmentCategory.setTenantId(999999L);
				equipmentCategory.setSystemId("ZHUSHUJU");
				equipmentCategory.setSourceId(categoryParam.getCategoryCode());
				if("add".equals(operateMethod)) {
					System.out.println("云南设备分类保存：---"+JSONObject.toJSONString(equipmentCategory));
					equipmentCategoryMapper.insert(equipmentCategory);
				}else{
					System.out.println("云南设备分类更新：---"+JSONObject.toJSONString(equipmentCategory));
					equipmentCategoryMapper.update(equipmentCategory);
				}
			}
		}
		YnsbjDataInfo dataInfo = new YnsbjDataInfo(categoryParam.getUuid(), categoryParam.getMasterDataCode(), "0", "");
		return dataInfo;
	}

	/**
	 * 保存或修改物料和设备
	 *
	 * @param ynsbjMaterialAndEquipParam
	 * @return
	 */
	@Override
	public YnsbjDataInfo saveOrUpdateYnsbjMaterialAndEquip(YnsbjMaterialAndEquipParam ynsbjMaterialAndEquipParam) {
		YnsbjDataInfo dataInfo = null;
		String materialAndEquipCode = ynsbjMaterialAndEquipParam.getMaterialAndEquipCode();
		if(StringUtils.isNotBlank(materialAndEquipCode)) {
			String prefixCode = materialAndEquipCode.substring(0, 1);
			if("1".equals(prefixCode)) { //物资
				String categoryCode = ynsbjMaterialAndEquipParam.getCategoryCode();
				List<MaterialCategoryEntity> materialCategoryList = materialCategoryMapper.queryByCode(999999l, categoryCode);
				if(materialCategoryList != null && materialCategoryList.size() > 0) {
					MaterialCategoryEntity materialCategoryEntity = materialCategoryList.get(0);

					String sourceId = ynsbjMaterialAndEquipParam.getMasterDataCode();
					MaterialEntity materialEntity = materialMapper.queryBySourceId(sourceId, 999999l);
					if(materialEntity != null) {
						materialEntity.setCategoryId(materialCategoryEntity.getId());
						materialEntity.setCategoryCode(materialCategoryEntity.getCode());
						materialEntity.setCategoryName(materialCategoryEntity.getName());
						materialEntity.setCode(ynsbjMaterialAndEquipParam.getMaterialAndEquipCode());
						materialEntity.setName(ynsbjMaterialAndEquipParam.getMaterialAndEquipName());
						materialEntity.setSpec(ynsbjMaterialAndEquipParam.getMaterialAndEquipModel());
						materialEntity.setUnitName(ynsbjMaterialAndEquipParam.getUnitName());
						materialEntity.setTenantId(999999L);

						MaterialVO materialVo = BeanMapper.map(materialEntity, MaterialVO.class);
						materialMapper.update(materialVo);
					}else{
						materialEntity = new MaterialEntity();
						materialEntity.setId(IdWorker.getId());
						materialEntity.setTenantId(999999L);
						materialEntity.setCategoryId(materialCategoryEntity.getId());
						materialEntity.setCategoryCode(materialCategoryEntity.getCode());
						materialEntity.setCategoryName(materialCategoryEntity.getName());
						materialEntity.setCode(ynsbjMaterialAndEquipParam.getMaterialAndEquipCode());
						materialEntity.setName(ynsbjMaterialAndEquipParam.getMaterialAndEquipName());
						materialEntity.setSpec(ynsbjMaterialAndEquipParam.getMaterialAndEquipModel());
						materialEntity.setUnitName(ynsbjMaterialAndEquipParam.getUnitName());
						materialEntity.setSourceId(ynsbjMaterialAndEquipParam.getMasterDataCode());

						MaterialVO materialVo = BeanMapper.map(materialEntity, MaterialVO.class);
						materialMapper.save(materialVo);
					}
					dataInfo = new YnsbjDataInfo(ynsbjMaterialAndEquipParam.getUuid(), ynsbjMaterialAndEquipParam.getMasterDataCode(), "0", "");
				}else{
					dataInfo = new YnsbjDataInfo(ynsbjMaterialAndEquipParam.getUuid(), ynsbjMaterialAndEquipParam.getMasterDataCode(), "1", "物料："+ynsbjMaterialAndEquipParam.getMaterialAndEquipName()+"所属分类为空！");
				}
			}else{ //设备
				String categoryCode = ynsbjMaterialAndEquipParam.getCategoryCode();
				List<EquipmentCategoryEntity> equipmentCategoryList = equipmentCategoryMapper.queryByCode(999999l, categoryCode);
				if(equipmentCategoryList != null && equipmentCategoryList.size() > 0) {
					EquipmentCategoryEntity equipmentCategoryEntity = equipmentCategoryList.get(0);

					String sourceId = ynsbjMaterialAndEquipParam.getMasterDataCode();
					EquipmentEntity equipmentEntity = equipmentMapper.queryBySourceId(sourceId, 999999l);
					if(equipmentEntity != null) {
						equipmentEntity.setCategoryId(equipmentCategoryEntity.getId());
						equipmentEntity.setCategoryName(equipmentCategoryEntity.getName());
						equipmentEntity.setCode(ynsbjMaterialAndEquipParam.getMaterialAndEquipCode());
						equipmentEntity.setName(ynsbjMaterialAndEquipParam.getMaterialAndEquipName());
						equipmentEntity.setSpec(ynsbjMaterialAndEquipParam.getMaterialAndEquipModel());
						equipmentEntity.setUnitName(ynsbjMaterialAndEquipParam.getUnitName());
						equipmentEntity.setTenantId(999999L);

						EquipmentVO equipmentVo = BeanMapper.map(equipmentEntity, EquipmentVO.class);
						equipmentMapper.update(equipmentVo);
					}else{
						equipmentEntity = new EquipmentEntity();
						equipmentEntity.setId(IdWorker.getId());
						equipmentEntity.setCategoryId(equipmentCategoryEntity.getId());
						equipmentEntity.setCategoryName(equipmentCategoryEntity.getName());
						equipmentEntity.setCode(ynsbjMaterialAndEquipParam.getMaterialAndEquipCode());
						equipmentEntity.setName(ynsbjMaterialAndEquipParam.getMaterialAndEquipName());
						equipmentEntity.setSpec(ynsbjMaterialAndEquipParam.getMaterialAndEquipModel());
						equipmentEntity.setUnitName(ynsbjMaterialAndEquipParam.getUnitName());
						equipmentEntity.setSourceId(ynsbjMaterialAndEquipParam.getMasterDataCode());
						equipmentEntity.setSystemId("ZHUSHUJU");
						equipmentEntity.setTenantId(999999L);

						EquipmentVO equipmentVo = BeanMapper.map(equipmentEntity, EquipmentVO.class);
						equipmentMapper.save(equipmentVo);
					}
					dataInfo = new YnsbjDataInfo(ynsbjMaterialAndEquipParam.getUuid(), ynsbjMaterialAndEquipParam.getMasterDataCode(), "0", "");
				}else{
					dataInfo = new YnsbjDataInfo(ynsbjMaterialAndEquipParam.getUuid(), ynsbjMaterialAndEquipParam.getMasterDataCode(), "1", "物料："+ynsbjMaterialAndEquipParam.getMaterialAndEquipName()+"所属分类为空！");
				}
			}
		}
		return dataInfo;
	}

	@Override
	public List<MaterialVO> queryMaterialListByCodes(List<String> codeList) {
		Map<String, Object> params = new HashMap<>();
		Long tenantId = InvocationInfoProxy.getTenantid();
		params.put("tenantId", tenantId);
		params.put("codeList", codeList);
		List<MaterialEntity> materialEntities = materialMapper.queryMaterialListByCodes(params);
		if(materialEntities != null && materialEntities.size() > 0) {
			return BeanMapper.mapList(materialEntities, MaterialVO.class);
		}
		return null;
	}

	@Override
	public List<MaterialVO> queryMaterialListByCodes(List<String> codeList, Long tenantId) {
		Map<String, Object> params = new HashMap<>();
		params.put("tenantId", tenantId);
		params.put("codeList", codeList);
		List<MaterialEntity> materialEntities = materialMapper.queryMaterialListByCodes(params);
		if(materialEntities != null && materialEntities.size() > 0) {
			return BeanMapper.mapList(materialEntities, MaterialVO.class);
		}
		return null;
	}

	@Override
	public void updateFinancialByCategoryIds(Long financialId, String financialName, List<Long> categoryIds) {
		materialMapper.updateFinancialByCategoryIds(financialId, financialName, categoryIds, InvocationInfoProxy.getTenantid());
	}

	/**
	 * 校验档案是否存在
	 *
	 * @param materialFuzzyMatchVO 材料设备模糊匹配VO
	 *
	 * @return {@link MaterialFuzzyMatchVO}
	 */
	@Override
	public MaterialFuzzyMatchVO checkArchive(MaterialFuzzyMatchVO materialFuzzyMatchVO) {
		Stopwatch stopwatch = Stopwatch.createStarted();
		logger.info("校验档案是否存在----start");

		Long tenantId = InvocationInfoProxy.getTenantid();

		List<CompletableFuture<Map<String, Boolean>>> futures1 = new ArrayList<>();
		List<CompletableFuture<Map<String, Boolean>>> futures2 = new ArrayList<>();


		// 材料档案
		Map<String, Boolean> materialCategoryMap = materialFuzzyMatchVO.getMaterialCategoryMap();
		if (null != materialCategoryMap && !materialCategoryMap.isEmpty()) {
			for (Map.Entry<String, Boolean> entry : materialCategoryMap.entrySet()) {
				CompletableFuture<Map<String, Boolean>> materialCategoryFuture = CompletableFuture.supplyAsync(() -> {
					logger.info("材料档案，当前线程为：{}", Thread.currentThread().getName());
					HashMap<String, Boolean> hashMap = new HashMap<>();
					Long count = materialCategoryMapper.checkArchive(tenantId, 1, entry.getKey());
					hashMap.put(entry.getKey(), count.compareTo(0L) > 0);
					return hashMap;
				}, executorService);
				futures1.add(materialCategoryFuture);
			}
		}

		// 设备档案
		Map<String, Boolean> equipmentCategoryMap = materialFuzzyMatchVO.getEquipmentCategoryMap();
		if (null != equipmentCategoryMap && !equipmentCategoryMap.isEmpty()) {
			for (Map.Entry<String, Boolean> entry : equipmentCategoryMap.entrySet()) {
				CompletableFuture<Map<String, Boolean>> equipmentCategoryFuture = CompletableFuture.supplyAsync(() -> {
					logger.info("设备档案，当前线程为：{}", Thread.currentThread().getName());
					HashMap<String, Boolean> hashMap = new HashMap<>();
					Long count = materialCategoryMapper.checkArchive(tenantId, 2, entry.getKey());
					hashMap.put(entry.getKey(), count.compareTo(0L) > 0);
					return hashMap;
				}, executorService);
				futures2.add(equipmentCategoryFuture);
			}
		}

		CompletableFuture.allOf(ArrayUtils.addAll(futures1.toArray(new CompletableFuture[0]), futures2.toArray(new CompletableFuture[0])));

		Map<String, Boolean> materialCategoryResult = new HashMap<>();
		Map<String, Boolean> equipmentCategoryResult = new HashMap<>();
		futures1.forEach(future -> materialCategoryResult.putAll(future.join()));
		futures2.forEach(future -> equipmentCategoryResult.putAll(future.join()));

		MaterialFuzzyMatchVO fuzzyMatchVO = new MaterialFuzzyMatchVO();
		fuzzyMatchVO.setMaterialCategoryMap(materialCategoryResult);
		fuzzyMatchVO.setEquipmentCategoryMap(equipmentCategoryResult);

		stopwatch.stop();
		logger.info("校验档案是否存在----end：已处理材料档案【{}】条数据，共用时【{}】毫秒", materialCategoryMap == null ? 0 : materialCategoryMap.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
		logger.info("校验档案是否存在----end：已处理设备档案【{}】条数据，共用时【{}】毫秒", equipmentCategoryMap == null ? 0 : equipmentCategoryMap.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));

		return fuzzyMatchVO;
	}

	/**
	 * 模糊匹配数量
	 *
	 * @param materialFuzzyMatchVO 材料设备模糊匹配VO
	 *
	 * @return {@link MaterialFuzzyMatchVO}
	 */
	@Override
	public MaterialFuzzyMatchVO fuzzyMatchNumber(MaterialFuzzyMatchVO materialFuzzyMatchVO) {
		Stopwatch stopwatch = Stopwatch.createStarted();
		logger.info("模糊匹配数量----start");

		MaterialFuzzyMatchVO fuzzyMatchVO = new MaterialFuzzyMatchVO();
		Long tenantId = InvocationInfoProxy.getTenantid();

		Map<String, MaterialPlusVO> fuzzyMatchMap = materialFuzzyMatchVO.getFuzzyMatchMap();
		if (null != fuzzyMatchMap && !fuzzyMatchMap.isEmpty()) {

			List<CompletableFuture<Map<String, MaterialPlusVO>>> futures = new ArrayList<>();

			for (Map.Entry<String, MaterialPlusVO> entry : fuzzyMatchMap.entrySet()) {
				CompletableFuture<Map<String, MaterialPlusVO>> future = CompletableFuture.supplyAsync(() -> {
					logger.info("模糊匹配数量，当前线程为：{}", Thread.currentThread().getName());
					HashMap<String, MaterialPlusVO> hashMap = new HashMap<>();
					MaterialPlusVO materialPlusVO = entry.getValue();

					// 清单名称为空，不处理
					String name = materialPlusVO.getName();
					if (StringUtils.isBlank(name)) {
						hashMap.put(entry.getKey(), entry.getValue());
						return hashMap;
					}

					String name1 = handleBlankString(name, false);
					String segmentation = handleSpecialString(name1);
					List<String> names = handleSegmentation(name, segmentation);

					// 费用类型 || 分类名称为空，不处理，不为空去除首尾空格
					Integer type = materialPlusVO.getType();
					if (type == null || StringUtils.isBlank(materialPlusVO.getCategoryName())) {
						hashMap.put(entry.getKey(), entry.getValue());
						return hashMap;
					}
					String categoryName = handleBlankString(materialPlusVO.getCategoryName(), true);

					// 规格型号、单位名称处理空字符串，为空按照空字符处理，不为空去除首尾空格
					String spec = handleBlankString(materialPlusVO.getSpec(), true);
					String unitName = handleBlankString(materialPlusVO.getUnitName(), true);
					String code = StringUtils.isNotEmpty(materialPlusVO.getCode()) ? handleBlankString(materialPlusVO.getCode(), true) : null;
					List<MaterialPlusVO> materialPlusVOS = materialMapper.findFuzzyResultListByLikeOr(tenantId, name, names, type, categoryName, spec, unitName, code);
					if (CollectionUtils.isNotEmpty(materialPlusVOS)) {
						// 根据最高权重判断是否是完全匹配
						MaterialPlusVO plusVO = materialPlusVOS.get(0);
						if (plusVO.getWeight() == 12) {
							// 完全匹配
							MaterialPlusVO vo = BeanMapper.map(plusVO, MaterialPlusVO.class);
							spliceMaterialPlusVO(vo, MaterialFuzzyMatchEnum.MACHED.getCode(), MaterialFuzzyMatchEnum.MACHED.getDesc(), materialPlusVOS.size(), new ArrayList<>());
							entry.setValue(vo);
						} else {
							// 模糊匹配
							spliceMaterialPlusVO(materialPlusVO, MaterialFuzzyMatchEnum.FUZZY_MATCH.getCode(), MaterialFuzzyMatchEnum.FUZZY_MATCH.getDesc() + materialPlusVOS.size() + "条", materialPlusVOS.size(), new ArrayList<>());
							entry.setValue(materialPlusVO);
						}
					} else {
						// 未匹配
						spliceMaterialPlusVO(materialPlusVO, MaterialFuzzyMatchEnum.UN_MATCH.getCode(), MaterialFuzzyMatchEnum.UN_MATCH.getDesc(), 0, new ArrayList<>());
						entry.setValue(materialPlusVO);
					}

					hashMap.put(entry.getKey(), entry.getValue());

					return hashMap;
				}, executorService);
				futures.add(future);
			}

			CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
			Map<String, MaterialPlusVO> fuzzyMatchResult = new HashMap<>();
			futures.forEach(future -> fuzzyMatchResult.putAll(future.join()));
			fuzzyMatchVO.setFuzzyMatchMap(fuzzyMatchResult);
		}

		stopwatch.stop();
		logger.info("模糊匹配数量----end：已处理【{}】条数据，共用时【{}】毫秒", fuzzyMatchMap == null ? 0 : fuzzyMatchMap.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS));

		return fuzzyMatchVO;
	}

	/**
	 * 模糊匹配分页查询
	 *
	 * @param current       当前页码
	 * @param size          条数
	 * @param name          清单名称
	 * @param type          费用类型
	 * @param categoryName  分类名称
	 * @param spec          规格型号
	 * @param unitName      单位名称
	 * @param fuzzyName     清单名称模糊
	 * @param fuzzySpec     规格型号模糊
	 * @param fuzzyUnitName 单位名称模糊
	 *
	 * @return {@link IPage}<{@link MaterialPlusVO}>
	 */
	@Override
	public IPage<MaterialPlusVO> fuzzyMatchQueryPage(long current, long size, String name, Integer type, String categoryName, String spec, String unitName, String fuzzyName, String fuzzySpec, String fuzzyUnitName) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		Page<MaterialPlusVO> page = new Page<>(current, size);

		// 清单名称为空，不处理
		if (StringUtils.isBlank(name)) {
			return null;
		}
		String name1 = handleBlankString(name, false);
		String segmentation = handleSpecialString(name1);
		List<String> names = handleSegmentation(name, segmentation);

		// 费用类型 || 分类名称为空，不处理，不为空去除首尾空格
		if (type == null || StringUtils.isBlank(categoryName)) {
			return null;
		}
		categoryName = handleBlankString(categoryName, true);

		// 规格型号、单位名称处理空字符串，为空按照空字符处理，不为空去除首尾空格
		spec = handleBlankString(spec, true);
		unitName = handleBlankString(unitName, true);

		List<MaterialPlusVO> materialPlusVOS = materialMapper.fuzzyMatchQueryPage(page, tenantId, name, names, type, categoryName, spec, unitName, fuzzyName, fuzzySpec, fuzzyUnitName);
		page.setRecords(materialPlusVOS);
		return page;
	}

	@Override
	public void updateSubject(String subjectIds, String subjectNames, String subjectRelations, List<Long> ids) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialEntity> materialEntities = materialMapper.queryMaterialByIds(ids,tenantId);
		List<MaterialVO> list = new ArrayList<>();
		materialEntities.forEach(entity -> list.add(BeanMapper.map(entity, MaterialVO.class)));
		list.forEach(vo -> {
			vo.setSubjectIds(subjectIds);
			vo.setSubjectNames(subjectNames);
			vo.setSubjectRelations(subjectRelations);
		});
		list.forEach(vo -> {
			materialMapper.update(vo);
		});
	}

	@Override
	public List<MaterialVO> queryItem(List<Long> ids, Long projectId) {
		List<MaterialVO> resp = null;
		Long tenantId = InvocationInfoProxy.getTenantid();
		List<MaterialEntity> materialEntities = materialMapper.queryItem(tenantId, ids);
		if(materialEntities != null && materialEntities.size() > 0) {
			resp = BeanMapper.mapList(materialEntities, MaterialVO.class);
			if(null != projectId) {
				getDefaultSubject(resp, projectId);
			}
		}

		return resp;
	}

	private void getDefaultSubject(List<MaterialVO> materialVOS, Long projectId) {
		ProjectSetPoolEntity project = projectSetService.selectById(projectId);

		if(null != project.getSubjectOrgCategoryId()) {
			List<Long> subjectIds = new ArrayList<>(materialVOS.stream().filter(item -> StringUtils.isNotEmpty(item.getSubjectIds())).map(item ->item.getSubjectIds())
					.flatMap(idStr -> Arrays.stream(idStr.split(","))).map(id -> Long.valueOf(id)).collect(Collectors.toSet()));
			if(CollectionUtils.isEmpty(subjectIds)) {
				return;
			}
			List<SubjectOrgEntity> subjectList = (List<SubjectOrgEntity>) subjectOrgService.listByIds(subjectIds);
			if(CollectionUtils.isNotEmpty(subjectList)) {
				Map<Long, SubjectOrgEntity> subjectMap = subjectList.stream().filter(item -> null != item.getCategoryId()
						&& project.getSubjectOrgCategoryId().equals(item.getCategoryId())).collect(Collectors.toMap(item -> item.getId(), item -> item));

				SubjectOrgEntity tmpSubject = null;
				for(MaterialVO m : materialVOS) {
					if(StringUtils.isBlank(m.getSubjectIds())) {
						continue;
					}
					for(String subjectIdStr : m.getSubjectIds().split(",")) {
						tmpSubject = subjectMap.get(Long.valueOf(subjectIdStr));
						if(null != tmpSubject) {
							m.setSubjectId(tmpSubject.getId());
							m.setSubjectName(tmpSubject.getSubjectName());
						}
					}
				}
			}
		}
	}

	/**
	 * 处理空字符
	 *
	 * @param str  str
	 * @param flag true:只去除首尾空格，false:去除空格和空白字符
	 *
	 * @return {@link String}
	 */
	private static String handleBlankString(String str, boolean flag) {
		if (StringUtils.isBlank(str)) {
			return "";
		}
		if (flag) {
			// 只去除首尾空格
			return str.trim();
		} else {
			// 去除空格和空白字符
			return str.replaceAll("\\s*", "");
		}
	}

	/**
	 * 处理特殊字符串
	 *
	 * @param str str
	 *
	 * @return {@link String}
	 */
	private static String handleSpecialString(String str) {
		// 去除特殊字符和数字，只返回英文和汉字
		Pattern p = Pattern.compile("[^(a-zA-Z\\u4e00-\\u9fa5)]");
		Matcher matcher = p.matcher(str);
		return matcher.replaceAll("");
	}

	/**
	 * 字符串分词
	 *
	 * @param oldStr 老str
	 * @param str    str
	 *
	 * @return {@link List}<{@link String}>
	 */
	private static List<String> handleSegmentation(String oldStr, String str) {
		List<String> strings = new ArrayList<>();
		strings.add(oldStr);

		if (StringUtils.isBlank(str)) {
			return strings;
		}

		// 英文单词
		List<String> english = new ArrayList<>();
		String pattern = "([a-zA-Z_]+)";
		Pattern p = Pattern.compile(pattern);
		Matcher m = p.matcher(str);
		while (m.find()) {
			english.add(m.group());
		}
		String ss = str.replaceAll(pattern, "#");

		int index = 0;
		for (int i = 0, length = ss.length(), len = length - 1; i < length; i++) {
			char c1 = ss.charAt(i);
			if (i + 1 < len) {
				char c2 = ss.charAt(i + 1);
				// 当前是#，后一个是汉字
				// 当前是汉字，后一个是汉字
				// 当前是汉字，后一个是#
				if ('#' == c1 && chineseYes(c2)) {
					String s = english.get(index) + c2;
					strings.add(s);
					index += 1;
				}
				if (chineseYes(c1) && chineseYes(c2)) {
					String s = String.valueOf(c1) + c2;
					strings.add(s);
				}
				if (chineseYes(c1) && '#' == c2) {
					String s = c1 + english.get(index);
					strings.add(s);
				}
			} else {
				// 特殊处理一下最后的数据
				String s = ss.substring(i);
				if (s.contains("#")) {
					s = s.replace("#", english.get(index));
				}
				strings.add(s);
				break;
			}
		}
		return strings;
	}

	/**
	 * 是否是中文
	 *
	 * @param ch ch
	 *
	 * @return boolean
	 */
	public static boolean chineseYes(char ch) {
		return String.valueOf(ch).matches("[\\u4e00-\\u9fa5]");
	}

	/**
	 * 拼接匹配相关参数
	 *
	 * @param materialPlusVO         材料设备增强VO
	 * @param matchStatus            匹配状态
	 * @param matchStatusDescription 匹配状态描述
	 * @param matchNumber            模糊匹配数量
	 * @param fuzzyMatchList         模糊匹配列表
	 */
	private static void spliceMaterialPlusVO(MaterialPlusVO materialPlusVO, Integer matchStatus, String matchStatusDescription, Integer matchNumber, List<MaterialPlusVO> fuzzyMatchList) {
		materialPlusVO.setMatchStatus(matchStatus);
		materialPlusVO.setMatchStatusDescription(matchStatusDescription);
		materialPlusVO.setMatchNumber(matchNumber);
		materialPlusVO.setFuzzyMatchList(fuzzyMatchList);
	}
}
