package com.ejianc.foundation.company.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.foundation.cpmpany.vo.CompanyStateDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.company.mapper.CompanyStateMapper;
import com.ejianc.foundation.company.bean.CompanyStateEntity;
import com.ejianc.foundation.company.service.ICompanyStateService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 公司潜亏情况主表
 * 
 * @author generator
 * 
 */
@Service("companyStateService")
public class CompanyStateServiceImpl extends BaseServiceImpl<CompanyStateMapper, CompanyStateEntity> implements ICompanyStateService{

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Integer flag) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        // 获取文件存储信息
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        //租户ID
        Long tenantid = InvocationInfoProxy.getTenantid();
        //判断文件格式是否正确
        boolean isFailed = false;
        //获取文件数据
        MultipartFile mf = null;
        //遍历文件,校验格式是否正确
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            if (entity == null) {
                continue;
            }
            //获取文件所有内容
            mf = entity.getValue();
            //获取文件名
            String originalFileName = mf.getOriginalFilename();
            // 替换文件名中的非法字符
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        if (mf == null) {
            throw new BusinessException("导入的文件中没有数据");
        }

        // 获取文件数据
        List<List<String>> result = ExcelReader.readExcel(mf);
        //解析成功的数据
        List<CompanyStateDetailVO> successList = new ArrayList<>();
        //解析失败的数据
        List<CompanyStateDetailVO> errorList = new ArrayList<>();
        //检查获取的数据
        if (result == null || result.isEmpty()) {
            throw new BusinessException("数据表格错误");
        }
        if (result.get(0).size() != 20) {
            throw new BusinessException("请按照导入模板导入数据");
        }
        if (result.size() >= 10000) {
            throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
        }
        for (int i = 1; i < result.size(); i++){
            //数据处理
            CompanyStateDetailVO vo = new CompanyStateDetailVO();
            //分公司
            String branch = result.get(i).get(0);
            vo.setBranch(branch);
            //项目名称
            String projectName = result.get(i).get(1);
            vo.setProjectName(projectName);
            //项目状态
            try {
                String s = result.get(i).get(2);
                vo.setProjectStatus(Integer.parseInt(s));
            } catch (NumberFormatException e) {
                vo.setErrorMsg("【项目状态】错误，错误数据：" + result.get(i).get(2));
                errorList.add(vo);
                continue;
            }
            try {
                //实际开工日期
                String actualCommencement = result.get(i).get(3);
                Date date = null;
                //格式日期
                LocalDate parse  = LocalDate.parse(actualCommencement, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                date = Date.from(parse.atStartOfDay(ZoneId.systemDefault()).toInstant());
                //转化成Date类型
                vo.setActualCommencement(date);
            } catch (Exception e) {
                vo.setErrorMsg("【实际开工日期】错误，错误数据：" + result.get(i).get(3));
                errorList.add(vo);
                continue;
            }
            try {
                //合同金额
                String contractAmount = result.get(i).get(4);
                vo.setContractAmount(new BigDecimal(contractAmount));
            } catch (Exception e) {
                vo.setErrorMsg("【合同金额】错误，错误数据：" + result.get(i).get(3));
                errorList.add(vo);
                continue;
            }
            try {
                //税率
                String taxRate = result.get(i).get(5);
                vo.setTaxRate(new BigDecimal(taxRate));
            } catch (Exception e) {
                vo.setErrorMsg("【税率】错误，错误数据：" + result.get(i).get(5));
                errorList.add(vo);
                continue;
            }
            try {
                //目标利润率
                String profitMargin = result.get(i).get(6);
                vo.setProfitMargin(new BigDecimal(profitMargin));
            }catch (Exception e) {
                vo.setErrorMsg("【目标利润率】错误，错误数据：" + result.get(i).get(6));
                errorList.add(vo);
                continue;
            }
            try {
                //预计不含税总收入
                String freeIncomeTax = result.get(i).get(7);
                vo.setFreeIncomeTax(new BigDecimal(freeIncomeTax));
            }catch (Exception e) {
                vo.setErrorMsg("【预计不含税总收入】错误，错误数据：" + result.get(i).get(7));
                errorList.add(vo);
                continue;
            }
            try {
                //预计含税总收入
                String revenueIncludingTax = result.get(i).get(8);
                vo.setTotalOutputTax(new BigDecimal(revenueIncludingTax));
            } catch (Exception e) {
                vo.setErrorMsg("【预计含税总收入】错误，错误数据：" + result.get(i).get(7));
                errorList.add(vo);
                continue;
            }
            //计算预计总销项税
            BigDecimal totalOutputTax = vo.getTotalOutputTax();


        }
        return null;
    }
}
