/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.company.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.company.bean.CompanyStateEntity;
import com.ejianc.foundation.company.mapper.CompanyStateMapper;
import com.ejianc.foundation.company.service.ICompanyStateService;
import com.ejianc.foundation.cpmpany.vo.CompanyStateDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="companyStateService")
public class CompanyStateServiceImpl
extends BaseServiceImpl<CompanyStateMapper, CompanyStateEntity>
implements ICompanyStateService {
    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Integer flag) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Long tenantid = InvocationInfoProxy.getTenantid();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            if (entity == null) continue;
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        if (mf == null) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList successList = new ArrayList();
        ArrayList<CompanyStateDetailVO> errorList = new ArrayList<CompanyStateDetailVO>();
        if (result == null || result.isEmpty()) {
            throw new BusinessException("\u6570\u636e\u8868\u683c\u9519\u8bef");
        }
        if (((List)result.get(0)).size() != 20) {
            throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
        }
        if (result.size() >= 10000) {
            throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
        }
        for (int i = 1; i < result.size(); ++i) {
            CompanyStateDetailVO vo = new CompanyStateDetailVO();
            String branch = (String)((List)result.get(i)).get(0);
            vo.setBranch(branch);
            String projectName = (String)((List)result.get(i)).get(1);
            vo.setProjectName(projectName);
            try {
                String s = (String)((List)result.get(i)).get(2);
                vo.setProjectStatus(Integer.valueOf(Integer.parseInt(s)));
            }
            catch (NumberFormatException e) {
                vo.setErrorMsg("\u3010\u9879\u76ee\u72b6\u6001\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(2));
                errorList.add(vo);
                continue;
            }
            try {
                String actualCommencement = (String)((List)result.get(i)).get(3);
                Date date = null;
                LocalDate parse = LocalDate.parse(actualCommencement, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                date = Date.from(parse.atStartOfDay(ZoneId.systemDefault()).toInstant());
                vo.setActualCommencement(date);
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u5b9e\u9645\u5f00\u5de5\u65e5\u671f\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(3));
                errorList.add(vo);
                continue;
            }
            try {
                String contractAmount = (String)((List)result.get(i)).get(4);
                vo.setContractAmount(new BigDecimal(contractAmount));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u5408\u540c\u91d1\u989d\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(3));
                errorList.add(vo);
                continue;
            }
            try {
                String taxRate = (String)((List)result.get(i)).get(5);
                vo.setTaxRate(new BigDecimal(taxRate));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7a0e\u7387\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(5));
                errorList.add(vo);
                continue;
            }
            try {
                String profitMargin = (String)((List)result.get(i)).get(6);
                vo.setProfitMargin(new BigDecimal(profitMargin));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u76ee\u6807\u5229\u6da6\u7387\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(6));
                errorList.add(vo);
                continue;
            }
            try {
                String freeIncomeTax = (String)((List)result.get(i)).get(7);
                vo.setFreeIncomeTax(new BigDecimal(freeIncomeTax));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u9884\u8ba1\u4e0d\u542b\u7a0e\u603b\u6536\u5165\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(7));
                errorList.add(vo);
                continue;
            }
            try {
                String revenueIncludingTax = (String)((List)result.get(i)).get(8);
                vo.setTotalOutputTax(new BigDecimal(revenueIncludingTax));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u9884\u8ba1\u542b\u7a0e\u603b\u6536\u5165\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(7));
                errorList.add(vo);
                continue;
            }
            BigDecimal bigDecimal = vo.getTotalOutputTax();
        }
        return null;
    }
}

