package com.ejianc.foundation.share.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.foundation.share.bean.LabsubItemEntity;
/**
 * 劳务分包分类
 *
 * @author generator
 *
 */
@TableName("ejc_share_labsub_category")
public class LabsubCategoryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="parent_id")
    private Long parentId; // 父ID
    @TableField(value="category_code")
    private String categoryCode; // 编码
    @TableField(value="category_name")
    private String categoryName; // 名称
    @TableField(value="remarks")
    private String remarks; // 备注
    @TableField(value="sequence")
    private Integer sequence; // 排序
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="inner_code")
    private String innerCode; // 内码


    @TableField(exist=false)
    @SubEntity(serviceName="labsubItemService",pidName ="categoryId")
    private List<LabsubItemEntity> labsubItemEntities = new ArrayList<>(); // 劳务分包档案

    @TableField
    private String subjectIds; //成本科目Id列表

    @TableField
    private String subjectNames; //成本科目名称列表

    @TableField
    private String subjectRelations; //成本科目关系

    public String getSubjectIds() {
        return subjectIds;
    }

    public void setSubjectIds(String subjectIds) {
        this.subjectIds = subjectIds;
    }

    public String getSubjectNames() {
        return subjectNames;
    }

    public void setSubjectNames(String subjectNames) {
        this.subjectNames = subjectNames;
    }

    public String getSubjectRelations() {
        return subjectRelations;
    }

    public void setSubjectRelations(String subjectRelations) {
        this.subjectRelations = subjectRelations;
    }

    private Long subjectId; //科目ID

    private String subjectName; //科目ID

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    /**
     * 父ID
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父ID
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 编码
     */
    public String getCategoryCode() {
        return categoryCode;
    }

    /**
     * 编码
     */
    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }
    /**
     * 名称
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * 名称
     */
    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 排序
     */
    public Integer getSequence() {
        return sequence;
    }

    /**
     * 排序
     */
    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 内码
     */
    public String getInnerCode() {
        return innerCode;
    }

    /**
     * 内码
     */
    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }

    /**
     * 劳务分包档案
     */
    public List<LabsubItemEntity> getLabsubItemEntities() {
        return labsubItemEntities;
    }

    /**
     * 劳务分包档案
     */
    public void setLabsubItemEntities(List<LabsubItemEntity> labsubItemEntities) {
        this.labsubItemEntities = labsubItemEntities;
    }
}
