package com.ejianc.foundation.share.controller.api;

import com.ejianc.foundation.share.bean.SubjectOrgEntity;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/shareSubjectOrgApi/")
public class SubjectOrgApi {

    @Autowired
    private ISubjectOrgService subjectOrgService;

    /**
     *
     * @Author
     * @param
     * @return
     */
    @GetMapping("querySubjectOrgTree")
    public CommonResponse<List<SubjectOrgVO>> querySubjectOrgTree() {
        QueryParam param = new QueryParam();
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("subjectCode", "asc");
        List<SubjectOrgEntity> list = subjectOrgService.queryList(param,false);
        List<SubjectOrgVO> subjectOrgVOList = BeanMapper.mapList(list, SubjectOrgVO.class);
        return CommonResponse.success("查询成功！", subjectOrgVOList);
    }

    /**
     * 查询
     * @param param
     * @return
     */
    @PostMapping("querySubjectOrg")
    @ResponseBody
    public CommonResponse<List<SubjectOrgVO>> querySubjectOrg(@RequestBody QueryParam param) {
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("subjectCode", "asc");
        List<SubjectOrgEntity> list = subjectOrgService.queryList(param,false);
        List<SubjectOrgVO> subjectOrgVOList = BeanMapper.mapList(list, SubjectOrgVO.class);
        return CommonResponse.success("查询成功！", subjectOrgVOList);
    }


    /**
     * 查询
     * @param subjectName
     * @return
     */
    @GetMapping("querySubjectOrgIds")
    public CommonResponse<List<Long>> querySubjectOrgIds(@RequestParam String subjectName) {
        List<Long> longs = subjectOrgService.querySubjectOrgIds(subjectName);
        return CommonResponse.success("查询成功！", longs);
    }


}
