package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.ProsubCategoryEntity;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import com.ejianc.foundation.share.bean.SubjectOrgEntity;
import com.ejianc.foundation.share.mapper.ProsubCategoryMapper;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.vo.ProsubCategoryImportVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 专业分包分类
 *
 * @author generator
 */
@Service("prosubCategoryService")
public class ProsubCategoryServiceImpl extends BaseServiceImpl<ProsubCategoryMapper, ProsubCategoryEntity> implements IProsubCategoryService {
    @Autowired
    private IProsubCategoryService service;
    @Autowired
    private IProsubItemService prosubItemService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PSC_CODE";
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ProsubCategoryMapper prosubCategoryMapper;
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private ISubjectOrgService subjectOrgService;

    /**
     * 根据id 删除专业分包档案分类
     **/
    @Override
    public CommonResponse<String> deleteById(List<ProsubCategoryVO> vos) {
        List<Long> collect = vos.stream().map(ProsubCategoryVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("category_id", new Parameter(QueryParam.IN, collect));
        List<ProsubItemEntity> prosubItemEntities = prosubItemService.queryList(queryParam);
        /**是否关联档案**/
        if (CollectionUtils.isNotEmpty(prosubItemEntities)) {
            return CommonResponse.error("分类下关联专业分包档案！");
        }
        /****/
        QueryParam queryClassifyParam = new QueryParam();
        queryClassifyParam.getParams().put("parent_id", new Parameter(QueryParam.IN, collect));
        List<ProsubCategoryEntity> prosubItems = service.queryList(queryClassifyParam);
        if (CollectionUtils.isNotEmpty(prosubItems)) {
            return CommonResponse.error("分类下关联子分类不允许删除！");
        }
        service.removeByIds(vos.stream().map(ProsubCategoryVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public List<ProsubCategoryVO> queryProsubCategoryList(QueryParam queryParam) {
        Map<String, Parameter> paramMap = queryParam.getParams();

        Map<String,Object> condition = new HashMap<>();
        for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
        //放入租户ID进map
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<ProsubCategoryVO> resultList = baseMapper.queryProsubCategoryList(condition);
        return resultList;
    }

    @Override
    public CommonResponse<ProsubCategoryVO> saveOrUpdateProsubCategory(ProsubCategoryVO saveorUpdateVO) {
        ProsubCategoryEntity entity = BeanMapper.map(saveorUpdateVO, ProsubCategoryEntity.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("categoryCode",new Parameter(QueryParam.EQ, saveorUpdateVO.getCategoryCode()));
        List<ProsubCategoryEntity> prosubCategoryEntityList = service.queryList(queryParam);
        if (saveorUpdateVO.getId()!=null){
            ProsubCategoryEntity prosubCategoryEntity = service.selectById(saveorUpdateVO.getId());
            if (!prosubCategoryEntity.getCategoryCode().equals(saveorUpdateVO.getCategoryCode())){
                if (CollectionUtils.isNotEmpty(prosubCategoryEntityList)){
                    return CommonResponse.error("分类编码重复！");
                }
            }
        }else {
            if (CollectionUtils.isNotEmpty(prosubCategoryEntityList)){
                return CommonResponse.error("分类编码重复！");
            }
        }
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                if (StringUtils.isEmpty(saveorUpdateVO.getCategoryCode())){
                    entity.setCategoryCode(billCode.getData());
                }else {
                    entity.setCategoryCode(saveorUpdateVO.getCategoryCode());
                }
                entity.setOrgId(sessionManager.getUserContext().getOrgId());
                entity.setOrgName(sessionManager.getUserContext().getOrgName());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            LambdaUpdateWrapper<ProsubCategoryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(ProsubCategoryEntity::getId, saveorUpdateVO.getId());
            updateWrapper.set(ProsubCategoryEntity::getCategoryCode, saveorUpdateVO.getCategoryCode());
            updateWrapper.set(ProsubCategoryEntity::getCategoryName, saveorUpdateVO.getCategoryName());
            updateWrapper.set(ProsubCategoryEntity::getOrgId, sessionManager.getUserContext().getOrgId());
            updateWrapper.set(ProsubCategoryEntity::getOrgName, sessionManager.getUserContext().getOrgName());
            updateWrapper.set(ProsubCategoryEntity::getRemarks, saveorUpdateVO.getRemarks());
            updateWrapper.set(ProsubCategoryEntity::getSubjectId, saveorUpdateVO.getSubjectId());
            updateWrapper.set(ProsubCategoryEntity::getSubjectName, saveorUpdateVO.getSubjectName());
            updateWrapper.set(ProsubCategoryEntity::getSubjectIds, saveorUpdateVO.getSubjectIds());
            updateWrapper.set(ProsubCategoryEntity::getSubjectNames, saveorUpdateVO.getSubjectNames());
            updateWrapper.set(ProsubCategoryEntity::getSubjectRelations, saveorUpdateVO.getSubjectRelations());
            updateWrapper.set(ProsubCategoryEntity::getSequence,saveorUpdateVO.getSequence());
            service.update(updateWrapper);
            Long tenantId = InvocationInfoProxy.getTenantid();
            List<Long> ids = new ArrayList<>();
            ids.add(entity.getId());
            List<ProsubCategoryEntity> prosubCategoryEntities = prosubCategoryMapper.queryByInnerCodes(tenantId, ids);
            ids.clear();
            prosubCategoryEntities.forEach(item->{
                ids.add(item.getId());
                // 更新字表的数据
                prosubItemService.updateByCategoryId(item.getId(),entity.getSubjectIds(),entity.getSubjectNames(),entity.getSubjectRelations());
            });
            prosubCategoryMapper.updateSubject(tenantId,entity.getSubjectIds(),entity.getSubjectNames(),ids, entity.getSubjectRelations());
            ProsubCategoryEntity prosubCategoryEntity = service.selectById(saveorUpdateVO.getId());
            if (prosubCategoryEntity!=null){
                LambdaUpdateWrapper<ProsubItemEntity> lambdaUpdateWrapper = new LambdaUpdateWrapper<>();
                lambdaUpdateWrapper.eq(ProsubItemEntity::getCategoryId,saveorUpdateVO.getId());
                lambdaUpdateWrapper.set(ProsubItemEntity::getCategoryName,prosubCategoryEntity.getCategoryName());
                prosubItemService.update(lambdaUpdateWrapper);
            }

            ProsubCategoryEntity dbEntity = service.selectById(saveorUpdateVO.getId());
            ProsubCategoryVO vo = BeanMapper.map(dbEntity, ProsubCategoryVO.class);
            return CommonResponse.success("保存或修改单据成功！", vo);
        }
        entity.setId(IdWorker.getId());
//        entity.setCategoryCode(saveorUpdateVO.getCategoryCode());
        if (entity.getParentId() != null && entity.getParentId() > 0) {
            ProsubCategoryEntity prosubCategoryEntity = service.selectById(entity.getParentId());
            entity.setInnerCode(prosubCategoryEntity.getInnerCode() + "|" + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        service.save(entity);
        ProsubCategoryVO vo = BeanMapper.map(entity, ProsubCategoryVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<ProsubCategoryImportVO> successList = new ArrayList<>();
        List<ProsubCategoryImportVO> processList = new ArrayList<>();
        List<ProsubCategoryImportVO> errorList = new ArrayList<>();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("分类数据超过10000条，请分批上传！");
                }
                Map<String, List<ProsubCategoryImportVO>> mapChildren = new HashMap<>();
                Map<String, ProsubCategoryImportVO> codeToData = new HashMap<>();
                Map<String, String> codeNotExistData = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ProsubCategoryImportVO prosubCategoryImportVO = new ProsubCategoryImportVO();
                    prosubCategoryImportVO.setId(IdWorker.getId());
                    prosubCategoryImportVO.setCategoryCode(datas.get(0));
                    prosubCategoryImportVO.setParentCode(datas.get(1));
                    prosubCategoryImportVO.setCategoryName(datas.get(2));
                    prosubCategoryImportVO.setRemarks(datas.get(3));
                    if (StringUtils.isBlank(datas.get(0))) {
                        prosubCategoryImportVO.setRemarks("分类编码为空！");
                        errorList.add(prosubCategoryImportVO);
                        continue;
                    }
                    if (StringUtils.isBlank(datas.get(2))) {
                        prosubCategoryImportVO.setRemarks("分类名称为空！");
                        errorList.add(prosubCategoryImportVO);
                        continue;
                    }
                    //通过物料分类Code获取物料分类
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("categoryCode", new Parameter(QueryParam.EQ, String.valueOf(datas.get(0))));
                    List<ProsubCategoryEntity> list = service.queryList(queryParam, false);
                    if (ListUtil.isEmpty(list)) {
                        //通过物料分类name获取物料分类
//                        queryParam = new QueryParam();
//                        queryParam.getParams().put("categoryName", new Parameter(QueryParam.EQ, String.valueOf(datas.get(2))));
//                        list = service.queryList(queryParam, false);
//                        if (ListUtil.isNotEmpty(list)) {
//                            prosubCategoryImportVO.setRemarks("分类名称重复！");
//                            errorList.add(prosubCategoryImportVO);
//                            continue;
//                        }
                        if (StringUtils.isBlank(datas.get(1))) {
                            prosubCategoryImportVO.setInnerCode(prosubCategoryImportVO.getId().toString());
                        }
                        prosubCategoryImportVO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        prosubCategoryImportVO.setCreateTime(new Date());
                        prosubCategoryImportVO.setTenantId(InvocationInfoProxy.getTenantid());
                        processList.add(prosubCategoryImportVO);
                        codeToData.put(prosubCategoryImportVO.getCategoryCode(), prosubCategoryImportVO);
                        if (StringUtils.isBlank(prosubCategoryImportVO.getParentCode())) {
                            List<ProsubCategoryImportVO> list1 = mapChildren.get("null");
                            if (ListUtil.isEmpty(list1)) {
                                list1 = new ArrayList<>();
                                mapChildren.put("null", list1);
                            }
                            list1.add(prosubCategoryImportVO);
                        } else {
                            List<ProsubCategoryImportVO> list1 = mapChildren.get(prosubCategoryImportVO.getParentCode());
                            if (ListUtil.isEmpty(list1)) {
                                list1 = new ArrayList<>();
                                mapChildren.put(prosubCategoryImportVO.getParentCode(), list1);
                            }
                            list1.add(prosubCategoryImportVO);
                        }
                    } else {
                        prosubCategoryImportVO.setRemarks("分类编码重复！");
                        errorList.add(prosubCategoryImportVO);
                    }
                }
                if (ListUtil.isNotEmpty(processList)) {
                    processList.forEach(p -> {
                        if (p.getCategoryCode().equals(p.getParentCode())){
                            p.setRemarks("分类编码和父分类编码一致");
                            errorList.add(p);
                        }else {
                            if (StringUtils.isNotEmpty(p.getParentCode())) {
                                ProsubCategoryImportVO parentVo = codeToData.get(p.getParentCode());
                                if (parentVo == null) {
                                    if (StringUtils.isNotEmpty(codeNotExistData.get(p.getParentCode()))) {
                                        p.setRemarks("父分类编码不存在");
                                        errorList.add(p);
                                    } else {
                                        QueryParam queryParam = new QueryParam();
                                        queryParam.getParams().put("categoryCode", new Parameter(QueryParam.EQ, p.getParentCode()));
                                        List<ProsubCategoryEntity> list = service.queryList(queryParam, false);
                                        if (ListUtil.isEmpty(list)) {
                                            codeNotExistData.put(p.getParentCode(), p.getParentCode());
                                            p.setRemarks("父分类编码不存在");
                                            errorList.add(p);
                                        } else {
                                            p.setInnerCode(list.get(0).getInnerCode() + "|" + p.getId());
                                            p.setParentId(list.get(0).getId());
                                            successList.add(p);
                                        }
                                    }
                                } else {
                                    if (StringUtils.isEmpty(parentVo.getInnerCode())) {
                                        setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
                                        if (StringUtils.isEmpty(parentVo.getInnerCode())) {
                                            p.setRemarks("父分类编码不存在");
                                            errorList.add(p);
                                        } else {
                                            p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                                            p.setParentId(parentVo.getId());
                                            successList.add(p);
                                        }
                                    } else {
                                        p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                                        p.setParentId(parentVo.getId());
                                        successList.add(p);
                                    }
                                }
                            } else {
                                successList.add(p);
                            }
                        }
                    });
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @Override
    public void updateSubject(String subjectIds, String subjectNames, List<Long> ids, String subjectRelations) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<ProsubCategoryEntity> prosubCategoryEntities = prosubCategoryMapper.queryByInnerCodes(tenantId, ids);
        ids.clear();
        prosubCategoryEntities.forEach(item->{
            ids.add(item.getId());
            prosubItemService.updateByCategoryId(item.getId(),subjectIds,subjectNames, subjectRelations);
        });
        prosubCategoryMapper.updateSubject(tenantId,subjectIds,subjectNames,ids, subjectRelations);
    }

    @Override
    public List<Map> queryMajorSubList(QueryWrapper wrapper) {
        return baseMapper.queryMajorSubList(wrapper);
    }

    @Override
    public List<ProsubCategoryVO> queryCategoryListByIds(List<Long> ids) {
        LambdaQueryWrapper<ProsubCategoryEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(CollectionUtils.isNotEmpty(ids), ProsubCategoryEntity::getId, ids);
        List<ProsubCategoryEntity> prosubCategoryEntityList = list(queryWrapper);
        if(prosubCategoryEntityList != null && prosubCategoryEntityList.size() > 0) {
            return BeanMapper.mapList(prosubCategoryEntityList, ProsubCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<ProsubCategoryEntity> queryListByPids(List<Long> asList) {
        return prosubCategoryMapper.queryByInnerCodes(InvocationInfoProxy.getTenantid(), asList);
    }

    @Override
    public void getDefaultSubject(List<ProsubCategoryVO> prosubCategoryVOS, Long projectId) {
        ProjectSetPoolEntity project = projectSetService.selectById(projectId);

        if(null != project.getSubjectOrgCategoryId()) {
            List<Long> subjectIds = new ArrayList<>(prosubCategoryVOS.stream().filter(item -> StringUtils.isNotEmpty(item.getSubjectIds())).map(item ->item.getSubjectIds())
                    .flatMap(idStr -> Arrays.stream(idStr.split(","))).map(id -> Long.valueOf(id)).collect(Collectors.toSet()));
            if(CollectionUtils.isEmpty(subjectIds)) {
                return;
            }
            List<SubjectOrgEntity> subjectList = (List<SubjectOrgEntity>) subjectOrgService.listByIds(subjectIds);
            if(CollectionUtils.isNotEmpty(subjectList)) {
                Map<Long, SubjectOrgEntity> subjectMap = subjectList.stream().filter(item -> null != item.getCategoryId()
                        && project.getSubjectOrgCategoryId().equals(item.getCategoryId())).collect(Collectors.toMap(item -> item.getId(), item -> item));

                SubjectOrgEntity tmpSubject = null;
                for(ProsubCategoryVO m : prosubCategoryVOS) {
                    if(StringUtils.isBlank(m.getSubjectIds())) {
                        continue;
                    }
                    for(String subjectIdStr : m.getSubjectIds().split(",")) {
                        tmpSubject = subjectMap.get(Long.valueOf(subjectIdStr));
                        if(null != tmpSubject) {
                            m.setSubjectId(tmpSubject.getId());
                            m.setSubjectName(tmpSubject.getSubjectName());
                        }
                    }
                }
            }
        }
    }

    @Override
    public List<ProsubCategoryVO> queryAllByCodes(List<String> categoryCodes) {
        QueryWrapper<ProsubCategoryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("category_code", categoryCodes);

        List<ProsubCategoryEntity> categoryEntityList = super.list(queryWrapper);
        if(CollectionUtils.isNotEmpty(categoryEntityList)) {
            return BeanMapper.mapList(categoryEntityList, ProsubCategoryVO.class);
        }
        return new ArrayList<>();
    }

    private void setInnerCodeAndParentId(ProsubCategoryImportVO vo, Map<String, ProsubCategoryImportVO> codeToData, Map<String, String> codeNotExistData) {
        ProsubCategoryImportVO parentVo = codeToData.get(vo.getParentCode());
        if (parentVo == null) {
            if (StringUtils.isNotEmpty(codeNotExistData.get(vo.getParentCode()))) {
                vo.setRemarks("父分类编码不存在");
            } else {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("categoryCode", new Parameter(QueryParam.EQ, vo.getParentCode()));
                List<ProsubCategoryEntity> list = service.queryList(queryParam, false);
                if (ListUtil.isEmpty(list)) {
                    codeNotExistData.put(vo.getParentCode(), vo.getParentCode());
                    vo.setRemarks("父分类编码不存在");
                } else {
                    vo.setInnerCode(list.get(0).getInnerCode() + "|" + vo.getId());
                    vo.setParentId(list.get(0).getId());
                }
            }
        } else {
            if (StringUtils.isEmpty(parentVo.getInnerCode())) {
                setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
                if (StringUtils.isEmpty(parentVo.getInnerCode())) {
                    vo.setRemarks("父分类编码不存在");
                } else {
                    vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
                    vo.setParentId(parentVo.getId());
                }
            } else {
                vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
                vo.setParentId(parentVo.getId());
            }

        }
    }
}
