package com.ejianc.foundation.company.controller;

import java.io.Serializable;

import com.ejianc.foundation.company.bean.CompanyStateDetailEntity;
import com.ejianc.foundation.cpmpany.vo.CompanyStateDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetExPoolEntity;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.service.IProjectSetExPoolService;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.company.bean.CompanyStateEntity;
import com.ejianc.foundation.company.service.ICompanyStateService;
import com.ejianc.foundation.cpmpany.vo.CompanyStateVO;

/**
 * 公司潜亏情况主表
 *
 * @author generator
 */
@Controller
@RequestMapping("companyState")
public class CompanyStateController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectSetService projectSetExPoolService;

    private static final String BILL_CODE = "COMPANY_STATE_CODE";//此处需要根据实际修改

    @Autowired
    private ICompanyStateService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CompanyStateVO> saveOrUpdate(@RequestBody CompanyStateVO saveOrUpdateVO) {
        CompanyStateEntity entity = BeanMapper.map(saveOrUpdateVO, CompanyStateEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //修正子表数据
        updateCompanyStateDetailEntity(entity);
        service.saveOrUpdate(entity, false);
        CompanyStateVO vo = BeanMapper.map(entity, CompanyStateVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CompanyStateVO> queryDetail(Long id) {
        CompanyStateEntity entity = service.selectById(id);
        //删除本行或者下一行
        List<CompanyStateDetailEntity> detailEntities = updateCompanyStateDetailEntity(entity);
        //修改子表
        entity.setCompanyStateDetailList(detailEntities);
        CompanyStateVO vo = BeanMapper.map(entity, CompanyStateVO.class);
        //修改vo
        List<CompanyStateDetailVO> vos = updateCompanyStateDetailVo(vo);
        vo.setCompanyStateDetailList(vos);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CompanyStateVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CompanyStateVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CompanyStateVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    //选择了组织，直接拉去组织本下的项目
    @ApiOperation("查询项目列表")
    @RequestMapping(value = "/queryProjects", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<CompanyStateDetailVO>> queryProjects(@RequestBody QueryParam param) {
        Parameter orgId = param.getParams().get("orgId");
        if (orgId == null) {
            return CommonResponse.error("请选择组织！");
        }
        Object object = orgId.getValue();
        if (object == null) {
            return CommonResponse.error("请检查组织是否正确！");
        }
        List<Long> list = null;
        try {
            long aLong = Long.parseLong(object.toString());
            list = iOrgApi.findChildrenByParentId(aLong).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        } catch (NumberFormatException e) {
            return CommonResponse.error("组织选择异常");
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, list));
        List<ProjectSetPoolEntity> poolEntities = projectSetExPoolService.queryList(param);
        if(poolEntities == null || poolEntities.isEmpty()){
            return CommonResponse.success("没有数据！",new ArrayList<>());
        }
        List<CompanyStateDetailVO> ans = new ArrayList<>();
        for (ProjectSetPoolEntity en : poolEntities) {
            CompanyStateDetailVO vo = new CompanyStateDetailVO();
            //项目ID
            vo.setProjectId(en.getId());
            //项目名称
            vo.setProjectName(en.getName());
            //项目状态
            try {
                vo.setProjectStatus(Integer.parseInt(en.getProjectStatus()));
            } catch (NumberFormatException e) {
                logger.debug("项目状态转换异常");
            }
            //分公司
            vo.setBranch(en.getParentProjectName());
            //实际开工日期
            vo.setActualCommencement(en.getActualStartDate());
            //TODO 合同金额（含补充协议）工程承包合同的总金额
            //TODO 税率 工程承包合同的税率
            //TODO 预计不含税总收入 策划成本的【策划总收入（无税)】
            //TODO 预计含税总收入 策划成本的【策划总收入（含税)】
            //TODO 累计含税收入 公司内部产值（月度）中【本期累计产值】金额汇总
        }
        return CommonResponse.success("查询成功", ans);
    }

    // excel数据导入
    @ApiOperation("导入")
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request, response, 0);
    }

    @ApiOperation("公司潜亏门户")
    @RequestMapping(value = "/selectCompanyState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> selectCompanyState(
            @RequestParam(required = false) String data,
            @RequestParam(required = false) String value) {
        //value 1-查询完工预计 2-开累经营 3-财务账面  （为空默认查询 完工预计）
        List<Map<String, String>> ans = new ArrayList<>();
        for (int i = 0; i <= 4; i++) {
            Map<String, String> map = new HashMap<>();
            String s = "";
            switch (i) {
                case 0:
                    s = "第一季度";break;
                case 1:
                    s = "第二季度";break;
                case 2:
                    s = "第三季度";break;
                case 3:
                    s = "第四季度";break;
            }
            map.put("first", s);
            ans.add(map);
        }
        return service.selectCompanyState(ans,data,value);
    }


    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CompanyStateVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<CompanyStateEntity> page = service.queryPage(param, false);
        IPage<CompanyStateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CompanyStateVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CompanyStateEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CompanyState-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCompanyStateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CompanyStateVO>> refCompanyStateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CompanyStateEntity> page = service.queryPage(param, false);
        IPage<CompanyStateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CompanyStateVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /*子表数据处理 实体类处理*/
    private List<CompanyStateDetailEntity> updateCompanyStateDetailEntity(CompanyStateEntity entity) {
        //1.获取主表对应子表数据
        List<CompanyStateDetailEntity> detailList = entity.getCompanyStateDetailList();
        if (detailList == null || detailList.isEmpty()) {
            return detailList;
        }
        List<CompanyStateDetailEntity> ans = new ArrayList<>();
        //2.处理子表数据
        for (CompanyStateDetailEntity detail : detailList) {
            //1. 预计总销项税
            BigDecimal outputTax = null;
            //1.1 预计不含税总收入
            BigDecimal freeIncomeTax = detail.getFreeIncomeTax();
            //1.2 预计含税总收入
            BigDecimal revenueIncludingTax = detail.getRevenueIncludingTax();
            //1.3 预计总销项税 = 预计含税总收入 - 预计不含税总收入
            outputTax = revenueIncludingTax.subtract(freeIncomeTax);
            detail.setTotalOutputTax(outputTax);
            //2. 预计总进项税、增值税、附加税等
            BigDecimal inputTaxVatSurcharge = BigDecimal.ZERO;
            // 2.1 预计不含税总成本
            BigDecimal costExcludingTax = detail.getCostExcludingTax() != null ? detail.getCostExcludingTax() : BigDecimal.ZERO;
            // 2.2 预计含税总成本
            BigDecimal costIncludingTax = detail.getCostIncludingTax() != null ? detail.getCostIncludingTax() : BigDecimal.ZERO;
            // 2.3 预计总财务费用
            BigDecimal totalFinancialExpenses = detail.getTotalFinancialExpenses() != null ? detail.getTotalFinancialExpenses() : BigDecimal.ZERO;
            // 2.4 预计总进项税等 = 预计含税总成本 - 预计不含税总成本 - 预计总财务费用
            inputTaxVatSurcharge = costIncludingTax.subtract(costExcludingTax).subtract(totalFinancialExpenses);
            detail.setInputTaxVatSurcharge(inputTaxVatSurcharge);
            // 3. 预计总盈亏 = 预计含税总收入 - 预计含税总成本
            BigDecimal totalProfitLoss = revenueIncludingTax.subtract(costIncludingTax);
            detail.setTotalProfitLoss(totalProfitLoss);
            // 4. 预计总利润率 = 预计总盈亏 / 预计含税总收入 (避免除零错误)
            BigDecimal totalProfitMargin = BigDecimal.ZERO;
            if (revenueIncludingTax.compareTo(BigDecimal.ZERO) != 0) {
                totalProfitMargin = totalProfitLoss.divide(revenueIncludingTax, 4, RoundingMode.HALF_UP);
            }
            detail.setTotalProfitMargin(totalProfitMargin);
            // 5. 累计销项税 = 累计含税收入 - 累计不含税收入
            BigDecimal cumulativeOutputTax = BigDecimal.ZERO;
            BigDecimal cumulativeFreeIncome = detail.getCumulativeFreeIncome() != null ? detail.getCumulativeFreeIncome() : BigDecimal.ZERO;
            BigDecimal cumulativeRevenueIncludingTax = detail.getCumulativeRevenueIncludingTax() != null ? detail.getCumulativeRevenueIncludingTax() : BigDecimal.ZERO;
            cumulativeOutputTax = cumulativeRevenueIncludingTax.subtract(cumulativeFreeIncome);
            detail.setCumulativeOutputTax(cumulativeOutputTax);
            // 6. 累计进项税、增值税、附加税等
            BigDecimal cumulativeInputTaxVatSurcharge = BigDecimal.ZERO;
            BigDecimal cumulativeFreeCost = detail.getCumulativeFreeCost() != null ? detail.getCumulativeFreeCost() : BigDecimal.ZERO;
            BigDecimal cumulativeCostIncludingTax = detail.getCumulativeCostIncludingTax() != null ? detail.getCumulativeCostIncludingTax() : BigDecimal.ZERO;
            BigDecimal cumulativeFinancialExpenses = detail.getCumulativeFinancialExpenses() != null ? detail.getCumulativeFinancialExpenses() : BigDecimal.ZERO;
            cumulativeInputTaxVatSurcharge = cumulativeCostIncludingTax.subtract(cumulativeFreeCost).subtract(cumulativeFinancialExpenses);
            detail.setCumulativeInputTaxVatSurcharge(cumulativeInputTaxVatSurcharge);
            // 7. 累计盈亏 = 累计含税收入 - 累计含税成本
            BigDecimal cumulativeProfitLoss = cumulativeRevenueIncludingTax.subtract(cumulativeCostIncludingTax);
            detail.setCumulativeProfitLoss(cumulativeProfitLoss);
            // 8. 累计利润率 = 累计盈亏 / 累计含税收入 (避免除零错误)
            BigDecimal cumulativeProfitMargin = BigDecimal.ZERO;
            if (cumulativeRevenueIncludingTax.compareTo(BigDecimal.ZERO) != 0) {
                cumulativeProfitMargin = cumulativeProfitLoss.divide(cumulativeRevenueIncludingTax, 4, RoundingMode.HALF_UP);
            }
            detail.setCumulativeProfitMargin(cumulativeProfitMargin);
            // 9. 财务项目净利 = 毛利 - (税金及附加 + 管理费用 + 研发费用 + 财务费用 + 资产/信用减值损失 + 其他)
            BigDecimal financialProjectProfit = BigDecimal.ZERO;
            BigDecimal grossProfit = detail.getGrossProfit() != null ? detail.getGrossProfit() : BigDecimal.ZERO;
            BigDecimal taxesSurcharges = detail.getTaxesSurcharges() != null ? detail.getTaxesSurcharges() : BigDecimal.ZERO;
            BigDecimal managementExpenses = detail.getManagementExpenses() != null ? detail.getManagementExpenses() : BigDecimal.ZERO;
            BigDecimal rdExpenses = detail.getRdExpenses() != null ? detail.getRdExpenses() : BigDecimal.ZERO;
            BigDecimal financialExpenses = detail.getFinancialExpenses() != null ? detail.getFinancialExpenses() : BigDecimal.ZERO;
            BigDecimal assetCreditImpairmentLoss = detail.getAssetCreditImpairmentLoss() != null ? detail.getAssetCreditImpairmentLoss() : BigDecimal.ZERO;
            BigDecimal otherIncomeExpenses = detail.getOtherIncomeExpenses() != null ? detail.getOtherIncomeExpenses() : BigDecimal.ZERO;

            financialProjectProfit = grossProfit.subtract(taxesSurcharges)
                    .subtract(managementExpenses)
                    .subtract(rdExpenses)
                    .subtract(financialExpenses)
                    .subtract(assetCreditImpairmentLoss)
                    .subtract(otherIncomeExpenses);
            detail.setFinancialProjectProfit(financialProjectProfit);
            ans.add(detail);
        }
        return ans;
    }

    /**
     * 处理公司状态详情列表，计算潜在亏损金额及分类，并设置相应的类型标识。
     *
     * @param vo 包含公司状态详情列表的数据传输对象
     * @return 处理后的公司状态详情列表，包含潜在亏损金额和各类亏损类型的标识；
     * 如果输入列表为空或null，则直接返回原列表
     */
    private List<CompanyStateDetailVO> updateCompanyStateDetailVo(CompanyStateVO vo) {
        List<CompanyStateDetailVO> vos = vo.getCompanyStateDetailList();
        if (vos == null || vos.isEmpty()) {
            return vos;
        }
        List<CompanyStateDetailVO> ans = new ArrayList<>();
        for (CompanyStateDetailVO detail : vos) {
            BigDecimal financialProjectProfit = detail.getFinancialProjectProfit() != null ?
                    detail.getFinancialProjectProfit() : BigDecimal.ZERO;
            BigDecimal assetCreditImpairmentLoss = detail.getAssetCreditImpairmentLoss() != null ?
                    detail.getAssetCreditImpairmentLoss() : BigDecimal.ZERO;
            BigDecimal cumulativeProfitLoss = detail.getCumulativeProfitLoss() != null ?
                    detail.getCumulativeProfitLoss() : BigDecimal.ZERO;

            // 计算潜在亏损金额：商务累计盈亏 - (财务项目利润 + 资产信用减值损失)
            BigDecimal potentialLossAmount = cumulativeProfitLoss.subtract(
                    financialProjectProfit.add(assetCreditImpairmentLoss));
            detail.setPotentialLossAmount(potentialLossAmount);

            // 根据商务累计盈亏与财务项目利润的关系判断潜亏类型
            if (cumulativeProfitLoss.compareTo(BigDecimal.ZERO) < 0 &&
                    cumulativeProfitLoss.compareTo(financialProjectProfit) < 0) {
                // 一类潜亏：商务累计盈亏 < 财务项目利润，且商务累计盈亏小于0
                detail.setPotentialLossType(1);
            } else if (cumulativeProfitLoss.compareTo(BigDecimal.ZERO) >= 0 &&
                    cumulativeProfitLoss.compareTo(financialProjectProfit) < 0) {
                // 二类潜亏：0 ≤ 商务累计盈亏 < 财务项目利润
                detail.setPotentialLossType(2);
            } else {
                // 正常项目：商务累计盈亏 ≥ 财务项目利润
                detail.setPotentialLossType(3);
            }

            // 完工预计经营情况判断
            BigDecimal totalProfitMargin = detail.getTotalProfitMargin() != null ?
                    detail.getTotalProfitMargin() : BigDecimal.ZERO;
            BigDecimal profitMargin = detail.getProfitMargin() != null ?
                    detail.getProfitMargin() : BigDecimal.ZERO;

            if (totalProfitMargin.compareTo(BigDecimal.ZERO) < 0) {
                // 一类潜亏：商务预计总利润率 < 0
                detail.setPotentialLossTypeCompletion(1);
            } else if (totalProfitMargin.compareTo(BigDecimal.ZERO) >= 0 &&
                    totalProfitMargin.compareTo(profitMargin) < 0) {
                // 二类潜亏：0 ≤ 商务预计总利润率 < 目标利润率
                detail.setPotentialLossTypeCompletion(2);
            } else {
                // 正常项目：商务预计总利润率 ≥ 目标利润率
                detail.setPotentialLossTypeCompletion(3);
            }

            // 开累经营情况判断
            BigDecimal cumulativeProfitMargin = detail.getCumulativeProfitMargin() != null ?
                    detail.getCumulativeProfitMargin() : BigDecimal.ZERO;

            if (cumulativeProfitMargin.compareTo(BigDecimal.ZERO) < 0) {
                // 一类潜亏：商务开累利润率 < 0
                detail.setPotentialLossTypeAccumulated(1);
            } else if (cumulativeProfitMargin.compareTo(BigDecimal.ZERO) >= 0 &&
                    cumulativeProfitMargin.compareTo(profitMargin) < 0) {
                // 二类潜亏：0 ≤ 商务开累利润率 < 目标利润率
                detail.setPotentialLossTypeAccumulated(2);
            } else {
                // 正常项目：商务开累利润率 ≥ 目标利润率
                detail.setPotentialLossTypeAccumulated(3);
            }
            ans.add(detail);
        }
        return ans;
    }
}
