/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.ProjectWbsEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.IProjectWbsService;
import com.ejianc.foundation.share.vo.ProjectWbsVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectWbs"})
public class ProjectWbsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IProjectWbsService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectSetService projectSetService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectWbsVO> saveOrUpdate(@RequestBody ProjectWbsVO saveOrUpdateVO) {
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectWbsVO> queryDetail(Long id) {
        ProjectWbsEntity entity = (ProjectWbsEntity)((Object)this.service.selectById(id));
        ProjectWbsVO vo = (ProjectWbsVO)BeanMapper.map((Object)((Object)entity), ProjectWbsVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody ProjectWbsVO projectWbsVO) {
        List ids = projectWbsVO.getIds();
        if (ListUtil.isNotEmpty((List)ids)) {
            for (Long id : ids) {
                CommonResponse resp = this.billTypeApi.checkQuote("EJCBT202206000006", id);
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
            this.service.removeByIds(ids);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        Parameter projectIdParam;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List wbsEntityList = this.service.queryList(param, false);
        if (param.getParams().containsKey("projectId") && (projectIdParam = (Parameter)param.getParams().get("projectId")).getValue() != null) {
            Long projectId = Long.valueOf(projectIdParam.getValue().toString());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)projectId);
            int count = this.service.count((Wrapper)queryWrapper);
            if (count == 0) {
                ProjectSetPoolEntity projectSetPoolEntity = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(projectId));
                long id = IdWorker.getId();
                ProjectWbsVO projectWbsVO = new ProjectWbsVO();
                projectWbsVO.setId(Long.valueOf(id));
                projectWbsVO.setCode(projectSetPoolEntity.getCode());
                projectWbsVO.setName(projectSetPoolEntity.getName());
                projectWbsVO.setProjectId(projectId);
                projectWbsVO.setOrgId(projectSetPoolEntity.getOrgId());
                projectWbsVO.setEnabled(Integer.valueOf(1));
                projectWbsVO.setInnerCode(String.valueOf(id));
                ProjectWbsEntity projectWbsEntity = (ProjectWbsEntity)((Object)BeanMapper.map((Object)projectWbsVO, ProjectWbsEntity.class));
                boolean b = this.service.saveOrUpdate((Object)projectWbsEntity);
                if (b) {
                    wbsEntityList.add(projectWbsEntity);
                }
            }
        }
        List resultMapList = BeanMapper.mapList((Iterable)wbsEntityList, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectWbs-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"projectWbs-export.xlsx", (String)"\u5408\u540c\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Long projectId) {
        return this.service.excelImport(request, response, projectId);
    }

    @RequestMapping(value={"/saveImportExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<ProjectWbsVO> importVOS) {
        return CommonResponse.success((String)((String)this.service.saveImportExcel(request, importVOS)));
    }

    @RequestMapping(value={"/refProjectWbsData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refProjectWbsData(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        param.setSearchText(searchText);
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter("eq", (Object)1));
        Long projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("projectId")) {
            projectId = Long.valueOf(conditionMap.get("projectId").toString());
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        List wbsEntityList = this.service.queryList(param, false);
        if (projectId != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)projectId);
            int count = this.service.count((Wrapper)queryWrapper);
            if (count == 0) {
                ProjectSetPoolEntity projectSetPoolEntity = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(projectId));
                long id = IdWorker.getId();
                ProjectWbsVO projectWbsVO = new ProjectWbsVO();
                projectWbsVO.setId(Long.valueOf(id));
                projectWbsVO.setCode(projectSetPoolEntity.getCode());
                projectWbsVO.setName(projectSetPoolEntity.getName());
                projectWbsVO.setProjectId(projectId);
                projectWbsVO.setOrgId(projectSetPoolEntity.getOrgId());
                projectWbsVO.setEnabled(Integer.valueOf(1));
                projectWbsVO.setInnerCode(String.valueOf(id));
                ProjectWbsEntity projectWbsEntity = (ProjectWbsEntity)((Object)BeanMapper.map((Object)projectWbsVO, ProjectWbsEntity.class));
                boolean b = this.service.saveOrUpdate((Object)projectWbsEntity);
                if (b) {
                    wbsEntityList.add(projectWbsEntity);
                }
            }
        }
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (ProjectWbsEntity entity : wbsEntityList) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("innerCode", entity.getInnerCode());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }
}

