package com.ejianc.foundation.share.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 清单档案入库申请主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_share_item_doc_apply")
public class ItemDocApplyEntity extends BaseEntity {

    private static final long serialVersionUID = -9162960378799974945L;

    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="employee_id")
    private Long employeeId; // 申请人id
    @TableField(value="employee_name")
    private String employeeName; // 申请人名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="apply_date")
    private Date applyDate; // 申请日期
    @TableField(value="apply_item_type")
    private String applyItemType; // 清单档案类型：labsub-劳务清单，prosub-专业清单

    @TableField(value = "bill_code")
    private String billCode; //申请单编码
    
    @TableField(exist=false)
    @SubEntity(serviceName="itemDocApplyDetailService")
    private List<ItemDocApplyDetailEntity> detailList = new ArrayList<>(); // 清单档案入库申请-子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public String getApplyItemType() {
        return applyItemType;
    }

    public void setApplyItemType(String applyItemType) {
        this.applyItemType = applyItemType;
    }


    public List<ItemDocApplyDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ItemDocApplyDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
