/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.company.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.company.bean.CompanyStateDetailEntity;
import com.ejianc.foundation.company.bean.CompanyStateEntity;
import com.ejianc.foundation.company.service.ICompanyStateService;
import com.ejianc.foundation.cpmpany.vo.CompanyStateDetailVO;
import com.ejianc.foundation.cpmpany.vo.CompanyStateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"companyState"})
public class CompanyStateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectSetService projectSetExPoolService;
    private static final String BILL_CODE = "COMPANY_STATE_CODE";
    @Autowired
    private ICompanyStateService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CompanyStateVO> saveOrUpdate(@RequestBody CompanyStateVO saveOrUpdateVO) {
        CompanyStateEntity entity = (CompanyStateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CompanyStateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.updateCompanyStateDetailEntity(entity);
        this.service.saveOrUpdate((Object)entity, false);
        CompanyStateVO vo = (CompanyStateVO)BeanMapper.map((Object)((Object)entity), CompanyStateVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CompanyStateVO> queryDetail(Long id) {
        CompanyStateEntity entity = (CompanyStateEntity)((Object)this.service.selectById(id));
        List<CompanyStateDetailEntity> detailEntities = this.updateCompanyStateDetailEntity(entity);
        entity.setCompanyStateDetailList(detailEntities);
        CompanyStateVO vo = (CompanyStateVO)BeanMapper.map((Object)((Object)entity), CompanyStateVO.class);
        List<CompanyStateDetailVO> vos = this.updateCompanyStateDetailVo(vo);
        vo.setCompanyStateDetailList(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CompanyStateVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CompanyStateVO companyStateVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u5217\u8868")
    @RequestMapping(value={"/queryProjects"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<CompanyStateDetailVO>> queryProjects(@RequestBody QueryParam param) {
        Parameter orgId = (Parameter)param.getParams().get("orgId");
        if (orgId == null) {
            return CommonResponse.error((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\uff01");
        }
        Object object = orgId.getValue();
        if (object == null) {
            return CommonResponse.error((String)"\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u662f\u5426\u6b63\u786e\uff01");
        }
        List list = null;
        try {
            long aLong = Long.parseLong(object.toString());
            list = ((List)this.iOrgApi.findChildrenByParentId(Long.valueOf(aLong)).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        catch (NumberFormatException e) {
            return CommonResponse.error((String)"\u7ec4\u7ec7\u9009\u62e9\u5f02\u5e38");
        }
        param.getParams().put("orgId", new Parameter("in", list));
        List poolEntities = this.projectSetExPoolService.queryList(param);
        if (poolEntities == null || poolEntities.isEmpty()) {
            return CommonResponse.success((String)"\u6ca1\u6709\u6570\u636e\uff01", new ArrayList());
        }
        ArrayList<CompanyStateDetailVO> ans = new ArrayList<CompanyStateDetailVO>();
        for (ProjectSetPoolEntity en : poolEntities) {
            CompanyStateDetailVO vo = new CompanyStateDetailVO();
            vo.setProjectId(en.getId());
            vo.setProjectName(en.getName());
            try {
                vo.setProjectStatus(Integer.valueOf(Integer.parseInt(en.getProjectStatus())));
            }
            catch (NumberFormatException e) {
                this.logger.debug("\u9879\u76ee\u72b6\u6001\u8f6c\u6362\u5f02\u5e38");
            }
            vo.setBranch(en.getParentProjectName());
            vo.setActualCommencement(en.getActualStartDate());
            ans.add(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", ans);
    }

    @ApiOperation(value="\u5bfc\u5165")
    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request, response, 0);
    }

    @ApiOperation(value="\u516c\u53f8\u6f5c\u4e8f\u95e8\u6237")
    @RequestMapping(value={"/selectCompanyState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> selectCompanyState(@RequestParam(required=false) String data, @RequestParam(required=false) String value) {
        ArrayList<Map<String, String>> ans = new ArrayList<Map<String, String>>();
        for (int i = 0; i <= 4; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            String s = "";
            switch (i) {
                case 0: {
                    s = "\u7b2c\u4e00\u5b63\u5ea6";
                    break;
                }
                case 1: {
                    s = "\u7b2c\u4e8c\u5b63\u5ea6";
                    break;
                }
                case 2: {
                    s = "\u7b2c\u4e09\u5b63\u5ea6";
                    break;
                }
                case 3: {
                    s = "\u7b2c\u56db\u5b63\u5ea6";
                }
            }
            map.put("first", s);
            ans.add(map);
        }
        return this.service.selectCompanyState(ans, data, value);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CompanyStateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CompanyStateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CompanyState-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCompanyStateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CompanyStateVO>> refCompanyStateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CompanyStateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private List<CompanyStateDetailEntity> updateCompanyStateDetailEntity(CompanyStateEntity entity) {
        List<CompanyStateDetailEntity> detailList = entity.getCompanyStateDetailList();
        if (detailList == null || detailList.isEmpty()) {
            return detailList;
        }
        ArrayList<CompanyStateDetailEntity> ans = new ArrayList<CompanyStateDetailEntity>();
        for (CompanyStateDetailEntity detail : detailList) {
            BigDecimal outputTax = null;
            BigDecimal freeIncomeTax = detail.getFreeIncomeTax();
            BigDecimal revenueIncludingTax = detail.getRevenueIncludingTax();
            outputTax = revenueIncludingTax.subtract(freeIncomeTax);
            detail.setTotalOutputTax(outputTax);
            BigDecimal inputTaxVatSurcharge = BigDecimal.ZERO;
            BigDecimal costExcludingTax = detail.getCostExcludingTax() != null ? detail.getCostExcludingTax() : BigDecimal.ZERO;
            BigDecimal costIncludingTax = detail.getCostIncludingTax() != null ? detail.getCostIncludingTax() : BigDecimal.ZERO;
            BigDecimal totalFinancialExpenses = detail.getTotalFinancialExpenses() != null ? detail.getTotalFinancialExpenses() : BigDecimal.ZERO;
            inputTaxVatSurcharge = costIncludingTax.subtract(costExcludingTax).subtract(totalFinancialExpenses);
            detail.setInputTaxVatSurcharge(inputTaxVatSurcharge);
            BigDecimal totalProfitLoss = revenueIncludingTax.subtract(costIncludingTax);
            detail.setTotalProfitLoss(totalProfitLoss);
            BigDecimal totalProfitMargin = BigDecimal.ZERO;
            if (revenueIncludingTax.compareTo(BigDecimal.ZERO) != 0) {
                totalProfitMargin = totalProfitLoss.divide(revenueIncludingTax, 4, RoundingMode.HALF_UP);
            }
            detail.setTotalProfitMargin(totalProfitMargin);
            BigDecimal cumulativeOutputTax = BigDecimal.ZERO;
            BigDecimal cumulativeFreeIncome = detail.getCumulativeFreeIncome() != null ? detail.getCumulativeFreeIncome() : BigDecimal.ZERO;
            BigDecimal cumulativeRevenueIncludingTax = detail.getCumulativeRevenueIncludingTax() != null ? detail.getCumulativeRevenueIncludingTax() : BigDecimal.ZERO;
            cumulativeOutputTax = cumulativeRevenueIncludingTax.subtract(cumulativeFreeIncome);
            detail.setCumulativeOutputTax(cumulativeOutputTax);
            BigDecimal cumulativeInputTaxVatSurcharge = BigDecimal.ZERO;
            BigDecimal cumulativeFreeCost = detail.getCumulativeFreeCost() != null ? detail.getCumulativeFreeCost() : BigDecimal.ZERO;
            BigDecimal cumulativeCostIncludingTax = detail.getCumulativeCostIncludingTax() != null ? detail.getCumulativeCostIncludingTax() : BigDecimal.ZERO;
            BigDecimal cumulativeFinancialExpenses = detail.getCumulativeFinancialExpenses() != null ? detail.getCumulativeFinancialExpenses() : BigDecimal.ZERO;
            cumulativeInputTaxVatSurcharge = cumulativeCostIncludingTax.subtract(cumulativeFreeCost).subtract(cumulativeFinancialExpenses);
            detail.setCumulativeInputTaxVatSurcharge(cumulativeInputTaxVatSurcharge);
            BigDecimal cumulativeProfitLoss = cumulativeRevenueIncludingTax.subtract(cumulativeCostIncludingTax);
            detail.setCumulativeProfitLoss(cumulativeProfitLoss);
            BigDecimal cumulativeProfitMargin = BigDecimal.ZERO;
            if (cumulativeRevenueIncludingTax.compareTo(BigDecimal.ZERO) != 0) {
                cumulativeProfitMargin = cumulativeProfitLoss.divide(cumulativeRevenueIncludingTax, 4, RoundingMode.HALF_UP);
            }
            detail.setCumulativeProfitMargin(cumulativeProfitMargin);
            BigDecimal financialProjectProfit = BigDecimal.ZERO;
            BigDecimal grossProfit = detail.getGrossProfit() != null ? detail.getGrossProfit() : BigDecimal.ZERO;
            BigDecimal taxesSurcharges = detail.getTaxesSurcharges() != null ? detail.getTaxesSurcharges() : BigDecimal.ZERO;
            BigDecimal managementExpenses = detail.getManagementExpenses() != null ? detail.getManagementExpenses() : BigDecimal.ZERO;
            BigDecimal rdExpenses = detail.getRdExpenses() != null ? detail.getRdExpenses() : BigDecimal.ZERO;
            BigDecimal financialExpenses = detail.getFinancialExpenses() != null ? detail.getFinancialExpenses() : BigDecimal.ZERO;
            BigDecimal assetCreditImpairmentLoss = detail.getAssetCreditImpairmentLoss() != null ? detail.getAssetCreditImpairmentLoss() : BigDecimal.ZERO;
            BigDecimal otherIncomeExpenses = detail.getOtherIncomeExpenses() != null ? detail.getOtherIncomeExpenses() : BigDecimal.ZERO;
            financialProjectProfit = grossProfit.subtract(taxesSurcharges).subtract(managementExpenses).subtract(rdExpenses).subtract(financialExpenses).subtract(assetCreditImpairmentLoss).subtract(otherIncomeExpenses);
            detail.setFinancialProjectProfit(financialProjectProfit);
            ans.add(detail);
        }
        return ans;
    }

    private List<CompanyStateDetailVO> updateCompanyStateDetailVo(CompanyStateVO vo) {
        List vos = vo.getCompanyStateDetailList();
        if (vos == null || vos.isEmpty()) {
            return vos;
        }
        ArrayList<CompanyStateDetailVO> ans = new ArrayList<CompanyStateDetailVO>();
        for (CompanyStateDetailVO detail : vos) {
            BigDecimal cumulativeProfitMargin;
            BigDecimal profitMargin;
            BigDecimal financialProjectProfit = detail.getFinancialProjectProfit() != null ? detail.getFinancialProjectProfit() : BigDecimal.ZERO;
            BigDecimal assetCreditImpairmentLoss = detail.getAssetCreditImpairmentLoss() != null ? detail.getAssetCreditImpairmentLoss() : BigDecimal.ZERO;
            BigDecimal cumulativeProfitLoss = detail.getCumulativeProfitLoss() != null ? detail.getCumulativeProfitLoss() : BigDecimal.ZERO;
            BigDecimal potentialLossAmount = cumulativeProfitLoss.subtract(financialProjectProfit.add(assetCreditImpairmentLoss));
            detail.setPotentialLossAmount(potentialLossAmount);
            if (cumulativeProfitLoss.compareTo(BigDecimal.ZERO) < 0 && cumulativeProfitLoss.compareTo(financialProjectProfit) < 0) {
                detail.setPotentialLossType(Integer.valueOf(1));
            } else if (cumulativeProfitLoss.compareTo(BigDecimal.ZERO) >= 0 && cumulativeProfitLoss.compareTo(financialProjectProfit) < 0) {
                detail.setPotentialLossType(Integer.valueOf(2));
            } else {
                detail.setPotentialLossType(Integer.valueOf(3));
            }
            BigDecimal totalProfitMargin = detail.getTotalProfitMargin() != null ? detail.getTotalProfitMargin() : BigDecimal.ZERO;
            BigDecimal bigDecimal = profitMargin = detail.getProfitMargin() != null ? detail.getProfitMargin() : BigDecimal.ZERO;
            if (totalProfitMargin.compareTo(BigDecimal.ZERO) < 0) {
                detail.setPotentialLossTypeCompletion(Integer.valueOf(1));
            } else if (totalProfitMargin.compareTo(BigDecimal.ZERO) >= 0 && totalProfitMargin.compareTo(profitMargin) < 0) {
                detail.setPotentialLossTypeCompletion(Integer.valueOf(2));
            } else {
                detail.setPotentialLossTypeCompletion(Integer.valueOf(3));
            }
            BigDecimal bigDecimal2 = cumulativeProfitMargin = detail.getCumulativeProfitMargin() != null ? detail.getCumulativeProfitMargin() : BigDecimal.ZERO;
            if (cumulativeProfitMargin.compareTo(BigDecimal.ZERO) < 0) {
                detail.setPotentialLossTypeAccumulated(Integer.valueOf(1));
            } else if (cumulativeProfitMargin.compareTo(BigDecimal.ZERO) >= 0 && cumulativeProfitMargin.compareTo(profitMargin) < 0) {
                detail.setPotentialLossTypeAccumulated(Integer.valueOf(2));
            } else {
                detail.setPotentialLossTypeAccumulated(Integer.valueOf(3));
            }
            ans.add(detail);
        }
        return ans;
    }
}

