package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.UnitEntity;
import com.ejianc.foundation.share.service.IEquipmentService;
import com.ejianc.foundation.share.service.IUnitService;
import com.ejianc.foundation.share.vo.UnitVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 计量单位实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("unit")
public class UnitController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IUnitService service;

    @Autowired
    private IEquipmentService equipmentService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UnitVO> saveOrUpdate(@RequestBody UnitVO saveOrUpdateVO) {
    	return service.saveOrUpdate(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UnitVO> queryDetail(Long id) {
    	UnitEntity entity = service.selectById(id);
    	UnitVO vo = BeanMapper.map(entity, UnitVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody UnitVO vos) {
        List<Long> ids = vos.getIds();
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse<String> response = billTypeApi.checkQuote("BT220214000000001", id);
                if (!response.isSuccess()) {
                    return CommonResponse.error("该数据已被引用，不允许删除。");
                }
            }
        } else {
            return CommonResponse.error("删除失败：主键为空!");
        }
        service.removeByIds(ids, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UnitVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("unitName");
        fuzzyFields.add("unitCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("unitCode", "asc");
        IPage<UnitEntity> page = service.queryPage(param,false);
        IPage<UnitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UnitVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<UnitEntity> list = service.queryList(param);
        List<UnitVO> vos = new ArrayList<>();
        for(UnitEntity entity : list){
            UnitVO vo = BeanMapper.map(entity, UnitVO.class);
            //变更状态 0未变更 1 已变更
            if(vo.getEnabled()!=null){
                if(vo.getEnabled()==0){
                    vo.setEnabledName("已停用");
                }
                if(vo.getEnabled()==1){
                    vo.setEnabledName("已启用");
                }
            }
            vos.add(vo);
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("unit-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refUnitData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UnitVO>> refUnitData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("unitCode");
        param.getFuzzyFields().add("unitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /*if(StringUtils.isNotEmpty(condition)){
            *//** 处理condition *//*
            JSONObject _con = JSONObject.parseObject(condition);
        }*/
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        IPage<UnitEntity> page = service.queryPage(param,false);
        IPage<UnitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UnitVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导出的模板 的下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "unit-import.xlsx", "计量单位档案导出模板");
    }

    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request,response);
    }

    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<UnitVO> importVOS) {
        return CommonResponse.success((String) service.saveImportExcel(request, importVOS));
    }
}
