package com.ejianc.foundation.company.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.foundation.company.mapper.CompanyStateDetailMapper;
import com.ejianc.foundation.cpmpany.vo.CompanyStateDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.company.mapper.CompanyStateMapper;
import com.ejianc.foundation.company.bean.CompanyStateEntity;
import com.ejianc.foundation.company.service.ICompanyStateService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 公司潜亏情况主表
 *
 * @author generator
 */
@Service("companyStateService")
public class CompanyStateServiceImpl extends BaseServiceImpl<CompanyStateMapper, CompanyStateEntity> implements ICompanyStateService {

    @Autowired
    private CompanyStateDetailMapper companyStateDetailMapper;
    @Autowired
    private IOrgApi iOrgApi;
    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Integer flag) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        // 获取文件存储信息
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        //租户ID
        //Long tenantid = InvocationInfoProxy.getTenantid();
        //判断文件格式是否正确
        boolean isFailed = false;
        //获取文件数据
        MultipartFile mf = null;
        //遍历文件,校验格式是否正确
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            if (entity == null) {
                continue;
            }
            //获取文件所有内容
            mf = entity.getValue();
            //获取文件名
            String originalFileName = mf.getOriginalFilename();
            // 替换文件名中的非法字符
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        if (mf == null) {
            throw new BusinessException("导入的文件中没有数据");
        }

        // 获取文件数据
        List<List<String>> result = ExcelReader.readExcel(mf);
        //解析成功的数据
        List<CompanyStateDetailVO> successList = new ArrayList<>();
        //解析失败的数据
        List<CompanyStateDetailVO> errorList = new ArrayList<>();
        //检查获取的数据
        if (result == null || result.isEmpty()) {
            throw new BusinessException("数据表格错误");
        }
        if (result.get(0).size() <= 40) {
            throw new BusinessException("请按照导入模板导入数据 【" + result.get(0).size() + "】大于规定长度 小于等于40");
        }
        if (result.size() >= 10000) {
            throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
        }
        for (int i = 1; i < result.size(); i++) {
            //数据处理
            CompanyStateDetailVO vo = new CompanyStateDetailVO();
            //分公司
            String branch = result.get(i).get(0);
            vo.setBranch(branch);
            //项目名称
            String projectName = result.get(i).get(1);
            vo.setProjectName(projectName);
            //项目状态
            try {
                String s = result.get(i).get(2);
                vo.setProjectStatus(Integer.parseInt(s));
            } catch (NumberFormatException e) {
                vo.setErrorMsg("【项目状态】错误，错误数据：" + result.get(i).get(2));
                errorList.add(vo);
                continue;
            }
            try {
                //实际开工日期
                String actualCommencement = result.get(i).get(3);
                Date date = null;
                //格式日期
                LocalDate parse = LocalDate.parse(actualCommencement, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                date = Date.from(parse.atStartOfDay(ZoneId.systemDefault()).toInstant());
                //转化成Date类型
                vo.setActualCommencement(date);
            } catch (Exception e) {
                vo.setErrorMsg("【实际开工日期】错误，错误数据：" + result.get(i).get(3));
                errorList.add(vo);
                continue;
            }
            try {
                //合同金额
                String contractAmount = result.get(i).get(4);
                vo.setContractAmount(new BigDecimal(contractAmount));
            } catch (Exception e) {
                vo.setErrorMsg("【合同金额】错误，错误数据：" + result.get(i).get(3));
                errorList.add(vo);
                continue;
            }
            try {
                //税率
                String taxRate = result.get(i).get(5);
                vo.setTaxRate(new BigDecimal(taxRate));
            } catch (Exception e) {
                vo.setErrorMsg("【税率】错误，错误数据：" + result.get(i).get(5));
                errorList.add(vo);
                continue;
            }
            try {
                //目标利润率
                String profitMargin = result.get(i).get(6);
                vo.setProfitMargin(new BigDecimal(profitMargin));
            } catch (Exception e) {
                vo.setErrorMsg("【目标利润率】错误，错误数据：" + result.get(i).get(6));
                errorList.add(vo);
                continue;
            }
            try {
                //预计不含税总收入
                String freeIncomeTax = result.get(i).get(7);
                vo.setFreeIncomeTax(new BigDecimal(freeIncomeTax));
            } catch (Exception e) {
                vo.setErrorMsg("【预计不含税总收入】错误，错误数据：" + result.get(i).get(7));
                errorList.add(vo);
                continue;
            }
            try {
                //预计含税总收入
                String revenueIncludingTax = result.get(i).get(8);
                vo.setRevenueIncludingTax(new BigDecimal(revenueIncludingTax));
            } catch (Exception e) {
                vo.setErrorMsg("【预计含税总收入】错误，错误数据：" + result.get(i).get(7));
                errorList.add(vo);
                continue;
            }
            try {
                //计算预计总销项税
                BigDecimal totalOutputTax = null;
                totalOutputTax = vo.getRevenueIncludingTax().subtract(vo.getFreeIncomeTax());
                vo.setTotalOutputTax(totalOutputTax);
            } catch (Exception e) {
                vo.setErrorMsg("【预计总销项税】计算错误，错误数据：" + result.get(i).get(8));
                errorList.add(vo);
                continue;
            }

            try {
                //预计不含税总成本 B1（第10列，索引9）
                String costExcludingTaxStr = result.get(i).get(9);
                vo.setCostExcludingTax(new BigDecimal(costExcludingTaxStr));
            } catch (Exception e) {
                vo.setErrorMsg("【预计不含税总成本】错误，错误数据：" + result.get(i).get(9));
                errorList.add(vo);
                continue;
            }

            try {
                //预计总进项税、增值税、附加税等 B2（第11列，索引10）
                String inputTaxVatSurchargeStr = result.get(i).get(10);
                vo.setInputTaxVatSurcharge(new BigDecimal(inputTaxVatSurchargeStr));
            } catch (Exception e) {
                vo.setErrorMsg("【预计总进项税、增值税、附加税等】错误，错误数据：" + result.get(i).get(10));
                errorList.add(vo);
                continue;
            }

            try {
                //预计总财务费用 C（第12列，索引11）
                String totalFinancialExpensesStr = result.get(i).get(11);
                vo.setTotalFinancialExpenses(new BigDecimal(totalFinancialExpensesStr));
            } catch (Exception e) {
                vo.setErrorMsg("【预计总财务费用】错误，错误数据：" + result.get(i).get(11));
                errorList.add(vo);
                continue;
            }

            try {
                //预计含税总成本 B = B1 + B2 + C（第13列，索引12）
                String costIncludingTaxStr = result.get(i).get(12);
                vo.setCostIncludingTax(new BigDecimal(costIncludingTaxStr));
            } catch (Exception e) {
                vo.setErrorMsg("【预计含税总成本】错误，错误数据：" + result.get(i).get(12));
                errorList.add(vo);
                continue;
            }

            try {
                //预计总盈亏 D = A - B（第14列，索引13）
                String totalProfitLossStr = result.get(i).get(13);
                vo.setTotalProfitLoss(new BigDecimal(totalProfitLossStr));
            } catch (Exception e) {
                vo.setErrorMsg("【预计总盈亏】错误，错误数据：" + result.get(i).get(13));
                errorList.add(vo);
                continue;
            }

            try {
                //预计总利润率 E = D / A（第15列，索引14）
                String totalProfitMarginStr = result.get(i).get(14);
                vo.setTotalProfitMargin(new BigDecimal(totalProfitMarginStr));
            } catch (Exception e) {
                vo.setErrorMsg("【预计总利润率】错误，错误数据：" + result.get(i).get(14));
                errorList.add(vo);
                continue;
            }

            try {
                //累计不含税收入 a1（第16列，索引15）
                String cumulativeFreeIncomeStr = result.get(i).get(15);
                vo.setCumulativeFreeIncome(new BigDecimal(cumulativeFreeIncomeStr));
            } catch (Exception e) {
                vo.setErrorMsg("【累计不含税收入】错误，错误数据：" + result.get(i).get(15));
                errorList.add(vo);
                continue;
            }

            try {
                //累计销项税 a2（第17列，索引16）
                String cumulativeOutputTaxStr = result.get(i).get(16);
                vo.setCumulativeOutputTax(new BigDecimal(cumulativeOutputTaxStr));
            } catch (Exception e) {
                vo.setErrorMsg("【累计销项税】错误，错误数据：" + result.get(i).get(16));
                errorList.add(vo);
                continue;
            }

            try {
                //累计含税收入 a = a1 + a2（第18列，索引17）
                String cumulativeRevenueIncludingTaxStr = result.get(i).get(17);
                vo.setCumulativeRevenueIncludingTax(new BigDecimal(cumulativeRevenueIncludingTaxStr));
            } catch (Exception e) {
                vo.setErrorMsg("【累计含税收入】错误，错误数据：" + result.get(i).get(17));
                errorList.add(vo);
                continue;
            }

            try {
                //累计不含税成本 b1（第19列，索引18）
                String cumulativeFreeCostStr = result.get(i).get(18);
                vo.setCumulativeFreeCost(new BigDecimal(cumulativeFreeCostStr));
            } catch (Exception e) {
                vo.setErrorMsg("【累计不含税成本】错误，错误数据：" + result.get(i).get(18));
                errorList.add(vo);
                continue;
            }

            try {
                //累计进项税、应纳增值税、附加税等（第20列，索引19）
                String cumulativeInputTaxVatSurchargeStr = result.get(i).get(19);
                vo.setCumulativeInputTaxVatSurcharge(new BigDecimal(cumulativeInputTaxVatSurchargeStr));
            } catch (Exception e) {
                vo.setErrorMsg("【累计进项税、应纳增值税、附加税等】错误，错误数据：" + result.get(i).get(19));
                errorList.add(vo);
                continue;
            }

            try {
                //累计财务费用 c（第21列，索引20）
                String cumulativeFinancialExpensesStr = result.get(i).get(20);
                vo.setCumulativeFinancialExpenses(new BigDecimal(cumulativeFinancialExpensesStr));
            } catch (Exception e) {
                vo.setErrorMsg("【累计财务费用】错误，错误数据：" + result.get(i).get(20));
                errorList.add(vo);
                continue;
            }

            try {
                //累计含税成本 b = b1 + b2 + c（第22列，索引21）
                String cumulativeCostIncludingTaxStr = result.get(i).get(21);
                vo.setCumulativeCostIncludingTax(new BigDecimal(cumulativeCostIncludingTaxStr));
            } catch (Exception e) {
                vo.setErrorMsg("【累计含税成本】错误，错误数据：" + result.get(i).get(21));
                errorList.add(vo);
                continue;
            }

            try {
                //累计盈亏 d = a - b（第23列，索引22）
                String cumulativeProfitLossStr = result.get(i).get(22);
                vo.setCumulativeProfitLoss(new BigDecimal(cumulativeProfitLossStr));
            } catch (Exception e) {
                vo.setErrorMsg("【累计盈亏】错误，错误数据：" + result.get(i).get(22));
                errorList.add(vo);
                continue;
            }

            try {
                //累计利润率 e = d / a（第24列，索引23）
                String cumulativeProfitMarginStr = result.get(i).get(23);
                vo.setCumulativeProfitMargin(new BigDecimal(cumulativeProfitMarginStr));
            } catch (Exception e) {
                vo.setErrorMsg("【累计利润率】错误，错误数据：" + result.get(i).get(23));
                errorList.add(vo);
                continue;
            }

            // 财务数据部分（第25列开始，索引24）
            try {
                //主营业务收入（第25列，索引24）
                String mainBusinessIncomeStr = result.get(i).get(24);
                vo.setMainBusinessIncome(new BigDecimal(mainBusinessIncomeStr));
            } catch (Exception e) {
                vo.setErrorMsg("【主营业务收入】错误，错误数据：" + result.get(i).get(24));
                errorList.add(vo);
                continue;
            }

            try {
                //主营业务成本（第26列，索引25）
                String mainBusinessCostStr = result.get(i).get(25);
                vo.setMainBusinessCost(new BigDecimal(mainBusinessCostStr));
            } catch (Exception e) {
                vo.setErrorMsg("【主营业务成本】错误，错误数据：" + result.get(i).get(25));
                errorList.add(vo);
                continue;
            }

            try {
                //毛利（第27列，索引26）
                String grossProfitStr = result.get(i).get(26);
                vo.setGrossProfit(new BigDecimal(grossProfitStr));
            } catch (Exception e) {
                vo.setErrorMsg("【毛利】错误，错误数据：" + result.get(i).get(26));
                errorList.add(vo);
                continue;
            }

            try {
                //税金及附加（第28列，索引27）
                String taxesSurchargesStr = result.get(i).get(27);
                vo.setTaxesSurcharges(new BigDecimal(taxesSurchargesStr));
            } catch (Exception e) {
                vo.setErrorMsg("【税金及附加】错误，错误数据：" + result.get(i).get(27));
                errorList.add(vo);
                continue;
            }

            try {
                //管理费用（第29列，索引28）
                String managementExpensesStr = result.get(i).get(28);
                vo.setManagementExpenses(new BigDecimal(managementExpensesStr));
            } catch (Exception e) {
                vo.setErrorMsg("【管理费用】错误，错误数据：" + result.get(i).get(28));
                errorList.add(vo);
                continue;
            }

            try {
                //研发费用（第30列，索引29）
                String rdExpensesStr = result.get(i).get(29);
                vo.setRdExpenses(new BigDecimal(rdExpensesStr));
            } catch (Exception e) {
                vo.setErrorMsg("【研发费用】错误，错误数据：" + result.get(i).get(29));
                errorList.add(vo);
                continue;
            }

            try {
                //财务费用（第31列，索引30）
                String financialExpensesStr = result.get(i).get(30);
                vo.setFinancialExpenses(new BigDecimal(financialExpensesStr));
            } catch (Exception e) {
                vo.setErrorMsg("【财务费用】错误，错误数据：" + result.get(i).get(30));
                errorList.add(vo);
                continue;
            }

            try {
                //资产/信用减值损失（第32列，索引31）
                String assetCreditImpairmentLossStr = result.get(i).get(31);
                vo.setAssetCreditImpairmentLoss(new BigDecimal(assetCreditImpairmentLossStr));
            } catch (Exception e) {
                vo.setErrorMsg("【资产/信用减值损失】错误，错误数据：" + result.get(i).get(31));
                errorList.add(vo);
                continue;
            }

            try {
                //其他（收益负数列示）（第33列，索引32）
                String otherIncomeExpensesStr = result.get(i).get(32);
                vo.setOtherIncomeExpenses(new BigDecimal(otherIncomeExpensesStr));
            } catch (Exception e) {
                vo.setErrorMsg("【其他（收益负数列示）】错误，错误数据：" + result.get(i).get(32));
                errorList.add(vo);
                continue;
            }

            try {
                //财务项目净利 m（第34列，索引33）
                String financialProjectProfitStr = result.get(i).get(33);
                vo.setFinancialProjectProfit(new BigDecimal(financialProjectProfitStr));
            } catch (Exception e) {
                vo.setErrorMsg("【财务项目净利】错误，错误数据：" + result.get(i).get(33));
                errorList.add(vo);
                continue;
            }
            successList.add(vo);
        }
        // 成功的数据直接入库，失败的数据不入库，返回前端查看错误原因
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @Override
    public CommonResponse<List<Map<String, String>>> selectCompanyState(List<Map<String, String>> ans, String data, String value) {
        int check = 1;
        if (value != null) {
            try {
                check = Integer.parseInt(value);
            } catch (NumberFormatException e) {
                return CommonResponse.error("检查筛选条件值【value】！=>【" + value + "】", ans);
            }
        }
        //获取组织ID
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).
                getData().stream().map(OrgVO::getId).collect(Collectors.toList());

        Map<String,Object> map = null;
        //value 1-查询完工预计 2-开累经营 3-财务账面  （为空默认查询 完工预计）
        //根据当前组织过滤
        switch (check) {
            case 1:
                //潜亏类别-完工预计经营情况统计
                map = companyStateDetailMapper.countByCompletionEstimateType();
                break;
            case 2:
                //潜亏类别-开累经营情况统计
                map = companyStateDetailMapper.countByCumulativeOperationType();
                break;
            case 3:
                //潜亏类别（与财务账面利润对比）统计
                map = companyStateDetailMapper.countByFinancialProfitType();
                break;
            default: return CommonResponse.error("检查筛选条件值【value】！=>【" + value + "】", ans);
        }
        //one 一类潜亏
        //two 二类潜亏
        //three 正常项目
        if(map == null || map.isEmpty()){
            for (Map<String, String> an : ans) {
                an.put("one","0");
                an.put("two","0");
                an.put("three","0");
            }
            return CommonResponse.success("数据查询成功", ans);
        }
        for (Map<String, String> an : ans) {
            //one 一类潜亏
            Object one = map.get("one");
            an.put("one",one == null ? "0" : one.toString());
            //two 二类潜亏
            Object two = map.get("two");
            an.put("two",two == null ? "0" : two.toString());
            //three 正常项目
            Object three = map.get("three");
            an.put("three",three == null ? "0" : three.toString());
        }
        return CommonResponse.success("数据查询成功", ans);
    }


}
