/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.PartDocDetailEntity;
import com.ejianc.foundation.share.bean.PartDocEntity;
import com.ejianc.foundation.share.service.IPartDocDetailService;
import com.ejianc.foundation.share.service.IPartDocService;
import com.ejianc.foundation.share.vo.PartDocVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"partDoc"})
public class PartDocController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPartDocService service;
    @Autowired
    private IPartDocDetailService partDocDetailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PartDocVO> saveOrUpdate(@RequestBody PartDocVO saveOrUpdateVO) {
        PartDocEntity entity = (PartDocEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PartDocEntity.class));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        lambda.eq(PartDocEntity::getCode, (Object)saveOrUpdateVO.getCode());
        List partDocEntities = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)partDocEntities) && partDocEntities.size() > 0) {
            throw new BusinessException("\u7f16\u7801\u91cd\u590d");
        }
        this.service.saveOrUpdate((Object)entity, false);
        PartDocVO vo = (PartDocVO)BeanMapper.map((Object)((Object)entity), PartDocVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PartDocVO> queryDetail(Long id) {
        PartDocEntity entity = (PartDocEntity)((Object)this.service.selectById(id));
        PartDocVO vo = (PartDocVO)BeanMapper.map((Object)((Object)entity), PartDocVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PartDocVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PartDocVO partDocVO : vos) {
            }
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        lambdaQueryWrapper.in(PartDocDetailEntity::getPartDocId, ids);
        List list = this.partDocDetailService.list((Wrapper)lambdaQueryWrapper);
        if (list != null && list.size() > 0) {
            return CommonResponse.error((String)"\u8981\u5220\u9664\u7684\u6863\u6848\u4e0b\u6709\u6863\u6848\u9879\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PartDocVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("code", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PartDocVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refPartDocData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PartDocVO> refPartDocData(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        List partDocVOS = BeanMapper.mapList((Iterable)page.getRecords(), PartDocVO.class);
        return partDocVOS;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PartDoc-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPartData"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray refBusinessScopeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        List list = this.service.queryList(param, false);
        String jsonArray = JSONArray.toJSONString((Object)list);
        return JSONArray.parseArray((String)jsonArray);
    }

    @GetMapping(value={"/partTreeRefer"})
    @ResponseBody
    public List<Map<String, Object>> moduleTreeRefer() {
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("code", "asc");
        queryParam.setOrderMap(orderMap);
        List dataList = this.service.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        for (PartDocEntity entity : dataList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("parentId", null);
            resultMapList.add(map);
        }
        List result = ResultAsTree.createTreeData(resultMapList);
        return result;
    }
}

