/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.SubjectOrgCategoryEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.ISubjectOrgCategoryService;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.vo.SubjectOrgCategoryVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"subjectOrgCategory"})
public class SubjectOrgCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "SUBJECT_CATEGORY";
    @Autowired
    private ISubjectOrgCategoryService service;
    @Autowired
    private IProjectSetService projectSetService;
    @Autowired
    private ISubjectOrgService subjectOrgService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<SubjectOrgCategoryVO> saveOrUpdate(@RequestBody SubjectOrgCategoryVO saveOrUpdateVO) {
        SubjectOrgCategoryEntity entity = (SubjectOrgCategoryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SubjectOrgCategoryEntity.class));
        if ((entity.getId() == null || entity.getId() == 0L) && StringUtils.isBlank((CharSequence)entity.getCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SubjectOrgCategoryVO vo = (SubjectOrgCategoryVO)BeanMapper.map((Object)((Object)entity), SubjectOrgCategoryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<SubjectOrgCategoryVO> queryDetail(Long id) {
        SubjectOrgCategoryEntity entity = (SubjectOrgCategoryEntity)((Object)this.service.selectById(id));
        SubjectOrgCategoryVO vo = (SubjectOrgCategoryVO)BeanMapper.map((Object)((Object)entity), SubjectOrgCategoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<SubjectOrgCategoryVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<SubjectOrgVO> subjectOrgVOList = this.subjectOrgService.getAllByCategoryIds(ids);
        if (CollectionUtils.isNotEmpty(subjectOrgVOList)) {
            return CommonResponse.error((String)"\u8981\u5220\u9664\u7684\u4e13\u4e1a\u7c7b\u578b\u4e0b\u5b58\u5728\u6210\u672c\u79d1\u76ee\u4fe1\u606f\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff01");
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<SubjectOrgCategoryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubjectOrgCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/updateEnableStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubjectOrgCategoryVO> updateEnableStatus(@RequestBody SubjectOrgCategoryVO saveOrUpdateVO) {
        SubjectOrgCategoryEntity entity = (SubjectOrgCategoryEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
        entity.setEnabled(saveOrUpdateVO.getEnabled());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)entity), SubjectOrgCategoryVO.class));
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubjectOrgCategory-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/subjectCategoryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> lazyProsubCategoryTree(@RequestParam(required=false) Integer pageNumber, @RequestParam(required=false) Integer pageSize, String condition, String searchObject, String searchText, Long pid) {
        List categoryEntities;
        List categoryVOS;
        List map;
        List treeData;
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", Parameter.getEqInstance((Object)1));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (_con = JSONObject.parseObject((String)condition)).getString("projectId")) {
            ProjectSetPoolEntity project = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(Long.valueOf(_con.getString("projectId"))));
            if (null == project) {
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5f53\u524d\u9879\u76ee\u4fe1\u606f\uff01");
            }
            if (null == project.getSubjectOrgCategoryId()) {
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u9879\u76ee\u672a\u8bbe\u7f6e\u6210\u672c\u4e13\u4e1a\u7c7b\u578b\uff01");
            }
            param.getParams().put("id", Parameter.getEqInstance((Object)project.getSubjectOrgCategoryId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(treeData = ResultAsTree.createTreeData((List)(map = BeanMapper.mapList((Iterable)(categoryVOS = BeanMapper.mapList((Iterable)(categoryEntities = this.service.queryList(param)), SubjectOrgCategoryVO.class)), Map.class)))))) {
            map.forEach(item -> item.put("isLeaf", true));
        }
        return treeData;
    }

    @RequestMapping(value={"/refSubjectOrgCategoryData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<SubjectOrgCategoryVO>> refSubjectOrgCategoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", Parameter.getEqInstance((Object)1));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (_con = JSONObject.parseObject((String)condition)).getString("projectId")) {
            ProjectSetPoolEntity project = (ProjectSetPoolEntity)((Object)this.projectSetService.selectById(Long.valueOf(_con.getString("projectId"))));
            if (null == project) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5f53\u524d\u9879\u76ee\u4fe1\u606f\uff01");
            }
            if (null == project.getSubjectOrgCategoryId()) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u5f53\u524d\u9879\u76ee\u672a\u8bbe\u7f6e\u6210\u672c\u4e13\u4e1a\u7c7b\u578b\uff01");
            }
            param.getParams().put("id", Parameter.getEqInstance((Object)project.getSubjectOrgCategoryId()));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubjectOrgCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

